/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.util.Out;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TextAttributesChooser
extends JDialog {
    JComboBox fontFamilyCombo;
    JComboBox fontSizeCombo;
    JCheckBox boldChk;
    JCheckBox italicChk;
    JCheckBox underlineChk;
    JCheckBox subscriptChk;
    JCheckBox superscriptChk;
    JCheckBox strikethroughChk;
    JCheckBox useForegroundChk;
    JCheckBox useBackgroundChk;
    JColorChooser fgChooser;
    JColorChooser bgChooser;
    JTextPane sampleText;
    JButton okButton;
    JButton cancelButton;
    MutableAttributeSet currentStyle;
    boolean choice;

    public TextAttributesChooser(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TextAttributesChooser(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TextAttributesChooser() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        int n;
        Serializable serializable;
        this.sampleText = new JTextPane();
        this.sampleText.setText("Type your own sample here...");
        if (this.currentStyle == null) {
            serializable = new StyleContext();
            this.currentStyle = ((StyleContext)serializable).addStyle(null, null);
            this.currentStyle.addAttributes(this.sampleText.getInputAttributes());
        }
        serializable = Box.createVerticalBox();
        JTabbedPane jTabbedPane = new JTabbedPane();
        Box box = Box.createVerticalBox();
        this.fontFamilyCombo = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.fontFamilyCombo.setSelectedItem(StyleConstants.getFontFamily(this.currentStyle));
        this.fontSizeCombo = new JComboBox<String>(new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26"});
        this.fontSizeCombo.setSelectedItem(new Integer(StyleConstants.getFontSize(this.currentStyle)).toString());
        this.fontSizeCombo.setEditable(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.fontFamilyCombo);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.fontSizeCombo);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        box.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Box box2 = Box.createVerticalBox();
        this.boldChk = new JCheckBox("<html><b>Bold</b></html>");
        this.boldChk.setSelected(StyleConstants.isBold(this.currentStyle));
        box2.add(this.boldChk);
        this.underlineChk = new JCheckBox("<html><u>Underline</u></html>");
        this.underlineChk.setSelected(StyleConstants.isUnderline(this.currentStyle));
        jPanel.add(box2);
        box2 = Box.createVerticalBox();
        this.italicChk = new JCheckBox("<html><i>Italic</i></html>");
        this.italicChk.setSelected(StyleConstants.isItalic(this.currentStyle));
        box2.add(this.italicChk);
        this.subscriptChk = new JCheckBox("<html>T<sub>Subscript</sub></html>");
        this.subscriptChk.setSelected(StyleConstants.isSubscript(this.currentStyle));
        this.superscriptChk = new JCheckBox("<html>T<sup>Superscript</sup></html>");
        this.superscriptChk.setSelected(StyleConstants.isSuperscript(this.currentStyle));
        this.strikethroughChk = new JCheckBox("<html><strike>Strikethrough</strike></html>");
        this.strikethroughChk.setSelected(StyleConstants.isStrikeThrough(this.currentStyle));
        jPanel.add(box2);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setBorder(BorderFactory.createTitledBorder("Effects"));
        box.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.useForegroundChk = new JCheckBox("Use foreground colour");
        this.useForegroundChk.setSelected(false);
        jPanel.add(this.useForegroundChk);
        this.useBackgroundChk = new JCheckBox("Use background colour");
        this.useBackgroundChk.setSelected(false);
        jPanel.add(this.useBackgroundChk);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.setBorder(BorderFactory.createTitledBorder("Use Colours"));
        box.add(jPanel);
        box.add(Box.createVerticalGlue());
        jTabbedPane.add("Font", box);
        this.fgChooser = new JColorChooser(StyleConstants.getForeground(this.currentStyle));
        JTabbedPane jTabbedPane2 = new JTabbedPane();
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.fgChooser.getChooserPanels();
        for (n = 0; n < abstractColorChooserPanelArray.length; ++n) {
            jTabbedPane2.add(abstractColorChooserPanelArray[n].getDisplayName(), abstractColorChooserPanelArray[n]);
        }
        jTabbedPane.add("Foreground", jTabbedPane2);
        this.bgChooser = new JColorChooser(StyleConstants.getBackground(this.currentStyle));
        jTabbedPane2 = new JTabbedPane();
        abstractColorChooserPanelArray = this.bgChooser.getChooserPanels();
        for (n = 0; n < abstractColorChooserPanelArray.length; ++n) {
            jTabbedPane2.add(abstractColorChooserPanelArray[n].getDisplayName(), abstractColorChooserPanelArray[n]);
        }
        jTabbedPane.add("Background", jTabbedPane2);
        ((Container)serializable).add(jTabbedPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Sample"));
        JScrollPane jScrollPane = new JScrollPane(this.sampleText);
        jScrollPane.setPreferredSize(new Dimension(400, 50));
        jPanel2.add(jScrollPane);
        jPanel2.add(Box.createHorizontalGlue());
        ((Container)serializable).add(jPanel2);
        Box box3 = Box.createHorizontalBox();
        this.okButton = new JButton("OK");
        box3.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        box3.add(this.cancelButton);
        ((Container)serializable).add(box3);
        this.getContentPane().add((Component)serializable, "Center");
        this.fontFamilyCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleConstants.setFontFamily(TextAttributesChooser.this.currentStyle, (String)TextAttributesChooser.this.fontFamilyCombo.getSelectedItem());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.fontSizeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Integer.parseInt((String)TextAttributesChooser.this.fontSizeCombo.getSelectedItem());
                }
                catch (NumberFormatException numberFormatException) {
                    TextAttributesChooser.this.fontSizeCombo.setSelectedIndex(3);
                }
                StyleConstants.setFontSize(TextAttributesChooser.this.currentStyle, Integer.parseInt((String)TextAttributesChooser.this.fontSizeCombo.getSelectedItem()));
                TextAttributesChooser.this.updateSample();
            }
        });
        this.boldChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleConstants.setBold(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.boldChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.italicChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleConstants.setItalic(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.italicChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.underlineChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextAttributesChooser.this.underlineChk.isSelected()) {
                    TextAttributesChooser.this.strikethroughChk.setSelected(false);
                }
                StyleConstants.setUnderline(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.underlineChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.strikethroughChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextAttributesChooser.this.strikethroughChk.isSelected()) {
                    TextAttributesChooser.this.underlineChk.setSelected(false);
                }
                StyleConstants.setStrikeThrough(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.strikethroughChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.superscriptChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextAttributesChooser.this.superscriptChk.isSelected()) {
                    TextAttributesChooser.this.subscriptChk.setSelected(false);
                }
                StyleConstants.setSuperscript(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.superscriptChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.subscriptChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextAttributesChooser.this.subscriptChk.isSelected()) {
                    TextAttributesChooser.this.superscriptChk.setSelected(false);
                }
                StyleConstants.setSubscript(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.subscriptChk.isSelected());
                TextAttributesChooser.this.updateSample();
            }
        });
        this.fgChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                StyleConstants.setForeground(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.fgChooser.getColor());
                TextAttributesChooser.this.useForegroundChk.setSelected(true);
                TextAttributesChooser.this.updateSample();
            }
        });
        this.useForegroundChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextAttributesChooser.this.useForegroundChk.isSelected()) {
                    StyleConstants.setForeground(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.fgChooser.getColor());
                } else {
                    TextAttributesChooser.this.currentStyle.removeAttribute(StyleConstants.Foreground);
                }
                TextAttributesChooser.this.updateSample();
            }
        });
        this.bgChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                StyleConstants.setBackground(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.bgChooser.getColor());
                TextAttributesChooser.this.useBackgroundChk.setSelected(true);
                TextAttributesChooser.this.updateSample();
            }
        });
        this.useBackgroundChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextAttributesChooser.this.useBackgroundChk.isSelected()) {
                    StyleConstants.setBackground(TextAttributesChooser.this.currentStyle, TextAttributesChooser.this.bgChooser.getColor());
                } else {
                    TextAttributesChooser.this.currentStyle.removeAttribute(StyleConstants.Background);
                }
                TextAttributesChooser.this.updateSample();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                TextAttributesChooser.this.updateSample();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextAttributesChooser.this.choice = true;
                TextAttributesChooser.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextAttributesChooser.this.choice = false;
                TextAttributesChooser.this.setVisible(false);
            }
        });
    }

    public AttributeSet show(AttributeSet attributeSet) {
        this.currentStyle = new SimpleAttributeSet(attributeSet);
        this.updateData();
        this.updateSample();
        this.setModal(true);
        super.setVisible(true);
        if (this.choice) {
            return this.currentStyle;
        }
        return attributeSet;
    }

    protected void updateData() {
        this.fontFamilyCombo.setSelectedItem(StyleConstants.getFontFamily(this.currentStyle));
        this.fontSizeCombo.setSelectedItem(new Integer(StyleConstants.getFontSize(this.currentStyle)).toString());
        this.boldChk.setSelected(StyleConstants.isBold(this.currentStyle));
        this.italicChk.setSelected(StyleConstants.isItalic(this.currentStyle));
        this.italicChk.setSelected(StyleConstants.isItalic(this.currentStyle));
        this.underlineChk.setSelected(StyleConstants.isUnderline(this.currentStyle));
        this.subscriptChk.setSelected(StyleConstants.isSubscript(this.currentStyle));
        this.superscriptChk.setSelected(StyleConstants.isSuperscript(this.currentStyle));
        this.strikethroughChk.setSelected(StyleConstants.isStrikeThrough(this.currentStyle));
        if (this.currentStyle.isDefined(StyleConstants.Foreground)) {
            this.fgChooser.setColor(StyleConstants.getForeground(this.currentStyle));
            this.useForegroundChk.setSelected(true);
        } else {
            this.useForegroundChk.setSelected(false);
        }
        if (this.currentStyle.isDefined(StyleConstants.Background)) {
            this.bgChooser.setColor(StyleConstants.getBackground(this.currentStyle));
            this.useBackgroundChk.setSelected(true);
        } else {
            this.useBackgroundChk.setSelected(false);
        }
    }

    protected void updateSample() {
        if (this.sampleText.getSelectedText() != null && this.sampleText.getSelectedText().length() > 0) {
            this.sampleText.setCharacterAttributes(this.currentStyle, true);
        } else {
            this.sampleText.selectAll();
            this.sampleText.setCharacterAttributes(this.currentStyle, true);
            this.sampleText.setSelectionStart(0);
            this.sampleText.setSelectionEnd(0);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame jFrame = new JFrame("Frame");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            final TextAttributesChooser textAttributesChooser = new TextAttributesChooser(jFrame, "Dialog", false);
            JButton jButton = new JButton("Display Dialog");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Style style = new StyleContext().addStyle(null, null);
                    StyleConstants.setBackground(style, Color.white);
                    Out.println(textAttributesChooser.show(style));
                }
            });
            jFrame.getContentPane().add(jButton);
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

