/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabHighlighter {
    JTabbedPane tPane;
    int tab;
    Color highlightColour;
    Color oldColour;

    public TabHighlighter(JTabbedPane jTabbedPane, Component component, Color color) {
        this.tPane = jTabbedPane;
        this.tab = this.tPane.indexOfComponent(component);
        this.highlightColour = color;
        this.tPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TabHighlighter.this.tPane.getSelectedIndex() == TabHighlighter.this.tab) {
                    TabHighlighter.this.removeHighlight();
                }
            }
        });
        this.tPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (TabHighlighter.this.tPane.getSelectedIndex() == TabHighlighter.this.tab) {
                    TabHighlighter.this.removeHighlight();
                }
            }
        });
    }

    public void highlight() {
        if (this.tPane.getSelectedIndex() != this.tab) {
            if (this.tPane.getBackgroundAt(this.tab).equals(this.highlightColour)) {
                return;
            }
            this.oldColour = this.tPane.getBackgroundAt(this.tab);
            this.tPane.setBackgroundAt(this.tab, this.highlightColour);
        }
    }

    public void removeHighlight() {
        this.tPane.setBackgroundAt(this.tab, this.oldColour);
    }
}

