/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.CreoleRegister;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.LanguageResource;
import gate.Node;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationSchema;
import gate.creole.AnnotationVisualResource;
import gate.creole.FeatureSchema;
import gate.gui.STreeNode;
import gate.util.Coordinates;
import gate.util.Err;
import gate.util.GateException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import gate.util.Out;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class SyntaxTreeViewer
extends AbstractVisualResource
implements Scrollable,
ActionListener,
MouseListener,
AnnotationVisualResource {
    public static final String TREE_NODE_ANNOTATION_TYPE = "SyntaxTreeNode";
    public static final String NODE_CAT_FEATURE_NAME = "cat";
    public static final String NODE_CONSISTS_FEATURE_NAME = "consists";
    protected boolean laidOut = false;
    protected int horizButtonGap = 5;
    protected int vertButtonGap = 50;
    protected int extraButtonWidth = 10;
    protected int maxUnitIncrement = 10;
    BorderLayout borderLayout1 = new BorderLayout();
    JPopupMenu popup = new JPopupMenu();
    Color buttonBackground;
    Color selectedNodeColor = Color.red.darker();
    HashSet lines = new HashSet();
    protected Annotation utterance;
    protected Long utteranceStartOffset = new Long(0L);
    protected Long utteranceEndOffset = new Long(0L);
    protected AnnotationSet currentSet = null;
    protected String tokenType = "Token";
    protected String displayedString = "";
    protected String treeNodeAnnotationType = "SyntaxTreeNode";
    protected String textAnnotationType = "Sentence";
    protected HashMap leaves = new HashMap();
    protected HashMap nonTerminals = new HashMap();
    protected HashMap buttons = new HashMap();
    protected Vector selection = new Vector();
    protected AnnotationSet treeAnnotations;
    protected Document document = null;
    protected boolean utteranceAdded = false;

    public SyntaxTreeViewer() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace(Err.getPrintWriter());
        }
    }

    private SyntaxTreeViewer(String string) {
        this.treeNodeAnnotationType = string;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace(Err.getPrintWriter());
        }
    }

    private void jbInit() throws Exception {
        if (this.laidOut) {
            this.setLayout(this.borderLayout1);
        } else {
            this.setLayout(null);
        }
        this.setPreferredSize(new Dimension(600, 400));
        this.setSize(600, 400);
        this.setBounds(0, 0, 600, 400);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                SyntaxTreeViewer.this.this_componentShown(componentEvent);
            }

            public void componentHidden(ComponentEvent componentEvent) {
                SyntaxTreeViewer.this.this_componentHidden(componentEvent);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SyntaxTreeViewer.this.this_propertyChange(propertyChangeEvent);
            }
        });
        this.buttonBackground = Color.red;
        this.fillCategoriesMenu();
        this.add(this.popup);
    }

    public void setTarget(Object object) {
        if (object == null) {
            return;
        }
        this.currentSet = (AnnotationSet)object;
        this.document = this.currentSet.getDocument();
    }

    public void setAnnotation(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        this.utterance = annotation;
        this.utteranceStartOffset = this.utterance.getStartNode().getOffset();
        this.utteranceEndOffset = this.utterance.getEndNode().getOffset();
        this.textAnnotationType = annotation.getType();
        this.clearAll();
        this.utterances2Trees();
        this.annotations2Trees();
        this.setVisible(true);
        this.repaint();
    }

    public void setSpan(Long l, Long l2, String string) {
        if (l == null || l2 == null) {
            return;
        }
        if (this.document == null) {
            return;
        }
        try {
            Integer n = this.currentSet.add(l, l2, string, Factory.newFeatureMap());
            this.utterance = this.currentSet.get(n);
            this.utteranceAdded = true;
            this.textAnnotationType = string;
            this.setAnnotation(this.utterance);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            invalidOffsetException.printStackTrace(Err.getPrintWriter());
        }
    }

    public void okAction() throws GateException {
        STreeNode.transferAnnotations(this.document, this.currentSet);
    }

    public void cancelAction() throws GateException {
        if (this.utteranceAdded) {
            this.currentSet.remove(this.utterance);
            this.utteranceAdded = false;
        }
        STreeNode.undo(this.document);
    }

    public boolean canDisplayAnnotationType(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        List<String> list = Gate.getCreoleRegister().getAnnotationVRs(string);
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext() && !bl) {
            String string2 = iterator.next();
            Out.println(string2);
            if (string2.indexOf(this.getClass().getName()) <= -1) continue;
            this.textAnnotationType = string;
            bl = true;
        }
        return bl;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawLines(graphics);
    }

    private void drawLines(Graphics graphics) {
        for (Coordinates coordinates : this.lines) {
            graphics.drawLine(coordinates.getX1(), coordinates.getY1(), coordinates.getX2(), coordinates.getY2());
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.maxUnitIncrement;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width - this.maxUnitIncrement;
        }
        return rectangle.height - this.maxUnitIncrement;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    void this_propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("utterance")) {
            this.clearAll();
            this.utterances2Trees();
        }
    }

    private void clearAll() {
        this.lines.clear();
        this.removeAll();
        this.buttons.clear();
        this.leaves.clear();
        this.nonTerminals.clear();
    }

    private void annotations2Trees() {
        if (this.document == null) {
            return;
        }
        HashMap<Integer, JButton> hashMap = new HashMap<Integer, JButton>();
        AnnotationSet annotationSet = this.currentSet.get(this.treeNodeAnnotationType);
        if (annotationSet == null || annotationSet.isEmpty()) {
            return;
        }
        this.treeAnnotations = annotationSet.get(this.utterance.getStartNode().getOffset(), this.utterance.getEndNode().getOffset());
        if (this.treeAnnotations == null || this.treeAnnotations.isEmpty()) {
            return;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(this.treeAnnotations);
        Collections.sort(arrayList, new OffsetComparator());
        Vector vector = new Vector();
        String string = "";
        for (Annotation object : arrayList) {
            List list = (List)object.getFeatures().get(NODE_CONSISTS_FEATURE_NAME);
            if (list != null && !list.isEmpty()) continue;
            STreeNode sTreeNode = this.findLeaf(object.getStartNode(), object.getEndNode());
            if (sTreeNode == null) {
                Out.println("Can't find my leaf node for annotation: " + object);
            }
            JButton jButton = (JButton)this.buttons.get(new Integer(sTreeNode.getID()));
            this.selection.clear();
            this.selection.add(jButton);
            STreeNode sTreeNode2 = new STreeNode(object);
            sTreeNode2.add(sTreeNode);
            sTreeNode2.setLevel(1);
            sTreeNode2.setUserObject(object.getFeatures().get(NODE_CAT_FEATURE_NAME));
            this.nonTerminals.put(new Integer(sTreeNode2.getID()), sTreeNode2);
            JButton jButton2 = this.createCentralButton(sTreeNode2);
            this.addLines(sTreeNode2);
            hashMap.put(object.getId(), jButton2);
        }
        for (Annotation annotation : arrayList) {
            if (hashMap.containsKey(annotation.getId())) continue;
            this.processChildrenAnnots(annotation, hashMap);
        }
        this.selection.clear();
        this.scrollRectToVisible(new Rectangle(0, this.getHeight() - (int)this.getVisibleRect().getHeight(), (int)this.getVisibleRect().getWidth(), (int)this.getVisibleRect().getHeight()));
    }

    private JButton processChildrenAnnots(Annotation annotation, HashMap hashMap) {
        Serializable serializable2;
        this.selection.clear();
        Vector<JButton> vector = new Vector<JButton>();
        List list = (List)annotation.getFeatures().get(NODE_CONSISTS_FEATURE_NAME);
        for (Serializable serializable2 : list) {
            Annotation annotation2 = this.treeAnnotations.get((Integer)serializable2);
            JButton jButton = hashMap.containsKey(annotation2.getId()) ? (JButton)hashMap.get(annotation2.getId()) : this.processChildrenAnnots(annotation2, hashMap);
            vector.add(jButton);
        }
        this.selection = (Vector)vector.clone();
        STreeNode sTreeNode = this.createParentNode((String)annotation.getFeatures().get(NODE_CAT_FEATURE_NAME), annotation);
        this.nonTerminals.put(new Integer(sTreeNode.getID()), sTreeNode);
        serializable2 = this.createCentralButton(sTreeNode);
        this.addLines(sTreeNode);
        hashMap.put(annotation.getId(), serializable2);
        this.selection.clear();
        return serializable2;
    }

    private STreeNode findLeaf(Node node, Node node2) {
        for (STreeNode sTreeNode : this.leaves.values()) {
            if (sTreeNode.getStart() != (long)node.getOffset().intValue() || sTreeNode.getEnd() != (long)node2.getOffset().intValue()) continue;
            return sTreeNode;
        }
        return null;
    }

    private void utterances2Trees() {
        if (!this.utterance.getType().equals(this.textAnnotationType)) {
            Out.println("Can't display annotations other than the specified type:" + this.textAnnotationType);
            return;
        }
        this.utteranceStartOffset = this.utterance.getStartNode().getOffset();
        this.utteranceEndOffset = this.utterance.getEndNode().getOffset();
        try {
            this.displayedString = this.currentSet.getDocument().getContent().getContent(this.utteranceStartOffset, this.utteranceEndOffset).toString();
        }
        catch (InvalidOffsetException invalidOffsetException) {
            invalidOffsetException.printStackTrace(Err.getPrintWriter());
        }
        AnnotationSet annotationSet = this.currentSet.get(this.tokenType, this.utteranceStartOffset, this.utteranceEndOffset);
        if (annotationSet == null || annotationSet.isEmpty()) {
            Out.println("TreeViewer warning: No annotations of type " + this.tokenType + "so cannot show or edit the text and the tree annotations.");
            return;
        }
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = this.getHeight() - 20 - insets.bottom;
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet);
        if (arrayList.isEmpty()) {
            return;
        }
        Collections.sort(arrayList, new OffsetComparator());
        for (int i = 0; i < arrayList.size(); ++i) {
            Annotation annotation = (Annotation)arrayList.get(i);
            Long l = annotation.getStartNode().getOffset();
            Long l2 = annotation.getEndNode().getOffset();
            String string = "";
            try {
                string = this.document.getContent().getContent(l, l2).toString();
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace(Err.getPrintWriter());
            }
            STreeNode sTreeNode = new STreeNode(l, l2);
            sTreeNode.setAllowsChildren(false);
            sTreeNode.setUserObject(string);
            sTreeNode.setLevel(0);
            this.leaves.put(new Integer(sTreeNode.getID()), sTreeNode);
            n = this.createButton4Node(sTreeNode, n, n2);
        }
        this.setSize(n, n2 + 20 + insets.bottom);
        this.setPreferredSize(this.getSize());
    }

    private int createButton4Node(STreeNode sTreeNode, int n, int n2) {
        JButton jButton = new JButton((String)sTreeNode.getUserObject());
        jButton.setBorderPainted(false);
        FontMetrics fontMetrics = jButton.getFontMetrics(jButton.getFont());
        int n3 = fontMetrics.stringWidth(jButton.getText()) + jButton.getMargin().left + jButton.getMargin().right + this.extraButtonWidth;
        int n4 = fontMetrics.getHeight() + jButton.getMargin().top + jButton.getMargin().bottom;
        jButton.setBounds(n, n2 -= n4, n3, n4);
        jButton.addActionListener(this);
        jButton.addMouseListener(this);
        jButton.setActionCommand("" + sTreeNode.getID());
        jButton.setVisible(true);
        jButton.setEnabled(true);
        this.add(jButton);
        this.buttons.put(new Integer(sTreeNode.getID()), jButton);
        return n += n3 + this.horizButtonGap;
    }

    private JButton createCentralButton(STreeNode sTreeNode) {
        FocusButton focusButton = new FocusButton((String)sTreeNode.getUserObject());
        focusButton.setBorderPainted(false);
        FontMetrics fontMetrics = focusButton.getFontMetrics(focusButton.getFont());
        int n = 0;
        int n2 = 0;
        int n3 = fontMetrics.stringWidth(focusButton.getText()) + focusButton.getMargin().left + focusButton.getMargin().right + this.extraButtonWidth;
        int n4 = fontMetrics.getHeight() + focusButton.getMargin().top + focusButton.getMargin().bottom;
        int n5 = this.getWidth();
        int n6 = 0;
        int n7 = this.getHeight();
        for (JButton jButton : this.selection) {
            if (n5 > jButton.getX()) {
                n5 = jButton.getX();
            }
            if (jButton.getX() + jButton.getWidth() > n6) {
                n6 = jButton.getX() + jButton.getWidth();
            }
            if (jButton.getY() >= n7) continue;
            n7 = jButton.getY();
        }
        n = (n5 + n6) / 2 - n3 / 2;
        n2 = n7 - this.vertButtonGap;
        focusButton.setBounds(n, n2, n3, n4);
        focusButton.addActionListener(this);
        focusButton.addMouseListener(this);
        focusButton.setActionCommand("" + sTreeNode.getID());
        this.add(focusButton);
        this.buttons.put(new Integer(sTreeNode.getID()), focusButton);
        if (n2 < 0) {
            this.setSize(this.getWidth(), this.getHeight() + 5 * -n2);
            this.setPreferredSize(this.getSize());
            this.shiftButtonsDown(5 * -n2);
        }
        return focusButton;
    }

    private void shiftButtonsDown(int n) {
        for (Object object : this.buttons.values()) {
            ((Component)object).setBounds(((JComponent)object).getX(), ((JComponent)object).getY() + n, ((JComponent)object).getWidth(), ((JComponent)object).getHeight());
        }
        for (Object object : this.lines) {
            ((Coordinates)object).setY1(((Coordinates)object).getY1() + n);
            ((Coordinates)object).setY2(((Coordinates)object).getY2() + n);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (this.popup.getLabel().equals("leaves")) {
                Integer n = new Integer(actionEvent.getActionCommand());
                JButton jButton = (JButton)this.buttons.get(n);
                this.selection.add(jButton);
                STreeNode sTreeNode = (STreeNode)this.leaves.get(n);
                STreeNode sTreeNode2 = new STreeNode(sTreeNode.getStart(), sTreeNode.getEnd());
                sTreeNode2.setLevel(sTreeNode.getLevel() + 1);
                sTreeNode2.add(sTreeNode);
                sTreeNode2.setUserObject(jMenuItem.getText());
                sTreeNode2.createAnnotation(this.document, this.treeNodeAnnotationType, this.displayedString, this.utteranceStartOffset);
                this.nonTerminals.put(new Integer(sTreeNode2.getID()), sTreeNode2);
                this.createCentralButton(sTreeNode2);
                this.addLines(sTreeNode2);
                this.clearSelection();
                this.repaint();
            } else if (this.popup.getLabel().equals("non-terminal")) {
                Integer n = new Integer(actionEvent.getActionCommand());
                JButton jButton = (JButton)this.buttons.get(n);
                this.selection.add(jButton);
                STreeNode sTreeNode = this.createParentNode(jMenuItem.getText());
                this.nonTerminals.put(new Integer(sTreeNode.getID()), sTreeNode);
                this.createCentralButton(sTreeNode);
                this.addLines(sTreeNode);
                this.clearSelection();
                this.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!(mouseEvent.getSource() instanceof JButton)) {
            return;
        }
        JButton jButton = (JButton)mouseEvent.getSource();
        if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.clearSelection();
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.selectNode(mouseEvent);
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (jButton.getBackground() != this.selectedNodeColor) {
                jButton.grabFocus();
                jButton.doClick();
                this.selectNode(mouseEvent);
            }
            this.showRightClickPopup(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void showRightClickPopup(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        Integer n = new Integer(jButton.getActionCommand());
        Object v = this.leaves.get(n);
        if (v != null) {
            STreeNode sTreeNode = (STreeNode)v;
            if (sTreeNode.getParent() != null) {
                this.clearSelection();
                JOptionPane.showMessageDialog(this, "Node already annotated. To delete the existing annotation, select it and press <DEL>.", "Syntax Tree Viewer message", 1);
                return;
            }
            this.popup.setLabel("leaves");
            this.setMenuCommands(this.popup, "" + n);
            this.popup.pack();
            this.popup.show(jButton, mouseEvent.getX(), mouseEvent.getY());
        } else {
            if (((STreeNode)this.nonTerminals.get(n)).getParent() != null) {
                this.clearSelection();
                JOptionPane.showMessageDialog(this, "Node already annotated. To delete the existing annotation, select it and press <DEL>.", "Syntax Tree Viewer message", 1);
                return;
            }
            this.popup.setLabel("non-terminal");
            this.setMenuCommands(this.popup, "" + n);
            this.popup.pack();
            this.popup.show(jButton, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void addLines(STreeNode sTreeNode) {
        JButton jButton = (JButton)this.buttons.get(new Integer(sTreeNode.getID()));
        int n = jButton.getX() + jButton.getWidth() / 2;
        int n2 = jButton.getY() + jButton.getHeight();
        for (JButton jButton2 : this.selection) {
            Coordinates coordinates = new Coordinates(n, n2, jButton2.getX() + jButton2.getWidth() / 2, jButton2.getY());
            this.lines.add(coordinates);
        }
    }

    private void clearSelection() {
        Enumeration enumeration = this.selection.elements();
        while (enumeration.hasMoreElements()) {
            JButton jButton = (JButton)enumeration.nextElement();
            jButton.setBackground(this.buttonBackground);
        }
        this.selection.clear();
    }

    private void fillCategoriesMenu() {
        boolean bl = false;
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        List<LanguageResource> list = creoleRegister.getLrInstances("gate.creole.AnnotationSchema");
        if (list.isEmpty()) {
            return;
        }
        for (AnnotationSchema annotationSchema : list) {
            if (!this.treeNodeAnnotationType.equals(annotationSchema.getAnnotationName())) continue;
            bl = true;
            FeatureSchema featureSchema = annotationSchema.getFeatureSchema(NODE_CAT_FEATURE_NAME);
            Iterator iterator = featureSchema.getPermissibleValues().iterator();
            while (iterator.hasNext()) {
                JMenuItem jMenuItem = new JMenuItem((String)iterator.next());
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
            }
        }
        if (!bl) {
            Out.println("Warning: You need to define an annotation schema for " + this.treeNodeAnnotationType + " in order to be able to add such annotations.");
        }
    }

    private void setMenuCommands(JPopupMenu jPopupMenu, String string) {
        for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
            JMenuItem jMenuItem = (JMenuItem)jPopupMenu.getComponent(i);
            jMenuItem.setActionCommand(string);
        }
    }

    protected STreeNode createParentNode(String string) {
        STreeNode sTreeNode = new STreeNode();
        long l = Integer.MAX_VALUE;
        long l2 = 0L;
        long l3 = -1L;
        for (JButton jButton : this.selection) {
            Integer n = new Integer(jButton.getActionCommand());
            STreeNode sTreeNode2 = (STreeNode)this.nonTerminals.get(n);
            if (l > sTreeNode2.getStart()) {
                l = sTreeNode2.getStart();
            }
            if (l2 < sTreeNode2.getEnd()) {
                l2 = sTreeNode2.getEnd();
            }
            if (l3 < (long)sTreeNode2.getLevel()) {
                l3 = sTreeNode2.getLevel();
            }
            sTreeNode.add(sTreeNode2);
        }
        sTreeNode.setLevel(l3 + 1L);
        sTreeNode.setStart(l);
        sTreeNode.setEnd(l2);
        sTreeNode.setUserObject(string);
        sTreeNode.createAnnotation(this.document, this.treeNodeAnnotationType, this.displayedString, this.utteranceStartOffset);
        return sTreeNode;
    }

    protected STreeNode createParentNode(String string, Annotation annotation) {
        STreeNode sTreeNode = new STreeNode(annotation);
        long l = -1L;
        for (JButton jButton : this.selection) {
            Integer n = new Integer(jButton.getActionCommand());
            STreeNode sTreeNode2 = (STreeNode)this.nonTerminals.get(n);
            if (l < (long)sTreeNode2.getLevel()) {
                l = sTreeNode2.getLevel();
            }
            sTreeNode.add(sTreeNode2);
        }
        sTreeNode.setLevel(l + 1L);
        sTreeNode.setUserObject(string);
        return sTreeNode;
    }

    void selectNode(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)mouseEvent.getSource();
            this.selection.add(jButton);
            this.buttonBackground = jButton.getBackground();
            jButton.setBackground(this.selectedNodeColor);
        }
    }

    void removeNode(JButton jButton) {
        Integer n = new Integer(jButton.getActionCommand());
        STreeNode sTreeNode = (STreeNode)this.nonTerminals.get(n);
        this.nonTerminals.remove(sTreeNode);
        sTreeNode.removeAnnotation(this.document);
        this.resetChildren(sTreeNode);
        this.removeNodesAbove(sTreeNode);
        this.buttons.remove(jButton);
        jButton.setVisible(false);
        this.remove(jButton);
        this.recalculateLines();
        this.selection.clear();
        this.repaint();
    }

    private void resetChildren(STreeNode sTreeNode) {
        Enumeration<TreeNode> enumeration = sTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ((STreeNode)enumeration.nextElement()).setParent(null);
        }
        sTreeNode.disconnectChildren();
    }

    private void removeNodesAbove(STreeNode sTreeNode) {
        for (STreeNode sTreeNode2 = (STreeNode)sTreeNode.getParent(); sTreeNode2 != null; sTreeNode2 = (STreeNode)sTreeNode2.getParent()) {
            Integer n = new Integer(sTreeNode2.getID());
            sTreeNode2.removeAnnotation(this.document);
            if (sTreeNode2.isNodeChild(sTreeNode)) {
                sTreeNode2.remove(sTreeNode);
            }
            sTreeNode2.disconnectChildren();
            this.nonTerminals.remove(n);
            JButton jButton = (JButton)this.buttons.get(n);
            this.remove(jButton);
            this.buttons.remove(n);
        }
    }

    private void recalculateLines() {
        this.lines.clear();
        Iterator iterator = this.nonTerminals.values().iterator();
        while (iterator.hasNext()) {
            this.recalculateLines((STreeNode)iterator.next());
        }
    }

    private void recalculateLines(STreeNode sTreeNode) {
        Integer n = new Integer(sTreeNode.getID());
        JButton jButton = (JButton)this.buttons.get(n);
        int n2 = jButton.getX() + jButton.getWidth() / 2;
        int n3 = jButton.getY() + jButton.getHeight();
        Enumeration<TreeNode> enumeration = sTreeNode.children();
        while (enumeration.hasMoreElements()) {
            STreeNode sTreeNode2 = (STreeNode)enumeration.nextElement();
            Integer n4 = new Integer(sTreeNode2.getID());
            JButton jButton2 = (JButton)this.buttons.get(n4);
            Coordinates coordinates = new Coordinates(n2, n3, jButton2.getX() + jButton2.getWidth() / 2, jButton2.getY());
            this.lines.add(coordinates);
        }
    }

    public void setTreeNodeAnnotationType(String string) {
        this.treeNodeAnnotationType = string;
    }

    public String getTreeNodeAnnotationType() {
        return this.treeNodeAnnotationType;
    }

    public void setTokenType(String string) {
        if (string != null && !string.equals("")) {
            this.tokenType = string;
        }
    }

    public String getTokenType() {
        return this.tokenType;
    }

    void this_componentShown(ComponentEvent componentEvent) {
        Out.println("Tree Viewer shown");
    }

    void this_componentHidden(ComponentEvent componentEvent) {
        Out.println("Tree Viewer closes");
    }

    private static class FocusButton
    extends JButton {
        public FocusButton(String string) {
            super(string);
        }

        public FocusButton() {
        }

        public FocusButton(Icon icon) {
            super(icon);
        }

        public FocusButton(String string, Icon icon) {
            super(string, icon);
        }

        public void processComponentKeyEvent(KeyEvent keyEvent) {
            super.processComponentKeyEvent(keyEvent);
            if (keyEvent.getID() != 402) {
                return;
            }
            if (keyEvent.getKeyCode() == 127) {
                SyntaxTreeViewer syntaxTreeViewer = (SyntaxTreeViewer)((JButton)keyEvent.getSource()).getParent();
                syntaxTreeViewer.removeNode((JButton)keyEvent.getSource());
            }
        }
    }
}

