/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.AnnotationSet;
import gate.Corpus;
import gate.CorpusController;
import gate.CreoleRegister;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.TextualDocument;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.gui.CorpusFillerComponent;
import gate.gui.DocumentEditor;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.OkCancelDialog;
import gate.gui.SerialControllerEditor;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.swing.XJMenuItem;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import guk.Editor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ShellSlacFrame
extends MainFrame {
    private static final boolean DEBUG = false;
    private CorpusController application = null;
    private Corpus corpus = null;
    private Corpus oneDocCorpus = null;
    private DataStore dataStore = null;
    private Action saveAction = null;
    private Action runOneAction = null;
    private Action runAction = null;
    public static final String DEFAULT_SLUG_CORPUS_NAME = "SLUG Corpus";
    public static final String ONE_DOC_SLUG_CORPUS_NAME = "SLUG One Doc Corpus";
    CorpusFillerComponent corpusFiller;

    public ShellSlacFrame() {
        super(true, null);
        this.initShellSlacLocalData();
        this.initShellSlacGuiComponents();
    }

    protected void initShellSlacLocalData() {
        this.createCorpus();
        String string = System.getProperty("gate.slug.app");
        if (string != null) {
            this.createDefaultApplication(string);
        } else {
            this.createDefaultApplication();
        }
        this.dataStore = null;
    }

    protected void initShellSlacGuiComponents() {
        super.setJMenuBar(this.createMenuBar());
    }

    private JMenuBar createMenuBar() {
        AbstractAction abstractAction;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        ResourceData resourceData = this.getDocumentResourceData();
        if (resourceData != null) {
            abstractAction = new MainFrame.NewResourceAction(resourceData);
            abstractAction.putValue("Name", "New Document");
            abstractAction.putValue("ShortDescription", "Create a new document");
            jMenu.add(new XJMenuItem(abstractAction, this));
        }
        this.corpusFiller = new CorpusFillerComponent();
        abstractAction = new PopulateCorpusAction();
        abstractAction.putValue("Name", "New Documents...");
        abstractAction.putValue("ShortDescription", "Create multiple documents");
        jMenu.add(new XJMenuItem(abstractAction, this));
        jMenu.add(new XJMenuItem(new CloseSelectedDocumentAction(), this));
        jMenu.add(new XJMenuItem(new CloseAllDocumentAction(), this));
        jMenu.addSeparator();
        abstractAction = new ImportDocumentAction();
        jMenu.add(new XJMenuItem(abstractAction, this));
        JMenu jMenu2 = new JMenu("Export");
        abstractAction = new ExportDocumentAction();
        jMenu2.add(new XJMenuItem(abstractAction, this));
        abstractAction = new ExportDocumentInlineAction();
        jMenu2.add(new XJMenuItem(abstractAction, this));
        jMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("Export All");
        abstractAction = new ExportAllDocumentAction();
        jMenu3.add(new XJMenuItem(abstractAction, this));
        abstractAction = new ExportAllDocumentInlineAction();
        jMenu3.add(new XJMenuItem(abstractAction, this));
        jMenu.add(jMenu3);
        jMenu.addSeparator();
        abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShellSlacFrame.this.setVisible(false);
                ShellSlacFrame.this.dispose();
                System.exit(0);
            }
        };
        abstractAction.putValue("Name", "Exit");
        jMenu.add(new XJMenuItem(abstractAction, this));
        jMenuBar.add(jMenu);
        JMenu jMenu4 = new JMenu("Analyse");
        abstractAction = new RunApplicationOneDocumentAction();
        if (this.application == null) {
            abstractAction.setEnabled(false);
        }
        this.runOneAction = abstractAction;
        jMenu4.add(new XJMenuItem(abstractAction, this));
        jMenuBar.add(jMenu4);
        abstractAction = new RunApplicationAction();
        if (this.application == null) {
            abstractAction.setEnabled(false);
        }
        this.runAction = abstractAction;
        jMenu4.add(new XJMenuItem(abstractAction, this));
        jMenuBar.add(jMenu4);
        JMenu jMenu5 = new JMenu("Tools");
        this.createToolsMenuItems(jMenu5);
        jMenuBar.add(jMenu5);
        JMenu jMenu6 = new JMenu("Help");
        jMenu6.add(new HelpAboutSlugAction());
        jMenuBar.add(jMenu6);
        return jMenuBar;
    }

    private void createToolsMenuItems(JMenu jMenu) {
        jMenu.add(new MainFrame.NewAnnotDiffAction());
        jMenu.add(new AbstractAction("Unicode editor", ShellSlacFrame.getIcon("unicode")){

            public void actionPerformed(ActionEvent actionEvent) {
                new Editor();
            }
        });
        if (System.getProperty("gate.slug.gazetteer") != null) {
            jMenu.add(new MainFrame.NewGazetteerEditorAction());
        }
    }

    private ResourceData getDocumentResourceData() {
        ResourceData resourceData = null;
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        List<String> list = creoleRegister.getPublicLrTypes();
        if (list != null && !list.isEmpty()) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                ResourceData resourceData2 = (ResourceData)creoleRegister.get(iterator.next());
                if (!"gate.corpora.DocumentImpl".equalsIgnoreCase(resourceData2.getClassName())) continue;
                resourceData = resourceData2;
                break;
            }
        }
        return resourceData;
    }

    private void createDefaultApplication() {
        ANNIERunnable aNNIERunnable = new ANNIERunnable(this);
        Thread thread = new Thread((Runnable)aNNIERunnable, "");
        thread.setPriority(1);
        thread.start();
    }

    private void createDefaultApplication(String string) {
        ApplicationLoadRun applicationLoadRun = new ApplicationLoadRun(string, this);
        Thread thread = new Thread((Runnable)applicationLoadRun, "");
        thread.setPriority(1);
        thread.start();
    }

    private void createCorpus() {
        try {
            Factory.newCorpus(DEFAULT_SLUG_CORPUS_NAME);
            Factory.newCorpus(ONE_DOC_SLUG_CORPUS_NAME);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            resourceInstantiationException.printStackTrace();
            throw new GateRuntimeException("Error in creating build in corpus.");
        }
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
        LanguageResource languageResource;
        super.resourceLoaded(creoleEvent);
        Resource resource = creoleEvent.getResource();
        if (resource instanceof CorpusController) {
            if (this.application != null) {
                Factory.deleteResource(this.application);
            }
            this.application = (CorpusController)resource;
            this.runOneAction.setEnabled(true);
            this.runAction.setEnabled(true);
            if (this.corpus != null) {
                this.application.setCorpus(this.corpus);
            }
        }
        if (resource instanceof Corpus) {
            languageResource = (Corpus)resource;
            if (DEFAULT_SLUG_CORPUS_NAME.equals(languageResource.getName())) {
                this.corpus = languageResource;
                if (this.application != null) {
                    this.application.setCorpus(this.corpus);
                }
            }
            if (ONE_DOC_SLUG_CORPUS_NAME.equals(languageResource.getName())) {
                this.oneDocCorpus = languageResource;
            }
        }
        if (resource instanceof Document) {
            languageResource = (Document)resource;
            this.corpus.add(languageResource);
            this.showDocument((Document)languageResource);
        }
    }

    protected void showDocument(Document document) {
        Handle handle = null;
        Enumeration<TreeNode> enumeration = this.resourcesTreeRoot.preorderEnumeration();
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = this.resourcesTreeRoot;
        while (!bl && enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof Handle)) continue;
            handle = (Handle)object;
            bl = (object = handle.getTarget()) instanceof Document && document == (Document)object;
        }
        if (bl) {
            this.select(handle);
        }
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
        super.datastoreOpened(creoleEvent);
        if (this.corpus == null) {
            return;
        }
        DataStore dataStore = creoleEvent.getDatastore();
        try {
            if (this.dataStore != null) {
                this.dataStore.close();
            }
            this.saveAction.setEnabled(false);
            LanguageResource languageResource = dataStore.adopt(this.corpus, null);
            dataStore.sync(languageResource);
            Factory.deleteResource(this.corpus);
            this.corpus = (Corpus)languageResource;
            if (this.application != null) {
                this.application.setCorpus(this.corpus);
            }
            this.dataStore = dataStore;
            this.saveAction.setEnabled(true);
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    private Handle getSelectedResource() {
        JComponent jComponent = (JComponent)this.mainTabbedPane.getSelectedComponent();
        Handle handle = null;
        Enumeration<TreeNode> enumeration = this.resourcesTreeRoot.preorderEnumeration();
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = this.resourcesTreeRoot;
        while (!bl && enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            bl = defaultMutableTreeNode.getUserObject() instanceof Handle && ((Handle)defaultMutableTreeNode.getUserObject()).getLargeView() == jComponent;
        }
        if (bl) {
            handle = (Handle)defaultMutableTreeNode.getUserObject();
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocuments(File file) {
        if (this.corpus == null || this.corpus.size() == 0) {
            return;
        }
        String string = file.getPath();
        String string2 = null;
        MainFrame.lockGUI("Export all documents...");
        string = string + File.separatorChar;
        for (int i = 0; i < this.corpus.size(); ++i) {
            int n;
            Document document = (Document)this.corpus.get(i);
            URL uRL = document.getSourceUrl();
            if (uRL != null) {
                string2 = uRL.toString();
            }
            string2 = (n = string2.lastIndexOf(47)) != -1 ? string2.substring(n + 1, string2.length()) : "content_txt";
            string2 = string + string2 + ".xml";
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(string2)), "UTF-8");
                outputStreamWriter.write(document.toXml());
                outputStreamWriter.flush();
                outputStreamWriter.close();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(Out.getPrintWriter());
                continue;
            }
            finally {
                MainFrame.unlockGUI();
            }
        }
        MainFrame.unlockGUI();
    }

    class PopulateCorpusAction
    extends AbstractAction {
        PopulateCorpusAction() {
            super("New Documents...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (ShellSlacFrame.this.corpus == null || ShellSlacFrame.this.corpusFiller == null) {
                        return;
                    }
                    ShellSlacFrame.this.corpusFiller.setExtensions(new ArrayList());
                    ShellSlacFrame.this.corpusFiller.setEncoding("");
                    boolean bl = OkCancelDialog.showDialog(ShellSlacFrame.this, ShellSlacFrame.this.corpusFiller, "Select a directory and allowed extensions");
                    if (bl) {
                        URL uRL = null;
                        try {
                            uRL = new URL(ShellSlacFrame.this.corpusFiller.getUrlString());
                            List list = ShellSlacFrame.this.corpusFiller.getExtensions();
                            ExtensionFileFilter extensionFileFilter = null;
                            if (list == null || list.isEmpty()) {
                                extensionFileFilter = null;
                            } else {
                                extensionFileFilter = new ExtensionFileFilter();
                                Iterator iterator = ShellSlacFrame.this.corpusFiller.getExtensions().iterator();
                                while (iterator.hasNext()) {
                                    extensionFileFilter.addExtension((String)iterator.next());
                                }
                            }
                            ShellSlacFrame.this.corpus.populate(uRL, extensionFileFilter, ShellSlacFrame.this.corpusFiller.getEncoding(), ShellSlacFrame.this.corpusFiller.isRecurseDirectories());
                        }
                        catch (MalformedURLException malformedURLException) {
                            JOptionPane.showMessageDialog(ShellSlacFrame.this, "Invalid URL!\n See \"Messages\" tab for details!", "GATE", 0);
                            malformedURLException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(ShellSlacFrame.this, "I/O error!\n See \"Messages\" tab for details!", "GATE", 0);
                            iOException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (ResourceInstantiationException resourceInstantiationException) {
                            JOptionPane.showMessageDialog(ShellSlacFrame.this, "Could not create document!\n See \"Messages\" tab for details!", "GATE", 0);
                            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        }
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable);
            thread.setPriority(1);
            thread.start();
        }
    }

    class HelpAboutSlugAction
    extends AbstractAction {
        public HelpAboutSlugAction() {
            super("About");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "Slug application.";
            String string2 = System.getProperty("gate.slug.abouturl");
            boolean bl = false;
            if (string2 != null) {
                try {
                    URL uRL = new URL(string2);
                    AboutPaneDialog aboutPaneDialog = new AboutPaneDialog(ShellSlacFrame.this, "Slug application about", true);
                    bl = aboutPaneDialog.setURL(uRL);
                    if (bl) {
                        aboutPaneDialog.setSize(300, 200);
                        aboutPaneDialog.setLocationRelativeTo(ShellSlacFrame.this);
                        aboutPaneDialog.setVisible(true);
                    } else {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                        String string3 = "";
                        StringBuffer stringBuffer = new StringBuffer();
                        do {
                            stringBuffer.append(string3);
                        } while ((string3 = bufferedReader.readLine()) != null);
                        if (stringBuffer.length() != 0) {
                            string = stringBuffer.toString();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(ShellSlacFrame.this, string, "Slug application about", 1);
            }
        }
    }

    class AboutPaneDialog
    extends JDialog {
        public AboutPaneDialog(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
        }

        public boolean setURL(URL uRL) {
            boolean bl = false;
            try {
                Container container = this.getContentPane();
                JScrollPane jScrollPane = new JScrollPane();
                JEditorPane jEditorPane = new JEditorPane(uRL);
                jEditorPane.setEditable(false);
                jScrollPane.getViewport().add(jEditorPane);
                container.add((Component)jScrollPane, "Center");
                JButton jButton = new JButton("Close");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AboutPaneDialog.this.setVisible(false);
                    }
                });
                container.add((Component)jButton, "South");
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }
    }

    public class ANNIERunnable
    implements Runnable {
        MainFrame parentFrame;

        ANNIERunnable(MainFrame mainFrame) {
            this.parentFrame = mainFrame;
        }

        public void run() {
            MainFrame.LoadANNIEWithDefaultsAction loadANNIEWithDefaultsAction = new MainFrame.LoadANNIEWithDefaultsAction();
            loadANNIEWithDefaultsAction.actionPerformed(new ActionEvent(this.parentFrame, 1, "Load ANNIE"));
        }
    }

    private class ApplicationLoadRun
    implements Runnable {
        private String appURL;
        private MainFrame appFrame;

        public ApplicationLoadRun(String string, MainFrame mainFrame) {
            this.appURL = string;
            this.appFrame = mainFrame;
        }

        public void run() {
            File file = new File(this.appURL);
            boolean bl = false;
            MainFrame.lockGUI("Application from '" + this.appURL + "' is being loaded...");
            if (file.exists()) {
                try {
                    PersistenceManager.loadObjectFromFile(file);
                    bl = true;
                }
                catch (PersistenceException persistenceException) {
                    persistenceException.printStackTrace();
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    resourceInstantiationException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            MainFrame.unlockGUI();
            if (!bl) {
                JOptionPane.showMessageDialog(ShellSlacFrame.this, "The application file '" + this.appURL + "'\n" + "from parameter -Dgate.slug.app\n" + "is missing or corrupted." + "Create default application.", "Load application error", 2);
                ShellSlacFrame.this.createDefaultApplication();
            }
        }
    }

    private class ExportAllRunnable
    implements Runnable {
        File directory;

        ExportAllRunnable(File file) {
            this.directory = file;
        }

        public void run() {
            ShellSlacFrame.this.saveDocuments(this.directory);
        }
    }

    class ExportAllDocumentInlineAction
    extends AbstractAction {
        public ExportAllDocumentInlineAction() {
            super("with inline markup");
            this.putValue("ShortDescription", "Save all documents in XML format with inline markup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            MainFrame.fileChooser.setDialogTitle("Select Export directory");
            MainFrame.fileChooser.setFileSelectionMode(1);
            int n = MainFrame.fileChooser.showOpenDialog(ShellSlacFrame.this);
            if (n == 0 && (file = MainFrame.fileChooser.getSelectedFile()) != null && file.isDirectory()) {
                for (int i = 0; i < ShellSlacFrame.this.corpus.size(); ++i) {
                    Document document = (Document)ShellSlacFrame.this.corpus.get(i);
                    URL uRL = document.getSourceUrl();
                    String string = null;
                    if (uRL != null) {
                        string = uRL.getFile();
                        string = Files.getLastPathComponent(string);
                    }
                    if (string == null || string.length() == 0) {
                        string = document.getName();
                    }
                    if (string.length() == 0) {
                        string = "gate_result" + i;
                    }
                    string = string + ".gate";
                    ExportInline exportInline = new ExportInline(document, new File(file, string));
                    Thread thread = new Thread((Runnable)exportInline, "");
                    thread.setPriority(1);
                    thread.start();
                }
            }
        }
    }

    class ExportAllDocumentAction
    extends AbstractAction {
        public ExportAllDocumentAction() {
            super("in GATE format");
            this.putValue("ShortDescription", "Save all documents in XML format");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            MainFrame.fileChooser.setDialogTitle("Select Export directory");
            MainFrame.fileChooser.setFileSelectionMode(1);
            int n = MainFrame.fileChooser.showOpenDialog(ShellSlacFrame.this);
            if (n == 0 && (file = MainFrame.fileChooser.getSelectedFile()) != null && file.isDirectory()) {
                ExportAllRunnable exportAllRunnable = new ExportAllRunnable(file);
                Thread thread = new Thread((Runnable)exportAllRunnable, "");
                thread.setPriority(1);
                thread.start();
            }
        }
    }

    class ExportDocumentAction
    extends AbstractAction {
        public ExportDocumentAction() {
            super("in GATE format");
            this.putValue("ShortDescription", "Save the selected document in XML format");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            JComponent jComponent = (JComponent)ShellSlacFrame.this.mainTabbedPane.getSelectedComponent();
            if (jComponent != null && (action = jComponent.getActionMap().get("Save As XML")) != null) {
                action.actionPerformed(null);
            }
        }
    }

    private class ExportInline
    implements Runnable {
        File targetFile;
        Document document;

        ExportInline(Document document, File file) {
            this.targetFile = file;
            this.document = document;
        }

        protected Set getTypes(String string) {
            HashSet<String> hashSet = new HashSet<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
            return hashSet;
        }

        public void run() {
            if (this.document == null || this.targetFile == null) {
                return;
            }
            MainFrame.lockGUI("Store document with inline markup...");
            try {
                Object object;
                AnnotationSet annotationSet = null;
                annotationSet = this.document.getAnnotations();
                String string = System.getProperty("annotTypesToExport");
                if (string != null) {
                    object = this.getTypes(string);
                    annotationSet = annotationSet.get((Set<String>)object);
                }
                if ((object = ((TextualDocument)this.document).getEncoding()) == null || ((String)object).length() == 0) {
                    object = System.getProperty("file.encoding");
                }
                if (object == null || ((String)object).length() == 0) {
                    object = "UTF-8";
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.targetFile), (String)object);
                Boolean bl = Gate.getUserConfig().getBoolean("Save_features_when_preserving_format");
                boolean bl2 = true;
                if (bl != null) {
                    bl2 = bl;
                }
                String string2 = this.document.toXml(annotationSet, bl2);
                String string3 = (String)this.document.getFeatures().get("MimeType");
                if ("text/plain".equalsIgnoreCase(string3)) {
                    string2 = "<GATE>\n" + string2 + "\n</GATE>";
                }
                outputStreamWriter.write(string2);
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(Out.getPrintWriter());
            }
            MainFrame.unlockGUI();
        }
    }

    class ExportDocumentInlineAction
    extends AbstractAction {
        public ExportDocumentInlineAction() {
            super("with inline markup");
            this.putValue("ShortDescription", "Save the selected document in XML format with inline markup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)ShellSlacFrame.this.mainTabbedPane.getSelectedComponent();
            if (jComponent == null) {
                return;
            }
            Document document = null;
            for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                Component component = jComponent.getComponent(i);
                if (!(component instanceof DocumentEditor)) continue;
                document = ((DocumentEditor)component).getDocument();
            }
            if (document != null) {
                JFileChooser jFileChooser = MainFrame.getFileChooser();
                File file = null;
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setDialogTitle("Select document to save ...");
                jFileChooser.setSelectedFiles(null);
                int n = jFileChooser.showDialog(ShellSlacFrame.this, "Save");
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                    jFileChooser.setCurrentDirectory(jFileChooser.getCurrentDirectory());
                    ExportInline exportInline = new ExportInline(document, file);
                    Thread thread = new Thread((Runnable)exportInline, "");
                    thread.setPriority(1);
                    thread.start();
                }
            }
        }
    }

    private class ImportRunnable
    implements Runnable {
        File file;

        ImportRunnable(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.file != null) {
                MainFrame.lockGUI("Import file...");
                try {
                    Factory.newDocument(this.file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    resourceInstantiationException.printStackTrace();
                }
                finally {
                    MainFrame.unlockGUI();
                }
            }
        }
    }

    class ImportDocumentAction
    extends AbstractAction {
        public ImportDocumentAction() {
            super("Import");
            this.putValue("ShortDescription", "Open a document in XML format");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.fileChooser.setDialogTitle("Select file to Import from");
            MainFrame.fileChooser.setFileSelectionMode(2);
            int n = MainFrame.fileChooser.showOpenDialog(ShellSlacFrame.this);
            if (n == 0) {
                File file = MainFrame.fileChooser.getSelectedFile();
                String string = "";
                char[] cArray = new char[1024];
                try {
                    FileReader fileReader = new FileReader(file);
                    int n2 = fileReader.read(cArray);
                    fileReader.close();
                    string = new String(cArray, 0, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = false;
                if (string.indexOf("<GateDocument") != -1 || string.indexOf(" GateDocument") != -1) {
                    bl = true;
                }
                if (bl) {
                    ImportRunnable importRunnable = new ImportRunnable(file);
                    Thread thread = new Thread((Runnable)importRunnable, "");
                    thread.setPriority(1);
                    thread.start();
                } else {
                    JOptionPane.showMessageDialog(ShellSlacFrame.this, "The import file '" + file.getAbsolutePath() + "'\n" + "is not a SLUG document.", "Import error", 2);
                }
            }
        }
    }

    class TestStoreAction
    extends AbstractAction {
        public TestStoreAction() {
            super("Test Store application");
            this.putValue("ShortDescription", "Store the application");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ShellSlacFrame.this.application != null) {
                try {
                    File file = new File("D:/temp/tempapplication.tmp");
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                    long l = System.currentTimeMillis();
                    objectOutputStream.writeObject(ShellSlacFrame.this.application);
                    long l2 = System.currentTimeMillis();
                    System.out.println("Storing completed in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                    ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    l = System.currentTimeMillis();
                    Object object = objectInputStream.readObject();
                    l2 = System.currentTimeMillis();
                    ShellSlacFrame.this.application = (CorpusController)object;
                    System.out.println("Loading completed in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    class LoadAllDocumentAction
    extends AbstractAction {
        public LoadAllDocumentAction() {
            super("Load all Documents");
            this.putValue("ShortDescription", "Load documents from storage");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ShellSlacFrame.this.dataStore != null) {
                try {
                    ShellSlacFrame.this.dataStore.close();
                }
                catch (PersistenceException persistenceException) {
                    persistenceException.printStackTrace();
                }
                ShellSlacFrame.this.dataStore = null;
            }
            ShellSlacFrame.this.dataStore = ShellSlacFrame.this.openSerialDataStore();
            if (ShellSlacFrame.this.dataStore != null) {
                List list = null;
                List list2 = null;
                String string = "";
                try {
                    list = ShellSlacFrame.this.dataStore.getLrIds("gate.corpora.CorpusImpl");
                    list2 = ShellSlacFrame.this.dataStore.getLrIds("gate.corpora.DocumentImpl");
                }
                catch (PersistenceException persistenceException) {
                    persistenceException.printStackTrace();
                }
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("LRPersistenceId", string);
                featureMap.put("DataStore", ShellSlacFrame.this.dataStore);
                for (int i = 0; i < list2.size(); ++i) {
                    string = (String)list2.get(i);
                    featureMap.put("LRPersistenceId", string);
                    Document document = null;
                    try {
                        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        resourceInstantiationException.printStackTrace();
                    }
                    if (document == null) continue;
                    ShellSlacFrame.this.corpus.add(document);
                }
            }
        }
    }

    class StoreAllDocumentAction
    extends AbstractAction {
        public StoreAllDocumentAction() {
            super("Store all Documents");
            this.putValue("ShortDescription", "Store all opened in the application documents");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ShellSlacFrame.this.dataStore != null) {
                try {
                    ShellSlacFrame.this.dataStore.sync(ShellSlacFrame.this.corpus);
                }
                catch (PersistenceException persistenceException) {
                    persistenceException.printStackTrace();
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
            }
        }
    }

    class StoreAllDocumentAsAction
    extends AbstractAction {
        public StoreAllDocumentAsAction() {
            super("Store all Documents As...");
            this.putValue("ShortDescription", "Store all opened in the application documents in new directory");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShellSlacFrame.this.createSerialDataStore();
        }
    }

    class CloseAllDocumentAction
    extends AbstractAction {
        public CloseAllDocumentAction() {
            super("Close All");
            this.putValue("ShortDescription", "Closes all documents");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = ShellSlacFrame.this.mainTabbedPane.getTabCount() - 1; i > 0; --i) {
                Action action;
                JComponent jComponent = (JComponent)ShellSlacFrame.this.mainTabbedPane.getComponentAt(i);
                if (jComponent == null || (action = jComponent.getActionMap().get("Close resource")) == null) continue;
                action.actionPerformed(null);
            }
        }
    }

    class CloseSelectedDocumentAction
    extends AbstractAction {
        public CloseSelectedDocumentAction() {
            super("Close Document");
            this.putValue("ShortDescription", "Closes the selected document");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            JComponent jComponent = (JComponent)ShellSlacFrame.this.mainTabbedPane.getSelectedComponent();
            if (jComponent != null && (action = jComponent.getActionMap().get("Close resource")) != null) {
                action.actionPerformed(null);
            }
        }
    }

    class RestoreDefaultApplicationAction
    extends AbstractAction {
        public RestoreDefaultApplicationAction() {
            super("Create ANNIE application");
            this.putValue("ShortDescription", "Create default ANNIE application");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShellSlacFrame.this.createDefaultApplication();
        }
    }

    class RunApplicationOneDocumentAction
    extends AbstractAction {
        public RunApplicationOneDocumentAction() {
            super("Analyse", MainFrame.getIcon("menu_controller"));
            this.putValue("ShortDescription", "Run the application to process current document");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ShellSlacFrame.this.application != null) {
                Handle handle = ShellSlacFrame.this.getSelectedResource();
                if (handle == null) {
                    return;
                }
                Object object = handle.getTarget();
                if (object == null) {
                    return;
                }
                if (object instanceof Document) {
                    Document document = (Document)object;
                    ShellSlacFrame.this.oneDocCorpus.clear();
                    ShellSlacFrame.this.oneDocCorpus.add(document);
                    ShellSlacFrame.this.application.setCorpus(ShellSlacFrame.this.oneDocCorpus);
                    SerialControllerEditor serialControllerEditor = new SerialControllerEditor();
                    serialControllerEditor.setTarget(ShellSlacFrame.this.application);
                    serialControllerEditor.runAction.actionPerformed(null);
                }
            }
        }
    }

    class RunApplicationAction
    extends AbstractAction {
        public RunApplicationAction() {
            super("Analyse All", MainFrame.getIcon("menu_controller"));
            this.putValue("ShortDescription", "Run the application to process documents");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ShellSlacFrame.this.application != null && ShellSlacFrame.this.corpus != null && ShellSlacFrame.this.corpus.size() > 0) {
                ShellSlacFrame.this.application.setCorpus(ShellSlacFrame.this.corpus);
                SerialControllerEditor serialControllerEditor = new SerialControllerEditor();
                serialControllerEditor.setTarget(ShellSlacFrame.this.application);
                serialControllerEditor.runAction.actionPerformed(null);
            }
        }
    }
}

