/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.CreoleRegister;
import gate.DataStore;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.VisualResource;
import gate.creole.AbstractResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.NameBearerHandle;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class SerialDatastoreViewer
extends JScrollPane
implements VisualResource,
DatastoreListener {
    DefaultMutableTreeNode treeRoot;
    DefaultTreeModel treeModel;
    JTree mainTree;
    DataStore datastore;
    NameBearerHandle myHandle;
    protected DeleteAction deleteAction;
    protected LoadAction loadAction;
    protected JPopupMenu popup;
    protected FeatureMap features;
    private transient Vector progressListeners;
    private transient Vector statusListeners;

    public void cleanup() {
        this.datastore.removeDatastoreListener(this);
        this.myHandle = null;
        this.datastore = null;
    }

    public FeatureMap getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureMap featureMap) {
        this.features = featureMap;
    }

    public Object getParameterValue(String string) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, string);
    }

    public void setParameterValue(String string, Object object) throws ResourceInstantiationException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + exception);
        }
        AbstractResource.setParameterValue(this, beanInfo, string, object);
    }

    public void setParameterValues(FeatureMap featureMap) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, featureMap);
    }

    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    public void clear() {
    }

    public void setTarget(Object object) {
        if (object == null) {
            this.datastore = null;
            return;
        }
        if (!(object instanceof DataStore)) {
            throw new IllegalArgumentException("SerialDatastoreViewers can only be used with GATE serial datastores!\n" + object.getClass().toString() + " is not a GATE serial datastore!");
        }
        this.datastore = (DataStore)object;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    public void setHandle(Handle handle) {
        if (handle instanceof NameBearerHandle) {
            this.myHandle = (NameBearerHandle)handle;
        }
    }

    protected void fireProgressChanged(int n) {
        this.myHandle.fireProgressChanged(n);
    }

    protected void fireProcessFinished() {
        this.myHandle.fireProcessFinished();
    }

    protected void fireStatusChanged(String string) {
        this.myHandle.fireStatusChanged(string);
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        Object object;
        this.treeRoot = new DefaultMutableTreeNode(this.datastore.getName(), true);
        this.treeModel = new DefaultTreeModel(this.treeRoot, true);
        this.mainTree = new JTree();
        this.mainTree.setModel(this.treeModel);
        this.mainTree.setExpandsSelectedPaths(true);
        this.mainTree.expandPath(new TreePath(this.treeRoot));
        try {
            object = this.datastore.getLrTypes().iterator();
            CreoleRegister creoleRegister = Gate.getCreoleRegister();
            while (object.hasNext()) {
                String string = (String)object.next();
                ResourceData resourceData = (ResourceData)creoleRegister.get(string);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(resourceData.getName());
                this.treeModel.insertNodeInto(defaultMutableTreeNode, this.treeRoot, this.treeRoot.getChildCount());
                this.mainTree.expandPath(new TreePath(new Object[]{this.treeRoot, defaultMutableTreeNode}));
                for (String string2 : this.datastore.getLrIds(string)) {
                    DSEntry dSEntry = new DSEntry(this.datastore.getLrName(string2), string2, string);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(dSEntry, false);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GateRuntimeException(persistenceException.toString());
        }
        object = new DefaultTreeSelectionModel();
        ((DefaultTreeSelectionModel)object).setSelectionMode(4);
        this.mainTree.setSelectionModel((TreeSelectionModel)object);
        this.getViewport().setView(this.mainTree);
        this.popup = new JPopupMenu();
        this.deleteAction = new DeleteAction();
        this.loadAction = new LoadAction();
        this.popup.add(this.deleteAction);
        this.popup.add(this.loadAction);
    }

    protected void initListeners() {
        this.datastore.addDatastoreListener(this);
        this.mainTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    TreePath treePath = SerialDatastoreViewer.this.mainTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    Object object = null;
                    if (treePath != null) {
                        object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    }
                    if (object != null && object instanceof DSEntry) {
                        SerialDatastoreViewer.this.loadAction.ignoreSelection = true;
                        SerialDatastoreViewer.this.loadAction.setLocation(treePath);
                        SerialDatastoreViewer.this.loadAction.actionPerformed(null);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = SerialDatastoreViewer.this.mainTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    SerialDatastoreViewer.this.deleteAction.setLocation(treePath);
                    SerialDatastoreViewer.this.loadAction.setLocation(treePath);
                    SerialDatastoreViewer.this.popup.show(SerialDatastoreViewer.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = SerialDatastoreViewer.this.mainTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    SerialDatastoreViewer.this.deleteAction.setLocation(treePath);
                    SerialDatastoreViewer.this.loadAction.setLocation(treePath);
                    SerialDatastoreViewer.this.popup.show(SerialDatastoreViewer.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public void resourceAdopted(DatastoreEvent datastoreEvent) {
    }

    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        Object object;
        String string = (String)datastoreEvent.getResourceID();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = this.treeRoot.depthFirstEnumeration();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            object = defaultMutableTreeNode.getUserObject();
            bl = object instanceof DSEntry && ((DSEntry)object).id.equals(string);
        }
        if (bl) {
            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            if (((DefaultMutableTreeNode)object).getChildCount() == 0) {
                this.treeModel.removeNodeFromParent((MutableTreeNode)object);
            }
        }
    }

    public void resourceWritten(DatastoreEvent datastoreEvent) {
        Resource resource = datastoreEvent.getResource();
        String string = (String)datastoreEvent.getResourceID();
        String string2 = ((ResourceData)Gate.getCreoleRegister().get(resource.getClass().getName())).getName();
        DefaultMutableTreeNode defaultMutableTreeNode = this.treeRoot;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            bl = defaultMutableTreeNode2.getUserObject().equals(string2);
        }
        if (!bl) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
        this.mainTree.expandPath(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2}));
        defaultMutableTreeNode = defaultMutableTreeNode2;
        enumeration = defaultMutableTreeNode.children();
        bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            bl = ((DSEntry)defaultMutableTreeNode2.getUserObject()).id.equals(string);
        }
        if (!bl) {
            try {
                DSEntry dSEntry = new DSEntry(this.datastore.getLrName(string), string, resource.getClass().getName());
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(dSEntry, false);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            catch (PersistenceException persistenceException) {
                persistenceException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class DSEntry {
        String name;
        String type;
        String id;

        DSEntry(String string, String string2, String string3) {
            this.name = string;
            this.type = string3;
            this.id = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    class LoadAction
    extends AbstractAction {
        protected TreePath location;
        protected boolean ignoreSelection;

        public LoadAction() {
            super("Load");
            this.ignoreSelection = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    TreePath[] treePathArray = SerialDatastoreViewer.this.mainTree.getSelectionPaths();
                    if (LoadAction.this.ignoreSelection) {
                        LoadAction.this.ignoreSelection = false;
                        treePathArray = null;
                    }
                    if (treePathArray == null && LoadAction.this.location != null) {
                        treePathArray = new TreePath[]{LoadAction.this.location};
                        LoadAction.this.location = null;
                    }
                    if (treePathArray != null) {
                        for (TreePath treePath : treePathArray) {
                            Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                            if (!(object instanceof DSEntry)) continue;
                            DSEntry dSEntry = (DSEntry)object;
                            try {
                                MainFrame.lockGUI("Loading " + dSEntry.name);
                                long l = System.currentTimeMillis();
                                SerialDatastoreViewer.this.fireStatusChanged("Loading " + dSEntry.name);
                                SerialDatastoreViewer.this.fireProgressChanged(0);
                                FeatureMap featureMap = Factory.newFeatureMap();
                                featureMap.put("DataStore", SerialDatastoreViewer.this.datastore);
                                featureMap.put("LRPersistenceId", dSEntry.id);
                                FeatureMap featureMap2 = Factory.newFeatureMap();
                                Resource resource = Factory.createResource(dSEntry.type, featureMap, featureMap2, dSEntry.name);
                                SerialDatastoreViewer.this.fireProgressChanged(0);
                                SerialDatastoreViewer.this.fireProcessFinished();
                                long l2 = System.currentTimeMillis();
                                SerialDatastoreViewer.this.fireStatusChanged(dSEntry.name + " loaded in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                            }
                            catch (ResourceInstantiationException resourceInstantiationException) {
                                MainFrame.unlockGUI();
                                JOptionPane.showMessageDialog(SerialDatastoreViewer.this, "Error!\n" + resourceInstantiationException.toString(), "GATE", 0);
                                resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                                SerialDatastoreViewer.this.fireProgressChanged(0);
                                SerialDatastoreViewer.this.fireProcessFinished();
                            }
                            finally {
                                MainFrame.unlockGUI();
                            }
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable, SerialDatastoreViewer.this.getClass().getCanonicalName() + " DS Loader");
            thread.setPriority(1);
            thread.start();
        }

        public TreePath getLocation() {
            return this.location;
        }

        public void setLocation(TreePath treePath) {
            this.location = treePath;
        }
    }

    class DeleteAction
    extends AbstractAction {
        TreePath location;

        public DeleteAction() {
            super("Delete");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = SerialDatastoreViewer.this.mainTree.getSelectionPaths();
            if (treePathArray == null && this.location != null) {
                treePathArray = new TreePath[]{this.location};
                this.location = null;
            }
            if (treePathArray != null) {
                for (TreePath treePath : treePathArray) {
                    Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    if (!(object instanceof DSEntry)) continue;
                    DSEntry dSEntry = (DSEntry)object;
                    try {
                        SerialDatastoreViewer.this.datastore.delete(dSEntry.type, dSEntry.id);
                    }
                    catch (PersistenceException persistenceException) {
                        JOptionPane.showMessageDialog(SerialDatastoreViewer.this, "Error!\n" + persistenceException.toString(), "GATE", 0);
                        persistenceException.printStackTrace(Err.getPrintWriter());
                    }
                    catch (SecurityException securityException) {
                        JOptionPane.showMessageDialog(SerialDatastoreViewer.this, "Error!\n" + securityException.toString(), "GATE", 0);
                        securityException.printStackTrace(Err.getPrintWriter());
                    }
                }
            }
        }

        public TreePath getLocation() {
            return this.location;
        }

        public void setLocation(TreePath treePath) {
            this.location = treePath;
        }
    }
}

