/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Corpus;
import gate.CorpusController;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnalyserRunningStrategy;
import gate.creole.ConditionalController;
import gate.creole.ConditionalSerialAnalyserController;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.RunningStrategy;
import gate.creole.SerialAnalyserController;
import gate.creole.SerialController;
import gate.event.ControllerEvent;
import gate.event.ControllerListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.ActionsPublisher;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.ResourceParametersEditor;
import gate.gui.ResourceRenderer;
import gate.swing.XJMenu;
import gate.swing.XJPopupMenu;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.NameComparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class SerialControllerEditor
extends AbstractVisualResource
implements CreoleListener,
ControllerListener,
ActionsPublisher {
    protected SerialController controller;
    protected Handle handle;
    protected List actionList;
    protected XJTable loadedPRsTable;
    protected LoadedPRsTableModel loadedPRsTableModel;
    protected XJTable memberPRsTable;
    protected MemberPRsTableModel memberPRsTableModel;
    protected JButton addButon;
    protected JButton removeButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected ResourceParametersEditor parametersEditor;
    protected JPanel parametersPanel;
    protected TitledBorder parametersBorder;
    protected JPanel strategyPanel;
    protected TitledBorder strategyBorder;
    protected JRadioButton yes_RunRBtn;
    protected JRadioButton no_RunRBtn;
    protected JRadioButton conditional_RunRBtn;
    protected ButtonGroup runBtnGrp;
    protected JTextField featureNameTextField;
    protected JTextField featureValueTextField;
    protected JComboBox corpusCombo;
    protected CorporaComboModel corpusComboModel;
    protected JMenu addMenu;
    protected JMenu removeMenu;
    protected RunAction runAction;
    protected boolean analyserMode = false;
    protected boolean conditionalMode = false;
    protected ProcessingResource selectedPR = null;
    protected RunningStrategy selectedPRRunStrategy = null;
    private transient Vector statusListeners;
    private transient Vector progressListeners;

    public void setTarget(Object object) {
        if (!(object instanceof SerialController)) {
            throw new IllegalArgumentException("gate.gui.ApplicationViewer can only be used for serial controllers\n" + object.getClass().toString() + " is not a gate.creole.SerialController!");
        }
        if (this.controller != null) {
            this.controller.removeControllerListener(this);
        }
        this.controller = (SerialController)object;
        this.controller.addControllerListener(this);
        this.analyserMode = this.controller instanceof SerialAnalyserController || this.controller instanceof ConditionalSerialAnalyserController;
        this.conditionalMode = this.controller instanceof ConditionalController;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.loadedPRsTableModel.fireTableDataChanged();
        this.memberPRsTableModel.fireTableDataChanged();
    }

    public void setHandle(Handle handle) {
        this.handle = handle;
        if (handle instanceof StatusListener) {
            this.addStatusListener(handle);
        }
        if (handle instanceof ProgressListener) {
            this.addProgressListener(handle);
        }
    }

    public Resource init() throws ResourceInstantiationException {
        super.init();
        return this;
    }

    protected void initLocalData() {
        this.actionList = new ArrayList();
        this.runAction = new RunAction();
        this.actionList.add(null);
        this.actionList.add(this.runAction);
    }

    protected void initGuiComponents() {
        Serializable serializable;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        this.loadedPRsTableModel = new LoadedPRsTableModel();
        this.loadedPRsTable = new XJTable();
        this.loadedPRsTable.setAutoResizeMode(0);
        this.loadedPRsTable.setSortable(false);
        this.loadedPRsTable.setModel(this.loadedPRsTableModel);
        this.loadedPRsTable.setDefaultRenderer(ProcessingResource.class, new ResourceRenderer());
        final int n = new JLabel((String)"Loaded Processing resources").getPreferredSize().width + 30;
        JScrollPane jScrollPane = new JScrollPane(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.max(dimension.width, n);
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = Math.max(dimension.width, n);
                return dimension;
            }
        };
        jScrollPane.getViewport().setView(this.loadedPRsTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Loaded Processing resources "));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createHorizontalGlue());
        this.addButon = new JButton(MainFrame.getIcon("right-arrow"));
        this.removeButton = new JButton(MainFrame.getIcon("left-arrow"));
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        box.add(this.addButon);
        box.add(Box.createVerticalStrut(5));
        box.add(this.removeButton);
        box.add(Box.createVerticalGlue());
        jPanel.add(box);
        jPanel.add(Box.createHorizontalGlue());
        this.memberPRsTableModel = new MemberPRsTableModel();
        this.memberPRsTable = new XJTable();
        this.memberPRsTable.setSortable(false);
        this.memberPRsTable.setModel(this.memberPRsTableModel);
        this.memberPRsTable.setAutoResizeMode(0);
        this.memberPRsTable.setDefaultRenderer(ProcessingResource.class, new ResourceRenderer());
        this.memberPRsTable.setDefaultRenderer(JLabel.class, new LabelRenderer());
        final int n2 = new JLabel((String)"Selected Processing resources").getPreferredSize().width + 30;
        jScrollPane = new JScrollPane(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.max(dimension.width, n2);
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = Math.max(dimension.width, n2);
                return dimension;
            }
        };
        jScrollPane.getViewport().setView(this.memberPRsTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Selected Processing resources "));
        jPanel.add(jScrollPane);
        this.moveUpButton = new JButton(MainFrame.getIcon("up"));
        this.moveDownButton = new JButton(MainFrame.getIcon("down"));
        box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        box.add(this.moveUpButton);
        box.add(Box.createVerticalStrut(5));
        box.add(this.moveDownButton);
        box.add(Box.createVerticalGlue());
        jPanel.add(box);
        jPanel.add(Box.createHorizontalGlue());
        this.add(jPanel);
        if (this.conditionalMode) {
            this.strategyPanel = new JPanel();
            this.strategyPanel.setLayout(new BoxLayout(this.strategyPanel, 0));
            this.strategyPanel.setAlignmentX(0.0f);
            this.runBtnGrp = new ButtonGroup();
            this.yes_RunRBtn = new JRadioButton("Yes", true);
            this.yes_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.yes_RunRBtn);
            this.no_RunRBtn = new JRadioButton("No", false);
            this.no_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.no_RunRBtn);
            this.conditional_RunRBtn = new JRadioButton("If value of feature", false);
            this.conditional_RunRBtn.setHorizontalTextPosition(2);
            this.runBtnGrp.add(this.conditional_RunRBtn);
            this.featureNameTextField = new JTextField("", 25);
            this.featureNameTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.featureNameTextField.getPreferredSize().height));
            this.featureValueTextField = new JTextField("", 25);
            this.featureValueTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.featureValueTextField.getPreferredSize().height));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("greenBall")));
            this.strategyPanel.add(this.yes_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("redBall")));
            this.strategyPanel.add(this.no_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel(MainFrame.getIcon("yellowBall")));
            this.strategyPanel.add(this.conditional_RunRBtn);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(this.featureNameTextField);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(new JLabel("is"));
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyPanel.add(this.featureValueTextField);
            this.strategyPanel.add(Box.createHorizontalStrut(5));
            this.strategyBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " No processing resource selected... ");
            this.strategyPanel.setBorder(this.strategyBorder);
            this.add(this.strategyPanel);
        }
        if (this.analyserMode) {
            this.corpusComboModel = new CorporaComboModel();
            this.corpusCombo = new JComboBox(this.corpusComboModel);
            this.corpusCombo.setRenderer(new ResourceRenderer());
            this.corpusCombo.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.corpusCombo.getPreferredSize().height));
            serializable = null;
            if (this.controller instanceof SerialAnalyserController) {
                serializable = ((SerialAnalyserController)this.controller).getCorpus();
            } else if (this.controller instanceof ConditionalSerialAnalyserController) {
                serializable = ((ConditionalSerialAnalyserController)this.controller).getCorpus();
            } else {
                throw new GateRuntimeException("Controller editor in analyser mode but the target controller is not an analyser!");
            }
            if (serializable != null) {
                this.corpusCombo.setSelectedItem(serializable);
            } else if (this.corpusCombo.getModel().getSize() > 1) {
                this.corpusCombo.setSelectedIndex(1);
            } else {
                this.corpusCombo.setSelectedIndex(0);
            }
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setAlignmentX(0.0f);
            jPanel2.add(new JLabel("Corpus:"));
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(this.corpusCombo);
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(Box.createHorizontalGlue());
            this.add(jPanel2);
            JLabel jLabel = new JLabel("<HTML>The <b>corpus</b> and <b>document</b> parameters are not available as they are automatically set by the controller!</HTML>");
            jLabel.setAlignmentX(0.0f);
            this.add(jLabel);
        }
        this.parametersPanel = new JPanel();
        this.parametersPanel.setLayout(new BoxLayout(this.parametersPanel, 1));
        this.parametersPanel.setAlignmentX(0.0f);
        this.parametersBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " No selected processing resource ");
        this.parametersPanel.setBorder(this.parametersBorder);
        this.parametersEditor = new ResourceParametersEditor();
        this.parametersEditor.init(null, null);
        this.parametersPanel.add(new JScrollPane(this.parametersEditor));
        this.add(Box.createVerticalStrut(5));
        this.add(this.parametersPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalGlue());
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 0));
        ((JComponent)serializable).setAlignmentX(0.0f);
        ((Container)serializable).add(Box.createHorizontalGlue());
        ((Container)serializable).add(new JButton(this.runAction));
        ((Container)serializable).add(Box.createHorizontalStrut(10));
        this.add((Component)serializable);
        this.add(Box.createVerticalStrut(10));
        this.addMenu = new XJMenu("Add");
        this.removeMenu = new XJMenu("Remove");
    }

    protected void initListeners() {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && SerialControllerEditor.this.handle != null && SerialControllerEditor.this.handle.getPopup() != null) {
                    SerialControllerEditor.this.handle.getPopup().show(SerialControllerEditor.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.addButon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = SerialControllerEditor.this.loadedPRsTable.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Please select some components from the list of available components!\n", "GATE", 0);
                } else {
                    ArrayList<AddPRAction> arrayList = new ArrayList<AddPRAction>();
                    for (int i = 0; i < nArray.length; ++i) {
                        AddPRAction addPRAction = new AddPRAction((ProcessingResource)SerialControllerEditor.this.loadedPRsTable.getValueAt(nArray[i], 0));
                        if (addPRAction == null) continue;
                        arrayList.add(addPRAction);
                    }
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        ((Action)iterator.next()).actionPerformed(null);
                    }
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Please select some components to be removed from the list of used components!\n", "GATE", 0);
                } else {
                    ArrayList<RemovePRAction> arrayList = new ArrayList<RemovePRAction>();
                    for (int i = 0; i < nArray.length; ++i) {
                        RemovePRAction removePRAction = new RemovePRAction((ProcessingResource)SerialControllerEditor.this.memberPRsTable.getValueAt(nArray[i], 1));
                        if (removePRAction == null) continue;
                        arrayList.add(removePRAction);
                    }
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        ((Action)iterator.next()).actionPerformed(null);
                    }
                }
            }
        });
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Please select some components to be moved from the list of used components!\n", "GATE", 0);
                } else {
                    int n;
                    int n2;
                    Arrays.sort(nArray);
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        n = nArray[n2];
                        if (n <= 0) continue;
                        ProcessingResource processingResource = SerialControllerEditor.this.controller.remove(n);
                        SerialControllerEditor.this.controller.add(n - 1, processingResource);
                    }
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        n = -1;
                        n = nArray[n2] > 0 ? nArray[n2] - 1 : nArray[n2];
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(n, n);
                    }
                }
            }
        });
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = SerialControllerEditor.this.memberPRsTable.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    JOptionPane.showMessageDialog(SerialControllerEditor.this, "Please select some components to be moved from the list of used components!\n", "GATE", 0);
                } else {
                    int n;
                    int n2;
                    Arrays.sort(nArray);
                    for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                        n = nArray[n2];
                        if (n >= SerialControllerEditor.this.controller.getPRs().size() - 1) continue;
                        ProcessingResource processingResource = SerialControllerEditor.this.controller.remove(n);
                        SerialControllerEditor.this.controller.add(n + 1, processingResource);
                    }
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        n = -1;
                        n = nArray[n2] < SerialControllerEditor.this.controller.getPRs().size() - 1 ? nArray[n2] + 1 : nArray[n2];
                        SerialControllerEditor.this.memberPRsTable.addRowSelectionInterval(n, n);
                    }
                }
            }
        });
        this.loadedPRsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = SerialControllerEditor.this.loadedPRsTable.rowAtPoint(mouseEvent.getPoint());
                if (n != -1) {
                    ProcessingResource processingResource = (ProcessingResource)SerialControllerEditor.this.loadedPRsTableModel.getValueAt(n, 0);
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                        new AddPRAction(processingResource).actionPerformed(null);
                    } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        XJPopupMenu xJPopupMenu = new XJPopupMenu();
                        xJPopupMenu.add(new AddPRAction(processingResource){
                            {
                                this.putValue("Name", "Add \"" + this.pr.getName() + "\" to the \"" + SerialControllerEditor.this.controller.getName() + "\" application");
                            }
                        });
                        xJPopupMenu.show(SerialControllerEditor.this.loadedPRsTable, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.memberPRsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                final int n = SerialControllerEditor.this.memberPRsTable.rowAtPoint(mouseEvent.getPoint());
                if (n != -1) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        ProcessingResource processingResource = (ProcessingResource)SerialControllerEditor.this.memberPRsTableModel.getValueAt(n, 1);
                        SerialControllerEditor.this.selectPR(n);
                    } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        XJPopupMenu xJPopupMenu = new XJPopupMenu();
                        xJPopupMenu.add(new AbstractAction("Edit parameters"){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ProcessingResource processingResource = (ProcessingResource)SerialControllerEditor.this.memberPRsTableModel.getValueAt(n, 1);
                                SerialControllerEditor.this.selectPR(n);
                            }
                        });
                        xJPopupMenu.show(SerialControllerEditor.this.memberPRsTable, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.addMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                SerialControllerEditor.this.buildInternalMenus();
            }
        });
        this.removeMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                SerialControllerEditor.this.buildInternalMenus();
            }
        });
        if (this.conditionalMode) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null && SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                        AnalyserRunningStrategy analyserRunningStrategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                        if (SerialControllerEditor.this.yes_RunRBtn.isSelected()) {
                            analyserRunningStrategy.setRunMode(1);
                            SerialControllerEditor.this.featureNameTextField.setEditable(false);
                            SerialControllerEditor.this.featureValueTextField.setEditable(false);
                        } else if (SerialControllerEditor.this.no_RunRBtn.isSelected()) {
                            analyserRunningStrategy.setRunMode(2);
                            SerialControllerEditor.this.featureNameTextField.setEditable(false);
                            SerialControllerEditor.this.featureValueTextField.setEditable(false);
                        } else if (SerialControllerEditor.this.conditional_RunRBtn.isSelected()) {
                            analyserRunningStrategy.setRunMode(4);
                            SerialControllerEditor.this.featureNameTextField.setEditable(true);
                            SerialControllerEditor.this.featureValueTextField.setEditable(true);
                            String string = SerialControllerEditor.this.featureNameTextField.getText();
                            analyserRunningStrategy.setFeatureName(string == null || string.length() == 0 ? null : string);
                            string = SerialControllerEditor.this.featureValueTextField.getText();
                            analyserRunningStrategy.setFeatureValue(string == null || string.length() == 0 ? null : string);
                        }
                    }
                    SerialControllerEditor.this.memberPRsTable.repaint();
                }
            };
            this.yes_RunRBtn.addActionListener(actionListener);
            this.no_RunRBtn.addActionListener(actionListener);
            this.conditional_RunRBtn.addActionListener(actionListener);
            this.featureNameTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                protected void changeOccured(DocumentEvent documentEvent) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null && SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                        AnalyserRunningStrategy analyserRunningStrategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                        analyserRunningStrategy.setFeatureName(SerialControllerEditor.this.featureNameTextField.getText());
                    }
                }
            });
            this.featureValueTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.changeOccured(documentEvent);
                }

                protected void changeOccured(DocumentEvent documentEvent) {
                    if (SerialControllerEditor.this.selectedPRRunStrategy != null && SerialControllerEditor.this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                        AnalyserRunningStrategy analyserRunningStrategy = (AnalyserRunningStrategy)SerialControllerEditor.this.selectedPRRunStrategy;
                        analyserRunningStrategy.setFeatureValue(SerialControllerEditor.this.featureValueTextField.getText());
                    }
                }
            });
        }
        if (this.analyserMode) {
            this.corpusCombo.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    SerialControllerEditor.this.corpusComboModel.fireDataChanged();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    public List getActions() {
        return this.actionList;
    }

    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.controller.removeControllerListener(this);
        this.controller = null;
        this.progressListeners.clear();
        this.statusListeners.clear();
        this.parametersEditor.cleanup();
        this.addMenu.removeAll();
        this.removeMenu.removeAll();
        this.handle = null;
    }

    protected void buildInternalMenus() {
        AbstractAction abstractAction;
        this.addMenu.removeAll();
        for (ProcessingResource processingResource : Gate.getCreoleRegister().getPrInstances()) {
            if (Gate.getHiddenAttribute(processingResource.getFeatures()) || !(abstractAction = new AddPRAction(processingResource)).isEnabled()) continue;
            this.addMenu.add(abstractAction);
        }
        this.removeMenu.removeAll();
        for (ProcessingResource processingResource : Gate.getCreoleRegister().getPrInstances()) {
            if (Gate.getHiddenAttribute(processingResource.getFeatures()) || !(abstractAction = new RemovePRAction(processingResource)).isEnabled()) continue;
            this.removeMenu.add(abstractAction);
        }
    }

    protected void selectPR(int n) {
        ProcessingResource processingResource = (ProcessingResource)((List)this.controller.getPRs()).get(n);
        this.showParamsEditor(processingResource);
        this.selectedPR = processingResource;
        if (this.conditionalMode) {
            this.strategyBorder.setTitle(" Run \"" + processingResource.getName() + "\"? ");
            this.selectedPRRunStrategy = (RunningStrategy)((List)((ConditionalController)((Object)this.controller)).getRunningStrategies()).get(n);
            int n2 = this.selectedPRRunStrategy.getRunMode();
            if (this.selectedPRRunStrategy instanceof AnalyserRunningStrategy) {
                this.yes_RunRBtn.setEnabled(true);
                this.no_RunRBtn.setEnabled(true);
                this.conditional_RunRBtn.setEnabled(true);
                this.featureNameTextField.setText(((AnalyserRunningStrategy)this.selectedPRRunStrategy).getFeatureName());
                this.featureValueTextField.setText(((AnalyserRunningStrategy)this.selectedPRRunStrategy).getFeatureValue());
            } else {
                this.yes_RunRBtn.setEnabled(false);
                this.no_RunRBtn.setEnabled(false);
                this.conditional_RunRBtn.setEnabled(false);
                this.featureNameTextField.setText("");
                this.featureValueTextField.setText("");
            }
            this.featureNameTextField.setEditable(false);
            this.featureValueTextField.setEditable(false);
            switch (this.selectedPRRunStrategy.getRunMode()) {
                case 1: {
                    this.yes_RunRBtn.setSelected(true);
                    break;
                }
                case 2: {
                    this.no_RunRBtn.setSelected(true);
                    break;
                }
                case 4: {
                    this.conditional_RunRBtn.setSelected(true);
                    if (!(this.selectedPRRunStrategy instanceof AnalyserRunningStrategy)) break;
                    this.featureNameTextField.setEditable(true);
                    this.featureValueTextField.setEditable(true);
                }
            }
        }
    }

    protected void showParamsEditor(ProcessingResource processingResource) {
        try {
            if (this.parametersEditor.getResource() != null) {
                this.parametersEditor.setParameters();
            }
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            JOptionPane.showMessageDialog(this, "Failed to set parameters for \"" + processingResource.getName() + "\"!\n", "GATE", 0);
            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
        }
        if (processingResource != null) {
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
            this.parametersBorder.setTitle(" Parameters for the \"" + processingResource.getName() + "\" " + resourceData.getName() + " ");
            List<List<Parameter>> list = resourceData.getParameterList().getRuntimeParameters();
            if (this.analyserMode) {
                ArrayList<ArrayList<Parameter>> arrayList = new ArrayList<ArrayList<Parameter>>();
                for (List<Parameter> list2 : list) {
                    ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>(list2);
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        Parameter parameter = (Parameter)iterator.next();
                        if (!parameter.getName().equals("corpus") && !parameter.getName().equals("document")) continue;
                        iterator.remove();
                    }
                    if (arrayList2.isEmpty()) continue;
                    arrayList.add(arrayList2);
                }
                this.parametersEditor.init(processingResource, arrayList);
            } else {
                this.parametersEditor.init(processingResource, list);
            }
        } else {
            this.parametersBorder.setTitle("No selected processing resource");
            this.parametersEditor.init(null, null);
        }
        this.validate();
        this.repaint(100L);
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
        if (Gate.getHiddenAttribute(creoleEvent.getResource().getFeatures())) {
            return;
        }
        if (creoleEvent.getResource() instanceof ProcessingResource) {
            this.loadedPRsTableModel.fireTableDataChanged();
            this.memberPRsTableModel.fireTableDataChanged();
        } else if (creoleEvent.getResource() instanceof LanguageResource && creoleEvent.getResource() instanceof Corpus && this.analyserMode) {
            this.corpusComboModel.fireDataChanged();
        }
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        if (Gate.getHiddenAttribute(creoleEvent.getResource().getFeatures())) {
            return;
        }
        if (creoleEvent.getResource() instanceof ProcessingResource) {
            ProcessingResource processingResource = (ProcessingResource)creoleEvent.getResource();
            if (this.controller.getPRs().contains(processingResource)) {
                new RemovePRAction(processingResource).actionPerformed(null);
            }
            this.loadedPRsTableModel.fireTableDataChanged();
            this.memberPRsTableModel.fireTableDataChanged();
        } else if (creoleEvent.getResource() instanceof LanguageResource && creoleEvent.getResource() instanceof Corpus && this.analyserMode) {
            Corpus corpus = (Corpus)creoleEvent.getResource();
            if (this.controller instanceof CorpusController) {
                if (corpus == ((CorpusController)((Object)this.controller)).getCorpus()) {
                    ((CorpusController)((Object)this.controller)).setCorpus(null);
                }
            } else {
                throw new GateRuntimeException("Controller editor in analyser mode but the target controller is not an analyser!");
            }
            this.corpusComboModel.fireDataChanged();
        }
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
        if (Gate.getHiddenAttribute(resource.getFeatures())) {
            return;
        }
        if (resource instanceof ProcessingResource) {
            this.repaint(100L);
        }
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public void resourceAdded(ControllerEvent controllerEvent) {
        this.loadedPRsTableModel.fireTableDataChanged();
        this.memberPRsTableModel.fireTableDataChanged();
    }

    public void resourceRemoved(ControllerEvent controllerEvent) {
        this.loadedPRsTableModel.fireTableDataChanged();
        this.memberPRsTableModel.fireTableDataChanged();
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StatusListener)vector.elementAt(i)).statusChanged(string);
            }
        }
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ProgressListener)vector.elementAt(i)).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ProgressListener)vector.elementAt(i)).processFinished();
            }
        }
    }

    protected class InternalStatusListener
    implements StatusListener {
        protected InternalStatusListener() {
        }

        public void statusChanged(String string) {
            SerialControllerEditor.this.fireStatusChanged(string);
        }
    }

    protected class InternalProgressListener
    implements ProgressListener {
        protected InternalProgressListener() {
        }

        public void progressChanged(int n) {
            SerialControllerEditor.this.fireProgressChanged(n);
        }

        public void processFinished() {
            SerialControllerEditor.this.fireProcessFinished();
        }
    }

    class RunAction
    extends AbstractAction {
        RunAction() {
            super("Run");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object;
                    Object object2;
                    try {
                        SerialControllerEditor.this.parametersEditor.setParameters();
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        JOptionPane.showMessageDialog(SerialControllerEditor.this, "Could not set parameters for the \"" + SerialControllerEditor.this.parametersEditor.getResource().getName() + "\" processing resource:\nSee \"Messages\" tab for details!", "GATE", 0);
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        return;
                    }
                    if (SerialControllerEditor.this.analyserMode) {
                        object2 = SerialControllerEditor.this.corpusCombo.getSelectedItem();
                        Object object3 = object = object2.equals("<none>") ? null : (Corpus)object2;
                        if (object == null) {
                            JOptionPane.showMessageDialog(SerialControllerEditor.this, "No corpus provided!\nPlease select a corpus and try again!", "GATE", 0);
                            return;
                        }
                        if (SerialControllerEditor.this.controller instanceof SerialAnalyserController) {
                            ((SerialAnalyserController)SerialControllerEditor.this.controller).setCorpus((Corpus)object);
                        } else if (SerialControllerEditor.this.controller instanceof ConditionalSerialAnalyserController) {
                            ((ConditionalSerialAnalyserController)SerialControllerEditor.this.controller).setCorpus((Corpus)object);
                        }
                    }
                    try {
                        object2 = SerialControllerEditor.this.controller.getOffendingPocessingResources();
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        JOptionPane.showMessageDialog(SerialControllerEditor.this, "Could not check runtime parameters for the processing resources:\n" + resourceInstantiationException.toString(), "GATE", 0);
                        return;
                    }
                    if (object2 != null && !object2.isEmpty()) {
                        JOptionPane.showMessageDialog(SerialControllerEditor.this, "Some required runtime parameters are not set!", "GATE", 0);
                        return;
                    }
                    object = new InternalStatusListener();
                    InternalProgressListener internalProgressListener = new InternalProgressListener();
                    SerialControllerEditor.this.controller.addStatusListener((StatusListener)object);
                    SerialControllerEditor.this.controller.addProgressListener(internalProgressListener);
                    Gate.setExecutable(SerialControllerEditor.this.controller);
                    MainFrame.lockGUI("Running " + SerialControllerEditor.this.controller.getName() + "...");
                    long l = System.currentTimeMillis();
                    SerialControllerEditor.this.fireStatusChanged("Running " + SerialControllerEditor.this.controller.getName());
                    SerialControllerEditor.this.fireProgressChanged(0);
                    try {
                        SerialControllerEditor.this.controller.execute();
                    }
                    catch (ExecutionInterruptedException executionInterruptedException) {
                        MainFrame.unlockGUI();
                        JOptionPane.showMessageDialog(SerialControllerEditor.this, "Interrupted!\n" + executionInterruptedException.toString(), "GATE", 0);
                    }
                    catch (ExecutionException executionException) {
                        executionException.printStackTrace(Err.getPrintWriter());
                        MainFrame.unlockGUI();
                        JOptionPane.showMessageDialog(SerialControllerEditor.this, "Execution error while running \"" + SerialControllerEditor.this.controller.getName() + "\" :\nSee \"Messages\" tab for details!", "GATE", 0);
                    }
                    catch (Exception exception) {
                        MainFrame.unlockGUI();
                        JOptionPane.showMessageDialog(SerialControllerEditor.this, "Unhandled execution error!\n See \"Messages\" tab for details!", "GATE", 0);
                        exception.printStackTrace(Err.getPrintWriter());
                    }
                    finally {
                        MainFrame.unlockGUI();
                        Gate.setExecutable(null);
                    }
                    SerialControllerEditor.this.controller.removeStatusListener((StatusListener)object);
                    SerialControllerEditor.this.controller.removeProgressListener(internalProgressListener);
                    long l2 = System.currentTimeMillis();
                    SerialControllerEditor.this.fireProcessFinished();
                    SerialControllerEditor.this.fireStatusChanged(SerialControllerEditor.this.controller.getName() + " run in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "ApplicationViewer1");
            thread.setPriority(1);
            thread.start();
        }
    }

    class RemovePRAction
    extends AbstractAction {
        ProcessingResource pr;

        RemovePRAction(ProcessingResource processingResource) {
            super(processingResource.getName());
            this.pr = processingResource;
            this.setEnabled(SerialControllerEditor.this.controller.getPRs().contains(processingResource));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SerialControllerEditor.this.controller.remove(this.pr) && SerialControllerEditor.this.parametersEditor.getResource() == this.pr) {
                SerialControllerEditor.this.parametersEditor.init(null, null);
                SerialControllerEditor.this.parametersBorder.setTitle("No selected processing resource");
            }
        }
    }

    class AddPRAction
    extends AbstractAction {
        ProcessingResource pr;

        AddPRAction(ProcessingResource processingResource) {
            super(processingResource.getName());
            this.pr = processingResource;
            this.setEnabled(!SerialControllerEditor.this.controller.getPRs().contains(processingResource));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SerialControllerEditor.this.controller.add(this.pr);
        }
    }

    class MemberPRsTableModel
    extends AbstractTableModel {
        protected JLabel green = new JLabel(MainFrame.getIcon("greenBall"));
        protected JLabel red = new JLabel(MainFrame.getIcon("redBall"));
        protected JLabel yellow = new JLabel(MainFrame.getIcon("yellowBall"));

        MemberPRsTableModel() {
        }

        public int getRowCount() {
            return SerialControllerEditor.this.controller == null ? 0 : SerialControllerEditor.this.controller.getPRs().size();
        }

        public Object getValueAt(int n, int n2) {
            ProcessingResource processingResource = (ProcessingResource)((List)SerialControllerEditor.this.controller.getPRs()).get(n);
            switch (n2) {
                case 0: {
                    if (SerialControllerEditor.this.conditionalMode) {
                        RunningStrategy runningStrategy = (RunningStrategy)((List)((ConditionalController)((Object)SerialControllerEditor.this.controller)).getRunningStrategies()).get(n);
                        switch (runningStrategy.getRunMode()) {
                            case 1: {
                                return this.green;
                            }
                            case 2: {
                                return this.red;
                            }
                            case 4: {
                                return this.yellow;
                            }
                        }
                    }
                    return this.green;
                }
                case 1: {
                    return processingResource;
                }
                case 2: {
                    ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
                    if (resourceData == null) {
                        return processingResource.getClass();
                    }
                    return resourceData.getName();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "!";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Type";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return JLabel.class;
                }
                case 1: {
                    return ProcessingResource.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }

    class LabelRenderer
    implements TableCellRenderer {
        LabelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return (JLabel)object;
        }
    }

    protected class CorporaComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected CorporaComboModel() {
        }

        public int getSize() {
            List<Resource> list = null;
            try {
                list = Gate.getCreoleRegister().getAllInstances("gate.Corpus");
            }
            catch (GateException gateException) {
                gateException.printStackTrace(Err.getPrintWriter());
            }
            return list == null ? 1 : list.size() + 1;
        }

        public Object getElementAt(int n) {
            if (n == 0) {
                return "<none>";
            }
            List<Resource> list = null;
            try {
                list = Gate.getCreoleRegister().getAllInstances("gate.Corpus");
            }
            catch (GateException gateException) {
                gateException.printStackTrace(Err.getPrintWriter());
            }
            return list == null ? "" : list.get(n - 1);
        }

        public void setSelectedItem(Object object) {
            if (SerialControllerEditor.this.controller instanceof SerialAnalyserController) {
                ((SerialAnalyserController)SerialControllerEditor.this.controller).setCorpus((Corpus)(object.equals("<none>") ? null : object));
            } else if (SerialControllerEditor.this.controller instanceof ConditionalSerialAnalyserController) {
                ((ConditionalSerialAnalyserController)SerialControllerEditor.this.controller).setCorpus((Corpus)(object.equals("<none>") ? null : object));
            }
        }

        public Object getSelectedItem() {
            Corpus corpus = null;
            if (SerialControllerEditor.this.controller instanceof SerialAnalyserController) {
                corpus = ((SerialAnalyserController)SerialControllerEditor.this.controller).getCorpus();
            } else if (SerialControllerEditor.this.controller instanceof ConditionalSerialAnalyserController) {
                corpus = ((ConditionalSerialAnalyserController)SerialControllerEditor.this.controller).getCorpus();
            } else {
                throw new GateRuntimeException("Controller editor in analyser mode but the target controller is not an analyser!");
            }
            return corpus == null ? "<none>" : corpus;
        }

        void fireDataChanged() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    class LoadedPRsTableModel
    extends AbstractTableModel {
        NameComparator nameComparator = new NameComparator();

        LoadedPRsTableModel() {
        }

        public int getRowCount() {
            ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>(Gate.getCreoleRegister().getPrInstances());
            if (SerialControllerEditor.this.controller != null) {
                arrayList.removeAll(SerialControllerEditor.this.controller.getPRs());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ProcessingResource processingResource = (ProcessingResource)iterator.next();
                if (!Gate.getHiddenAttribute(processingResource.getFeatures())) continue;
                iterator.remove();
            }
            return arrayList.size();
        }

        public Object getValueAt(int n, int n2) {
            ProcessingResource processingResource;
            ArrayList<ProcessingResource> arrayList = new ArrayList<ProcessingResource>(Gate.getCreoleRegister().getPrInstances());
            if (SerialControllerEditor.this.controller != null) {
                arrayList.removeAll(SerialControllerEditor.this.controller.getPRs());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                processingResource = (ProcessingResource)iterator.next();
                if (!Gate.getHiddenAttribute(processingResource.getFeatures())) continue;
                iterator.remove();
            }
            Collections.sort(arrayList, this.nameComparator);
            processingResource = (ProcessingResource)arrayList.get(n);
            switch (n2) {
                case 0: {
                    return processingResource;
                }
                case 1: {
                    ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(processingResource.getClass().getName());
                    if (resourceData == null) {
                        return processingResource.getClass();
                    }
                    return resourceData.getName();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return ProcessingResource.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

