/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.CreoleRegister;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.AnnotationSchema;
import gate.creole.AnnotationVisualResource;
import gate.creole.FeatureSchema;
import gate.gui.ResizableVisualResource;
import gate.util.GateException;
import gate.util.LuckyException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class SchemaAnnotationEditor
extends AbstractVisualResource
implements AnnotationVisualResource,
ResizableVisualResource {
    List currentAnnotationSchemaList = null;
    AnnotationSet currentAnnotSet = null;
    Annotation currentAnnot = null;
    Long currentStartOffset = null;
    Long currentEndOffset = null;
    AnnotationSchema currentAnnotSchema = null;
    FeatureMap currentAnnotFeaturesMap = null;
    FeatureMap responseMap = null;
    FeaturesTableModel tableModel = null;
    Map name2featureSchemaMap = null;
    Map name2annotSchemaMap = null;
    DefaultListModel listModel = null;
    JTable featuresTable = null;
    JScrollPane featuresTableScroll = null;
    JList featureSchemaList = null;
    JScrollPane featuresListScroll = null;
    JButton removeFeatButton = null;
    JButton addFeatButton = null;
    JComboBox annotSchemaComboBox = null;
    InnerFeaturesEditor featuresEditor = null;

    public void setTarget(Object object) {
        this.currentAnnotSet = (AnnotationSet)object;
    }

    public void setAnnotation(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        this.currentAnnot = annotation;
        this.currentStartOffset = this.currentAnnot.getStartNode().getOffset();
        this.currentEndOffset = this.currentAnnot.getEndNode().getOffset();
        this.currentAnnotFeaturesMap = Factory.newFeatureMap();
        this.currentAnnotFeaturesMap.putAll(this.currentAnnot.getFeatures());
        this.currentAnnotSchema = null;
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        List<LanguageResource> list = creoleRegister.getLrInstances("gate.creole.AnnotationSchema");
        if (list.isEmpty()) {
            return;
        }
        this.name2annotSchemaMap = new TreeMap();
        Iterator<LanguageResource> iterator = list.iterator();
        this.currentAnnotSchema = (AnnotationSchema)list.get(0);
        while (iterator.hasNext()) {
            AnnotationSchema annotationSchema = (AnnotationSchema)iterator.next();
            String string = annotationSchema.getAnnotationName();
            if (annotationSchema != null && string != null) {
                this.name2annotSchemaMap.put(string, annotationSchema);
            }
            if (!this.currentAnnot.getType().equals(string)) continue;
            this.currentAnnotSchema = annotationSchema;
        }
        this.initLocalData();
        this.buildGuiComponents();
        this.initListeners();
    }

    public void setSpan(Long l, Long l2, String string) {
        if (l == null || l2 == null) {
            return;
        }
        this.currentStartOffset = l;
        this.currentEndOffset = l2;
        this.currentAnnot = null;
        this.currentAnnotFeaturesMap = null;
        this.currentAnnotSchema = null;
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        List<Resource> list = null;
        try {
            list = creoleRegister.getAllInstances("gate.creole.AnnotationSchema");
        }
        catch (GateException gateException) {
            throw new LuckyException("gate.creole.AnnotationSchema or a class that extends it, is not registered in the creole.xml register.Edit your creole.xml and try again.");
        }
        if (list.isEmpty()) {
            return;
        }
        this.name2annotSchemaMap = new TreeMap();
        Iterator<Resource> iterator = list.iterator();
        this.currentAnnotSchema = (AnnotationSchema)list.get(0);
        while (iterator.hasNext()) {
            AnnotationSchema annotationSchema = (AnnotationSchema)iterator.next();
            String string2 = annotationSchema.getAnnotationName();
            if (annotationSchema == null || string2 == null) continue;
            this.name2annotSchemaMap.put(string2, annotationSchema);
        }
        this.initLocalData();
        this.buildGuiComponents();
        this.initListeners();
    }

    public void okAction() throws GateException {
        for (RowData rowData : this.tableModel.data) {
            this.responseMap.put(rowData.getFeatureSchema().getFeatureName(), rowData.getValue());
        }
        if (this.currentAnnot == null) {
            this.currentAnnotSet.add(this.currentStartOffset, this.currentEndOffset, this.currentAnnotSchema.getAnnotationName(), this.responseMap);
        } else if (this.currentAnnot.getType().equals(this.currentAnnotSchema.getAnnotationName())) {
            this.currentAnnot.setFeatures(this.responseMap);
        } else {
            this.currentAnnotSet.add(this.currentStartOffset, this.currentEndOffset, this.currentAnnotSchema.getAnnotationName(), this.responseMap);
            this.currentAnnotSet.remove(this.currentAnnot);
        }
    }

    public void cancelAction() throws GateException {
    }

    public boolean canDisplayAnnotationType(String string) {
        if (string == null) {
            return false;
        }
        CreoleRegister creoleRegister = Gate.getCreoleRegister();
        List<LanguageResource> list = creoleRegister.getLrInstances("gate.creole.AnnotationSchema");
        if (list.isEmpty()) {
            return false;
        }
        for (AnnotationSchema annotationSchema : list) {
            if (!string.equals(annotationSchema.getAnnotationName())) continue;
            return true;
        }
        return false;
    }

    protected void initLocalData() {
        this.responseMap = Factory.newFeatureMap();
        if (this.currentAnnotFeaturesMap == null) {
            this.currentAnnotFeaturesMap = Factory.newFeatureMap();
        }
        this.name2featureSchemaMap = new HashMap();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.listModel = new DefaultListModel();
        Set set = this.currentAnnotSchema.getFeatureSchemaSet();
        if (set != null) {
            for (Object object : set) {
                if (object == null) continue;
                hashMap.put(((FeatureSchema)object).getFeatureName(), object);
                if (this.currentAnnotFeaturesMap.containsKey(((FeatureSchema)object).getFeatureName())) continue;
                this.name2featureSchemaMap.put(((FeatureSchema)object).getFeatureName(), object);
                this.listModel.addElement(((FeatureSchema)object).getFeatureName());
            }
        }
        HashSet hashSet = new HashSet();
        for (String string : this.currentAnnotFeaturesMap.keySet()) {
            if (hashMap.keySet().contains(string)) {
                Object v = this.currentAnnotFeaturesMap.get(string);
                hashSet.add(new RowData(v, (FeatureSchema)hashMap.get(string)));
                continue;
            }
            this.responseMap.put(string, this.currentAnnotFeaturesMap.get(string));
        }
        this.tableModel = new FeaturesTableModel(hashSet);
    }

    protected void buildGuiComponents() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createVerticalStrut(5));
        this.annotSchemaComboBox = new JComboBox<Object>(this.name2annotSchemaMap.keySet().toArray());
        this.annotSchemaComboBox.setEditable(false);
        this.annotSchemaComboBox.setAlignmentX(0.0f);
        this.annotSchemaComboBox.setSelectedItem(this.currentAnnotSchema.getAnnotationName());
        JLabel jLabel = new JLabel("Select annotation type");
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(this.annotSchemaComboBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentX(0.0f);
        this.featuresTable = new JTable();
        this.featuresTable.setSelectionMode(2);
        this.featuresTable.setModel(new FeaturesTableModel(new HashSet()));
        this.featuresEditor = new InnerFeaturesEditor();
        this.featuresTable.setDefaultEditor(Object.class, this.featuresEditor);
        this.featuresTableScroll = new JScrollPane(this.featuresTable);
        Box box = Box.createVerticalBox();
        JLabel jLabel2 = new JLabel("Current features");
        jLabel2.setAlignmentX(0.0f);
        box.add(jLabel2);
        box.add(Box.createVerticalStrut(10));
        box.add(this.featuresTableScroll);
        this.featuresTableScroll.setAlignmentX(0.0f);
        jPanel2.add(box);
        jPanel2.add(Box.createHorizontalStrut(10));
        Box box2 = Box.createVerticalBox();
        this.removeFeatButton = new JButton(">>");
        this.addFeatButton = new JButton("<<");
        box2.add(this.addFeatButton);
        box2.add(Box.createVerticalStrut(10));
        box2.add(this.removeFeatButton);
        jPanel2.add(box2);
        jPanel2.add(Box.createHorizontalStrut(10));
        this.featureSchemaList = new JList();
        this.featureSchemaList.setSelectionMode(2);
        Set set = this.currentAnnotSchema.getFeatureSchemaSet();
        if (set != null) {
            this.featureSchemaList.setVisibleRowCount(set.size());
        }
        this.featuresListScroll = new JScrollPane(this.featureSchemaList);
        box = Box.createVerticalBox();
        JLabel jLabel3 = new JLabel("Possible features");
        jLabel3.setAlignmentX(0.0f);
        box.add(jLabel3);
        box.add(Box.createVerticalStrut(10));
        this.featuresListScroll.setAlignmentX(0.0f);
        box.add(this.featuresListScroll);
        jPanel2.add(box);
        jPanel2.add(Box.createHorizontalStrut(5));
        box = Box.createVerticalBox();
        box.add(jPanel);
        box.add(jPanel2);
        this.add(box);
        this.initGuiComponents();
    }

    protected void initGuiComponents() {
        this.featuresTable.setModel(this.tableModel);
        this.featureSchemaList.setModel(this.listModel);
    }

    protected void initListeners() {
        this.annotSchemaComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaAnnotationEditor.this.currentAnnotSchema = (AnnotationSchema)SchemaAnnotationEditor.this.name2annotSchemaMap.get((String)SchemaAnnotationEditor.this.annotSchemaComboBox.getSelectedItem());
                SchemaAnnotationEditor.this.initLocalData();
                SchemaAnnotationEditor.this.initGuiComponents();
            }
        });
        this.removeFeatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaAnnotationEditor.this.doRemoveFeatures();
            }
        });
        this.addFeatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaAnnotationEditor.this.doAddFeatures();
            }
        });
    }

    private void doRemoveFeatures() {
        int[] nArray = this.featuresTable.getSelectedRows();
        if (nArray.length <= 0) {
            return;
        }
        for (int i = nArray.length - 1; i > -1; --i) {
            this.doRemoveFeature(nArray[i]);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void doRemoveFeature(int n) {
        RowData rowData = (RowData)this.tableModel.data.get(n);
        this.name2featureSchemaMap.put(rowData.getFeatureSchema().getFeatureName(), rowData.getFeatureSchema());
        this.listModel.addElement(rowData.getFeatureSchema().getFeatureName());
        this.tableModel.data.remove(n);
    }

    private void doAddFeatures() {
        Object[] objectArray = this.featureSchemaList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.doAddFeature((String)objectArray[i]);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void doAddFeature(String string) {
        Iterator iterator;
        FeatureSchema featureSchema = (FeatureSchema)this.name2featureSchemaMap.get(string);
        this.name2featureSchemaMap.remove(string);
        this.listModel.removeElement(string);
        String string2 = null;
        if (featureSchema.isDefault() || featureSchema.isFixed()) {
            string2 = featureSchema.getFeatureValue();
        }
        if (string2 == null && featureSchema.isEnumeration() && (iterator = featureSchema.getPermissibleValues().iterator()).hasNext()) {
            string2 = iterator.next();
        }
        this.tableModel.data.add(new RowData(string2, featureSchema));
    }

    class InnerFeaturesEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox cb = null;
        JTextField tf = null;
        int thisRow = 0;
        int thisColumn = 0;

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.thisRow = n;
            this.thisColumn = n2;
            RowData rowData = (RowData)SchemaAnnotationEditor.this.tableModel.data.get(n);
            if (rowData.getFeatureSchema().isEnumeration()) {
                this.cb = new JComboBox<Object>(rowData.getFeatureSchema().getPermissibleValues().toArray());
                this.cb.setSelectedItem(object);
                this.cb.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SchemaAnnotationEditor.this.tableModel.setValueAt(InnerFeaturesEditor.this.cb.getSelectedItem(), InnerFeaturesEditor.this.thisRow, InnerFeaturesEditor.this.thisColumn);
                    }
                });
                this.tf = null;
                return this.cb;
            }
            if (rowData.getFeatureSchema().isDefault() || rowData.getFeatureSchema().isOptional() || rowData.getFeatureSchema().isRequired()) {
                this.tf = new JTextField(object.toString());
                this.cb = null;
                return this.tf;
            }
            return new JLabel(object.toString());
        }

        public Object getCellEditorValue() {
            if (this.cb != null) {
                return this.cb.getSelectedItem();
            }
            if (this.tf != null) {
                return this.tf.getText();
            }
            return new String("");
        }
    }

    class RowData {
        private Object value = null;
        private FeatureSchema featSchema = null;

        RowData(Object object, FeatureSchema featureSchema) {
            this.value = object;
            this.featSchema = featureSchema;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public void setFeatureSchema(FeatureSchema featureSchema) {
            this.featSchema = featureSchema;
        }

        public FeatureSchema getFeatureSchema() {
            return this.featSchema;
        }
    }

    protected class FeaturesTableModel
    extends AbstractTableModel {
        ArrayList data = null;

        public FeaturesTableModel(Set set) {
            this.data = new ArrayList(set);
        }

        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 3;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
                case 2: {
                    return "Type";
                }
            }
            return "?";
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                RowData rowData = (RowData)this.data.get(n);
                FeatureSchema featureSchema = rowData.getFeatureSchema();
                return !featureSchema.isFixed() && !featureSchema.isProhibited();
            }
            if (n2 == 0 || n2 == 2) {
                return false;
            }
            return false;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public Object getValueAt(int n, int n2) {
            RowData rowData = (RowData)this.data.get(n);
            switch (n2) {
                case 0: {
                    return rowData.getFeatureSchema().getFeatureName();
                }
                case 1: {
                    return rowData.getValue() == null ? new String("") : rowData.getValue();
                }
                case 2: {
                    String string = rowData.getFeatureSchema().getValueClassName();
                    if (string == null) {
                        return new String("");
                    }
                    int n3 = string.lastIndexOf(".");
                    if (n3 > -1 && n3 < string.length()) {
                        return string.substring(n3 + 1, string.length());
                    }
                    return string;
                }
            }
            return "?";
        }

        public void setValueAt(Object object, int n, int n2) {
            if (this.data == null || this.data.isEmpty()) {
                return;
            }
            RowData rowData = (RowData)this.data.get(n);
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    String string = null;
                    String string2 = null;
                    if (object == null) {
                        rowData.setValue("?");
                        return;
                    }
                    string = rowData.getFeatureSchema().getValueClassName();
                    string2 = object.getClass().toString();
                    if (string == null) {
                        rowData.setValue(object);
                        return;
                    }
                    if (string.equals(string2)) {
                        rowData.setValue(object);
                        return;
                    }
                    if (!"class java.lang.String".equals(string2)) {
                        rowData.setValue(object);
                        return;
                    }
                    Class<?> clazz = null;
                    try {
                        clazz = Gate.getClassLoader().loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            clazz = Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            rowData.setValue(object);
                            return;
                        }
                    }
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    if (constructorArray == null) {
                        rowData.setValue(object);
                        return;
                    }
                    boolean bl = false;
                    Constructor<?> constructor = null;
                    for (int i = 0; i < constructorArray.length; ++i) {
                        constructor = constructorArray[i];
                        if (constructor.getParameterTypes().length != 1 || !"class java.lang.String".equals(constructor.getParameterTypes()[0].toString())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        rowData.setValue(object);
                        return;
                    }
                    try {
                        Object[] objectArray = new Object[]{object};
                        Object obj = constructor.newInstance(objectArray);
                        rowData.setValue(obj);
                    }
                    catch (Exception exception) {
                        rowData.setValue("");
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }
}

