/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class STreeNode
extends DefaultMutableTreeNode {
    private static final boolean DEBUG = false;
    private static final String ADDEDSET = "TreeViewerTempAdded";
    private static final String REMOVEDSET = "TreeViewerTempRemoved";
    static int nextID = 0;
    int level = -1;
    int nodeID = nextID++;
    long start;
    long end;
    Annotation annot;

    public STreeNode(Annotation annotation) {
        this.annot = annotation;
        this.start = annotation.getStartNode().getOffset();
        this.end = annotation.getEndNode().getOffset();
    }

    public STreeNode(long l, long l2) {
        this.start = l;
        this.end = l2;
    }

    public STreeNode() {
        this.start = 0L;
        this.end = 0L;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(long l) {
        this.level = (int)l;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getID() {
        return this.nodeID;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long l) {
        this.end = l;
    }

    public void setAnnotation(Annotation annotation) {
        this.annot = annotation;
        this.start = annotation.getStartNode().getOffset();
        this.end = annotation.getEndNode().getOffset();
    }

    public Annotation getAnnotation() {
        return this.annot;
    }

    public void disconnectChildren() {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ((STreeNode)iterator.next()).setParent(null);
        }
        this.children.clear();
    }

    public boolean createAnnotation(Document document, String string, String string2, long l) {
        boolean bl = false;
        if (this.annot != null) {
            return false;
        }
        if (document == null) {
            return false;
        }
        if (!this.getAllowsChildren()) {
            return false;
        }
        FeatureMap featureMap = Factory.newFeatureMap();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Long l2 = new Long(this.start);
        Long l3 = new Long(this.end);
        featureMap.put("text", string2.substring((int)(this.start - l), (int)(this.end - l)));
        featureMap.put("cat", (String)this.getUserObject());
        featureMap.put("consists", arrayList);
        for (Serializable serializable : this.children) {
            if (((STreeNode)serializable).getAnnotation() == null) {
                if (!((DefaultMutableTreeNode)serializable).getAllowsChildren() || !this.createAnnotation(document, string, string2, l)) continue;
                arrayList.add(((STreeNode)serializable).getAnnotation().getId());
                continue;
            }
            arrayList.add(((STreeNode)serializable).getAnnotation().getId());
        }
        AnnotationSet annotationSet = document.getAnnotations(ADDEDSET);
        try {
            Serializable serializable;
            serializable = annotationSet.add(l2, l3, string, featureMap);
            this.annot = annotationSet.get((Integer)serializable);
            bl = true;
        }
        catch (InvalidOffsetException invalidOffsetException) {
            Out.println("Invalid annotation offsets: " + this.start + " and/or " + this.end);
            bl = false;
        }
        return bl;
    }

    public static boolean transferAnnotations(Document document, AnnotationSet annotationSet) {
        if (document == null || annotationSet == null) {
            return false;
        }
        HashMap<Integer, Comparable> hashMap = new HashMap<Integer, Comparable>();
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        AnnotationSet annotationSet2 = document.getAnnotations(ADDEDSET);
        if (annotationSet2 != null && !annotationSet2.isEmpty()) {
            Comparable comparable;
            for (Annotation annotation : annotationSet2) {
                try {
                    comparable = annotationSet.add(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), annotation.getType(), annotation.getFeatures());
                    hashMap.put(annotation.getId(), comparable);
                    arrayList.add(annotationSet.get((Integer)comparable));
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    Out.println("Invalid annotation offsets: " + annotation.getStartNode().getOffset() + " and/or " + annotation.getEndNode().getOffset());
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                comparable = (Annotation)arrayList.get(i);
                List list = (List)comparable.getFeatures().get("consists");
                if (list == null || list.size() == 0) continue;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (int j = 0; j < list.size(); ++j) {
                    Integer n = (Integer)list.get(j);
                    if (hashMap.get(n) != null) {
                        arrayList2.add(hashMap.get(n));
                        continue;
                    }
                    arrayList2.add(n);
                }
                comparable.getFeatures().put("consists", arrayList2);
            }
            annotationSet2.clear();
        }
        document.removeAnnotationSet(ADDEDSET);
        AnnotationSet annotationSet3 = document.getAnnotations(REMOVEDSET);
        if (annotationSet3 != null && !annotationSet3.isEmpty()) {
            annotationSet.removeAll(annotationSet3);
            annotationSet3.clear();
        }
        document.removeAnnotationSet(REMOVEDSET);
        return true;
    }

    public static void undo(Document document) {
        AnnotationSet annotationSet = document.getAnnotations(ADDEDSET);
        AnnotationSet annotationSet2 = document.getAnnotations(REMOVEDSET);
        annotationSet.clear();
        annotationSet2.clear();
        document.removeAnnotationSet(ADDEDSET);
        document.removeAnnotationSet(REMOVEDSET);
    }

    public void removeAnnotation(Document document) {
        if (this.annot == null || document == null) {
            return;
        }
        document.getAnnotations(REMOVEDSET).add(this.annot);
        this.annot = null;
    }
}

