/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Controller;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ResourceData;
import gate.gui.MainFrame;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class ResourceRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer,
TreeCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public ResourceRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.prepareRenderer(jList, object, bl, this.hasFocus());
        return this;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.prepareRenderer(jTable, object, bl, bl2);
        return this;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.prepareRenderer(jTree, object, bl, bl4);
        return this;
    }

    private void prepareRenderer(JComponent jComponent, Object object, boolean bl, boolean bl2) {
        Icon icon;
        String string;
        Object object2;
        if (bl) {
            if (jComponent instanceof JTable) {
                this.setForeground(((JTable)jComponent).getSelectionForeground());
                this.setBackground(((JTable)jComponent).getSelectionBackground());
            } else if (jComponent instanceof JTree) {
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
            } else if (jComponent instanceof JList) {
                this.setForeground(((JList)jComponent).getSelectionForeground());
                this.setBackground(((JList)jComponent).getSelectionBackground());
            }
        } else if (jComponent instanceof JTable) {
            object2 = (JTable)jComponent;
            this.setForeground(jComponent.getForeground());
            this.setBackground(jComponent.getBackground());
        } else {
            this.setForeground(jComponent.getForeground());
            this.setBackground(jComponent.getBackground());
        }
        this.setFont(jComponent.getFont());
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        ResourceData resourceData = null;
        if (object instanceof Resource) {
            object2 = ((Resource)object).getName();
            resourceData = (ResourceData)Gate.getCreoleRegister().get(object.getClass().getName());
        } else {
            Object object3 = object2 = object == null ? "<none>" : object.toString();
        }
        if (resourceData != null) {
            string = "<HTML>Type: <b>" + resourceData.getName() + "</b></HTML>";
            String string2 = resourceData.getIcon();
            if (string2 == null) {
                if (object instanceof LanguageResource) {
                    string2 = "lr";
                } else if (object instanceof ProcessingResource) {
                    string2 = "pr";
                } else if (object instanceof Controller) {
                    string2 = "application";
                }
            }
            icon = string2 == null ? null : MainFrame.getIcon(string2);
        } else {
            icon = null;
            string = null;
        }
        this.setText((String)object2);
        this.setIcon(icon);
        this.setToolTipText(string);
    }
}

