/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.BooleanRenderer;
import gate.gui.FeatureMapEditorDialog;
import gate.gui.ListEditorDialog;
import gate.gui.MainFrame;
import gate.gui.ObjectRenderer;
import gate.gui.ParameterDisjunction;
import gate.gui.ResourceRenderer;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.GateException;
import gate.util.LuckyException;
import gate.util.NameBearer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class ResourceParametersEditor
extends XJTable
implements CreoleListener {
    ParametersTableModel tableModel;
    Resource resource;
    protected List parameterDisjunctions;
    protected boolean editable = true;

    public ResourceParametersEditor() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.setSortable(true);
        this.setSortedColumn(0);
        this.setComparator(0, new ParameterDisjunctionComparator());
    }

    public void init(Resource resource, List list) {
        this.cleanup();
        this.resource = resource;
        if (list != null) {
            this.parameterDisjunctions = new ArrayList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.parameterDisjunctions.add(new ParameterDisjunction(resource, (List)list.get(i)));
            }
        } else {
            this.parameterDisjunctions = null;
        }
        this.tableModel.fireTableDataChanged();
    }

    protected void initLocalData() {
        this.resource = null;
        this.parameterDisjunctions = null;
    }

    protected void initGuiComponents() {
        this.tableModel = new ParametersTableModel();
        this.setModel(this.tableModel);
        this.getColumnModel().getColumn(0).setCellRenderer(new ParameterDisjunctionRenderer());
        this.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer());
        this.getColumnModel().getColumn(2).setCellRenderer(new BooleanRenderer());
        this.getColumnModel().getColumn(3).setCellRenderer(new ParameterValueRenderer());
        this.getColumnModel().getColumn(0).setCellEditor(new ParameterDisjunctionEditor());
        this.getColumnModel().getColumn(3).setCellEditor(new ParameterValueEditor());
        this.setIntercellSpacing(new Dimension(5, 5));
        this.setAutoResizeMode(3);
        this.setSurrendersFocusOnKeystroke(true);
    }

    protected void initListeners() {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && ResourceParametersEditor.this.getEditingColumn() == -1 && ResourceParametersEditor.this.getEditingRow() == -1) {
                    ResourceParametersEditor.this.getParent().dispatchEvent(keyEvent);
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        if (this.parameterDisjunctions != null && this.parameterDisjunctions.size() > 0) {
            for (int i = 0; i < this.parameterDisjunctions.size(); ++i) {
                ((ParameterDisjunction)this.parameterDisjunctions.get(i)).cleanup();
            }
        }
        this.resource = null;
    }

    public void setParameters() throws ResourceInstantiationException {
        if (this.resource == null || this.parameterDisjunctions == null) {
            return;
        }
        if (this.getEditingColumn() != -1 && this.getEditingRow() != -1) {
            this.editingStopped(new ChangeEvent(this.getCellEditor(this.getEditingRow(), this.getEditingColumn())));
        }
        for (int i = 0; i < this.parameterDisjunctions.size(); ++i) {
            ParameterDisjunction parameterDisjunction = (ParameterDisjunction)this.parameterDisjunctions.get(i);
            this.resource.setParameterValue(parameterDisjunction.getName(), parameterDisjunction.getValue());
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public FeatureMap getParameterValues() {
        if (this.getEditingColumn() != -1 && this.getEditingRow() != -1) {
            this.editingStopped(new ChangeEvent(this.getCellEditor(this.getEditingRow(), this.getEditingColumn())));
        }
        FeatureMap featureMap = Factory.newFeatureMap();
        if (this.parameterDisjunctions != null) {
            for (int i = 0; i < this.parameterDisjunctions.size(); ++i) {
                ParameterDisjunction parameterDisjunction = (ParameterDisjunction)this.parameterDisjunctions.get(i);
                featureMap.put(parameterDisjunction.getName(), parameterDisjunction.getValue());
            }
        }
        return featureMap;
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
        this.repaint();
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        this.repaint();
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
        this.repaint();
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    void removeCreoleListenerLink() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        if (this.parameterDisjunctions != null && this.parameterDisjunctions.size() > 0) {
            for (int i = 0; i < this.parameterDisjunctions.size(); ++i) {
                ((ParameterDisjunction)this.parameterDisjunctions.get(i)).removeCreoleListenerLink();
            }
        }
    }

    class ParameterValueEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        String type;
        JComboBox combo = new JComboBox();
        JTextField textField;
        JTextField textFieldBoolean;
        JFileChooser fileChooser;
        ListEditorDialog listEditor = null;
        Collection listValue;
        FeatureMapEditorDialog fmEditor = null;
        FeatureMap fmValue;
        boolean comboUsed;
        boolean listUsed;
        boolean fmUsed;
        JButton fileButton;
        JButton listButton;
        JButton fmButton;
        JPanel textButtonBox;

        ParameterValueEditor() {
            this.combo.setRenderer(new ResourceRenderer());
            this.combo.setEditable(false);
            this.textField = new JTextField();
            this.fileChooser = MainFrame.getFileChooser();
            this.fileButton = new JButton(MainFrame.getIcon("open-file"));
            this.fileButton.setToolTipText("Set from file...");
            this.fileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ParameterValueEditor.this.fileChooser.setFileSelectionMode(2);
                    ParameterValueEditor.this.fileChooser.setDialogTitle("Select a file");
                    int n = ParameterValueEditor.this.fileChooser.showOpenDialog(ResourceParametersEditor.this);
                    if (n == 0) {
                        try {
                            ParameterValueEditor.this.textField.setText(ParameterValueEditor.this.fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ParameterValueEditor.this.fireEditingStopped();
                    } else {
                        ParameterValueEditor.this.fireEditingCanceled();
                    }
                }
            });
            this.listButton = new JButton(MainFrame.getIcon("edit-list"));
            this.listButton.setToolTipText("Edit the collection");
            this.listButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List list = ParameterValueEditor.this.listEditor.showDialog();
                    if (list != null) {
                        ParameterValueEditor.this.listValue = list;
                        ParameterValueEditor.this.fireEditingStopped();
                    } else {
                        ParameterValueEditor.this.fireEditingCanceled();
                    }
                }
            });
            this.fmButton = new JButton(MainFrame.getIcon("edit-list"));
            this.fmButton.setToolTipText("Edit the feature map");
            this.fmButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FeatureMap featureMap = ParameterValueEditor.this.fmEditor.showDialog();
                    if (featureMap != null) {
                        ParameterValueEditor.this.fmValue = featureMap;
                        ParameterValueEditor.this.fireEditingStopped();
                    } else {
                        ParameterValueEditor.this.fireEditingCanceled();
                    }
                }
            });
            this.textButtonBox = new JPanel();
            this.textButtonBox.setLayout(new BoxLayout(this.textButtonBox, 0));
            this.textButtonBox.setOpaque(false);
            this.textFieldBoolean = new JTextField();
            this.textFieldBoolean.setEditable(false);
            this.textFieldBoolean.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Boolean bl = new Boolean(ParameterValueEditor.this.textFieldBoolean.getText());
                    bl = new Boolean(bl == false);
                    ParameterValueEditor.this.textFieldBoolean.setText(bl.toString());
                }
            });
            this.textFieldBoolean.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    Boolean bl = new Boolean(ParameterValueEditor.this.textFieldBoolean.getText());
                    bl = new Boolean(bl == false);
                    ParameterValueEditor.this.textFieldBoolean.setText(bl.toString());
                }
            });
            this.textButtonBox.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    if (!ParameterValueEditor.this.comboUsed) {
                        ParameterValueEditor.this.textField.requestFocusInWindow();
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.comboUsed = false;
            this.listUsed = false;
            this.fmUsed = false;
            ParameterDisjunction parameterDisjunction = (ParameterDisjunction)jTable.getValueAt(n, 0);
            this.type = parameterDisjunction.getType();
            this.combo.setToolTipText(parameterDisjunction.getComment());
            this.textField.setToolTipText(parameterDisjunction.getComment());
            if (Gate.isGateType(this.type)) {
                this.comboUsed = true;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                try {
                    arrayList.addAll(Gate.getCreoleRegister().getAllInstances(this.type));
                }
                catch (GateException gateException) {
                    gateException.printStackTrace(Err.getPrintWriter());
                }
                arrayList.add(0, "<none>");
                this.combo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.combo.setSelectedItem(object == null ? "<none>" : object);
                this.combo.setToolTipText(parameterDisjunction.getComment());
                return this.combo;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.type, true, Gate.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.textField.setText(object == null ? "" : object.toString());
            if (this.type.equals("java.net.URL")) {
                this.fileChooser.resetChoosableFileFilters();
                this.fileChooser.setAcceptAllFileFilterUsed(true);
                this.fileChooser.setFileFilter(this.fileChooser.getAcceptAllFileFilter());
                Parameter parameter = parameterDisjunction.getParameter();
                Set set = parameter.getSuffixes();
                if (set != null) {
                    ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        extensionFileFilter.addExtension((String)iterator.next());
                    }
                    extensionFileFilter.setDescription("Known file types " + set.toString());
                    this.fileChooser.addChoosableFileFilter(extensionFileFilter);
                    this.fileChooser.setFileFilter(extensionFileFilter);
                }
                this.textField.setEditable(true);
                this.textButtonBox.removeAll();
                this.textButtonBox.add(this.textField);
                this.textButtonBox.add(Box.createHorizontalStrut(5));
                this.textButtonBox.add(this.fileButton);
                return this.textButtonBox;
            }
            if (this.type.equals("java.lang.Boolean")) {
                this.textFieldBoolean.setText(object == null ? "false" : object.toString());
                return this.textFieldBoolean;
            }
            if (clazz != null && Collection.class.isAssignableFrom(clazz)) {
                this.listUsed = true;
                Parameter parameter = parameterDisjunction.getParameter();
                this.listValue = (Collection)object;
                this.listEditor = new ListEditorDialog(SwingUtilities.getAncestorOfClass(Window.class, ResourceParametersEditor.this), (Collection)object, clazz, parameter.getItemClassName());
                this.textField.setEditable(false);
                this.textField.setText(this.textForList((Collection)object));
                this.textButtonBox.removeAll();
                this.textButtonBox.add(this.textField);
                this.textButtonBox.add(Box.createHorizontalStrut(5));
                this.textButtonBox.add(this.listButton);
                return this.textButtonBox;
            }
            if (clazz != null && FeatureMap.class.isAssignableFrom(clazz)) {
                this.fmUsed = true;
                this.fmValue = (FeatureMap)object;
                this.fmEditor = new FeatureMapEditorDialog(SwingUtilities.getAncestorOfClass(Window.class, ResourceParametersEditor.this), (FeatureMap)object);
                this.textField.setEditable(false);
                this.textField.setText(this.textForFeatureMap((FeatureMap)object));
                this.textButtonBox.removeAll();
                this.textButtonBox.add(this.textField);
                this.textButtonBox.add(Box.createHorizontalStrut(5));
                this.textButtonBox.add(this.fmButton);
                return this.textButtonBox;
            }
            if (clazz != null && clazz.isEnum()) {
                this.comboUsed = true;
                try {
                    Method method = clazz.getMethod("values", new Class[0]);
                    Object[] objectArray = (Object[])method.invoke(null, new Object[0]);
                    Object[] objectArray2 = null;
                    Parameter parameter = parameterDisjunction.getParameter();
                    if (parameter.isOptional()) {
                        objectArray2 = new Object[objectArray.length + 1];
                        objectArray2[0] = "<none>";
                        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                    } else {
                        objectArray2 = objectArray;
                    }
                    this.combo.setModel(new DefaultComboBoxModel<Object>(objectArray2));
                    this.combo.setSelectedItem(object == null ? "<none>" : object);
                    return this.combo;
                }
                catch (Exception exception) {
                    throw new LuckyException("Error calling \"values\" method of an enum type");
                }
            }
            this.textField.setEditable(true);
            return this.textField;
        }

        protected String textForList(Collection collection) {
            if (collection == null || collection.isEmpty()) {
                return "[]";
            }
            StringBuffer stringBuffer = new StringBuffer("[");
            for (Object e : collection) {
                stringBuffer.append((e instanceof NameBearer ? ((NameBearer)e).getName() : e.toString()) + ", ");
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length() - 1);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        protected String textForFeatureMap(FeatureMap featureMap) {
            return featureMap == null ? "" : featureMap.toString();
        }

        public Object getCellEditorValue() {
            if (this.comboUsed) {
                Object object = this.combo.getSelectedItem();
                return object == "<none>" ? null : object;
            }
            if (this.listUsed) {
                return this.listValue;
            }
            if (this.fmUsed) {
                return this.fmValue;
            }
            if (this.type.equals("java.lang.Boolean")) {
                return new Boolean(this.textFieldBoolean.getText());
            }
            return this.textField.getText();
        }
    }

    class ParameterDisjunctionEditor
    extends DefaultCellEditor {
        JComboBox combo;
        ParameterDisjunction pDisj;

        public ParameterDisjunctionEditor() {
            super(new JComboBox());
            this.combo = (JComboBox)super.getComponent();
            class CustomRenderer
            extends JLabel
            implements ListCellRenderer {
                public CustomRenderer() {
                    this.setOpaque(true);
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (bl) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(jList.getBackground());
                        this.setForeground(jList.getForeground());
                    }
                    this.setFont(jList.getFont());
                    this.setText((String)object);
                    String string = "param";
                    Parameter[] parameterArray = ParameterDisjunctionEditor.this.pDisj.getParameters();
                    for (int i = 0; i < parameterArray.length; ++i) {
                        ResourceData resourceData;
                        Parameter parameter = parameterArray[i];
                        if (!parameter.getName().equals(object)) continue;
                        String string2 = parameter.getTypeName();
                        if (!Gate.getCreoleRegister().containsKey(string2) || (resourceData = (ResourceData)Gate.getCreoleRegister().get(string2)) == null) break;
                        string = resourceData.getIcon();
                        break;
                    }
                    this.setIcon(MainFrame.getIcon(string));
                    return this;
                }
            }
            this.combo.setRenderer(new CustomRenderer());
            this.combo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ParameterDisjunctionEditor.this.stopCellEditing();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.pDisj = (ParameterDisjunction)object;
            this.combo.setModel(new DefaultComboBoxModel<String>(this.pDisj.getNames()));
            return this.combo;
        }

        public Object getCellEditorValue() {
            return new Integer(this.combo.getSelectedIndex());
        }

        public boolean stopCellEditing() {
            this.combo.hidePopup();
            return super.stopCellEditing();
        }
    }

    class ParameterDisjunctionComparator
    implements Comparator {
        ParameterDisjunctionComparator() {
        }

        public int compare(Object object, Object object2) {
            ParameterDisjunction parameterDisjunction = (ParameterDisjunction)object;
            ParameterDisjunction parameterDisjunction2 = (ParameterDisjunction)object2;
            return parameterDisjunction.getName().compareTo(parameterDisjunction2.getName());
        }
    }

    class ParameterValueRenderer
    extends ObjectRenderer {
        JButton fileButton = new JButton(MainFrame.getIcon("open-file"));
        JButton listButton;
        JButton fmButton;
        JComboBox combo;
        JPanel textButtonBox;
        JTextField textField;

        ParameterValueRenderer() {
            this.fileButton.setToolTipText("Set from file...");
            this.listButton = new JButton(MainFrame.getIcon("edit-list"));
            this.listButton.setToolTipText("Edit the list");
            this.fmButton = new JButton(MainFrame.getIcon("edit-list"));
            this.fmButton.setToolTipText("Edit the feature map");
            this.textField = new JTextField();
            this.textButtonBox = new JPanel();
            this.textButtonBox.setLayout(new BoxLayout(this.textButtonBox, 0));
            this.textButtonBox.setOpaque(false);
            this.combo = new JComboBox();
            this.combo.setRenderer(new ResourceRenderer());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ParameterDisjunction parameterDisjunction = (ParameterDisjunction)jTable.getValueAt(n, 0);
            String string = parameterDisjunction.getType();
            this.combo.setToolTipText(parameterDisjunction.getComment());
            this.textField.setToolTipText(parameterDisjunction.getComment());
            if (Gate.isGateType(string)) {
                if (ResourceParametersEditor.this.isEditable()) {
                    this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{object == null ? "<none>" : object}));
                    return this.combo;
                }
                String string2 = object == null ? "<none>" : object.toString();
                this.textField.setText(string2);
                return this.textField;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string, true, Gate.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            String string3 = object == null ? "                                                                                " : object.toString();
            this.textField.setText(string3);
            if (string.equals("java.net.URL")) {
                if (ResourceParametersEditor.this.isEditable()) {
                    this.textButtonBox.removeAll();
                    this.textField.setText(string3);
                    this.textButtonBox.add(this.textField);
                    this.textButtonBox.add(Box.createHorizontalStrut(5));
                    this.textButtonBox.add(this.fileButton);
                    return this.textButtonBox;
                }
                return this.textField;
            }
            if (clazz != null && Collection.class.isAssignableFrom(clazz)) {
                this.textField.setText(this.textForList((Collection)object));
                if (ResourceParametersEditor.this.isEditable()) {
                    this.textButtonBox.removeAll();
                    this.textButtonBox.add(this.textField);
                    this.textButtonBox.add(Box.createHorizontalStrut(5));
                    this.textButtonBox.add(this.listButton);
                    return this.textButtonBox;
                }
            } else if (clazz != null && FeatureMap.class.isAssignableFrom(clazz)) {
                this.textField.setText(this.textForFeatureMap((FeatureMap)object));
                if (ResourceParametersEditor.this.isEditable()) {
                    this.textButtonBox.removeAll();
                    this.textButtonBox.add(this.textField);
                    this.textButtonBox.add(Box.createHorizontalStrut(5));
                    this.textButtonBox.add(this.fmButton);
                    return this.textButtonBox;
                }
            } else {
                if (clazz != null && clazz.isEnum()) {
                    if (ResourceParametersEditor.this.isEditable()) {
                        this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{object == null ? "<none>" : object}));
                        return this.combo;
                    }
                    return this.textField;
                }
                return this.textField;
            }
            return this.textField;
        }

        protected String textForList(Collection collection) {
            if (collection == null || collection.isEmpty()) {
                return "[]";
            }
            StringBuffer stringBuffer = new StringBuffer("[");
            for (Object e : collection) {
                stringBuffer.append((e instanceof NameBearer ? ((NameBearer)e).getName() : e.toString()) + ", ");
            }
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length() - 1);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        protected String textForFeatureMap(FeatureMap featureMap) {
            return featureMap == null ? "" : featureMap.toString();
        }
    }

    class ParameterDisjunctionRenderer
    extends DefaultTableCellRenderer {
        JComboBox combo = new JComboBox();
        String iconName;
        String text;

        public ParameterDisjunctionRenderer() {
            class CustomRenderer
            extends JLabel
            implements ListCellRenderer {
                CustomRenderer() {
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    this.setText(ParameterDisjunctionRenderer.this.text);
                    this.setIcon(MainFrame.getIcon(ParameterDisjunctionRenderer.this.iconName));
                    return this;
                }
            }
            this.combo.setRenderer(new CustomRenderer());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            ParameterDisjunction parameterDisjunction = (ParameterDisjunction)object;
            this.text = parameterDisjunction.getName();
            String string = parameterDisjunction.getType();
            this.iconName = "param";
            if (Gate.isGateType(string) && (serializable = (ResourceData)Gate.getCreoleRegister().get(string)) != null) {
                this.iconName = serializable.getIcon();
            }
            if (parameterDisjunction.size() > 1) {
                this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{this.text}));
                return this.combo;
            }
            serializable = super.getTableCellRendererComponent(jTable, this.text, bl, bl2, n, n2);
            this.setIcon(MainFrame.getIcon(this.iconName));
            return this;
        }
    }

    protected class ParametersTableModel
    extends AbstractTableModel {
        protected ParametersTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return ParameterDisjunction.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Required";
                }
                case 3: {
                    return "Value";
                }
            }
            return "?";
        }

        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ((ParameterDisjunction)ResourceParametersEditor.this.parameterDisjunctions.get(n)).size() > 1;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return ResourceParametersEditor.this.editable;
                }
            }
            return false;
        }

        public int getRowCount() {
            return ResourceParametersEditor.this.parameterDisjunctions == null ? 0 : ResourceParametersEditor.this.parameterDisjunctions.size();
        }

        public Object getValueAt(int n, int n2) {
            ParameterDisjunction parameterDisjunction = (ParameterDisjunction)ResourceParametersEditor.this.parameterDisjunctions.get(n);
            switch (n2) {
                case 0: {
                    return parameterDisjunction;
                }
                case 1: {
                    return parameterDisjunction.getType();
                }
                case 2: {
                    return parameterDisjunction.isRequired();
                }
                case 3: {
                    return parameterDisjunction.getValue();
                }
            }
            return "?";
        }

        public void setValueAt(Object object, int n, int n2) {
            ParameterDisjunction parameterDisjunction = (ParameterDisjunction)ResourceParametersEditor.this.parameterDisjunctions.get(n);
            switch (n2) {
                case 0: {
                    parameterDisjunction.setSelectedIndex((Integer)object);
                    ResourceParametersEditor.this.tableModel.fireTableRowsUpdated(n, n);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    parameterDisjunction.setValue(object);
                    break;
                }
            }
        }
    }
}

