/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.GateConstants;
import gate.gui.MainFrame;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PluginManagerUI
extends JDialog
implements GateConstants {
    protected XJTable mainTable;
    protected JSplitPane mainSplit;
    protected MainTableModel mainTableModel;
    protected ResourcesListModel resourcesListModel;
    protected JList resourcesList;
    protected Map loadNowByURL;
    protected Map loadAlwaysByURL;
    protected static final int ICON_COLUMN = 0;
    protected static final int NAME_COLUMN = 1;
    protected static final int URL_COLUMN = 2;
    protected static final int LOAD_NOW_COLUMN = 3;
    protected static final int LOAD_ALWAYS_COLUMN = 4;
    protected static final int DELETE_COLUMN = 5;

    public PluginManagerUI(Frame frame) {
        super(frame);
        this.initLocalData();
        this.initGUI();
        this.initListeners();
    }

    protected void initLocalData() {
        this.loadNowByURL = new HashMap();
        this.loadAlwaysByURL = new HashMap();
    }

    protected void initGUI() {
        this.setTitle("Plugin Management Console");
        this.mainTableModel = new MainTableModel();
        this.mainTable = new XJTable();
        this.mainTable.setModel(this.mainTableModel);
        this.mainTable.setSelectionMode(0);
        DeleteColumnCellRendererEditor deleteColumnCellRendererEditor = new DeleteColumnCellRendererEditor();
        this.mainTable.getColumnModel().getColumn(5).setCellEditor(deleteColumnCellRendererEditor);
        this.mainTable.getColumnModel().getColumn(5).setCellRenderer(deleteColumnCellRendererEditor);
        this.mainTable.getColumnModel().getColumn(0).setCellRenderer(new IconTableCellRenderer());
        this.resourcesListModel = new ResourcesListModel();
        this.resourcesList = new JList(this.resourcesListModel);
        this.resourcesList.setCellRenderer(new ResourcesListCellRenderer());
        this.resourcesList.setSelectionMode(0);
        ToolTipManager.sharedInstance().registerComponent(this.resourcesList);
        this.mainSplit = new JSplitPane(1, true);
        this.mainSplit.setResizeWeight(0.75);
        JScrollPane jScrollPane = new JScrollPane(this.mainTable);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(jScrollPane.getBorder(), "Known CREOLE directories", 1, 1));
        this.mainSplit.setLeftComponent(jScrollPane);
        jScrollPane = new JScrollPane(this.resourcesList);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(jScrollPane.getBorder(), "CREOLE resources in directory", 1, 1));
        this.mainSplit.setRightComponent(jScrollPane);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.mainSplit, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("You can also "));
        box.add(new JButton(new AddCreoleRepositoryAction()));
        box.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)box, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        box = Box.createHorizontalBox();
        box.add(new JButton(new OkAction()));
        box.add(Box.createHorizontalStrut(20));
        box.add(new JButton(new CancelAction()));
        this.getContentPane().add((Component)box, gridBagConstraints);
    }

    protected void initListeners() {
        this.mainTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PluginManagerUI.this.resourcesListModel.dataChanged();
            }
        });
        this.mainSplit.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                PluginManagerUI.this.mainSplit.setDividerLocation(-100);
            }
        });
    }

    protected Boolean getLoadNow(URL uRL) {
        Boolean bl = (Boolean)this.loadNowByURL.get(uRL);
        if (bl == null) {
            bl = new Boolean(Gate.getCreoleRegister().getDirectories().contains(uRL));
            this.loadNowByURL.put(uRL, bl);
        }
        return bl;
    }

    protected Boolean getLoadAlways(URL uRL) {
        Boolean bl = (Boolean)this.loadAlwaysByURL.get(uRL);
        if (bl == null) {
            bl = new Boolean(Gate.getAutoloadPlugins().contains(uRL));
            this.loadAlwaysByURL.put(uRL, bl);
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.loadNowByURL.clear();
            this.loadAlwaysByURL.clear();
            this.mainTableModel.fireTableDataChanged();
        }
        super.setVisible(bl);
    }

    protected class AddCreoleRepositoryAction
    extends AbstractAction {
        public AddCreoleRepositoryAction() {
            super("Add a new CREOLE repository");
            this.putValue("ShortDescription", "Load a new CREOLE repository");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Box box = Box.createHorizontalBox();
            Box box2 = Box.createVerticalBox();
            JTextField jTextField = new JTextField(20);
            box2.add(new JLabel("Type an URL"));
            box2.add(jTextField);
            box.add(box2);
            box.add(Box.createHorizontalStrut(10));
            box.add(new JLabel("or"));
            box.add(Box.createHorizontalStrut(10));
            Box box3 = Box.createVerticalBox();
            box3.add(new JLabel("Select a directory"));
            class URLfromFileAction
            extends AbstractAction {
                JTextField textField;

                URLfromFileAction(JTextField jTextField) {
                    super(null, MainFrame.getIcon("open-file"));
                    this.putValue("ShortDescription", "Click to select a directory");
                    this.textField = jTextField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = MainFrame.getFileChooser();
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
                    int n = jFileChooser.showOpenDialog(PluginManagerUI.this);
                    if (n == 0) {
                        try {
                            this.textField.setText(jFileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new GateRuntimeException(malformedURLException.toString());
                        }
                    }
                }
            }
            JButton jButton = new JButton(new URLfromFileAction(jTextField));
            box3.add(jButton);
            box.add(box3);
            int n = JOptionPane.showOptionDialog(PluginManagerUI.this, box, "Enter an URL to the directory containing the \"creole.xml\" file", 2, 3, null, null, null);
            if (n == 0) {
                try {
                    URL uRL = new URL(jTextField.getText());
                    Gate.addKnownPlugin(uRL);
                    PluginManagerUI.this.mainTableModel.fireTableDataChanged();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(PluginManagerUI.this, "There was a problem with your selection:\n" + exception.toString(), "GATE", 0);
                    exception.printStackTrace(Err.getPrintWriter());
                }
            }
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PluginManagerUI.this.setVisible(false);
            PluginManagerUI.this.loadNowByURL.clear();
            PluginManagerUI.this.loadAlwaysByURL.clear();
        }
    }

    protected class OkAction
    extends AbstractAction {
        public OkAction() {
            super("OK");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            boolean bl2;
            PluginManagerUI.this.setVisible(false);
            for (URL uRL : PluginManagerUI.this.loadNowByURL.keySet()) {
                bl2 = (Boolean)PluginManagerUI.this.loadNowByURL.get(uRL);
                bl = Gate.getCreoleRegister().getDirectories().contains(uRL);
                if (bl2 && !bl) {
                    try {
                        Gate.getCreoleRegister().registerDirectories(uRL);
                    }
                    catch (GateException gateException) {
                        throw new GateRuntimeException(gateException);
                    }
                }
                if (bl2 || !bl) continue;
                Gate.getCreoleRegister().removeDirectory(uRL);
            }
            for (URL uRL : PluginManagerUI.this.loadAlwaysByURL.keySet()) {
                bl2 = (Boolean)PluginManagerUI.this.loadAlwaysByURL.get(uRL);
                bl = Gate.getAutoloadPlugins().contains(uRL);
                if (bl2 && !bl) {
                    Gate.addAutoloadPlugin(uRL);
                }
                if (bl2 || !bl) continue;
                Gate.removeAutoloadPlugin(uRL);
            }
            PluginManagerUI.this.loadNowByURL.clear();
            PluginManagerUI.this.loadAlwaysByURL.clear();
        }
    }

    protected class ResourcesListCellRenderer
    extends DefaultListCellRenderer {
        protected ResourcesListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Gate.ResourceInfo resourceInfo = (Gate.ResourceInfo)object;
            super.getListCellRendererComponent((JList<?>)jList, resourceInfo.getResourceName(), n, bl, bl2);
            this.setToolTipText(resourceInfo.getResourceComment());
            return this;
        }
    }

    protected class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        protected IconTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Icon) {
                super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
                this.setIcon((Icon)object);
                return this;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    protected class DeleteColumnCellRendererEditor
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        JButton editorDeleteButton;
        JButton rendererDeleteButton;
        JPanel rendererBox;
        JPanel editorBox;
        JLabel label = new JLabel();

        public DeleteColumnCellRendererEditor() {
            this.rendererDeleteButton = new JButton(MainFrame.getIcon("delete"));
            this.rendererDeleteButton.setMaximumSize(this.rendererDeleteButton.getPreferredSize());
            this.rendererDeleteButton.setMargin(new Insets(2, 5, 2, 5));
            this.rendererBox = new JPanel();
            this.rendererBox.setLayout(new GridBagLayout());
            this.rendererBox.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.weightx = 1.0;
            this.rendererBox.add(Box.createGlue(), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            this.rendererBox.add((Component)this.rendererDeleteButton, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            this.rendererBox.add(Box.createGlue(), gridBagConstraints);
            this.editorDeleteButton = new JButton(MainFrame.getIcon("delete"));
            this.editorDeleteButton.setMargin(new Insets(2, 5, 2, 5));
            this.editorDeleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = PluginManagerUI.this.mainTable.getEditingRow();
                    TableCellEditor tableCellEditor = PluginManagerUI.this.mainTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.cancelCellEditing();
                    }
                    n = PluginManagerUI.this.mainTable.rowViewToModel(n);
                    URL uRL = Gate.getKnownPlugins().get(n);
                    Gate.removeKnownPlugin(uRL);
                    PluginManagerUI.this.loadAlwaysByURL.remove(uRL);
                    PluginManagerUI.this.loadNowByURL.remove(uRL);
                    PluginManagerUI.this.mainTableModel.fireTableDataChanged();
                    PluginManagerUI.this.resourcesListModel.dataChanged();
                }
            });
            this.editorDeleteButton.setMaximumSize(this.editorDeleteButton.getPreferredSize());
            this.editorBox = new JPanel();
            this.editorBox.setLayout(new GridBagLayout());
            this.editorBox.setOpaque(false);
            gridBagConstraints.weightx = 1.0;
            this.editorBox.add(Box.createGlue(), gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            this.editorBox.add((Component)this.editorDeleteButton, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            this.editorBox.add(Box.createGlue(), gridBagConstraints);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            switch (n2) {
                case 5: {
                    return this.rendererBox;
                }
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            switch (n2) {
                case 5: {
                    return this.editorBox;
                }
            }
            return null;
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    protected class ResourcesListModel
    extends AbstractListModel {
        protected ResourcesListModel() {
        }

        public Object getElementAt(int n) {
            int n2 = PluginManagerUI.this.mainTable.getSelectedRow();
            if (n2 == -1) {
                return null;
            }
            n2 = PluginManagerUI.this.mainTable.rowViewToModel(n2);
            Gate.DirectoryInfo directoryInfo = Gate.getDirectoryInfo(Gate.getKnownPlugins().get(n2));
            return directoryInfo.getResourceInfoList().get(n);
        }

        public int getSize() {
            int n = PluginManagerUI.this.mainTable.getSelectedRow();
            if (n == -1) {
                return 0;
            }
            n = PluginManagerUI.this.mainTable.rowViewToModel(n);
            Gate.DirectoryInfo directoryInfo = Gate.getDirectoryInfo(Gate.getKnownPlugins().get(n));
            return directoryInfo.getResourceInfoList().size();
        }

        public void dataChanged() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    protected class MainTableModel
    extends AbstractTableModel {
        protected Icon localIcon = MainFrame.getIcon("open-file");
        protected Icon remoteIcon = MainFrame.getIcon("internet");
        protected Icon invalidIcon = MainFrame.getIcon("param");

        public int getRowCount() {
            return Gate.getKnownPlugins().size();
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 1: {
                    return "Name";
                }
                case 0: {
                    return "";
                }
                case 2: {
                    return "URL";
                }
                case 3: {
                    return "Load now";
                }
                case 4: {
                    return "Load always";
                }
                case 5: {
                    return "Delete";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 1: {
                    return String.class;
                }
                case 0: {
                    return Icon.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Boolean.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 5: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public Object getValueAt(int n, int n2) {
            Gate.DirectoryInfo directoryInfo = Gate.getDirectoryInfo(Gate.getKnownPlugins().get(n));
            switch (n2) {
                case 1: {
                    return new File(directoryInfo.getUrl().getFile()).getName();
                }
                case 0: {
                    return directoryInfo.isValid() ? (directoryInfo.getUrl().getProtocol().equalsIgnoreCase("file") ? this.localIcon : this.remoteIcon) : this.invalidIcon;
                }
                case 2: {
                    return directoryInfo.getUrl().toString();
                }
                case 3: {
                    return PluginManagerUI.this.getLoadNow(directoryInfo.getUrl());
                }
                case 4: {
                    return PluginManagerUI.this.getLoadAlways(directoryInfo.getUrl());
                }
                case 5: {
                    return null;
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 3 || n2 == 4 || n2 == 5;
        }

        public void setValueAt(Object object, int n, int n2) {
            Boolean bl = (Boolean)object;
            Gate.DirectoryInfo directoryInfo = Gate.getDirectoryInfo(Gate.getKnownPlugins().get(n));
            switch (n2) {
                case 3: {
                    PluginManagerUI.this.loadNowByURL.put(directoryInfo.getUrl(), bl);
                    break;
                }
                case 4: {
                    PluginManagerUI.this.loadAlwaysByURL.put(directoryInfo.getUrl(), bl);
                }
            }
        }
    }
}

