/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.gui.MainFrame;
import gate.swing.JFontChooser;
import gate.util.GateRuntimeException;
import gate.util.OptionsMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class OptionsDialog
extends JDialog {
    public static String[] menuKeys = new String[]{"CheckBoxMenuItem.acceleratorFont", "CheckBoxMenuItem.font", "Menu.acceleratorFont", "Menu.font", "MenuBar.font", "MenuItem.acceleratorFont", "MenuItem.font", "RadioButtonMenuItem.acceleratorFont", "RadioButtonMenuItem.font"};
    public static String[] componentsKeys = new String[]{"Button.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "InternalFrame.titleFont", "Label.font", "List.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "ScrollPane.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font"};
    public static String[] textComponentsKeys = new String[]{"EditorPane.font", "TextArea.font", "TextPane.font"};
    JTabbedPane mainTabbedPane;
    JButton okButton;
    JButton cancelButton;
    JRadioButton textBtn;
    String selectedFontBtn = null;
    JRadioButton menuBtn;
    JRadioButton otherCompsBtn;
    ButtonGroup fontBG;
    JFontChooser fontChooser;
    JCheckBox saveOptionsChk;
    JCheckBox saveSessionChk;
    JCheckBox includeFeaturesOnPreserveFormatChk;
    JCheckBox addSpaceOnMarkupUnpackChk;
    JCheckBox doceditInsertAppendChk;
    JCheckBox doceditInsertPrependChk;
    String lookAndFeelClassName;
    Font menusFont;
    Font textComponentsFont;
    Font componentsFont;
    boolean dirtyGUI;
    JComboBox lnfCombo;

    public OptionsDialog(Frame frame) {
        super(frame, "GATE Options", true);
        MainFrame.getGuiRoots().add(this);
    }

    protected void initLocalData() {
        this.lookAndFeelClassName = Gate.getUserConfig().getString("Look_and_Feel");
        this.textComponentsFont = Gate.getUserConfig().getFont("Text_components_font");
        this.menusFont = Gate.getUserConfig().getFont("Menus_font");
        this.componentsFont = Gate.getUserConfig().getFont("Other_components_font");
        this.dirtyGUI = false;
    }

    protected void initGuiComponents() {
        Serializable serializable;
        Object object;
        this.getContentPane().removeAll();
        this.mainTabbedPane = new JTabbedPane(1);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.mainTabbedPane);
        Box box = Box.createVerticalBox();
        ArrayList<LNFData> arrayList = new ArrayList<LNFData>();
        LNFData lNFData = null;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            object = lookAndFeelInfoArray[i];
            try {
                serializable = Class.forName(((UIManager.LookAndFeelInfo)object).getClassName());
                if (!((LookAndFeel)((Class)serializable).newInstance()).isSupportedLookAndFeel()) continue;
                if (((UIManager.LookAndFeelInfo)object).getName().equals(UIManager.getLookAndFeel().getName())) {
                    lNFData = new LNFData(((UIManager.LookAndFeelInfo)object).getClassName(), ((UIManager.LookAndFeelInfo)object).getName());
                    arrayList.add(lNFData);
                    continue;
                }
                arrayList.add(new LNFData(((UIManager.LookAndFeelInfo)object).getClassName(), ((UIManager.LookAndFeelInfo)object).getName()));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        this.lnfCombo = new JComboBox<Object>(arrayList.toArray());
        this.lnfCombo.setSelectedItem(lNFData);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(5));
        box2.add(new JLabel("Look and feel:"));
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.lnfCombo);
        box2.add(Box.createHorizontalStrut(5));
        box.add(Box.createVerticalStrut(10));
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(" Font options "));
        this.fontBG = new ButtonGroup();
        this.textBtn = new JRadioButton("Text components font");
        this.textBtn.setActionCommand("text");
        this.fontBG.add(this.textBtn);
        this.menuBtn = new JRadioButton("Menu components font");
        this.menuBtn.setActionCommand("menu");
        this.fontBG.add(this.menuBtn);
        this.otherCompsBtn = new JRadioButton("Other components font");
        this.otherCompsBtn.setActionCommand("other");
        this.fontBG.add(this.otherCompsBtn);
        serializable = Box.createVerticalBox();
        ((Container)serializable).add(Box.createVerticalStrut(5));
        ((Container)serializable).add(this.textBtn);
        ((Container)serializable).add(Box.createVerticalStrut(5));
        ((Container)serializable).add(this.menuBtn);
        ((Container)serializable).add(Box.createVerticalStrut(5));
        ((Container)serializable).add(this.otherCompsBtn);
        ((Container)serializable).add(Box.createVerticalStrut(5));
        ((Container)serializable).add(Box.createVerticalGlue());
        ((Container)object).add((Component)serializable);
        this.fontChooser = new JFontChooser();
        ((Container)object).add(this.fontChooser);
        box.add((Component)object);
        this.mainTabbedPane.add("Appearance", box);
        Box box3 = Box.createVerticalBox();
        this.saveOptionsChk = new JCheckBox("Save options on exit", (boolean)Gate.getUserConfig().getBoolean("Save_options_on_exit"));
        this.saveSessionChk = new JCheckBox("Save session on exit", (boolean)Gate.getUserConfig().getBoolean("Save_session_on_exit"));
        this.includeFeaturesOnPreserveFormatChk = new JCheckBox("Include annotation features for \"Save preserving format\"", (boolean)Gate.getUserConfig().getBoolean("Save_features_when_preserving_format"));
        this.addSpaceOnMarkupUnpackChk = new JCheckBox("Add space on markup unpack if needed", true);
        if (Gate.getUserConfig().get("Document_add_space_on_unpack") != null && !Gate.getUserConfig().getBoolean("Document_add_space_on_unpack").booleanValue()) {
            this.addSpaceOnMarkupUnpackChk.setSelected(false);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.doceditInsertAppendChk = new JCheckBox("Append (default)");
        buttonGroup.add(this.doceditInsertAppendChk);
        this.doceditInsertPrependChk = new JCheckBox("Prepend");
        buttonGroup.add(this.doceditInsertPrependChk);
        this.doceditInsertPrependChk.setSelected(Gate.getUserConfig().getBoolean("docedit_insert_prepend"));
        this.doceditInsertAppendChk.setSelected(Gate.getUserConfig().getBoolean("docedit_insert_append"));
        if (!this.doceditInsertAppendChk.isSelected() && !this.doceditInsertPrependChk.isSelected()) {
            this.doceditInsertAppendChk.setSelected(true);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.includeFeaturesOnPreserveFormatChk);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.addSpaceOnMarkupUnpackChk);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Advanced features "));
        box3.add(jPanel);
        box3.add(Box.createVerticalStrut(10));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.saveOptionsChk);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.saveSessionChk);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Session persistence "));
        box3.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.doceditInsertAppendChk);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.doceditInsertPrependChk);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Document editor insert behaviour "));
        box3.add(jPanel);
        this.mainTabbedPane.add("Advanced", box3);
        Box box4 = Box.createHorizontalBox();
        box4.add(Box.createHorizontalGlue());
        this.okButton = new JButton(new OKAction());
        box4.add(this.okButton);
        box4.add(Box.createHorizontalStrut(10));
        this.cancelButton = new JButton("Cancel");
        box4.add(this.cancelButton);
        box4.add(Box.createHorizontalGlue());
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.getContentPane().add(box4);
        this.getContentPane().add(Box.createVerticalStrut(10));
    }

    protected void initListeners() {
        this.lnfCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!OptionsDialog.this.lookAndFeelClassName.equals(((LNFData)OptionsDialog.this.lnfCombo.getSelectedItem()).className)) {
                    OptionsDialog.this.dirtyGUI = true;
                    OptionsDialog.this.lookAndFeelClassName = ((LNFData)OptionsDialog.this.lnfCombo.getSelectedItem()).className;
                }
            }
        });
        this.fontChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fontValue")) {
                    String string = OptionsDialog.this.fontBG.getSelection().getActionCommand();
                    if (string.equals("text")) {
                        OptionsDialog.this.textComponentsFont = (Font)propertyChangeEvent.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    } else if (string.equals("menu")) {
                        OptionsDialog.this.menusFont = (Font)propertyChangeEvent.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    } else if (string.equals("other")) {
                        OptionsDialog.this.componentsFont = (Font)propertyChangeEvent.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    }
                }
            }
        });
        this.textBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.textBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "text";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.textComponentsFont);
            }
        });
        this.menuBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.menuBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "menu";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.menusFont);
            }
        });
        this.otherCompsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.otherCompsBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "other";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.componentsFont);
            }
        });
        this.cancelButton.setAction(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.setVisible(false);
            }
        });
        this.textBtn.setSelected(true);
    }

    protected void selectedFontChanged() {
        if (this.selectedFontBtn != null) {
            if (this.selectedFontBtn.equals("text")) {
                this.textComponentsFont = this.fontChooser.getFontValue();
            } else if (this.selectedFontBtn.equals("menu")) {
                this.menusFont = this.fontChooser.getFontValue();
            } else if (this.selectedFontBtn.equals("other")) {
                this.componentsFont = this.fontChooser.getFontValue();
            }
        }
    }

    public void showDialog() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.textBtn.doClick();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        final JFrame jFrame = new JFrame("Foo frame");
        jFrame.setDefaultCloseOperation(2);
        JButton jButton = new JButton("Show dialog");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog optionsDialog = new OptionsDialog(jFrame);
                optionsDialog.pack();
                optionsDialog.showDialog();
            }
        });
        jFrame.getContentPane().add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
        System.out.println("Font: " + UIManager.getFont("Button.font"));
    }

    protected static void setUIDefaults(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            UIManager.put(objectArray[i], object);
        }
    }

    public static void setTextComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(textComponentsKeys, new FontUIResource(font));
        Gate.getUserConfig().put("Text_components_font", font);
    }

    public static void setMenuComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(menuKeys, new FontUIResource(font));
        Gate.getUserConfig().put("Menus_font", font);
    }

    public static void setComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(componentsKeys, new FontUIResource(font));
        Gate.getUserConfig().put("Other_components_font", font);
    }

    protected static class LNFData {
        String className;
        String name;

        public LNFData(String string, String string2) {
            this.className = string;
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            super("OK");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsMap optionsMap = Gate.getUserConfig();
            if (OptionsDialog.this.dirtyGUI) {
                OptionsDialog.setMenuComponentsFont(OptionsDialog.this.menusFont);
                OptionsDialog.setComponentsFont(OptionsDialog.this.componentsFont);
                OptionsDialog.setTextComponentsFont(OptionsDialog.this.textComponentsFont);
                optionsMap.put("Look_and_Feel", OptionsDialog.this.lookAndFeelClassName);
                try {
                    UIManager.setLookAndFeel(OptionsDialog.this.lookAndFeelClassName);
                }
                catch (Exception exception) {
                    throw new GateRuntimeException("Error while setting the look and feel", exception);
                }
                Iterator iterator = MainFrame.getGuiRoots().iterator();
                while (iterator.hasNext()) {
                    try {
                        SwingUtilities.updateComponentTreeUI((Component)iterator.next());
                    }
                    catch (Exception exception) {
                        throw new GateRuntimeException("Error while updating the graphical interface", exception);
                    }
                }
            }
            optionsMap.put("Save_options_on_exit", new Boolean(OptionsDialog.this.saveOptionsChk.isSelected()));
            optionsMap.put("Save_session_on_exit", new Boolean(OptionsDialog.this.saveSessionChk.isSelected()));
            optionsMap.put("Save_features_when_preserving_format", new Boolean(OptionsDialog.this.includeFeaturesOnPreserveFormatChk.isSelected()));
            optionsMap.put("Document_add_space_on_unpack", new Boolean(OptionsDialog.this.addSpaceOnMarkupUnpackChk.isSelected()));
            optionsMap.put("docedit_insert_append", new Boolean(OptionsDialog.this.doceditInsertAppendChk.isSelected()));
            optionsMap.put("docedit_insert_prepend", new Boolean(OptionsDialog.this.doceditInsertPrependChk.isSelected()));
            OptionsDialog.this.setVisible(false);
        }
    }
}

