/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.gui.ResourceParametersEditor;
import gate.util.Err;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class NewResourceDialog
extends JDialog {
    JButton okBtn;
    JButton cancelBtn;
    JTextField nameField;
    ResourceParametersEditor parametersEditor;
    JScrollPane tableScroll;
    ResourceData resourceData;
    Resource resource;
    boolean userCanceled;

    public NewResourceDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        MainFrame.getGuiRoots().add(this);
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(new JLabel("Name: "));
        box.add(Box.createHorizontalStrut(5));
        this.nameField = new JTextField(30);
        this.nameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.nameField.getPreferredSize().height));
        this.nameField.setRequestFocusEnabled(true);
        this.nameField.setVerifyInputWhenFocusTarget(false);
        box.add(this.nameField);
        this.nameField.setToolTipText("Enter a name for the resource");
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        this.getContentPane().add(box);
        this.getContentPane().add(Box.createVerticalStrut(5));
        this.parametersEditor = new ResourceParametersEditor();
        this.tableScroll = new JScrollPane(this.parametersEditor);
        this.getContentPane().add(this.tableScroll);
        this.getContentPane().add(Box.createVerticalStrut(5));
        this.getContentPane().add(Box.createVerticalGlue());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalStrut(10));
        this.okBtn = new JButton("OK");
        jPanel.add(this.okBtn);
        jPanel.add(Box.createHorizontalStrut(10));
        this.cancelBtn = new JButton("Cancel");
        jPanel.add(this.cancelBtn);
        jPanel.add(Box.createHorizontalStrut(10));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(Box.createVerticalStrut(5));
        this.setSize(400, 300);
        this.getRootPane().setDefaultButton(this.okBtn);
    }

    protected void initListeners() {
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewResourceDialog.this.userCanceled = false;
                TableCellEditor tableCellEditor = NewResourceDialog.this.parametersEditor.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                NewResourceDialog.this.setVisible(false);
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewResourceDialog.this.userCanceled = true;
                NewResourceDialog.this.setVisible(false);
            }
        });
    }

    public synchronized boolean show(ResourceData resourceData, String string) {
        this.resourceData = resourceData;
        if (string != null) {
            this.setTitle(string);
        }
        this.nameField.setText("");
        this.parametersEditor.init(null, resourceData.getParameterList().getInitimeParameters());
        this.pack();
        this.nameField.requestFocusInWindow();
        this.userCanceled = true;
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        super.setVisible(true);
        this.dispose();
        return !this.userCanceled;
    }

    public FeatureMap getSelectedParameters() {
        if (this.parametersEditor != null) {
            return this.parametersEditor.getParameterValues();
        }
        return null;
    }

    public synchronized void show(ResourceData resourceData) {
        this.resourceData = resourceData;
        this.nameField.setText("");
        this.parametersEditor.init(null, resourceData.getParameterList().getInitimeParameters());
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.userCanceled = true;
        this.setVisible(true);
        this.dispose();
        if (this.userCanceled) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                block11: {
                    ProgressListener progressListener;
                    FeatureMap featureMap = NewResourceDialog.this.parametersEditor.getParameterValues();
                    StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
                    if (statusListener != null) {
                        statusListener.statusChanged("Loading " + NewResourceDialog.this.nameField.getText() + "...");
                    }
                    if ((progressListener = (ProgressListener)MainFrame.getListeners().get("gate.event.ProgressListener")) != null) {
                        progressListener.progressChanged(0);
                    }
                    try {
                        long l = System.currentTimeMillis();
                        FeatureMap featureMap2 = Factory.newFeatureMap();
                        String string = NewResourceDialog.this.nameField.getText();
                        if (string == null || string.length() == 0) {
                            string = null;
                        }
                        Resource resource = Factory.createResource(NewResourceDialog.this.resourceData.getClassName(), featureMap, featureMap2, string);
                        long l2 = System.currentTimeMillis();
                        if (statusListener != null) {
                            statusListener.statusChanged(NewResourceDialog.this.nameField.getText() + " loaded in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                        }
                        if (progressListener != null) {
                            progressListener.processFinished();
                        }
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        JOptionPane.showMessageDialog(NewResourceDialog.this.getOwner(), "Resource could not be created!\n" + resourceInstantiationException.toString(), "GATE", 0);
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        Object var2_10 = null;
                        if (statusListener != null) {
                            statusListener.statusChanged("Error loading " + NewResourceDialog.this.nameField.getText() + "!");
                        }
                        if (progressListener != null) {
                            progressListener.processFinished();
                        }
                    }
                    catch (Throwable throwable) {
                        JOptionPane.showMessageDialog(NewResourceDialog.this.getOwner(), "Unhandled error!\n" + throwable.toString(), "GATE", 0);
                        throwable.printStackTrace(Err.getPrintWriter());
                        Object var2_11 = null;
                        if (statusListener != null) {
                            statusListener.statusChanged("Error loading " + NewResourceDialog.this.nameField.getText() + "!");
                        }
                        if (progressListener == null) break block11;
                        progressListener.processFinished();
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "");
        thread.setPriority(1);
        thread.start();
    }
}

