/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import com.ontotext.gate.hmm.agent.AlternativeHMMAgent;
import com.ontotext.gate.hmm.agent.SaveAsAction;
import gate.Controller;
import gate.Corpus;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.TextualDocument;
import gate.VisualResource;
import gate.corpora.DocumentStaxUtils;
import gate.creole.AbstractResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.ir.DefaultIndexDefinition;
import gate.creole.ir.DocumentContentReader;
import gate.creole.ir.FeatureReader;
import gate.creole.ir.IREngine;
import gate.creole.ir.IndexException;
import gate.creole.ir.IndexField;
import gate.creole.ir.IndexedCorpus;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.AccessRightsDialog;
import gate.gui.ActionsPublisher;
import gate.gui.CorpusFillerComponent;
import gate.gui.CreateIndexDialog;
import gate.gui.CreateIndexGUI;
import gate.gui.DocumentEditor;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.OkCancelDialog;
import gate.persist.PersistenceException;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.SecurityInfo;
import gate.security.User;
import gate.swing.XJMenuItem;
import gate.swing.XJPopupMenu;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.NameBearer;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class NameBearerHandle
implements Handle,
StatusListener,
ProgressListener,
CreoleListener {
    String title;
    String tooltipText;
    NameBearer target;
    protected List actionPublishers;
    protected List staticPopupItems;
    Window window;
    ResourceData rData;
    Icon icon;
    JComponent smallView;
    JComponent largeView;
    protected boolean viewsBuilt = false;
    CorpusFillerComponent corpusFiller;
    StatusListener sListenerProxy;
    private transient Vector progressListeners;
    private transient Vector statusListeners;

    public NameBearerHandle(NameBearer nameBearer, Window window) {
        this.target = nameBearer;
        this.window = window;
        this.actionPublishers = new ArrayList();
        this.sListenerProxy = new ProxyStatusListener();
        String string = null;
        if (nameBearer instanceof Resource) {
            this.rData = (ResourceData)Gate.getCreoleRegister().get(nameBearer.getClass().getName());
            if (this.rData != null) {
                string = this.rData.getIcon();
                if (string == null) {
                    if (nameBearer instanceof LanguageResource) {
                        string = "lr";
                    } else if (nameBearer instanceof ProcessingResource) {
                        string = "pr";
                    } else if (nameBearer instanceof Controller) {
                        string = "application";
                    }
                }
                if (nameBearer instanceof Controller && nameBearer.getName().startsWith("ANNIE")) {
                    string = "annie-application";
                }
                this.tooltipText = "<HTML> <b>" + this.rData.getComment() + "</b><br>(<i>" + this.rData.getClassName() + "</i>)</HTML>";
            } else {
                string = "lr";
            }
        } else if (nameBearer instanceof DataStore) {
            string = ((DataStore)nameBearer).getIconName();
            this.tooltipText = ((DataStore)nameBearer).getComment();
        }
        this.title = nameBearer.getName();
        this.icon = MainFrame.getIcon(string);
        Gate.getCreoleRegister().addCreoleListener(this);
        if (nameBearer instanceof ActionsPublisher) {
            this.actionPublishers.add(nameBearer);
        }
        this.buildStaticPopupItems();
        this.viewsBuilt = false;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean viewsBuilt() {
        return this.viewsBuilt;
    }

    public JComponent getSmallView() {
        if (!this.viewsBuilt) {
            this.buildViews();
        }
        return this.smallView;
    }

    public JComponent getLargeView() {
        if (!this.viewsBuilt) {
            this.buildViews();
        }
        return this.largeView;
    }

    public JPopupMenu getPopup() {
        XJPopupMenu xJPopupMenu = new XJPopupMenu();
        for (Object object : this.staticPopupItems) {
            if (object == null) {
                xJPopupMenu.addSeparator();
                continue;
            }
            xJPopupMenu.add((JMenuItem)object);
        }
        for (ActionsPublisher actionsPublisher : this.actionPublishers) {
            if (actionsPublisher.getActions() == null) continue;
            for (Action action : actionsPublisher.getActions()) {
                if (action == null) {
                    xJPopupMenu.addSeparator();
                    continue;
                }
                xJPopupMenu.add(new XJMenuItem(action, this.sListenerProxy));
            }
        }
        return xJPopupMenu;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String string) {
        this.tooltipText = string;
    }

    public Object getTarget() {
        return this.target;
    }

    public Action getCloseAction() {
        return new CloseAction();
    }

    private void fillHMMActions(List list) {
        AlternativeHMMAgent alternativeHMMAgent = (AlternativeHMMAgent)this.target;
        list.add(null);
        com.ontotext.gate.hmm.agent.SaveAction saveAction = new com.ontotext.gate.hmm.agent.SaveAction(alternativeHMMAgent);
        saveAction.putValue("ShortDescription", "Save trained HMM model into PR URL file");
        list.add(new XJMenuItem((Action)saveAction, this.sListenerProxy));
        saveAction = new SaveAsAction(alternativeHMMAgent);
        saveAction.putValue("ShortDescription", "Save trained HMM model into new file");
        list.add(new XJMenuItem((Action)saveAction, this.sListenerProxy));
    }

    protected void buildStaticPopupItems() {
        this.staticPopupItems = new ArrayList();
        XJMenuItem xJMenuItem = new XJMenuItem(new CloseAction(), this.sListenerProxy);
        xJMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        this.staticPopupItems.add(xJMenuItem);
        if (this.target instanceof ProcessingResource) {
            this.staticPopupItems.add(null);
            this.staticPopupItems.add(new XJMenuItem(new ReloadAction(), this.sListenerProxy));
            if (this.target instanceof AlternativeHMMAgent) {
                this.fillHMMActions(this.staticPopupItems);
            }
        } else if (this.target instanceof LanguageResource) {
            this.staticPopupItems.add(null);
            this.staticPopupItems.add(new XJMenuItem(new SaveAction(), this.sListenerProxy));
            this.staticPopupItems.add(new XJMenuItem(new SaveToAction(), this.sListenerProxy));
            if (this.target instanceof TextualDocument) {
                XJMenuItem xJMenuItem2 = new XJMenuItem(new SaveAsXmlAction(), this.sListenerProxy);
                xJMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 2));
                this.staticPopupItems.add(xJMenuItem2);
            } else if (this.target instanceof Corpus) {
                this.staticPopupItems.add(null);
                this.corpusFiller = new CorpusFillerComponent();
                this.staticPopupItems.add(new XJMenuItem(new PopulateCorpusAction(), this.sListenerProxy));
                this.staticPopupItems.add(null);
                this.staticPopupItems.add(new XJMenuItem(new SaveCorpusAsXmlAction(false), this.sListenerProxy));
                if (this.target instanceof IndexedCorpus) {
                    this.staticPopupItems.add(null);
                    this.staticPopupItems.add(new XJMenuItem(new CreateIndexAction(), this.sListenerProxy));
                    this.staticPopupItems.add(new XJMenuItem(new OptimizeIndexAction(), this.sListenerProxy));
                    this.staticPopupItems.add(new XJMenuItem(new DeleteIndexAction(), this.sListenerProxy));
                }
            }
            if (this.target instanceof Document) {
                this.staticPopupItems.add(null);
                this.staticPopupItems.add(new XJMenuItem(new CreateCorpusForDocAction(), this.sListenerProxy));
            }
        } else if (this.target instanceof Controller) {
            this.staticPopupItems.add(null);
            this.staticPopupItems.add(new XJMenuItem(new DumpToFileAction(), this.sListenerProxy));
        }
    }

    protected void buildViews() {
        Object object;
        FeatureMap featureMap;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        this.viewsBuilt = true;
        this.fireStatusChanged("Building views...");
        List<String> list = Gate.getCreoleRegister().getLargeVRsForResource(this.target.getClass().getName());
        if (list != null && !list.isEmpty()) {
            this.largeView = new JTabbedPane(3);
            object4 = list.iterator();
            while (object4.hasNext()) {
                try {
                    iterator = (String)object4.next();
                    object3 = (ResourceData)Gate.getCreoleRegister().get(iterator);
                    object2 = Factory.newFeatureMap();
                    featureMap = Factory.newFeatureMap();
                    Gate.setHiddenAttribute(featureMap, true);
                    object = (VisualResource)Factory.createResource(iterator, (FeatureMap)object2, featureMap);
                    object.setTarget(this.target);
                    object.setHandle(this);
                    ((JTabbedPane)this.largeView).add((Component)object, ((ResourceData)object3).getName());
                    if (!(object instanceof ActionsPublisher)) continue;
                    this.actionPublishers.add(object);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                }
            }
            if (list.size() == 1) {
                this.largeView = (JComponent)((JTabbedPane)this.largeView).getComponentAt(0);
            } else {
                ((JTabbedPane)this.largeView).setSelectedIndex(0);
            }
        }
        if ((object4 = Gate.getCreoleRegister().getSmallVRsForResource(this.target.getClass().getName())) != null && !object4.isEmpty()) {
            this.smallView = new JTabbedPane(3);
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                try {
                    object3 = (String)iterator.next();
                    object2 = (ResourceData)Gate.getCreoleRegister().get(object3);
                    featureMap = Factory.newFeatureMap();
                    object = Factory.newFeatureMap();
                    Gate.setHiddenAttribute((FeatureMap)object, true);
                    VisualResource visualResource = (VisualResource)Factory.createResource((String)object3, featureMap, (FeatureMap)object);
                    visualResource.setTarget(this.target);
                    visualResource.setHandle(this);
                    ((JTabbedPane)this.smallView).add((Component)((Object)visualResource), ((ResourceData)object2).getName());
                    if (!(visualResource instanceof ActionsPublisher)) continue;
                    this.actionPublishers.add(visualResource);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                }
            }
            if (object4.size() == 1) {
                this.smallView = (JComponent)((JTabbedPane)this.smallView).getComponentAt(0);
            } else {
                ((JTabbedPane)this.smallView).setSelectedIndex(0);
            }
        }
        this.fireStatusChanged("Views built!");
        iterator = this.getLargeView();
        if (iterator != null) {
            ((JComponent)((Object)iterator)).getActionMap().put("Close resource", new CloseAction());
            if (this.target instanceof TextualDocument) {
                ((JComponent)((Object)iterator)).getActionMap().put("Save As XML", new SaveAsXmlAction());
            }
        }
    }

    public String toString() {
        return this.title;
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public void removeViews() {
        int n;
        Component[] componentArray;
        if (this.largeView != null) {
            if (this.largeView instanceof VisualResource) {
                if (this.largeView instanceof ActionsPublisher) {
                    this.actionPublishers.remove(this.largeView);
                }
                Factory.deleteResource((VisualResource)((Object)this.largeView));
            } else {
                componentArray = ((JTabbedPane)this.largeView).getComponents();
                for (n = 0; n < componentArray.length; ++n) {
                    if (!(componentArray[n] instanceof VisualResource)) continue;
                    if (componentArray[n] instanceof ActionsPublisher) {
                        this.actionPublishers.remove(componentArray[n]);
                    }
                    Factory.deleteResource((VisualResource)((Object)componentArray[n]));
                }
            }
            this.largeView = null;
        }
        if (this.smallView != null) {
            if (this.smallView instanceof VisualResource) {
                if (this.smallView instanceof ActionsPublisher) {
                    this.actionPublishers.remove(this.smallView);
                }
                Factory.deleteResource((VisualResource)((Object)this.smallView));
            } else {
                componentArray = ((JTabbedPane)this.smallView).getComponents();
                for (n = 0; n < componentArray.length; ++n) {
                    if (!(componentArray[n] instanceof VisualResource)) continue;
                    if (componentArray[n] instanceof ActionsPublisher) {
                        this.actionPublishers.remove(componentArray[n]);
                    }
                    Factory.deleteResource((VisualResource)((Object)componentArray[n]));
                }
            }
            this.smallView = null;
        }
        this.viewsBuilt = false;
    }

    public void cleanup() {
        this.removeViews();
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.target = null;
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ProgressListener)vector.elementAt(i)).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ProgressListener)vector.elementAt(i)).processFinished();
            }
        }
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StatusListener)vector.elementAt(i)).statusChanged(string);
            }
        }
    }

    public void statusChanged(String string) {
        this.fireStatusChanged(string);
    }

    public void progressChanged(int n) {
        this.fireProgressChanged(n);
    }

    public void processFinished() {
        this.fireProcessFinished();
    }

    public Window getWindow() {
        return this.window;
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
        if (this.target == resource) {
            this.title = this.target.getName();
        }
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
        if (this.getTarget() == creoleEvent.getDatastore()) {
            this.cleanup();
        }
    }

    class ProxyStatusListener
    implements StatusListener {
        ProxyStatusListener() {
        }

        public void statusChanged(String string) {
            NameBearerHandle.this.fireStatusChanged(string);
        }
    }

    class CreateCorpusForDocAction
    extends AbstractAction {
        public CreateCorpusForDocAction() {
            super("New corpus with this document");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Corpus corpus = Factory.newCorpus("Corpus for " + NameBearerHandle.this.target.getName());
                corpus.add(NameBearerHandle.this.target);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                Err.println("Exception creating corpus");
                resourceInstantiationException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class DeleteIndexAction
    extends AbstractAction {
        DeleteIndexAction() {
            super("Delete Index");
            this.putValue("ShortDescription", "Delete existing index");
        }

        public boolean isEnabled() {
            return ((IndexedCorpus)NameBearerHandle.this.target).getIndexDefinition() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showOptionDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "Do you want to delete index?", "Gate", 0, 3, null, null, null);
            if (n == 0) {
                try {
                    IndexedCorpus indexedCorpus = (IndexedCorpus)NameBearerHandle.this.target;
                    if (indexedCorpus.getIndexManager() != null) {
                        indexedCorpus.getIndexManager().deleteIndex();
                        indexedCorpus.getFeatures().remove("Index_definition_feature_key");
                    } else {
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "There is no index to delete!", "GATE", -1);
                    }
                }
                catch (IndexException indexException) {
                    indexException.printStackTrace();
                }
            }
        }
    }

    class OptimizeIndexAction
    extends AbstractAction {
        OptimizeIndexAction() {
            super("Optimize Index");
            this.putValue("ShortDescription", "Optimize existing index");
        }

        public boolean isEnabled() {
            return ((IndexedCorpus)NameBearerHandle.this.target).getIndexDefinition() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IndexedCorpus indexedCorpus = (IndexedCorpus)NameBearerHandle.this.target;
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        NameBearerHandle.this.fireProgressChanged(1);
                        NameBearerHandle.this.fireStatusChanged("Optimising index...");
                        long l = System.currentTimeMillis();
                        ((IndexedCorpus)NameBearerHandle.this.target).getIndexManager().optimizeIndex();
                        NameBearerHandle.this.fireStatusChanged("Index optimised in " + NumberFormat.getInstance().format((double)(System.currentTimeMillis() - l) / 1000.0) + " seconds");
                        NameBearerHandle.this.fireProcessFinished();
                    }
                    catch (IndexException indexException) {
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "Errors during optimisation!", "GATE", -1);
                        indexException.printStackTrace(Err.getPrintWriter());
                    }
                    finally {
                        NameBearerHandle.this.fireProcessFinished();
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }
    }

    class CreateIndexAction
    extends AbstractAction {
        CreateIndexGUI createIndexGui;

        CreateIndexAction() {
            super("Index corpus");
            this.putValue("ShortDescription", "Create index with documents from the corpus");
            this.createIndexGui = new CreateIndexGUI();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = OkCancelDialog.showDialog(NameBearerHandle.this.largeView, this.createIndexGui, "Index \"" + NameBearerHandle.this.target.getName() + "\" corpus");
            if (bl) {
                Object object2;
                DefaultIndexDefinition defaultIndexDefinition = new DefaultIndexDefinition();
                IREngine iREngine = this.createIndexGui.getIREngine();
                defaultIndexDefinition.setIrEngineClassName(iREngine.getClass().getName());
                defaultIndexDefinition.setIndexLocation(this.createIndexGui.getIndexLocation().toString());
                if (this.createIndexGui.getUseDocumentContent()) {
                    defaultIndexDefinition.addIndexField(new IndexField("body", new DocumentContentReader(), false));
                }
                for (Object object2 : this.createIndexGui.getFeaturesList()) {
                    defaultIndexDefinition.addIndexField(new IndexField((String)object2, new FeatureReader((String)object2), false));
                }
                ((IndexedCorpus)NameBearerHandle.this.target).setIndexDefinition(defaultIndexDefinition);
                object2 = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            NameBearerHandle.this.fireProgressChanged(1);
                            NameBearerHandle.this.fireStatusChanged("Indexing corpus...");
                            long l = System.currentTimeMillis();
                            ((IndexedCorpus)NameBearerHandle.this.target).getIndexManager().deleteIndex();
                            NameBearerHandle.this.fireProgressChanged(10);
                            ((IndexedCorpus)NameBearerHandle.this.target).getIndexManager().createIndex();
                            NameBearerHandle.this.fireProgressChanged(100);
                            NameBearerHandle.this.fireProcessFinished();
                            NameBearerHandle.this.fireStatusChanged("Corpus indexed in " + NumberFormat.getInstance().format((double)(System.currentTimeMillis() - l) / 1000.0) + " seconds");
                        }
                        catch (IndexException indexException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "Could not create index!\n See \"Messages\" tab for details!", "GATE", 0);
                            indexException.printStackTrace(Err.getPrintWriter());
                        }
                        finally {
                            NameBearerHandle.this.fireProcessFinished();
                        }
                    }
                });
                ((Thread)object2).setPriority(1);
                ((Thread)object2).start();
            }
        }
    }

    class CreateIndexAction1
    extends AbstractAction {
        CreateIndexAction1() {
            super("Create Index");
            this.putValue("ShortDescription", "Create index with documents from a corpus");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Dialog dialog = null;
            if (NameBearerHandle.this.getWindow() instanceof Frame) {
                dialog = new CreateIndexDialog((Frame)NameBearerHandle.this.getWindow(), (IndexedCorpus)NameBearerHandle.this.target);
            }
            if (NameBearerHandle.this.getWindow() instanceof Dialog) {
                dialog = new CreateIndexDialog((Dialog)NameBearerHandle.this.getWindow(), (IndexedCorpus)NameBearerHandle.this.target);
            }
            dialog.setVisible(true);
        }
    }

    class PopulateCorpusAction
    extends AbstractAction {
        PopulateCorpusAction() {
            super("Populate");
            this.putValue("ShortDescription", "Fills this corpus with documents from a directory");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    NameBearerHandle.this.corpusFiller.setExtensions(new ArrayList());
                    NameBearerHandle.this.corpusFiller.setEncoding("");
                    boolean bl = OkCancelDialog.showDialog(NameBearerHandle.this.getLargeView(), NameBearerHandle.this.corpusFiller, "Select a directory and allowed extensions");
                    if (bl) {
                        long l = System.currentTimeMillis();
                        URL uRL = null;
                        try {
                            uRL = new URL(NameBearerHandle.this.corpusFiller.getUrlString());
                            List list = NameBearerHandle.this.corpusFiller.getExtensions();
                            ExtensionFileFilter extensionFileFilter = null;
                            if (list == null || list.isEmpty()) {
                                extensionFileFilter = null;
                            } else {
                                extensionFileFilter = new ExtensionFileFilter();
                                Iterator iterator = NameBearerHandle.this.corpusFiller.getExtensions().iterator();
                                while (iterator.hasNext()) {
                                    extensionFileFilter.addExtension((String)iterator.next());
                                }
                            }
                            ((Corpus)NameBearerHandle.this.target).populate(uRL, extensionFileFilter, NameBearerHandle.this.corpusFiller.getEncoding(), NameBearerHandle.this.corpusFiller.isRecurseDirectories());
                            long l2 = System.currentTimeMillis();
                            NameBearerHandle.this.fireStatusChanged("Corpus populated in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds!");
                        }
                        catch (MalformedURLException malformedURLException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Invalid URL!\n See \"Messages\" tab for details!", "GATE", 0);
                            malformedURLException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "I/O error!\n See \"Messages\" tab for details!", "GATE", 0);
                            iOException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (ResourceInstantiationException resourceInstantiationException) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Could not create document!\n See \"Messages\" tab for details!", "GATE", 0);
                            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        }
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable);
            thread.setPriority(1);
            thread.start();
        }
    }

    class ReloadAction
    extends AbstractAction {
        ReloadAction() {
            super("Reinitialise");
            this.putValue("ShortDescription", "Reloads this resource");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (!(NameBearerHandle.this.target instanceof ProcessingResource)) {
                        return;
                    }
                    try {
                        long l = System.currentTimeMillis();
                        NameBearerHandle.this.fireStatusChanged("Reinitialising " + NameBearerHandle.this.target.getName());
                        HashMap<String, EventListener> hashMap = new HashMap<String, EventListener>();
                        StatusListener statusListener = new StatusListener(){

                            public void statusChanged(String string) {
                                NameBearerHandle.this.fireStatusChanged(string);
                            }
                        };
                        hashMap.put("gate.event.StatusListener", statusListener);
                        ProgressListener progressListener = new ProgressListener(){

                            public void progressChanged(int n) {
                                NameBearerHandle.this.fireProgressChanged(n);
                            }

                            public void processFinished() {
                                NameBearerHandle.this.fireProcessFinished();
                            }
                        };
                        hashMap.put("gate.event.ProgressListener", progressListener);
                        ProcessingResource processingResource = (ProcessingResource)NameBearerHandle.this.target;
                        try {
                            AbstractResource.setResourceListeners(processingResource, hashMap);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(Err.getPrintWriter());
                        }
                        NameBearerHandle.this.fireProgressChanged(0);
                        processingResource.reInit();
                        try {
                            AbstractResource.removeResourceListeners(processingResource, hashMap);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(Err.getPrintWriter());
                        }
                        long l2 = System.currentTimeMillis();
                        NameBearerHandle.this.fireStatusChanged(NameBearerHandle.this.target.getName() + " reinitialised in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                        NameBearerHandle.this.fireProcessFinished();
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        NameBearerHandle.this.fireStatusChanged("reinitialisation failed");
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Reload failed!\n See \"Messages\" tab for details!", "GATE", 0);
                        NameBearerHandle.this.fireProcessFinished();
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "DefaultResourceHandle1");
            thread.setPriority(1);
            thread.start();
        }
    }

    class SaveToAction
    extends AbstractAction {
        public SaveToAction() {
            super("Save to...");
            this.putValue("ShortDescription", "Save this resource to a datastore");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Object object;
                        Object object2;
                        ArrayList arrayList2;
                        DataStoreRegister dataStoreRegister = Gate.getDataStoreRegister();
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        for (ArrayList arrayList2 : dataStoreRegister) {
                            object2 = arrayList2.getName();
                            if (object2 == null) {
                                object2 = arrayList2.getStorageUrl();
                                try {
                                    object = new URL((String)object2);
                                    object2 = ((URL)object).getFile();
                                }
                                catch (MalformedURLException malformedURLException) {
                                    throw new GateRuntimeException();
                                }
                            }
                            hashMap.put((String)object2, arrayList2);
                        }
                        arrayList2 = new ArrayList(hashMap.keySet());
                        if (arrayList2.isEmpty()) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "There are no open datastores!\n Please open a datastore first!", "GATE", 0);
                        } else {
                            object2 = JOptionPane.showInputDialog(NameBearerHandle.this.getLargeView(), "Select the datastore", "GATE", 3, null, arrayList2.toArray(), arrayList2.get(0));
                            if (object2 == null) {
                                return;
                            }
                            object = (DataStore)hashMap.get(object2);
                            if (object == null) {
                                Err.prln("The datastore does not exists. Saving procedure has FAILED! This should never happen again!");
                                return;
                            }
                            DataStore dataStore = ((LanguageResource)NameBearerHandle.this.target).getDataStore();
                            if (object == dataStore) {
                                MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
                                if (statusListener != null) {
                                    statusListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                }
                                double d = System.currentTimeMillis();
                                object.sync((LanguageResource)NameBearerHandle.this.target);
                                double d2 = System.currentTimeMillis();
                                if (statusListener != null) {
                                    statusListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((d2 - d) / 1000.0) + " seconds");
                                }
                            } else {
                                FeatureMap featureMap = (FeatureMap)DataStoreRegister.getSecurityData((DataStore)object);
                                SecurityInfo securityInfo = null;
                                if (featureMap != null) {
                                    if (!AccessRightsDialog.showDialog(NameBearerHandle.this.window)) {
                                        return;
                                    }
                                    int n = AccessRightsDialog.getSelectedMode();
                                    if (n < 0) {
                                        return;
                                    }
                                    securityInfo = new SecurityInfo(n, (User)featureMap.get("user"), (Group)featureMap.get("group"));
                                }
                                StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
                                MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                if (statusListener != null) {
                                    statusListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                                }
                                double d = System.currentTimeMillis();
                                LanguageResource languageResource = object.adopt((LanguageResource)NameBearerHandle.this.target, securityInfo);
                                object.sync(languageResource);
                                double d3 = System.currentTimeMillis();
                                if (statusListener != null) {
                                    statusListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((d3 - d) / 1000.0) + " seconds");
                                }
                                if (languageResource != NameBearerHandle.this.target) {
                                    Factory.deleteResource((LanguageResource)NameBearerHandle.this.target);
                                }
                            }
                        }
                    }
                    catch (PersistenceException persistenceException) {
                        MainFrame.unlockGUI();
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + persistenceException.toString(), "GATE", 0);
                    }
                    catch (SecurityException securityException) {
                        MainFrame.unlockGUI();
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + securityException.toString(), "GATE", 0);
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    class DumpToFileAction
    extends AbstractAction {
        public DumpToFileAction() {
            super("Save application state");
            this.putValue("ShortDescription", "Saves the data needed to recreate this application");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = MainFrame.getFileChooser();
            jFileChooser.setDialogTitle("Select a file for this resource");
            jFileChooser.setFileSelectionMode(2);
            if (jFileChooser.showSaveDialog(NameBearerHandle.this.largeView) == 0) {
                final File file = jFileChooser.getSelectedFile();
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            PersistenceManager.saveObjectToFile((Resource)NameBearerHandle.this.target, file);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Error!\n" + exception.toString(), "GATE", 0);
                            exception.printStackTrace(Err.getPrintWriter());
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                thread.start();
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save");
            this.putValue("ShortDescription", "Save back to the datastore");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    DataStore dataStore = ((LanguageResource)NameBearerHandle.this.target).getDataStore();
                    if (dataStore != null) {
                        try {
                            MainFrame.lockGUI("Saving " + ((LanguageResource)NameBearerHandle.this.target).getName());
                            StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
                            if (statusListener != null) {
                                statusListener.statusChanged("Saving: " + ((LanguageResource)NameBearerHandle.this.target).getName());
                            }
                            double d = System.currentTimeMillis();
                            ((LanguageResource)NameBearerHandle.this.target).getDataStore().sync((LanguageResource)NameBearerHandle.this.target);
                            double d2 = System.currentTimeMillis();
                            if (statusListener == null) return;
                            statusListener.statusChanged(((LanguageResource)NameBearerHandle.this.target).getName() + " saved in " + NumberFormat.getInstance().format((d2 - d) / 1000.0) + " seconds");
                            return;
                        }
                        catch (PersistenceException persistenceException) {
                            MainFrame.unlockGUI();
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + persistenceException.toString(), "GATE", 0);
                            return;
                        }
                        catch (SecurityException securityException) {
                            MainFrame.unlockGUI();
                            JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "Save failed!\n " + securityException.toString(), "GATE", 0);
                            return;
                        }
                        finally {
                            MainFrame.unlockGUI();
                        }
                    } else {
                        JOptionPane.showMessageDialog(NameBearerHandle.this.getLargeView(), "This resource has not been loaded from a datastore.\nPlease use the \"Save to\" option!\n", "GATE", 0);
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    class ReloadClassAction
    extends AbstractAction {
        public ReloadClassAction() {
            super("Reload resource class");
            this.putValue("ShortDescription", "Reloads the java class for this resource");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showOptionDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "This is an advanced option!\nYou should not use this unless your name is Hamish.\nAre you sure you want to do this?", "GATE", 0, 2, null, null, null);
            if (n == 0) {
                try {
                    String string = NameBearerHandle.this.target.getClass().getName();
                    Gate.getClassLoader().reloadClass(string);
                    NameBearerHandle.this.fireStatusChanged("Class " + string + " reloaded!");
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Look what you've done: \n" + exception.toString() + "\nI told you not to do it...", "GATE", 0);
                    exception.printStackTrace(Err.getPrintWriter());
                }
            }
        }
    }

    class SaveCorpusAsXmlAction
    extends AbstractAction {
        private boolean preserveFormat;

        public SaveCorpusAsXmlAction(boolean bl) {
            super("Save As Xml...");
            this.putValue("ShortDescription", "Saves this corpus in XML");
            this.preserveFormat = bl;
            if (bl) {
                this.putValue("Name", "Save As Xml preserve format...");
                this.putValue("ShortDescription", "Saves this corpus in XML preserve format");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block29: {
                        if (SaveCorpusAsXmlAction.this.preserveFormat) {
                            System.out.println("Preserve option set!");
                        }
                        try {
                            JFileChooser jFileChooser = MainFrame.getFileChooser();
                            jFileChooser.setDialogTitle("Select the directory that will contain the corpus");
                            jFileChooser.setFileSelectionMode(1);
                            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
                            if (jFileChooser.showDialog(NameBearerHandle.this.getLargeView() != null ? NameBearerHandle.this.getLargeView() : NameBearerHandle.this.getSmallView(), "Select") != 0) break block29;
                            File file = jFileChooser.getSelectedFile();
                            if (!file.exists() && !file.mkdirs()) {
                                JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Could not create top directory!", "GATE", 0);
                                return;
                            }
                            MainFrame.lockGUI("Saving...");
                            Corpus corpus = (Corpus)NameBearerHandle.this.target;
                            Iterator iterator = corpus.iterator();
                            boolean bl = false;
                            int n = corpus.size();
                            int n2 = 0;
                            while (iterator.hasNext()) {
                                Object[] objectArray;
                                boolean bl2 = corpus.isDocumentLoaded(n2);
                                Document document = (Document)iterator.next();
                                URL uRL = document.getSourceUrl();
                                String string = null;
                                if (uRL != null) {
                                    string = uRL.getFile();
                                    string = Files.getLastPathComponent(string);
                                }
                                if (string == null || string.length() == 0) {
                                    string = document.getName();
                                }
                                if (!(string = string.replaceAll("[\\/:\\*\\?\"<>|]", "_")).toLowerCase().endsWith(".xml")) {
                                    string = string + ".xml";
                                }
                                File file2 = null;
                                boolean bl3 = false;
                                do {
                                    if ((file2 = new File(file, string)).exists() && !bl) {
                                        objectArray = new Object[]{"Yes", "All", "No", "Cancel"};
                                        MainFrame.unlockGUI();
                                        int n3 = JOptionPane.showOptionDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "File " + file2.getName() + " already exists!\n" + "Overwrite?", "GATE", -1, 2, null, objectArray, objectArray[2]);
                                        MainFrame.lockGUI("Saving...");
                                        switch (n3) {
                                            case 0: {
                                                bl3 = true;
                                                break;
                                            }
                                            case 1: {
                                                bl3 = true;
                                                bl = true;
                                                break;
                                            }
                                            case 2: {
                                                MainFrame.unlockGUI();
                                                string = (String)JOptionPane.showInputDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Please provide an alternative file name", "GATE", 3, null, null, string);
                                                if (string == null) {
                                                    NameBearerHandle.this.fireProcessFinished();
                                                    return;
                                                }
                                                MainFrame.lockGUI("Saving");
                                                break;
                                            }
                                            case 3: {
                                                NameBearerHandle.this.fireProcessFinished();
                                                return;
                                            }
                                        }
                                        continue;
                                    }
                                    bl3 = true;
                                } while (!bl3);
                                try {
                                    objectArray = "";
                                    if (SaveCorpusAsXmlAction.this.preserveFormat) {
                                        Serializable serializable;
                                        Set set = null;
                                        if (NameBearerHandle.this.largeView instanceof JTabbedPane && (serializable = ((JTabbedPane)NameBearerHandle.this.largeView).getSelectedComponent()) instanceof DocumentEditor) {
                                            set = ((DocumentEditor)serializable).getDisplayedAnnotations();
                                        }
                                        serializable = Gate.getUserConfig().getBoolean("Save_features_when_preserving_format");
                                        boolean bl4 = true;
                                        if (serializable != null) {
                                            bl4 = (Boolean)serializable;
                                        }
                                        objectArray = document.toXml(set, bl4);
                                        String string2 = ((TextualDocument)document).getEncoding();
                                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string2);
                                        outputStreamWriter.write((String)objectArray);
                                        outputStreamWriter.flush();
                                        outputStreamWriter.close();
                                    } else {
                                        DocumentStaxUtils.writeDocument(document, file2);
                                    }
                                }
                                catch (Exception exception) {
                                    MainFrame.unlockGUI();
                                    JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Could not create write file:" + exception.toString(), "GATE", 0);
                                    exception.printStackTrace(Err.getPrintWriter());
                                    MainFrame.unlockGUI();
                                    return;
                                }
                                NameBearerHandle.this.fireStatusChanged(document.getName() + " saved");
                                if (!bl2) {
                                    corpus.unloadDocument(document);
                                    Factory.deleteResource(document);
                                }
                                NameBearerHandle.this.fireProgressChanged(100 * n2++ / n);
                            }
                            NameBearerHandle.this.fireStatusChanged("Corpus saved");
                            NameBearerHandle.this.fireProcessFinished();
                        }
                        finally {
                            MainFrame.unlockGUI();
                        }
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Corpus XML dumper");
            thread.setPriority(1);
            thread.start();
        }
    }

    class SaveAsXmlAction
    extends AbstractAction {
        public SaveAsXmlAction() {
            super("Save As Xml...");
            this.putValue("ShortDescription", "Saves this resource in XML");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int n;
                    JFileChooser jFileChooser = MainFrame.getFileChooser();
                    File file = null;
                    List<FileFilter> list = Arrays.asList(jFileChooser.getChoosableFileFilters());
                    Iterator<FileFilter> iterator = list.iterator();
                    FileFilter fileFilter = null;
                    if (iterator.hasNext()) {
                        fileFilter = iterator.next();
                        while (iterator.hasNext() && fileFilter.getDescription().indexOf("XML") == -1) {
                            fileFilter = iterator.next();
                        }
                    }
                    if (fileFilter == null || fileFilter.getDescription().indexOf("XML") == -1) {
                        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
                        extensionFileFilter.setDescription("XML files");
                        extensionFileFilter.addExtension("xml");
                        extensionFileFilter.addExtension("gml");
                        jFileChooser.addChoosableFileFilter(extensionFileFilter);
                        fileFilter = extensionFileFilter;
                    }
                    jFileChooser.setFileFilter(fileFilter);
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setDialogTitle("Select document to save ...");
                    jFileChooser.setSelectedFiles(null);
                    int n2 = NameBearerHandle.this.getLargeView() != null ? jFileChooser.showDialog(NameBearerHandle.this.getLargeView(), "Save") : (n = NameBearerHandle.this.getSmallView() != null ? jFileChooser.showDialog(NameBearerHandle.this.getSmallView(), "Save") : jFileChooser.showDialog(null, "Save"));
                    if (n == 0) {
                        file = jFileChooser.getSelectedFile();
                        File file2 = jFileChooser.getCurrentDirectory();
                        if (file == null) {
                            return;
                        }
                        long l = System.currentTimeMillis();
                        NameBearerHandle.this.statusChanged("Saving as XML to " + file.toString() + "...");
                        try {
                            MainFrame.lockGUI("Saving...");
                            DocumentStaxUtils.writeDocument((Document)NameBearerHandle.this.target, file);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(Out.getPrintWriter());
                        }
                        finally {
                            MainFrame.unlockGUI();
                        }
                        long l2 = System.currentTimeMillis() - l;
                        NameBearerHandle.this.statusChanged("Finished saving as xml into  the file: " + file.toString() + " in " + (double)l2 / 1000.0 + " s");
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
            this.putValue("ShortDescription", "Removes this resource from the system");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NameBearerHandle.this.target instanceof Resource) {
                Factory.deleteResource((Resource)NameBearerHandle.this.target);
            } else if (NameBearerHandle.this.target instanceof DataStore) {
                try {
                    ((DataStore)NameBearerHandle.this.target).close();
                }
                catch (PersistenceException persistenceException) {
                    JOptionPane.showMessageDialog(NameBearerHandle.this.largeView != null ? NameBearerHandle.this.largeView : NameBearerHandle.this.smallView, "Error!\n" + persistenceException.toString(), "GATE", 0);
                }
            }
            NameBearerHandle.this.statusListeners.clear();
            NameBearerHandle.this.progressListeners.clear();
        }
    }
}

