/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import com.ontotext.gate.vr.Gaze;
import debugger.JapeDebugger;
import gate.Controller;
import gate.CreoleRegister;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Main;
import gate.ProcessingResource;
import gate.Resource;
import gate.VisualResource;
import gate.creole.ANNIEConstants;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialAnalyserController;
import gate.creole.gazetteer.Gazetteer;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.AnnotationDiffGUI;
import gate.gui.AppearanceDialog;
import gate.gui.BootStrapDialog;
import gate.gui.Handle;
import gate.gui.HelpFrame;
import gate.gui.LogArea;
import gate.gui.NameBearerHandle;
import gate.gui.NewResourceDialog;
import gate.gui.OkCancelDialog;
import gate.gui.OptionsDialog;
import gate.gui.PluginManagerUI;
import gate.gui.Splash;
import gate.gui.TabHighlighter;
import gate.persist.PersistenceException;
import gate.security.AccessController;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.Session;
import gate.security.User;
import gate.swing.WaitDialog;
import gate.swing.XJMenu;
import gate.swing.XJMenuItem;
import gate.swing.XJPopupMenu;
import gate.swing.XJTabbedPane;
import gate.util.CorpusBenchmarkTool;
import gate.util.Err;
import gate.util.Files;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.OptionsMap;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import guk.Editor;
import guk.im.GateIMDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.Assert;
import mpi.alt.java.awt.im.spi.lookup.LookupDescriptor;

public class MainFrame
extends JFrame
implements ProgressListener,
StatusListener,
CreoleListener {
    protected JMenuBar menuBar;
    protected JSplitPane mainSplit;
    protected JSplitPane leftSplit;
    protected JLabel statusBar;
    protected JProgressBar progressBar;
    protected XJTabbedPane mainTabbedPane;
    protected JScrollPane projectTreeScroll;
    protected JScrollPane lowerScroll;
    protected JPopupMenu appsPopup;
    protected JPopupMenu dssPopup;
    protected JPopupMenu lrsPopup;
    protected JPopupMenu prsPopup;
    protected JCheckBoxMenuItem verboseModeItem;
    protected JTree resourcesTree;
    protected JScrollPane resourcesTreeScroll;
    protected DefaultTreeModel resourcesTreeModel;
    protected DefaultMutableTreeNode resourcesTreeRoot;
    protected DefaultMutableTreeNode applicationsRoot;
    protected DefaultMutableTreeNode languageResourcesRoot;
    protected DefaultMutableTreeNode processingResourcesRoot;
    protected DefaultMutableTreeNode datastoresRoot;
    protected Splash splash;
    protected PluginManagerUI pluginManager;
    protected LogArea logArea;
    protected JScrollPane logScroll;
    protected JToolBar toolbar;
    static JFileChooser fileChooser;
    private static MainFrame instance;
    protected AppearanceDialog appearanceDialog;
    protected OptionsDialog optionsDialog;
    protected CartoonMinder animator;
    protected TabHighlighter logHighlighter;
    protected NewResourceDialog newResourceDialog;
    protected WaitDialog waitDialog;
    protected static Map iconByName;
    private static Map listeners;
    protected static Collection guiRoots;
    protected static final String[] ICON_EXTENSIONS;
    private static JDialog guiLock;
    private boolean titleChangable = false;

    public static Icon getIcon(String string) {
        Icon icon = (Icon)iconByName.get(string);
        for (int i = 0; i < ICON_EXTENSIONS.length && icon == null; ++i) {
            String string2 = ICON_EXTENSIONS[i];
            String string3 = string + string2;
            URL uRL = null;
            uRL = string3.charAt(0) == '/' ? Files.getResource(string3) : Files.getGateResource("/img/" + string3);
            if (uRL == null) continue;
            icon = new ImageIcon(uRL);
            iconByName.put(string, icon);
        }
        return icon;
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    public static JFileChooser getFileChooser() {
        return fileChooser;
    }

    public void select(Resource resource) {
        Handle handle = null;
        Enumeration<TreeNode> enumeration = this.resourcesTreeRoot.breadthFirstEnumeration();
        while (enumeration.hasMoreElements() && handle == null) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || !((defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode).getUserObject() instanceof Handle) || ((Handle)defaultMutableTreeNode.getUserObject()).getTarget() != resource) continue;
            handle = (Handle)defaultMutableTreeNode.getUserObject();
        }
        if (handle != null) {
            this.select(handle);
        }
    }

    protected void select(Handle handle) {
        JComponent jComponent;
        if (handle.viewsBuilt() && this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
            jComponent = handle.getLargeView();
            if (jComponent != null) {
                this.mainTabbedPane.setSelectedComponent(jComponent);
            }
        } else {
            jComponent = handle.getLargeView();
            if (jComponent != null) {
                this.mainTabbedPane.addTab(handle.getTitle(), handle.getIcon(), jComponent, handle.getTooltipText());
                this.mainTabbedPane.setSelectedComponent(handle.getLargeView());
            }
        }
        jComponent = handle.getSmallView();
        if (jComponent != null) {
            this.lowerScroll.getViewport().setView(jComponent);
        } else {
            this.lowerScroll.getViewport().setView(null);
        }
    }

    public MainFrame() {
        this((GraphicsConfiguration)null);
    }

    public MainFrame(GraphicsConfiguration graphicsConfiguration) {
        this(false, graphicsConfiguration);
    }

    public MainFrame(boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        instance = this;
        guiRoots.add(this);
        if (fileChooser == null) {
            Serializable serializable;
            fileChooser = new GateFileChooser();
            fileChooser.setMultiSelectionEnabled(false);
            String string = Gate.getUserConfig().getString("Last_filechooser_location");
            if (string != null && string.length() > 0 && ((File)(serializable = new File(string))).exists() && ((File)serializable).isDirectory()) {
                fileChooser.setCurrentDirectory(new File(string));
            }
            guiRoots.add(fileChooser);
            serializable = new JDialog(this, "", true);
            Container container = ((JDialog)serializable).getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)fileChooser, "Center");
            ((Window)serializable).pack();
            ((JDialog)serializable).getContentPane().removeAll();
            ((Window)serializable).dispose();
            serializable = null;
        }
        this.enableEvents(64L);
        this.initLocalData(bl);
        this.initGuiComponents(bl);
        this.initListeners(bl);
    }

    protected void initLocalData(boolean bl) {
        this.resourcesTreeRoot = new DefaultMutableTreeNode("GATE", true);
        this.applicationsRoot = new DefaultMutableTreeNode("Applications", true);
        this.languageResourcesRoot = bl ? new DefaultMutableTreeNode("Documents", true) : new DefaultMutableTreeNode("Language Resources", true);
        this.processingResourcesRoot = new DefaultMutableTreeNode("Processing Resources", true);
        this.datastoresRoot = new DefaultMutableTreeNode("Data stores", true);
        this.resourcesTreeRoot.add(this.applicationsRoot);
        this.resourcesTreeRoot.add(this.languageResourcesRoot);
        this.resourcesTreeRoot.add(this.processingResourcesRoot);
        this.resourcesTreeRoot.add(this.datastoresRoot);
        this.resourcesTreeModel = new ResourcesTreeModel(this.resourcesTreeRoot, true);
    }

    protected void initGuiComponents(boolean bl) {
        Serializable serializable;
        Serializable serializable2;
        String string;
        this.getContentPane().setLayout(new BorderLayout());
        Integer n = Gate.getUserConfig().getInt("Main_frame_width");
        Integer n2 = Gate.getUserConfig().getInt("Main_frame_height");
        this.setSize(new Dimension(n == null ? 800 : n, n2 == null ? 600 : n2));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(Files.getGateResource("/img/gate-icon.png")));
        this.resourcesTree = new ResourcesTree();
        this.resourcesTree.setModel(this.resourcesTreeModel);
        this.resourcesTree.setRowHeight(0);
        this.resourcesTree.setEditable(true);
        ResourcesTreeCellRenderer resourcesTreeCellRenderer = new ResourcesTreeCellRenderer();
        this.resourcesTree.setCellRenderer(resourcesTreeCellRenderer);
        this.resourcesTree.setCellEditor(new ResourcesTreeCellEditor(this.resourcesTree, resourcesTreeCellRenderer));
        this.resourcesTree.setRowHeight(0);
        this.resourcesTree.expandRow(0);
        this.resourcesTree.expandRow(1);
        this.resourcesTree.expandRow(2);
        this.resourcesTree.expandRow(3);
        this.resourcesTree.expandRow(4);
        this.resourcesTree.getSelectionModel().setSelectionMode(4);
        this.resourcesTree.setEnabled(true);
        ToolTipManager.sharedInstance().registerComponent(this.resourcesTree);
        this.resourcesTreeScroll = new JScrollPane(this.resourcesTree);
        this.lowerScroll = new JScrollPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new OverlayLayout(jPanel));
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setOpaque(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setOpaque(false);
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add(jPanel2);
        jPanel4.add(jPanel3);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel.add(jPanel4);
        jPanel.add(this.lowerScroll);
        this.animator = new CartoonMinder(jPanel2);
        Thread thread = new Thread(Thread.currentThread().getThreadGroup(), this.animator, "MainFrame1");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        this.leftSplit = new JSplitPane(0, this.resourcesTreeScroll, jPanel);
        this.leftSplit.setResizeWeight(0.7);
        this.logArea = new LogArea();
        this.logScroll = new JScrollPane(this.logArea);
        Out.prln("GATE " + Main.version + " build " + Main.build + " started at: " + new Date().toString());
        this.mainTabbedPane = new XJTabbedPane(1);
        this.mainTabbedPane.insertTab("Messages", null, this.logScroll, "GATE log", 0);
        this.logHighlighter = new TabHighlighter(this.mainTabbedPane, this.logScroll, Color.red);
        this.mainSplit = new JSplitPane(1, this.leftSplit, this.mainTabbedPane);
        this.mainSplit.setDividerLocation(this.leftSplit.getPreferredSize().width + 10);
        this.getContentPane().add((Component)this.mainSplit, "Center");
        this.statusBar = new JLabel(" ");
        this.statusBar.setPreferredSize(new Dimension(200, this.statusBar.getPreferredSize().height));
        UIManager.put("ProgressBar.cellSpacing", new Integer(0));
        this.progressBar = new JProgressBar(0);
        this.progressBar.setForeground(new Color(150, 75, 150));
        this.progressBar.setStringPainted(false);
        this.progressBar.setOrientation(0);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2));
        jPanel5.setBorder(null);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(this.statusBar);
        jPanel5.add(box);
        box = Box.createHorizontalBox();
        box.add(this.progressBar);
        box.add(Box.createHorizontalStrut(5));
        jPanel5.add(box);
        this.getContentPane().add((Component)jPanel5, "South");
        this.progressBar.setVisible(false);
        this.newResourceDialog = new NewResourceDialog(this, "Resource parameters", true);
        this.waitDialog = new WaitDialog(this, "");
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.WHITE);
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JLabel jLabel = new JLabel(MainFrame.getIcon("splash"));
        jPanel6.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        try {
            string = Files.getGateResourceAsString("splash.html");
        }
        catch (IOException iOException) {
            string = "GATE";
            Err.prln("couldn't get splash.html resource: " + iOException);
        }
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setHorizontalAlignment(0);
        jPanel6.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jLabel2 = new JLabel("<HTML><FONT color=\"blue\">Version <B>" + Main.version + "</B></FONT>" + ", <FONT color=\"red\">build <B>" + Main.build + "</B></FONT>" + "<P><B>JVM version</B>: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + "</HTML>");
        gridBagConstraints.fill = 2;
        jPanel6.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.splash.setVisible(false);
            }
        });
        jButton.setBackground(Color.white);
        jPanel6.add((Component)jButton, gridBagConstraints);
        this.splash = new Splash((Window)this, jPanel6);
        this.menuBar = new JMenuBar();
        XJMenu xJMenu = new XJMenu("File");
        LiveMenu liveMenu = new LiveMenu(3);
        liveMenu.setText("New application");
        liveMenu.setIcon(MainFrame.getIcon("applications"));
        xJMenu.add(liveMenu);
        LiveMenu liveMenu2 = new LiveMenu(1);
        liveMenu2.setText("New language resource");
        liveMenu2.setIcon(MainFrame.getIcon("lrs"));
        xJMenu.add(liveMenu2);
        LiveMenu liveMenu3 = new LiveMenu(2);
        liveMenu3.setText("New processing resource");
        liveMenu3.setIcon(MainFrame.getIcon("prs"));
        xJMenu.add(liveMenu3);
        JMenu jMenu = new JMenu("Datastores");
        jMenu.setIcon(MainFrame.getIcon("datastores"));
        jMenu.add(new XJMenuItem(new NewDSAction(), this));
        jMenu.add(new XJMenuItem(new OpenDSAction(), this));
        xJMenu.add(jMenu);
        xJMenu.addSeparator();
        xJMenu.add(new XJMenuItem(new LoadResourceFromFileAction(), this));
        xJMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Load ANNIE system");
        jMenu2.setIcon(MainFrame.getIcon("annie-application"));
        jMenu2.add(new XJMenuItem(new LoadANNIEWithDefaultsAction(), this));
        jMenu2.add(new XJMenuItem(new LoadANNIEWithoutDefaultsAction(), this));
        xJMenu.add(jMenu2);
        xJMenu.add(new XJMenuItem(new ManagePluginsAction(), this));
        xJMenu.addSeparator();
        xJMenu.add(new XJMenuItem(new ExitGateAction(), this));
        this.menuBar.add(xJMenu);
        JMenu jMenu3 = new JMenu("Options");
        this.optionsDialog = new OptionsDialog(this);
        jMenu3.add(new XJMenuItem(new AbstractAction("Configuration"){
            {
                this.putValue("ShortDescription", "Edit gate options");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.optionsDialog.showDialog();
                MainFrame.this.optionsDialog.dispose();
            }
        }, this));
        XJMenu xJMenu2 = null;
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        try {
            Class.forName("guk.im.GateIMDescriptor");
            arrayList.addAll(Arrays.asList(new GateIMDescriptor().getAvailableLocales()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("mpi.alt.java.awt.im.spi.lookup.LookupDescriptor");
            arrayList.addAll(Arrays.asList(new LookupDescriptor().getAvailableLocales()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Locale)object).getDisplayName().compareTo(((Locale)object2).getDisplayName());
            }
        });
        if (!arrayList.isEmpty()) {
            xJMenu2 = new XJMenu("Input methods");
            serializable2 = new ButtonGroup();
            LocaleSelectorMenuItem localeSelectorMenuItem = new LocaleSelectorMenuItem();
            xJMenu2.add(localeSelectorMenuItem);
            localeSelectorMenuItem.setSelected(true);
            xJMenu2.addSeparator();
            ((ButtonGroup)serializable2).add(localeSelectorMenuItem);
            for (int i = 0; i < arrayList.size(); ++i) {
                serializable = (Locale)arrayList.get(i);
                localeSelectorMenuItem = new LocaleSelectorMenuItem((Locale)serializable);
                xJMenu2.add(localeSelectorMenuItem);
                ((ButtonGroup)serializable2).add(localeSelectorMenuItem);
            }
        }
        if (xJMenu2 != null) {
            jMenu3.add(xJMenu2);
        }
        this.menuBar.add(jMenu3);
        serializable2 = new XJMenu("Tools");
        ((JMenu)serializable2).add(new NewAnnotDiffAction());
        ((JMenu)serializable2).add(new NewBootStrapAction());
        JMenu jMenu4 = new JMenu("Corpus Benchmark Tools");
        jMenu4.setIcon(MainFrame.getIcon("corpus-benchmark"));
        ((JMenu)serializable2).add(jMenu4);
        jMenu4.add(new NewCorpusEvalAction());
        jMenu4.addSeparator();
        jMenu4.add(new GenerateStoredCorpusEvalAction());
        jMenu4.addSeparator();
        jMenu4.add(new StoredMarkedCorpusEvalAction());
        jMenu4.add(new CleanMarkedCorpusEvalAction());
        jMenu4.addSeparator();
        this.verboseModeItem = new JCheckBoxMenuItem(new VerboseModeCorpusEvalToolAction());
        jMenu4.add(this.verboseModeItem);
        ((JMenu)serializable2).add(new AbstractAction("Unicode editor", MainFrame.getIcon("unicode")){

            public void actionPerformed(ActionEvent actionEvent) {
                new Editor();
            }
        });
        if (Gate.isEnableJapeDebug()) {
            ((JMenu)serializable2).add(new AbstractAction("JAPE Debugger", MainFrame.getIcon("application")){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("Creating Jape Debugger");
                    new JapeDebugger();
                }
            });
        }
        this.menuBar.add((JMenu)serializable2);
        serializable = new JMenu("Help");
        ((JMenu)serializable).add(new HelpAboutAction());
        this.menuBar.add((JMenu)serializable);
        this.setJMenuBar(this.menuBar);
        this.appsPopup = new XJPopupMenu();
        LiveMenu liveMenu4 = new LiveMenu(3);
        liveMenu4.setText("New");
        this.appsPopup.add(liveMenu4);
        this.appsPopup.addSeparator();
        this.appsPopup.add(new XJMenuItem(new LoadResourceFromFileAction(), this));
        guiRoots.add(liveMenu4);
        guiRoots.add(this.appsPopup);
        this.lrsPopup = new XJPopupMenu();
        LiveMenu liveMenu5 = new LiveMenu(1);
        liveMenu5.setText("New");
        this.lrsPopup.add(liveMenu5);
        guiRoots.add(this.lrsPopup);
        guiRoots.add(liveMenu5);
        this.prsPopup = new XJPopupMenu();
        LiveMenu liveMenu6 = new LiveMenu(2);
        liveMenu6.setText("New");
        this.prsPopup.add(liveMenu6);
        guiRoots.add(liveMenu6);
        guiRoots.add(this.prsPopup);
        this.dssPopup = new XJPopupMenu();
        this.dssPopup.add(new NewDSAction());
        this.dssPopup.add(new OpenDSAction());
        guiRoots.add(this.dssPopup);
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        this.toolbar.add(new LoadResourceFromFileAction());
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorderPainted(false);
        jMenuBar.setAlignmentY(0.5f);
        JMenu jMenu5 = new JMenu();
        jMenu5.setIcon(MainFrame.getIcon("annie-application"));
        jMenu5.setToolTipText("Load ANNIE System");
        jMenu5.add(new LoadANNIEWithDefaultsAction());
        jMenu5.add(new LoadANNIEWithoutDefaultsAction());
        jMenuBar.add(jMenu5);
        this.toolbar.add(jMenuBar);
        this.toolbar.addSeparator();
        jMenuBar = new JMenuBar();
        jMenuBar.setBorderPainted(false);
        jMenuBar.setAlignmentY(0.5f);
        LiveMenu liveMenu7 = new LiveMenu(1);
        liveMenu7.setToolTipText("New Language Resource");
        liveMenu7.setIcon(MainFrame.getIcon("lrs"));
        jMenuBar.add(liveMenu7);
        this.toolbar.add(jMenuBar);
        jMenuBar = new JMenuBar();
        jMenuBar.setBorderPainted(false);
        jMenuBar.setAlignmentY(0.5f);
        LiveMenu liveMenu8 = new LiveMenu(2);
        liveMenu8.setToolTipText("New Processing Resource");
        liveMenu8.setIcon(MainFrame.getIcon("prs"));
        jMenuBar.add(liveMenu8);
        this.toolbar.add(jMenuBar);
        jMenuBar = new JMenuBar();
        jMenuBar.setBorderPainted(false);
        jMenuBar.setAlignmentY(0.5f);
        LiveMenu liveMenu9 = new LiveMenu(3);
        liveMenu9.setToolTipText("New Application");
        liveMenu9.setIcon(MainFrame.getIcon("applications"));
        jMenuBar.add(liveMenu9);
        this.toolbar.add(jMenuBar);
        jMenuBar = new JMenuBar();
        jMenuBar.setBorderPainted(false);
        jMenuBar.setAlignmentY(0.5f);
        JMenu jMenu6 = new JMenu();
        jMenu6.setToolTipText("Datastores");
        jMenu6.setIcon(MainFrame.getIcon("datastores"));
        jMenu6.add(new NewDSAction());
        jMenu6.add(new OpenDSAction());
        jMenuBar.add(jMenu6);
        this.toolbar.add(jMenuBar);
        this.toolbar.addSeparator();
        this.toolbar.add(new ManagePluginsAction());
        this.toolbar.addSeparator();
        this.toolbar.add(new NewAnnotDiffAction());
        this.toolbar.add(Box.createGlue());
        this.getContentPane().add((Component)this.toolbar, "North");
    }

    protected void initListeners(boolean bl) {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.resourcesTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TreePath treePath = MainFrame.this.resourcesTree.getPathForLocation(n, n2);
                JPopupMenu jPopupMenu = null;
                Handle handle = null;
                if (treePath != null && (object = treePath.getLastPathComponent()) != MainFrame.this.resourcesTreeRoot) {
                    if (object == MainFrame.this.applicationsRoot) {
                        jPopupMenu = MainFrame.this.appsPopup;
                    } else if (object == MainFrame.this.languageResourcesRoot) {
                        jPopupMenu = MainFrame.this.lrsPopup;
                    } else if (object == MainFrame.this.processingResourcesRoot) {
                        jPopupMenu = MainFrame.this.prsPopup;
                    } else if (object == MainFrame.this.datastoresRoot) {
                        jPopupMenu = MainFrame.this.dssPopup;
                    } else if ((object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof Handle) {
                        handle = (Handle)object;
                        jPopupMenu = handle.getPopup();
                    }
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (MainFrame.this.resourcesTree.getSelectionCount() > 1) {
                        jPopupMenu = new XJPopupMenu();
                        jPopupMenu.add(new XJMenuItem(new CloseSelectedResourcesAction(), MainFrame.this));
                        jPopupMenu.show(MainFrame.this.resourcesTree, mouseEvent.getX(), mouseEvent.getY());
                    } else if (jPopupMenu != null) {
                        if (handle != null) {
                            jPopupMenu.insert(new JPopupMenu.Separator(), 2);
                            jPopupMenu.insert(new XJMenuItem(new RenameResourceAction(treePath), MainFrame.this), 3);
                        }
                        jPopupMenu.show(MainFrame.this.resourcesTree, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && handle != null) {
                    MainFrame.this.select(handle);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                Action action;
                JComponent jComponent;
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 115 && (jComponent = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent()) != null && (action = jComponent.getActionMap().get("Close resource")) != null) {
                    action.actionPerformed(null);
                }
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 72 && (jComponent = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent()) != null && (action = jComponent.getActionMap().get("Hide current view")) != null) {
                    action.actionPerformed(null);
                }
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 88 && (jComponent = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent()) != null && (action = jComponent.getActionMap().get("Save As XML")) != null) {
                    action.actionPerformed(null);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.mainTabbedPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JComponent jComponent = (JComponent)MainFrame.this.mainTabbedPane.getSelectedComponent();
                Enumeration<TreeNode> enumeration = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
                boolean bl = false;
                DefaultMutableTreeNode defaultMutableTreeNode = MainFrame.this.resourcesTreeRoot;
                while (!bl && enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    bl = defaultMutableTreeNode.getUserObject() instanceof Handle && ((Handle)defaultMutableTreeNode.getUserObject()).viewsBuilt() && ((Handle)defaultMutableTreeNode.getUserObject()).getLargeView() == jComponent;
                }
                if (bl) {
                    Handle handle = (Handle)defaultMutableTreeNode.getUserObject();
                    TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                    MainFrame.this.resourcesTree.setSelectionPath(treePath);
                    MainFrame.this.resourcesTree.scrollPathToVisible(treePath);
                    MainFrame.this.lowerScroll.getViewport().setView(handle.getSmallView());
                } else {
                    MainFrame.this.lowerScroll.getViewport().setView(null);
                }
            }
        });
        this.mainTabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (SwingUtilities.isRightMouseButton(mouseEvent) && (n = MainFrame.this.mainTabbedPane.getIndexAt(mouseEvent.getPoint())) != -1) {
                    JComponent jComponent = (JComponent)MainFrame.this.mainTabbedPane.getComponentAt(n);
                    Enumeration<TreeNode> enumeration = MainFrame.this.resourcesTreeRoot.preorderEnumeration();
                    boolean bl = false;
                    DefaultMutableTreeNode defaultMutableTreeNode = MainFrame.this.resourcesTreeRoot;
                    while (!bl && enumeration.hasMoreElements()) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                        bl = defaultMutableTreeNode.getUserObject() instanceof Handle && ((Handle)defaultMutableTreeNode.getUserObject()).viewsBuilt() && ((Handle)defaultMutableTreeNode.getUserObject()).getLargeView() == jComponent;
                    }
                    if (bl) {
                        Handle handle = (Handle)defaultMutableTreeNode.getUserObject();
                        JPopupMenu jPopupMenu = handle.getPopup();
                        CloseViewAction closeViewAction = new CloseViewAction(handle);
                        XJMenuItem xJMenuItem = new XJMenuItem(closeViewAction, MainFrame.this);
                        jPopupMenu.insert(xJMenuItem, 1);
                        jPopupMenu.insert(new JPopupMenu.Separator(), 2);
                        jPopupMenu.show(MainFrame.this.mainTabbedPane, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
                MainFrame.this.leftSplit.setDividerLocation(0.7);
            }
        });
        if (bl) {
            this.mainSplit.setDividerSize(0);
            this.mainSplit.getTopComponent().setVisible(false);
            this.mainSplit.getTopComponent().addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                    MainFrame.this.mainSplit.setDividerLocation(0);
                }

                public void componentResized(ComponentEvent componentEvent) {
                    MainFrame.this.mainSplit.setDividerLocation(0);
                }

                public void componentShown(ComponentEvent componentEvent) {
                    MainFrame.this.mainSplit.setDividerLocation(0);
                }
            });
        }
        this.logArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changeOccured();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changeOccured();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.changeOccured();
            }

            protected void changeOccured() {
                MainFrame.this.logHighlighter.highlight();
            }
        });
        this.logArea.addPropertyChangeListener("document", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MainFrame.this.logArea.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.changeOccured();
                    }

                    protected void changeOccured() {
                        MainFrame.this.logHighlighter.highlight();
                    }
                });
            }
        });
        listeners.put("gate.event.StatusListener", this);
        listeners.put("gate.event.ProgressListener", this);
        if (System.getProperty("mrj.version") != null) {
            this.initMacListeners();
        }
    }

    protected void initMacListeners() {
        try {
            Class<?> clazz = Gate.getClassLoader().loadClass("com.apple.eawt.Application");
            Class<?> clazz2 = Gate.getClassLoader().loadClass("com.apple.eawt.ApplicationListener");
            Class<?> clazz3 = Gate.getClassLoader().loadClass("com.apple.eawt.ApplicationEvent");
            final Method method = clazz3.getMethod("setHandled", Boolean.TYPE);
            InvocationHandler invocationHandler = new InvocationHandler(){
                private Action aboutAction;
                private Action exitAction;
                {
                    this.aboutAction = new HelpAboutAction();
                    this.exitAction = new ExitGateAction();
                }

                public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
                    Object object2 = objectArray[0];
                    if ("handleAbout".equals(method2.getName())) {
                        method.invoke(object2, Boolean.TRUE);
                        this.aboutAction.actionPerformed(null);
                    } else if ("handleQuit".equals(method2.getName())) {
                        method.invoke(object2, Boolean.FALSE);
                        this.exitAction.actionPerformed(null);
                    } else if ("handlePreferences".equals(method2.getName())) {
                        method.invoke(object2, Boolean.TRUE);
                        MainFrame.this.optionsDialog.showDialog();
                    }
                    return null;
                }
            };
            Object object = Proxy.newProxyInstance(Gate.getClassLoader(), new Class[]{clazz2}, invocationHandler);
            Method method2 = clazz.getMethod("getApplication", new Class[0]);
            Object object2 = method2.invoke(null, new Object[0]);
            Method method3 = clazz.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            method3.invoke(object2, Boolean.TRUE);
            Method method4 = clazz.getMethod("addApplicationListener", clazz2);
            method4.invoke(object2, object);
        }
        catch (Throwable throwable) {
            System.out.println("Warning: there was a problem setting up the Mac application\nmenu.  Your options/session will not be saved if you exit\nwith command-Q, use \"File/Exit GATE\" instead");
        }
    }

    public void progressChanged(int n) {
        int n2 = this.progressBar.getValue();
        if (!this.animator.isActive()) {
            this.animator.activate();
        }
        if (n2 != n) {
            SwingUtilities.invokeLater(new ProgressBarUpdater(n));
        }
    }

    public void processFinished() {
        SwingUtilities.invokeLater(new ProgressBarUpdater(0));
        this.animator.deactivate();
    }

    public void statusChanged(String string) {
        SwingUtilities.invokeLater(new StatusBarUpdater(string));
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
        Resource resource = creoleEvent.getResource();
        if (Gate.getHiddenAttribute(resource.getFeatures()) || resource instanceof VisualResource) {
            return;
        }
        NameBearerHandle nameBearerHandle = new NameBearerHandle(resource, this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(nameBearerHandle, false);
        if (resource instanceof ProcessingResource) {
            this.resourcesTreeModel.insertNodeInto(defaultMutableTreeNode, this.processingResourcesRoot, 0);
        } else if (resource instanceof LanguageResource) {
            this.resourcesTreeModel.insertNodeInto(defaultMutableTreeNode, this.languageResourcesRoot, 0);
        } else if (resource instanceof Controller) {
            this.resourcesTreeModel.insertNodeInto(defaultMutableTreeNode, this.applicationsRoot, 0);
        }
        nameBearerHandle.addProgressListener(this);
        nameBearerHandle.addStatusListener(this);
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        final Resource resource = creoleEvent.getResource();
        if (Gate.getHiddenAttribute(resource.getFeatures())) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                if (resource instanceof ProcessingResource) {
                    defaultMutableTreeNode = MainFrame.this.processingResourcesRoot;
                } else if (resource instanceof LanguageResource) {
                    defaultMutableTreeNode = MainFrame.this.languageResourcesRoot;
                } else if (resource instanceof Controller) {
                    defaultMutableTreeNode = MainFrame.this.applicationsRoot;
                }
                if (defaultMutableTreeNode != null) {
                    Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                    while (enumeration.hasMoreElements()) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                        if (((NameBearerHandle)defaultMutableTreeNode2.getUserObject()).getTarget() != resource) continue;
                        MainFrame.this.resourcesTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
                        Handle handle = (Handle)defaultMutableTreeNode2.getUserObject();
                        if (handle.viewsBuilt()) {
                            if (MainFrame.this.mainTabbedPane.indexOfComponent(handle.getLargeView()) != -1) {
                                MainFrame.this.mainTabbedPane.remove(handle.getLargeView());
                            }
                            if (MainFrame.this.lowerScroll.getViewport().getView() == handle.getSmallView()) {
                                MainFrame.this.lowerScroll.getViewport().setView(null);
                            }
                        }
                        handle.cleanup();
                        return;
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
        DataStore dataStore = creoleEvent.getDatastore();
        dataStore.setName(dataStore.getStorageUrl());
        NameBearerHandle nameBearerHandle = new NameBearerHandle(dataStore, this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(nameBearerHandle, false);
        this.resourcesTreeModel.insertNodeInto(defaultMutableTreeNode, this.datastoresRoot, 0);
        nameBearerHandle.addProgressListener(this);
        nameBearerHandle.addStatusListener(this);
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
        this.datastoreOpened(creoleEvent);
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
        DataStore dataStore = creoleEvent.getDatastore();
        DefaultMutableTreeNode defaultMutableTreeNode = this.datastoresRoot;
        if (defaultMutableTreeNode != null) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (((NameBearerHandle)defaultMutableTreeNode2.getUserObject()).getTarget() != dataStore) continue;
                this.resourcesTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
                NameBearerHandle nameBearerHandle = (NameBearerHandle)defaultMutableTreeNode2.getUserObject();
                if (nameBearerHandle.viewsBuilt() && this.mainTabbedPane.indexOfComponent(nameBearerHandle.getLargeView()) != -1) {
                    this.mainTabbedPane.remove(nameBearerHandle.getLargeView());
                }
                if (this.lowerScroll.getViewport().getView() == nameBearerHandle.getSmallView()) {
                    this.lowerScroll.getViewport().setView(null);
                }
                return;
            }
        }
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
        for (int i = 0; i < this.mainTabbedPane.getTabCount(); ++i) {
            if (!this.mainTabbedPane.getTitleAt(i).equals(string)) continue;
            this.mainTabbedPane.setTitleAt(i, string2);
            return;
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            new ExitGateAction().actionPerformed(null);
        }
        super.processWindowEvent(windowEvent);
    }

    public static Map getListeners() {
        return listeners;
    }

    public static Collection getGuiRoots() {
        return guiRoots;
    }

    public static synchronized void lockGUI(String string) {
        if (MainFrame.getGuiRoots() == null || MainFrame.getGuiRoots().isEmpty()) {
            return;
        }
        MainFrame.unlockGUI();
        Object[] objectArray = new Object[]{new JButton(new StopAction())};
        JOptionPane jOptionPane = new JOptionPane(string, 2, -1, null, objectArray, null);
        Component component = (Component)((ArrayList)MainFrame.getGuiRoots()).get(0);
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, "Please wait", true){

            protected void processWindowEvent(WindowEvent windowEvent) {
                if (windowEvent.getID() == 201) {
                    this.getToolkit().beep();
                }
            }
        } : (window instanceof Dialog ? new JDialog((Dialog)window, "Please wait", true){

            protected void processWindowEvent(WindowEvent windowEvent) {
                if (windowEvent.getID() == 201) {
                    this.getToolkit().beep();
                }
            }
        } : new JDialog(JOptionPane.getRootFrame(), "Please wait", true){

            protected void processWindowEvent(WindowEvent windowEvent) {
                if (windowEvent.getID() == 201) {
                    this.getToolkit().beep();
                }
            }
        });
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jOptionPane, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        jDialog.setDefaultCloseOperation(0);
        guiLock = jDialog;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                guiLock.setVisible(true);
            }
        });
        while (!guiLock.isShowing()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static synchronized void unlockGUI() {
        if (MainFrame.getGuiRoots() == null || MainFrame.getGuiRoots().isEmpty()) {
            return;
        }
        if (guiLock != null) {
            guiLock.setVisible(false);
            guiLock.dispose();
        }
        guiLock = null;
    }

    public void setTitleChangable(boolean bl) {
        this.titleChangable = bl;
    }

    public synchronized void setTitle(String string) {
        if (this.titleChangable) {
            super.setTitle(string);
        }
    }

    protected DataStore createSerialDataStore() {
        DataStore dataStore = null;
        fileChooser.setDialogTitle("Please create a new empty directory");
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL uRL = fileChooser.getSelectedFile().toURI().toURL();
                dataStore = Factory.createDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + malformedURLException.toString(), "GATE", 0);
            }
            catch (PersistenceException persistenceException) {
                JOptionPane.showMessageDialog(this, "Datastore creation error!\n " + persistenceException.toString(), "GATE", 0);
            }
        }
        return dataStore;
    }

    protected DataStore openSerialDataStore() {
        DataStore dataStore = null;
        fileChooser.setDialogTitle("Select the datastore directory");
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL uRL = fileChooser.getSelectedFile().toURI().toURL();
                dataStore = Factory.openDataStore("gate.persist.SerialDataStore", uRL.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + malformedURLException.toString(), "GATE", 0);
            }
            catch (PersistenceException persistenceException) {
                JOptionPane.showMessageDialog(this, "Datastore opening error!\n " + persistenceException.toString(), "GATE", 0);
            }
        }
        return dataStore;
    }

    protected DataStore openDocServiceDataStore() {
        DataStore dataStore = null;
        try {
            String string = JOptionPane.showInputDialog(this, "Enter document service URL", "http://localhost:8080/docservice/services/docservice");
            dataStore = Factory.openDataStore("gleam.docservice.gate.DocServiceDataStore", string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Datastore opening error!\n " + exception.toString(), "GATE", 0);
        }
        return dataStore;
    }

    protected DataStore createSearchableDataStore() {
        try {
            JPanel jPanel = new JPanel(new GridLayout(6, 1));
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            JPanel jPanel3 = new JPanel(new FlowLayout(0));
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            JPanel jPanel5 = new JPanel(new FlowLayout(0));
            JPanel jPanel6 = new JPanel(new FlowLayout(0));
            JPanel jPanel7 = new JPanel(new FlowLayout(0));
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            jPanel.add(jPanel5);
            jPanel.add(jPanel6);
            jPanel.add(jPanel7);
            jPanel2.add(new JLabel("DataStore Location:"));
            jPanel3.add(new JLabel("Index Location:"));
            jPanel4.add(new JLabel("Input Annotation Set Name:"));
            jPanel5.add(new JLabel("Base Token Annotation Type:"));
            jPanel6.add(new JLabel("Index Unit Annotation Type:"));
            jPanel7.add(new JLabel("Features To Exclude:"));
            final JTextField jTextField = new JTextField("", 25);
            final JTextField jTextField2 = new JTextField("", 25);
            JTextField jTextField3 = new JTextField("Token", 25);
            JTextField jTextField4 = new JTextField("Sentence", 25);
            JTextField jTextField5 = new JTextField("Key", 25);
            JTextField jTextField6 = new JTextField("SpaceToken;Split;Person.matches", 25);
            jPanel2.add(jTextField);
            jPanel3.add(jTextField2);
            jPanel4.add(jTextField5);
            jPanel5.add(jTextField3);
            jPanel6.add(jTextField4);
            jPanel7.add(jTextField6);
            JButton jButton = new JButton("Browse");
            JButton jButton2 = new JButton("Browse");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    fileChooser.setDialogTitle("Please create a new empty directory for datastore");
                    fileChooser.setFileSelectionMode(1);
                    if (fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        try {
                            jTextField.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (Exception exception) {
                            jTextField.setText("");
                        }
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    fileChooser.setDialogTitle("Please create a new empty directory for datastore");
                    fileChooser.setFileSelectionMode(1);
                    if (fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        try {
                            jTextField2.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (Exception exception) {
                            jTextField2.setText("");
                        }
                    }
                }
            });
            jPanel2.add(jButton);
            jPanel3.add(jButton2);
            int n = JOptionPane.showOptionDialog(MainFrame.getInstance(), jPanel, "SearchableDataStore", -1, 2, null, new String[]{"OK", "Cancel"}, "OK");
            if (n == 0) {
                Object object;
                DataStore dataStore = Factory.createDataStore("gate.persist.LuceneDataStoreImpl", jTextField.getText());
                Class[] classArray = new Class[]{URL.class};
                Constructor<?> constructor = Class.forName("gate.creole.annic.lucene.LuceneIndexer", true, Gate.getClassLoader()).getConstructor(classArray);
                Object obj = constructor.newInstance(new URL(jTextField2.getText()));
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("INDEX_LOCATION_URL", new URL(jTextField2.getText()));
                hashMap.put("BASE_TOKEN_ANNOTATION_TYPE", jTextField3.getText());
                hashMap.put("INDEX_UNIT_ANNOTATION_TYPE", jTextField4.getText());
                hashMap.put("FEATURES_TO_EXCLUDE", new ArrayList());
                hashMap.put("ANNOTATION_SET_NAME", jTextField5.getText());
                String[] stringArray = jTextField6.getText().split(";");
                if (stringArray != null && stringArray.length > 0) {
                    object = new ArrayList();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ((ArrayList)object).add(stringArray[i]);
                    }
                    hashMap.put("FEATURES_TO_EXCLUDE", object);
                }
                object = new Class[]{Class.forName("gate.creole.annic.Indexer", true, Gate.getClassLoader()), Map.class};
                Method method = dataStore.getClass().getMethod("setIndexer", (Class<?>)object);
                method.invoke((Object)dataStore, obj, hashMap);
                Constructor<?> constructor2 = Class.forName("gate.creole.annic.lucene.LuceneSearcher", true, Gate.getClassLoader()).getConstructor(new Class[0]);
                Object obj2 = constructor2.newInstance(new Object[0]);
                Class[] classArray2 = new Class[]{Class.forName("gate.creole.annic.Searcher", true, Gate.getClassLoader())};
                Method method2 = dataStore.getClass().getMethod("setSearcher", classArray2);
                method2.invoke((Object)dataStore, obj2);
                return dataStore;
            }
            return null;
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    protected DataStore openSearchableDataStore() {
        DataStore dataStore = null;
        fileChooser.setDialogTitle("Select the datastore directory");
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                URL uRL = fileChooser.getSelectedFile().toURI().toURL();
                dataStore = Factory.openDataStore("gate.persist.LuceneDataStoreImpl", uRL.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, "Invalid location for the datastore\n " + malformedURLException.toString(), "GATE", 0);
            }
            catch (PersistenceException persistenceException) {
                JOptionPane.showMessageDialog(this, "Datastore opening error!\n " + persistenceException.toString(), "GATE", 0);
            }
        }
        return dataStore;
    }

    static {
        iconByName = new HashMap();
        listeners = new HashMap();
        guiRoots = new ArrayList();
        ICON_EXTENSIONS = new String[]{"", ".png", ".gif"};
        guiLock = null;
    }

    class NewGazetteerEditorAction
    extends AbstractAction {
        public NewGazetteerEditorAction() {
            super("Gazetteer Editor", MainFrame.getIcon("gazetteer"));
            this.putValue("ShortDescription", "Start the Gazetteer Editor");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Gaze gaze = new Gaze();
            try {
                JFrame jFrame = new JFrame();
                gaze.init();
                jFrame.setTitle("Gazetteer Editor");
                jFrame.getContentPane().add(gaze);
                HashSet<LanguageResource> hashSet = new HashSet<LanguageResource>(Gate.getCreoleRegister().getLrInstances("gate.creole.gazetteer.DefaultGazetteer"));
                if (hashSet == null || hashSet.isEmpty()) {
                    return;
                }
                for (Gazetteer gazetteer : hashSet) {
                    if (!gazetteer.getListsURL().toString().endsWith(System.getProperty("gate.slug.gazetteer"))) continue;
                    gaze.setTarget(gazetteer);
                }
                jFrame.setSize(700, 500);
                jFrame.setLocation(300, 200);
                jFrame.setVisible(true);
                gaze.setVisible(true);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                resourceInstantiationException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class LocaleSelectorMenuItem
    extends JRadioButtonMenuItem {
        Locale myLocale;
        JRadioButtonMenuItem me;

        public LocaleSelectorMenuItem(Locale locale) {
            super(locale.getDisplayName());
            this.me = this;
            this.myLocale = locale;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (Object e : MainFrame.getGuiRoots()) {
                        if (!(e instanceof Window)) continue;
                        LocaleSelectorMenuItem.this.me.setSelected(((Window)e).getInputContext().selectInputMethod(LocaleSelectorMenuItem.this.myLocale));
                    }
                }
            });
        }

        public LocaleSelectorMenuItem() {
            super("System default  >>" + Locale.getDefault().getDisplayName() + "<<");
            this.me = this;
            this.myLocale = Locale.getDefault();
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (Object e : MainFrame.getGuiRoots()) {
                        if (!(e instanceof Window)) continue;
                        LocaleSelectorMenuItem.this.me.setSelected(((Window)e).getInputContext().selectInputMethod(LocaleSelectorMenuItem.this.myLocale));
                    }
                }
            });
        }
    }

    class CartoonMinder
    implements Runnable {
        boolean dying = false;
        boolean active = false;
        String lock = "lock";
        JPanel targetPanel;
        JLabel imageLabel;

        CartoonMinder(JPanel jPanel) {
            this.targetPanel = jPanel;
            this.imageLabel = new JLabel(MainFrame.getIcon("working"));
            this.imageLabel.setOpaque(false);
            this.imageLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            boolean bl;
            String string = this.lock;
            synchronized (string) {
                bl = this.active;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activate() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CartoonMinder.this.targetPanel.add(CartoonMinder.this.imageLabel);
                }
            });
            String string = this.lock;
            synchronized (string) {
                this.active = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivate() {
            String string = this.lock;
            synchronized (string) {
                this.active = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CartoonMinder.this.targetPanel.removeAll();
                    CartoonMinder.this.targetPanel.repaint();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            String string = this.lock;
            synchronized (string) {
                this.dying = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            String string = this.lock;
            synchronized (string) {
                bl = this.dying;
            }
            while (!bl) {
                boolean bl2;
                String string2 = this.lock;
                synchronized (string2) {
                    bl2 = this.active;
                }
                if (bl2 && this.targetPanel.isVisible()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CartoonMinder.this.targetPanel.getParent().getParent().invalidate();
                            CartoonMinder.this.targetPanel.getParent().getParent().repaint();
                        }
                    });
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                string2 = this.lock;
                synchronized (string2) {
                    bl = this.dying;
                }
            }
        }
    }

    class StatusBarUpdater
    implements Runnable {
        String text;

        StatusBarUpdater(String string) {
            this.text = string;
        }

        public void run() {
            MainFrame.this.statusBar.setText(this.text);
        }
    }

    class ProgressBarUpdater
    implements Runnable {
        int value;

        ProgressBarUpdater(int n) {
            this.value = n;
        }

        public void run() {
            if (this.value == 0) {
                MainFrame.this.progressBar.setVisible(false);
            } else {
                MainFrame.this.progressBar.setVisible(true);
            }
            MainFrame.this.progressBar.setValue(this.value);
        }
    }

    public static class GateFileChooser
    extends JFileChooser {
        public int showDialog(Component component, String string) throws HeadlessException {
            if (component == null) {
                return super.showDialog(MainFrame.getInstance(), string);
            }
            return super.showDialog(component, string);
        }
    }

    protected class ResourcesTreeModel
    extends DefaultTreeModel {
        ResourcesTreeModel(TreeNode treeNode, boolean bl) {
            super(treeNode, bl);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object3 = defaultMutableTreeNode.getUserObject();
            if (object3 instanceof Handle && (object2 = ((Handle)object3).getTarget()) instanceof Resource) {
                Gate.getCreoleRegister().setResourceName((Resource)object2, (String)object);
            }
            this.nodeChanged(defaultMutableTreeNode);
        }
    }

    protected class ResourcesTreeCellEditor
    extends DefaultTreeCellEditor {
        ResourcesTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        protected void startEditingTimer() {
            if (this.timer == null) {
                this.timer = new Timer(500, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Component component = super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
            if (this.renderer != null) {
                this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, false);
                this.editingIcon = this.renderer.getIcon();
            }
            return component;
        }
    }

    protected class ResourcesTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public ResourcesTreeCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object == MainFrame.this.resourcesTreeRoot) {
                this.setIcon(MainFrame.getIcon("root"));
                this.setToolTipText("GATE");
            } else if (object == MainFrame.this.applicationsRoot) {
                this.setIcon(MainFrame.getIcon("applications"));
                this.setToolTipText("GATE applications");
            } else if (object == MainFrame.this.languageResourcesRoot) {
                this.setIcon(MainFrame.getIcon("lrs"));
                this.setToolTipText("Language Resources");
            } else if (object == MainFrame.this.processingResourcesRoot) {
                this.setIcon(MainFrame.getIcon("prs"));
                this.setToolTipText("Processing Resources");
            } else if (object == MainFrame.this.datastoresRoot) {
                this.setIcon(MainFrame.getIcon("datastores"));
                this.setToolTipText("GATE Datastores");
            } else if ((object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof Handle) {
                this.setIcon(((Handle)object).getIcon());
                this.setText(((Handle)object).getTitle());
                this.setToolTipText(((Handle)object).getTooltipText());
            }
            return this;
        }

        public Component getTreeCellRendererComponent1(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, this.selected, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 != null && object2 instanceof Handle) {
                this.setIcon(((Handle)object2).getIcon());
                this.setText(((Handle)object2).getTitle());
                this.setToolTipText(((Handle)object2).getTooltipText());
            }
            return this;
        }
    }

    class HelpUserGuideAction
    extends AbstractAction {
        public HelpUserGuideAction() {
            super("User Guide");
            this.putValue("ShortDescription", "This option needs an internet connection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        HelpFrame helpFrame = new HelpFrame();
                        helpFrame.setPage(new URL("http://www.gate.ac.uk/sale/tao/index.html"));
                        helpFrame.setSize(800, 600);
                        Dimension dimension = helpFrame.getSize();
                        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                        Point point = new Point(0, 0);
                        helpFrame.setLocation(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2);
                        helpFrame.setVisible(true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(Err.getPrintWriter());
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        public HelpAboutAction() {
            super("About");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.splash.showSplash();
        }
    }

    class ResourceToolTip
    extends JToolTip {
        JLabel iconLabel;
        JLabel textLabel;
        JPanel tipComponent;

        public ResourceToolTip() {
            this.setLayout(new BoxLayout(this, 0));
            this.tipComponent = new JPanel();
            this.tipComponent.setOpaque(false);
            this.tipComponent.setLayout(new BoxLayout(this.tipComponent, 0));
            this.tipComponent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.iconLabel = new JLabel(MainFrame.getIcon("annie-application"));
            this.iconLabel.setText(null);
            this.iconLabel.setOpaque(false);
            this.tipComponent.add(this.iconLabel);
            this.textLabel = new JLabel();
            this.textLabel.setOpaque(false);
            this.tipComponent.add(Box.createHorizontalStrut(10));
            this.tipComponent.add(this.textLabel);
            this.add(this.tipComponent);
        }

        public void setTipText(String string) {
        }

        public void setValue(Object object) {
            if (object != null) {
                if (object instanceof String) {
                    this.textLabel.setText((String)object);
                    this.iconLabel.setIcon(null);
                } else if (object instanceof NameBearerHandle) {
                    NameBearerHandle nameBearerHandle = (NameBearerHandle)object;
                    this.textLabel.setText(nameBearerHandle.getTooltipText());
                    this.iconLabel.setIcon(nameBearerHandle.getIcon());
                } else {
                    this.textLabel.setText(null);
                    this.iconLabel.setIcon(null);
                }
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.tipComponent.getPreferredSize();
            Insets insets = this.getInsets();
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
    }

    class ResourcesTree
    extends JTree {
        ResourceToolTip myToolTip;

        public ResourcesTree() {
            this.myToolTip = new ResourceToolTip();
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = super.getToolTipText(mouseEvent);
            if (mouseEvent != null) {
                Point point = mouseEvent.getPoint();
                int n = this.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = this.getPathForRow(n);
                    Object object = treePath.getLastPathComponent();
                    Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                    this.myToolTip.setValue(object2);
                }
            }
            return string;
        }

        public JToolTip createToolTip() {
            return this.myToolTip;
        }
    }

    class LiveMenu
    extends XJMenu {
        protected int type;
        public static final int LR = 1;
        public static final int PR = 2;
        public static final int APP = 3;

        public LiveMenu(int n) {
            this.type = n;
            this.init();
        }

        protected void init() {
            this.addMenuListener(new MenuListener(){

                public void menuCanceled(MenuEvent menuEvent) {
                }

                public void menuDeselected(MenuEvent menuEvent) {
                }

                public void menuSelected(MenuEvent menuEvent) {
                    List<String> list;
                    LiveMenu.this.removeAll();
                    CreoleRegister creoleRegister = Gate.getCreoleRegister();
                    switch (LiveMenu.this.type) {
                        case 1: {
                            list = creoleRegister.getPublicLrTypes();
                            break;
                        }
                        case 2: {
                            list = creoleRegister.getPublicPrTypes();
                            break;
                        }
                        case 3: {
                            list = creoleRegister.getPublicControllerTypes();
                            break;
                        }
                        default: {
                            throw new GateRuntimeException("Unknown LiveMenu type: " + LiveMenu.this.type);
                        }
                    }
                    if (list != null && !list.isEmpty()) {
                        Serializable serializable;
                        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                        Iterator<String> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            serializable = (ResourceData)creoleRegister.get(iterator.next());
                            hashMap.put(((ResourceData)serializable).getName(), serializable);
                        }
                        serializable = new ArrayList(hashMap.keySet());
                        Collections.sort(serializable);
                        iterator = serializable.iterator();
                        while (iterator.hasNext()) {
                            ResourceData resourceData = (ResourceData)hashMap.get(iterator.next());
                            LiveMenu.this.add(new XJMenuItem(new NewResourceAction(resourceData), MainFrame.this));
                        }
                    }
                }
            });
        }
    }

    class OpenDSAction
    extends AbstractAction {
        public OpenDSAction() {
            super("Open datastore");
            this.putValue("ShortDescription", "Open a datastore");
            this.putValue("SmallIcon", MainFrame.getIcon("datastore"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataStoreRegister dataStoreRegister = Gate.getDataStoreRegister();
            Map map = DataStoreRegister.getDataStoreClassNames();
            HashMap hashMap = new HashMap();
            for (Map.Entry objectArray : map.entrySet()) {
                hashMap.put(objectArray.getValue(), objectArray.getKey());
            }
            if (!hashMap.isEmpty()) {
                Object[] objectArray = hashMap.keySet().toArray();
                Object object = JOptionPane.showInputDialog(MainFrame.this, "Select type of Datastore", "GATE", 3, null, objectArray, objectArray[0]);
                if (object != null) {
                    String string = (String)hashMap.get(object);
                    if (string.indexOf("SerialDataStore") != -1) {
                        MainFrame.this.openSerialDataStore();
                    } else if (string.indexOf("LuceneDataStoreImpl") != -1) {
                        MainFrame.this.openSearchableDataStore();
                    } else if (string.indexOf("DocServiceDataStore") != -1) {
                        MainFrame.this.openDocServiceDataStore();
                    } else if (string.equals("gate.persist.OracleDataStore") || string.equals("gate.persist.PostgresDataStore")) {
                        Object object2;
                        String string22;
                        ArrayList arrayList = new ArrayList();
                        for (String string22 : DataStoreRegister.getConfigData().keySet()) {
                            if (!string22.startsWith("url")) continue;
                            arrayList.add(DataStoreRegister.getConfigData().get(string22));
                        }
                        if (arrayList.isEmpty()) {
                            throw new GateRuntimeException("JDBC URL not configured in gate.xml");
                        }
                        string22 = (String)arrayList.get(0);
                        if (arrayList.size() > 1) {
                            object2 = arrayList.toArray();
                            object = JOptionPane.showInputDialog(MainFrame.this, "Select a database", "GATE", 3, null, (Object[])object2, object2[0]);
                            if (object != null) {
                                string22 = (String)object;
                            } else {
                                return;
                            }
                        }
                        object2 = null;
                        AccessController accessController = null;
                        try {
                            Object securityException;
                            accessController = Factory.createAccessController(string22);
                            Assert.assertNotNull((Object)accessController);
                            accessController.open();
                            Session persistenceException = null;
                            User persistenceException2 = null;
                            Group group = null;
                            try {
                                securityException = "";
                                String string3 = "";
                                String string4 = "";
                                JPanel jPanel = new JPanel();
                                jPanel.setLayout(new BoxLayout(jPanel, 0));
                                JPanel jPanel2 = new JPanel();
                                jPanel2.setLayout(new BoxLayout(jPanel2, 1));
                                jPanel2.add(new JLabel("User name: "));
                                jPanel2.add(new JLabel("Password: "));
                                jPanel2.add(new JLabel("Group: "));
                                JPanel jPanel3 = new JPanel();
                                jPanel3.setLayout(new BoxLayout(jPanel3, 1));
                                JTextField jTextField = new JTextField(30);
                                jPanel3.add(jTextField);
                                JPasswordField jPasswordField = new JPasswordField(30);
                                jPanel3.add(jPasswordField);
                                JComboBox<Object> jComboBox = new JComboBox<Object>(accessController.listGroups().toArray());
                                jComboBox.setSelectedIndex(0);
                                jPanel3.add(jComboBox);
                                jPanel.add(jPanel2);
                                jPanel.add(Box.createHorizontalStrut(20));
                                jPanel.add(jPanel3);
                                if (OkCancelDialog.showDialog(MainFrame.this.getContentPane(), jPanel, "Please enter login details")) {
                                    securityException = jTextField.getText();
                                    string3 = new String(jPasswordField.getPassword());
                                    string4 = (String)jComboBox.getSelectedItem();
                                    if (((String)securityException).equals("") || string3.equals("") || string4.equals("")) {
                                        JOptionPane.showMessageDialog(MainFrame.this, "You must provide non-empty user name, password and group!", "Login error", 0);
                                        return;
                                    }
                                } else if (OkCancelDialog.userHasPressedCancel) {
                                    return;
                                }
                                group = accessController.findGroup(string4);
                                persistenceException2 = accessController.findUser((String)securityException);
                                persistenceException = accessController.login((String)securityException, string3, group.getID());
                            }
                            catch (SecurityException securityException2) {
                                JOptionPane.showMessageDialog(MainFrame.this, securityException2.getMessage(), "Login error", 0);
                                accessController.close();
                                return;
                            }
                            if (!accessController.isValidSession(persistenceException)) {
                                JOptionPane.showMessageDialog(MainFrame.this, "Incorrect session obtained. Probably there is a problem with the database!", "Login error", 0);
                                accessController.close();
                                return;
                            }
                            object2 = Factory.openDataStore(string, string22);
                            object2.setSession(persistenceException);
                            securityException = Factory.newFeatureMap();
                            securityException.put("user", persistenceException2);
                            securityException.put("group", group);
                            DataStoreRegister.addSecurityData((DataStore)object2, (Map)securityException);
                        }
                        catch (PersistenceException securityException) {
                            JOptionPane.showMessageDialog(MainFrame.this, "Datastore open error!\n " + securityException.toString(), "GATE", 0);
                        }
                        catch (SecurityException securityException) {
                            JOptionPane.showMessageDialog(MainFrame.this, "User identification error!\n " + securityException.toString(), "GATE", 0);
                            try {
                                if (accessController != null) {
                                    accessController.close();
                                }
                                if (object2 != null) {
                                    object2.close();
                                }
                            }
                            catch (PersistenceException persistenceException) {
                                JOptionPane.showMessageDialog(MainFrame.this, "Persistence error!\n " + persistenceException.toString(), "GATE", 0);
                            }
                        }
                    } else {
                        JOptionPane.showMessageDialog(MainFrame.this, "Support for this type of datastores is not implemenented!\n", "GATE", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(MainFrame.this, "Could not find any registered types of datastores...\nCheck your GATE installation!", "GATE", 0);
            }
        }
    }

    class ExitGateAction
    extends AbstractAction {
        public ExitGateAction() {
            super("Exit GATE");
            this.putValue("ShortDescription", "Closes the application");
            this.putValue("SmallIcon", MainFrame.getIcon("exit"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    List<Resource> list;
                    Serializable serializable;
                    Serializable serializable2;
                    OptionsMap optionsMap = Gate.getUserConfig();
                    if (optionsMap.getBoolean("Save_options_on_exit").booleanValue()) {
                        serializable2 = new Integer(MainFrame.this.getWidth());
                        serializable = new Integer(MainFrame.this.getHeight());
                        optionsMap.put("Main_frame_width", serializable2);
                        optionsMap.put("Main_frame_height", serializable);
                        try {
                            list = fileChooser.getCurrentDirectory();
                            optionsMap.put("Last_filechooser_location", list == null ? "" : ((File)((Object)list)).getCanonicalPath());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            Gate.writeUserConfig();
                        }
                        catch (GateException gateException) {
                            MainFrame.this.logArea.getOriginalErr().println("Failed to save config data:");
                            gateException.printStackTrace(MainFrame.this.logArea.getOriginalErr());
                        }
                    } else {
                        serializable2 = Gate.getOriginalUserConfig();
                        ((OptionsMap)serializable2).put("Save_options_on_exit", new Boolean(false));
                        optionsMap.clear();
                        optionsMap.putAll(serializable2);
                        try {
                            Gate.writeUserConfig();
                        }
                        catch (GateException gateException) {
                            MainFrame.this.logArea.getOriginalErr().println("Failed to save config data:");
                            gateException.printStackTrace(MainFrame.this.logArea.getOriginalErr());
                        }
                    }
                    serializable2 = Gate.getUserSessionFile();
                    if (optionsMap.getBoolean("Save_session_on_exit").booleanValue()) {
                        try {
                            serializable = new ArrayList<Resource>(Gate.getCreoleRegister().getAllInstances("gate.Controller"));
                            list = ((ArrayList)serializable).iterator();
                            while (list.hasNext()) {
                                if (!Gate.getHiddenAttribute(((Controller)list.next()).getFeatures())) continue;
                                list.remove();
                            }
                            PersistenceManager.saveObjectToFile(serializable, (File)serializable2);
                        }
                        catch (Exception exception) {
                            MainFrame.this.logArea.getOriginalErr().println("Failed to save session data:");
                            exception.printStackTrace(MainFrame.this.logArea.getOriginalErr());
                        }
                    } else if (((File)serializable2).exists()) {
                        ((File)serializable2).delete();
                    }
                    System.setErr(MainFrame.this.logArea.getOriginalErr());
                    System.setOut(MainFrame.this.logArea.getOriginalOut());
                    serializable = new ArrayList(MainFrame.getGuiRoots());
                    while (!serializable.isEmpty()) {
                        list = serializable.remove(0);
                        if (!(list instanceof Window)) continue;
                        Window window = (Window)((Object)list);
                        serializable.addAll(Arrays.asList(window.getOwnedWindows()));
                        window.setVisible(false);
                        window.dispose();
                    }
                    try {
                        list = Gate.getCreoleRegister().getAllInstances(Resource.class.getName());
                        for (Resource resource : list) {
                            try {
                                resource.cleanup();
                            }
                            catch (Throwable throwable) {
                                System.err.println(" Some problem cleaning up the resource " + throwable.getMessage());
                            }
                        }
                    }
                    catch (GateException gateException) {
                        // empty catch block
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Shutdown thread");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CloseSelectedResourcesAction
    extends AbstractAction {
        public CloseSelectedResourcesAction() {
            super("Close all");
            this.putValue("ShortDescription", "Closes the selected resources");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    TreePath[] treePathArray = MainFrame.this.resourcesTree.getSelectionPaths();
                    for (int i = 0; i < treePathArray.length; ++i) {
                        Object object = ((DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()).getUserObject();
                        if (!(object instanceof NameBearerHandle)) continue;
                        ((NameBearerHandle)object).getCloseAction().actionPerformed(null);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(1);
            thread.start();
        }
    }

    class RenameResourceAction
    extends AbstractAction {
        TreePath path;

        RenameResourceAction(TreePath treePath) {
            super("Rename");
            this.putValue("ShortDescription", "Renames the resource");
            this.path = treePath;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.resourcesTree.startEditingAtPath(this.path);
        }
    }

    class CloseViewAction
    extends AbstractAction {
        Handle handle;

        public CloseViewAction(Handle handle) {
            super("Hide this view");
            this.putValue("ShortDescription", "Hides this view");
            this.handle = handle;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.mainTabbedPane.remove(this.handle.getLargeView());
            MainFrame.this.mainTabbedPane.setSelectedIndex(MainFrame.this.mainTabbedPane.getTabCount() - 1);
            this.handle.removeViews();
        }
    }

    class LoadResourceFromFileAction
    extends AbstractAction {
        public LoadResourceFromFileAction() {
            super("Restore application from file");
            this.putValue("ShortDescription", "Restores a previously saved application");
            this.putValue("SmallIcon", MainFrame.getIcon("open-application"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    fileChooser.setDialogTitle("Select a file for this resource");
                    fileChooser.setFileSelectionMode(2);
                    if (fileChooser.showOpenDialog(MainFrame.this) == 0) {
                        File file = fileChooser.getSelectedFile();
                        try {
                            PersistenceManager.loadObjectFromFile(file);
                        }
                        catch (ResourceInstantiationException resourceInstantiationException) {
                            MainFrame.this.processFinished();
                            JOptionPane.showMessageDialog(MainFrame.this, "Error!\n" + resourceInstantiationException.toString(), "GATE", 0);
                            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                        }
                        catch (Exception exception) {
                            MainFrame.this.processFinished();
                            JOptionPane.showMessageDialog(MainFrame.this, "Error!\n" + exception.toString(), "GATE", 0);
                            exception.printStackTrace(Err.getPrintWriter());
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(1);
            thread.start();
        }
    }

    class NewDSAction
    extends AbstractAction {
        public NewDSAction() {
            super("Create datastore");
            this.putValue("ShortDescription", "Create a new Datastore");
            this.putValue("SmallIcon", MainFrame.getIcon("datastore"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            DataStoreRegister dataStoreRegister = Gate.getDataStoreRegister();
            Map map = DataStoreRegister.getDataStoreClassNames();
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                hashMap.put(entry.getValue(), entry.getKey());
            }
            if (!hashMap.isEmpty()) {
                Object[] objectArray = hashMap.keySet().toArray();
                Object object = JOptionPane.showInputDialog(MainFrame.this, "Select type of Datastore", "GATE", 3, null, objectArray, objectArray[0]);
                if (object == null) return;
                String string = (String)hashMap.get(object);
                if (string.equals("gate.persist.SerialDataStore")) {
                    MainFrame.this.createSerialDataStore();
                    return;
                } else if (string.equals("gate.persist.LuceneDataStoreImpl")) {
                    MainFrame.this.createSearchableDataStore();
                    return;
                } else {
                    if (!string.equals("gate.persist.OracleDataStore")) throw new UnsupportedOperationException("Unimplemented option!\nUse a serial datastore");
                    JOptionPane.showMessageDialog(MainFrame.this, "Oracle datastores can only be created by your Oracle administrator!", "GATE", 0);
                }
                return;
            } else {
                JOptionPane.showMessageDialog(MainFrame.this, "Could not find any registered types of datastores...\nCheck your GATE installation!", "GATE", 0);
            }
        }
    }

    static class StopAction
    extends AbstractAction {
        public StopAction() {
            super(" Stop! ");
            this.putValue("ShortDescription", "Stops the current action");
        }

        public boolean isEnabled() {
            return Gate.getExecutable() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Executable executable = Gate.getExecutable();
            if (executable != null) {
                executable.interrupt();
            }
        }
    }

    class NewResourceAction
    extends AbstractAction {
        ResourceData rData;

        public NewResourceAction(ResourceData resourceData) {
            super(resourceData.getName());
            this.putValue("ShortDescription", resourceData.getComment());
            this.rData = resourceData;
            this.putValue("SmallIcon", MainFrame.getIcon(resourceData.getIcon()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    MainFrame.this.newResourceDialog.setTitle("Parameters for the new " + NewResourceAction.this.rData.getName());
                    MainFrame.this.newResourceDialog.show(NewResourceAction.this.rData);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    class LoadCreoleRepositoryAction
    extends AbstractAction {
        public LoadCreoleRepositoryAction() {
            super("Load a CREOLE repository");
            this.putValue("ShortDescription", "Load a CREOLE repository");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Box box = Box.createHorizontalBox();
            Box box2 = Box.createVerticalBox();
            JTextField jTextField = new JTextField(20);
            box2.add(new JLabel("Type an URL"));
            box2.add(jTextField);
            box.add(box2);
            box.add(Box.createHorizontalStrut(10));
            box.add(new JLabel("or"));
            box.add(Box.createHorizontalStrut(10));
            Box box3 = Box.createVerticalBox();
            box3.add(new JLabel("Select a directory"));
            class URLfromFileAction
            extends AbstractAction {
                JTextField textField;

                URLfromFileAction(JTextField jTextField) {
                    super(null, MainFrame.getIcon("open-file"));
                    this.putValue("ShortDescription", "Click to select a directory");
                    this.textField = jTextField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    fileChooser.setMultiSelectionEnabled(false);
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                    int n = fileChooser.showOpenDialog(MainFrame.this);
                    if (n == 0) {
                        try {
                            this.textField.setText(fileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new GateRuntimeException(malformedURLException.toString());
                        }
                    }
                }
            }
            JButton jButton = new JButton(new URLfromFileAction(jTextField));
            box3.add(jButton);
            box.add(box3);
            int n = JOptionPane.showConfirmDialog(MainFrame.this, box, "Enter an URL to the directory containig the \"creole.xml\" file", 2, 3, null);
            if (n == 0) {
                try {
                    URL uRL = new URL(jTextField.getText());
                    Gate.getCreoleRegister().registerDirectories(uRL);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(MainFrame.this, "There was a problem with your selection:\n" + exception.toString(), "GATE", 0);
                    exception.printStackTrace(Err.getPrintWriter());
                }
            }
        }
    }

    class ManagePluginsAction
    extends AbstractAction {
        public ManagePluginsAction() {
            super("Manage CREOLE plugins");
            this.putValue("ShortDescription", "Manage CREOLE plugins");
            this.putValue("SmallIcon", MainFrame.getIcon("creole-plugins"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.pluginManager == null) {
                MainFrame.this.pluginManager = new PluginManagerUI(MainFrame.this);
                MainFrame.this.pluginManager.setModal(true);
                MainFrame.getGuiRoots().add(MainFrame.this.pluginManager);
                MainFrame.this.pluginManager.pack();
                Dimension dimension = MainFrame.this.getGraphicsConfiguration().getBounds().getSize();
                Dimension dimension2 = MainFrame.this.pluginManager.getPreferredSize();
                int n = dimension2.width > dimension.width ? dimension.width * 3 / 4 : dimension2.width;
                int n2 = dimension2.height > dimension.height ? dimension.height * 3 / 4 : dimension2.height;
                MainFrame.this.pluginManager.setSize(n, n2);
                MainFrame.this.pluginManager.validate();
                int n3 = (dimension.width - n) / 2;
                int n4 = (dimension.height - n2) / 2;
                MainFrame.this.pluginManager.setLocation(n3, n4);
            }
            MainFrame.this.pluginManager.setVisible(true);
            MainFrame.this.pluginManager.dispose();
        }
    }

    class NewBootStrapAction
    extends AbstractAction {
        public NewBootStrapAction() {
            super("BootStrap Wizard", MainFrame.getIcon("application"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BootStrapDialog bootStrapDialog = new BootStrapDialog(MainFrame.this);
            bootStrapDialog.setVisible(true);
        }
    }

    class LoadANNIEWithoutDefaultsAction1
    extends AbstractAction
    implements ANNIEConstants {
        public LoadANNIEWithoutDefaultsAction1() {
            super("Without defaults");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreoleRegister creoleRegister = Gate.getCreoleRegister();
            for (int i = 0; i < PR_NAMES.length; ++i) {
                ResourceData resourceData = (ResourceData)creoleRegister.get(PR_NAMES[i]);
                if (resourceData != null) {
                    NewResourceDialog newResourceDialog = new NewResourceDialog(MainFrame.this, "Resource parameters", true);
                    newResourceDialog.setTitle("Parameters for the new " + resourceData.getName());
                    newResourceDialog.show(resourceData);
                    continue;
                }
                Err.prln(PR_NAMES[i] + " not found in Creole register");
            }
            try {
                Factory.createResource("gate.creole.SerialAnalyserController", Factory.newFeatureMap(), Factory.newFeatureMap(), "ANNIE_" + Gate.genSym());
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                resourceInstantiationException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class LoadANNIEWithoutDefaultsAction
    extends AbstractAction
    implements ANNIEConstants {
        public LoadANNIEWithoutDefaultsAction() {
            super("Without defaults");
            this.putValue("ShortDescription", "Load ANNIE system without defaults");
            this.putValue("SmallIcon", MainFrame.getIcon("annie-application"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    FeatureMap featureMap = Factory.newFeatureMap();
                    try {
                        SerialAnalyserController serialAnalyserController = (SerialAnalyserController)Factory.createResource("gate.creole.SerialAnalyserController", Factory.newFeatureMap(), Factory.newFeatureMap(), "ANNIE_" + Gate.genSym());
                        for (int i = 0; i < ANNIEConstants.PR_NAMES.length; ++i) {
                            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(ANNIEConstants.PR_NAMES[i]);
                            if (!MainFrame.this.newResourceDialog.show(resourceData, "Parameters for the new " + resourceData.getName())) {
                                MainFrame.this.statusChanged("Loading cancelled! Removing traces...");
                                Iterator iterator = new ArrayList(serialAnalyserController.getPRs()).iterator();
                                while (iterator.hasNext()) {
                                    Factory.deleteResource((ProcessingResource)iterator.next());
                                }
                                Factory.deleteResource(serialAnalyserController);
                                MainFrame.this.statusChanged("Loading cancelled!");
                                return;
                            }
                            serialAnalyserController.add((ProcessingResource)Factory.createResource(ANNIEConstants.PR_NAMES[i], MainFrame.this.newResourceDialog.getSelectedParameters()));
                        }
                        MainFrame.this.statusChanged("ANNIE loaded!");
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    class LoadANNIEWithDefaultsAction
    extends AbstractAction
    implements ANNIEConstants {
        public LoadANNIEWithDefaultsAction() {
            super("With defaults");
            this.putValue("ShortDescription", "Load ANNIE system using defaults");
            this.putValue("SmallIcon", MainFrame.getIcon("annie-application"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    long l = System.currentTimeMillis();
                    FeatureMap featureMap = Factory.newFeatureMap();
                    try {
                        MainFrame.lockGUI("ANNIE is being loaded...");
                        SerialAnalyserController serialAnalyserController = (SerialAnalyserController)Factory.createResource("gate.creole.SerialAnalyserController", Factory.newFeatureMap(), Factory.newFeatureMap(), "ANNIE_" + Gate.genSym());
                        for (int i = 0; i < ANNIEConstants.PR_NAMES.length; ++i) {
                            ProcessingResource processingResource = (ProcessingResource)Factory.createResource(ANNIEConstants.PR_NAMES[i], featureMap);
                            serialAnalyserController.add(processingResource);
                        }
                        long l2 = System.currentTimeMillis();
                        MainFrame.this.statusChanged("ANNIE loaded in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }

    class VerboseModeCorpusEvalToolAction
    extends AbstractAction {
        protected boolean verboseMode;

        public VerboseModeCorpusEvalToolAction() {
            super("Verbose mode");
            this.verboseMode = false;
            this.putValue("ShortDescription", "Run the Benchmark Tool in verbose mode");
        }

        public boolean isVerboseMode() {
            return this.verboseMode;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(actionEvent.getSource() instanceof JCheckBoxMenuItem)) {
                return;
            }
            this.verboseMode = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
        }
    }

    class GenerateStoredCorpusEvalAction
    extends AbstractAction {
        public GenerateStoredCorpusEvalAction() {
            super("Store corpus for future evaluation");
            this.putValue("ShortDescription", "Run the Benchmark Tool -generate");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    JFileChooser jFileChooser = MainFrame.getFileChooser();
                    jFileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setMultiSelectionEnabled(false);
                    int n = jFileChooser.showOpenDialog(MainFrame.this);
                    File file = jFileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    jFileChooser.setDialogTitle("Please select the application that you want to run");
                    jFileChooser.setFileSelectionMode(0);
                    n = jFileChooser.showOpenDialog(MainFrame.this);
                    File file2 = jFileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
                    corpusBenchmarkTool.setStartDirectory(file);
                    corpusBenchmarkTool.setApplicationFile(file2);
                    corpusBenchmarkTool.setGenerateMode(true);
                    Out.prln("Processing and storing documents for future evaluation.");
                    corpusBenchmarkTool.init();
                    corpusBenchmarkTool.execute();
                    corpusBenchmarkTool.unloadPRs();
                    Out.prln("Finished!");
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Eval thread");
            thread.setPriority(1);
            thread.start();
        }
    }

    class CleanMarkedCorpusEvalAction
    extends AbstractAction {
        public CleanMarkedCorpusEvalAction() {
            super("Human marked against current processing results");
            this.putValue("ShortDescription", "Run the Benchmark Tool -marked_clean");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    JFileChooser jFileChooser = MainFrame.getFileChooser();
                    jFileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setMultiSelectionEnabled(false);
                    int n = jFileChooser.showOpenDialog(MainFrame.this);
                    File file = jFileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    jFileChooser.setDialogTitle("Please select the application that you want to run");
                    jFileChooser.setFileSelectionMode(0);
                    n = jFileChooser.showOpenDialog(MainFrame.this);
                    File file2 = jFileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
                    corpusBenchmarkTool.setStartDirectory(file);
                    corpusBenchmarkTool.setApplicationFile(file2);
                    corpusBenchmarkTool.setMarkedClean(true);
                    corpusBenchmarkTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Evaluating human-marked documents against current processing results.");
                    corpusBenchmarkTool.init();
                    corpusBenchmarkTool.execute();
                    corpusBenchmarkTool.printStatistics();
                    Out.prln("Overall average precision: " + corpusBenchmarkTool.getPrecisionAverage());
                    Out.prln("Overall average recall: " + corpusBenchmarkTool.getRecallAverage());
                    Out.prln("Overall average fMeasure : " + corpusBenchmarkTool.getFMeasureAverage());
                    Out.prln("Finished!");
                    corpusBenchmarkTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Eval thread");
            thread.setPriority(1);
            thread.start();
        }
    }

    class StoredMarkedCorpusEvalAction
    extends AbstractAction {
        public StoredMarkedCorpusEvalAction() {
            super("Human marked against stored processing results");
            this.putValue("ShortDescription", "Run the Benchmark Tool -stored_clean");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    JFileChooser jFileChooser = MainFrame.getFileChooser();
                    jFileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setMultiSelectionEnabled(false);
                    int n = jFileChooser.showOpenDialog(MainFrame.this);
                    File file = jFileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
                    corpusBenchmarkTool.setStartDirectory(file);
                    corpusBenchmarkTool.setMarkedStored(true);
                    corpusBenchmarkTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Evaluating human-marked documents against pre-stored results.");
                    corpusBenchmarkTool.init();
                    corpusBenchmarkTool.execute();
                    corpusBenchmarkTool.printStatistics();
                    Out.prln("<BR>Overall average precision: " + corpusBenchmarkTool.getPrecisionAverage());
                    Out.prln("<BR>Overall average recall: " + corpusBenchmarkTool.getRecallAverage());
                    Out.prln("<BR>Overall average fMeasure : " + corpusBenchmarkTool.getFMeasureAverage());
                    Out.prln("<BR>Finished!");
                    corpusBenchmarkTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Eval thread");
            thread.setPriority(1);
            thread.start();
        }
    }

    class NewCorpusEvalAction
    extends AbstractAction {
        public NewCorpusEvalAction() {
            super("Default mode");
            this.putValue("ShortDescription", "Run the Benchmark Tool in its default mode");
            this.putValue("SmallIcon", MainFrame.getIcon("corpus-benchmark"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    JFileChooser jFileChooser = MainFrame.getFileChooser();
                    jFileChooser.setDialogTitle("Please select a directory which contains the documents to be evaluated");
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setMultiSelectionEnabled(false);
                    int n = jFileChooser.showOpenDialog(MainFrame.this);
                    File file = jFileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    jFileChooser.setDialogTitle("Please select the application that you want to run");
                    jFileChooser.setFileSelectionMode(0);
                    n = jFileChooser.showOpenDialog(MainFrame.this);
                    File file2 = jFileChooser.getSelectedFile();
                    if (n == 1 || file == null) {
                        return;
                    }
                    CorpusBenchmarkTool corpusBenchmarkTool = new CorpusBenchmarkTool();
                    corpusBenchmarkTool.setStartDirectory(file);
                    corpusBenchmarkTool.setApplicationFile(file2);
                    corpusBenchmarkTool.setVerboseMode(MainFrame.this.verboseModeItem.isSelected());
                    Out.prln("Please wait while GATE tools are initialised.");
                    corpusBenchmarkTool.init();
                    corpusBenchmarkTool.execute();
                    corpusBenchmarkTool.printStatistics();
                    Out.prln("<BR>Overall average precision: " + corpusBenchmarkTool.getPrecisionAverage());
                    Out.prln("<BR>Overall average recall: " + corpusBenchmarkTool.getRecallAverage());
                    Out.prln("<BR>Overall average fMeasure : " + corpusBenchmarkTool.getFMeasureAverage());
                    Out.prln("<BR>Finished!");
                    corpusBenchmarkTool.unloadPRs();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Eval thread");
            thread.setPriority(1);
            thread.start();
        }
    }

    class NewAnnotDiffAction
    extends AbstractAction {
        public NewAnnotDiffAction() {
            super("Annotation Diff", MainFrame.getIcon("annotation-diff"));
            this.putValue("ShortDescription", "Open a new Annotation Diff window");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationDiffGUI annotationDiffGUI = new AnnotationDiffGUI("Annotation Diff Tool");
            annotationDiffGUI.pack();
            try {
                annotationDiffGUI.setIconImage(((ImageIcon)MainFrame.getIcon("annotation-diff")).getImage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            annotationDiffGUI.setLocationRelativeTo(MainFrame.this);
            annotationDiffGUI.setVisible(true);
        }
    }
}

