/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Corpus;
import gate.Main;
import gate.Resource;
import gate.corpora.SerialCorpusImpl;
import gate.creole.AbstractVisualResource;
import gate.creole.annic.Hit;
import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import gate.creole.annic.Searcher;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.event.ProgressListener;
import gate.gui.MainFrame;
import gate.persist.LuceneDataStoreImpl;
import gate.persist.PersistenceException;
import gate.swing.ColorGenerator;
import gate.swing.XJTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class LuceneDataStoreSearchGUI
extends AbstractVisualResource
implements ProgressListener,
ActionListener,
DatastoreListener {
    private static final long serialVersionUID = 3256720688877285686L;
    private int firstColumnWidth = 0;
    private LuceneDataStoreImpl target;
    private ArrayList<Hit> patterns;
    private Map<String, ArrayList<String>> annotTypes;
    private XJTable patternTable;
    private PatternsTableModel patternsTableModel;
    private JComboBox annotTypesBox = new JComboBox();
    private JComboBox featuresBox = new JComboBox();
    private String previousChoice = "";
    private JButton addAnnotTypeButton;
    private JButton nextResults;
    private JButton executeQuery;
    private JButton clearQueryTF;
    private JButton exportToHTML;
    private ButtonGroup exportButtonsGroup;
    private ButtonGroup patternExportButtonsGroup;
    private JRadioButton allPatterns;
    private JRadioButton selectedPatterns;
    private boolean explicitCall;
    private JTextField newQuery;
    private JComboBox corpusToSearchIn;
    private ArrayList corpusIds;
    private JTextField noOfPatternsField;
    private JTextField contextWindowField;
    private JLabel queryToExecute;
    private JLabel totalFoundPatterns;
    private JPanel comboPanel;
    private JPanel guiPanel;
    private HashMap addedAnnotTypes;
    private ArrayList<String> addedAnnotTypesInGUI;
    private ArrayList<String> addedAnnotFeatureInGUI;
    private GridBagConstraints guiCons;
    private ArrayList<PatternRow> currentPatternRows;
    private JPanel titleTextPanel;
    ColorGenerator colorGenerator = new ColorGenerator();
    ExecuteQueryAction execQueryAction;
    NextResultAction nextResultAction;
    ClearQueryAction clearQueryAction;
    ExportResultsAction exportResultsAction;
    JTextField patText;
    LuceneDataStoreSearchGUI thisInstance;

    public Resource init() {
        this.patterns = new ArrayList();
        this.annotTypes = new HashMap<String, ArrayList<String>>();
        this.addedAnnotTypes = new HashMap();
        this.addedAnnotTypesInGUI = new ArrayList();
        this.addedAnnotFeatureInGUI = new ArrayList();
        this.thisInstance = this;
        this.corpusIds = new ArrayList();
        this.initGui();
        if (this.target != null) {
            this.initLocalData();
            this.updateGui();
            this.patternsTableModel.fireTableDataChanged();
            if (this.patternTable.getRowCount() > 0) {
                this.patternTable.setRowSelectionInterval(0, 0);
                this.tableValueChanged();
            }
        }
        this.validate();
        return this;
    }

    protected void updateDisplay() {
        this.patterns.clear();
        this.annotTypes.clear();
        this.addedAnnotTypes.clear();
        this.addedAnnotTypesInGUI.clear();
        this.addedAnnotFeatureInGUI.clear();
        if (this.target != null) {
            this.initLocalData();
            this.updateGui();
            this.patternsTableModel.fireTableDataChanged();
            if (this.patternTable.getRowCount() > 0) {
                this.patternTable.setRowSelectionInterval(0, 0);
                this.tableValueChanged();
            }
            this.totalFoundPatterns.setText("Total Found Patterns : " + this.patternTable.getRowCount());
            this.totalFoundPatterns.updateUI();
        }
    }

    protected void initGui() {
        this.guiCons = new GridBagConstraints();
        this.guiCons.fill = 2;
        this.guiCons.anchor = 23;
        this.comboPanel = new JPanel(new FlowLayout(0));
        this.guiPanel = new JPanel();
        this.guiPanel.setLayout(new GridBagLayout());
        this.guiPanel.setOpaque(true);
        this.guiPanel.setBackground(Color.WHITE);
        this.execQueryAction = new ExecuteQueryAction();
        this.executeQuery = new JButton(this.execQueryAction);
        this.nextResultAction = new NextResultAction();
        this.nextResults = new JButton(this.nextResultAction);
        this.clearQueryAction = new ClearQueryAction();
        this.clearQueryTF = new JButton(this.clearQueryAction);
        this.newQuery = new JTextField(20);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Entire DataStore");
        this.corpusToSearchIn = new JComboBox(defaultComboBoxModel);
        this.corpusToSearchIn.setPrototypeDisplayValue("Entire DataStore   ");
        this.corpusToSearchIn.setToolTipText("Corpus Name");
        this.executeQuery.setEnabled(true);
        this.nextResults.setEnabled(true);
        this.clearQueryTF.setEnabled(true);
        this.newQuery.setEnabled(true);
        this.noOfPatternsField = new JTextField("50", 3);
        this.noOfPatternsField.setToolTipText("Number of Patterns to retrieve");
        this.contextWindowField = new JTextField("5", 2);
        this.contextWindowField.setToolTipText("Number of Tokens to be displayed in context");
        this.noOfPatternsField.setEnabled(true);
        this.contextWindowField.setEnabled(true);
        this.queryToExecute = new JLabel("New Query : ");
        this.totalFoundPatterns = new JLabel("Total Found Patterns : 0        ");
        this.exportResultsAction = new ExportResultsAction();
        this.exportToHTML = new JButton(this.exportResultsAction);
        this.exportButtonsGroup = new ButtonGroup();
        this.patternExportButtonsGroup = new ButtonGroup();
        this.exportButtonsGroup.add(this.exportToHTML);
        this.exportToHTML.setEnabled(false);
        this.allPatterns = new JRadioButton("All Patterns");
        this.selectedPatterns = new JRadioButton("Selected Patterns");
        this.patternExportButtonsGroup.add(this.allPatterns);
        this.patternExportButtonsGroup.add(this.selectedPatterns);
        this.allPatterns.setToolTipText("re-issues the previous query and export all patterns without any limit on number of documents");
        this.selectedPatterns.setToolTipText("exports only the selected patterns");
        this.allPatterns.setSelected(true);
        this.allPatterns.setEnabled(false);
        this.selectedPatterns.setSelected(false);
        this.selectedPatterns.setEnabled(false);
        this.annotTypesBox = new JComboBox();
        this.annotTypesBox.addActionListener(this);
        this.featuresBox = new JComboBox();
        this.addAnnotTypeButton = new JButton(new AddAnnotTypeAction());
        this.comboPanel.add(new JLabel("Annotation Types : "));
        this.comboPanel.add(this.annotTypesBox);
        this.comboPanel.add(new JLabel("Features : "));
        this.comboPanel.add(this.featuresBox);
        this.comboPanel.add(this.addAnnotTypeButton);
        this.patternsTableModel = new PatternsTableModel();
        this.patternTable = new XJTable(this.patternsTableModel);
        this.patternTable.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = LuceneDataStoreSearchGUI.this.patternTable.rowAtPoint(mouseEvent.getPoint());
                n = LuceneDataStoreSearchGUI.this.patternTable.rowViewToModel(n);
                Pattern pattern = null;
                if (n > -1) {
                    pattern = (Pattern)LuceneDataStoreSearchGUI.this.patterns.get(n);
                    LuceneDataStoreSearchGUI.this.patternTable.setToolTipText(pattern.getQueryString());
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        this.patternTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    final JPopupMenu jPopupMenu = new JPopupMenu();
                    JButton jButton = new JButton("Delete");
                    jPopupMenu.add(jButton);
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n;
                            int[] nArray = LuceneDataStoreSearchGUI.this.patternTable.getSelectedRows();
                            for (n = 0; n < nArray.length; ++n) {
                                nArray[n] = LuceneDataStoreSearchGUI.this.patternTable.rowViewToModel(nArray[n]);
                            }
                            nArray = LuceneDataStoreSearchGUI.this.sort(nArray);
                            for (n = nArray.length - 1; n >= 0; --n) {
                                LuceneDataStoreSearchGUI.this.patterns.remove(nArray[n]);
                            }
                            LuceneDataStoreSearchGUI.this.patternsTableModel.fireTableDataChanged();
                            LuceneDataStoreSearchGUI.this.totalFoundPatterns.setText("Total Found Patterns : " + LuceneDataStoreSearchGUI.this.patternTable.getRowCount());
                            LuceneDataStoreSearchGUI.this.tableValueChanged();
                            jPopupMenu.setVisible(false);
                        }
                    });
                    jPopupMenu.show(LuceneDataStoreSearchGUI.this.patternTable, mouseEvent.getX(), mouseEvent.getY() - 10);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.patternTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LuceneDataStoreSearchGUI.this.tableValueChanged();
            }
        });
        this.patternTable.setSelectionMode(2);
        this.patternTable.setSortable(true);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.queryToExecute);
        jPanel2.add(this.newQuery);
        jPanel2.add(this.corpusToSearchIn);
        jPanel2.add(this.noOfPatternsField);
        jPanel2.add(this.contextWindowField);
        jPanel2.add(this.clearQueryTF);
        jPanel2.add(this.executeQuery);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.totalFoundPatterns);
        jPanel3.add(this.nextResults);
        jPanel3.add(this.exportToHTML);
        jPanel3.add(this.allPatterns);
        jPanel3.add(this.selectedPatterns);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(this.comboPanel);
        this.add((Component)jPanel, "North");
        this.titleTextPanel = new JPanel(new BorderLayout());
        this.titleTextPanel.setOpaque(true);
        this.titleTextPanel.setBackground(Color.WHITE);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerLocation(300);
        jSplitPane.add(new JScrollPane(this.guiPanel, 20, 30));
        jSplitPane.add(new JScrollPane(this.patternTable));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jSplitPane, "Center");
        this.add((Component)jPanel4, "Center");
    }

    private int[] sort(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length - 1; ++j) {
                if (nArray[j] <= nArray[j + 1]) continue;
                int n = nArray[j];
                nArray[j] = nArray[j + 1];
                nArray[j + 1] = n;
            }
        }
        return nArray;
    }

    public void tableValueChanged() {
        int n;
        Object object;
        int n2;
        this.firstColumnWidth = 0;
        int n3 = this.patternTable.getSelectedRow();
        if (n3 == -1) {
            VariableWidthJLabel variableWidthJLabel = new VariableWidthJLabel("Pattern Text : ");
            int n4 = variableWidthJLabel.getOriginalPreferredSize().width;
            if (n4 > this.firstColumnWidth) {
                this.firstColumnWidth = n4;
            }
            this.titleTextPanel.removeAll();
            this.titleTextPanel.add((Component)variableWidthJLabel, "West");
            this.patText = new JTextField("<No Pattern Found>", 15);
            this.patText.setEditable(false);
            this.patText.setOpaque(false);
            this.patText.setBorder(null);
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setOpaque(false);
            jPanel.add(this.patText);
            this.titleTextPanel.add((Component)jPanel, "Center");
            this.titleTextPanel.validate();
            this.addAnnotTypeButton.setEnabled(false);
            this.annotTypesBox.setEnabled(false);
            this.featuresBox.setEnabled(false);
            this.guiCons.gridheight = 1;
            this.guiCons.gridx = 0;
            this.guiCons.gridy = 0;
            this.guiCons.weighty = 0.0;
            this.guiCons.weightx = 1.0;
            this.guiCons.fill = 2;
            this.guiCons.insets = new Insets(0, 0, 0, 0);
            if (this.guiPanel.getComponentCount() > 0) {
                this.guiPanel.removeAll();
                this.guiPanel.add((Component)this.titleTextPanel, this.guiCons);
                this.guiCons.weighty = 1.0;
                this.guiCons.fill = 1;
                this.guiPanel.add(Box.createVerticalGlue(), this.guiCons);
                this.guiPanel.validate();
            }
            return;
        }
        this.addAnnotTypeButton.setEnabled(true);
        this.annotTypesBox.setEnabled(true);
        this.featuresBox.setEnabled(true);
        n3 = this.patternTable.rowViewToModel(n3);
        Pattern pattern = null;
        if (n3 > -1) {
            pattern = (Pattern)this.patterns.get(n3);
        }
        VariableWidthJLabel variableWidthJLabel = new VariableWidthJLabel("Pattern Text : ");
        int n5 = variableWidthJLabel.getOriginalPreferredSize().width;
        if (n5 > this.firstColumnWidth) {
            this.firstColumnWidth = n5;
        }
        this.titleTextPanel.removeAll();
        this.titleTextPanel.add((Component)variableWidthJLabel, "West");
        this.patText = new JTextField(pattern == null ? "<No Pattern Found>" : pattern.getPatternText());
        this.patText.setBorder(null);
        this.patText.setEditable(false);
        this.patText.setOpaque(false);
        if (pattern != null) {
            this.patText.setToolTipText(pattern.getQueryString());
        }
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setOpaque(false);
        jPanel.add(this.patText);
        this.titleTextPanel.add((Component)jPanel, "Center");
        Highlighter highlighter = this.patText.getHighlighter();
        this.titleTextPanel.validate();
        if (pattern == null) {
            return;
        }
        try {
            highlighter.addHighlight(pattern.getStartOffset() - pattern.getLeftContextStartOffset(), pattern.getEndOffset() - pattern.getLeftContextStartOffset(), new DefaultHighlighter.DefaultHighlightPainter(new Color(240, 201, 184)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.currentPatternRows = new ArrayList();
        for (n2 = 0; n2 < this.addedAnnotTypesInGUI.size(); ++n2) {
            Object object2;
            int n6;
            int n7;
            int n8;
            int n9;
            int[] nArray;
            PatternAnnotation[] patternAnnotationArray;
            String string = this.addedAnnotTypesInGUI.get(n2);
            object = this.addedAnnotFeatureInGUI.get(n2);
            PatternRow patternRow = null;
            if (!((String)object).equals("nothing")) {
                Serializable serializable;
                if (patternRow == null) {
                    patternRow = new PatternRow(string, (String)object, this.patText.getWidth());
                }
                if ((patternAnnotationArray = pattern.getPatternAnnotations(string, (String)object)) == null || patternAnnotationArray.length == 0) {
                    patternAnnotationArray = new PatternAnnotation[]{};
                }
                nArray = new int[patternAnnotationArray.length * 2];
                n9 = 0;
                n8 = 0;
                while (n9 < patternAnnotationArray.length) {
                    serializable = patternAnnotationArray[n9];
                    nArray[n8] = ((PatternAnnotation)serializable).getStartOffset() - pattern.getLeftContextStartOffset();
                    nArray[n8 + 1] = ((PatternAnnotation)serializable).getEndOffset() - pattern.getLeftContextStartOffset();
                    ++n9;
                    n8 += 2;
                }
                n9 = 0;
                for (n8 = 0; n8 < patternAnnotationArray.length; ++n8) {
                    try {
                        serializable = this.patText.modelToView(nArray[n9]);
                        int n10 = (int)((Rectangle)serializable).getX();
                        n7 = (int)((Rectangle)serializable).getY();
                        serializable = this.patText.modelToView(nArray[n9 + 1]);
                        n6 = (int)((Rectangle)serializable).getX();
                        PatternAnnotation patternAnnotation = patternAnnotationArray[n8];
                        object2 = patternAnnotation.getFeatures().get(object);
                        if (object2 != null) {
                            int n11 = variableWidthJLabel.getPreferredSize().height;
                            patternRow.addPattern(n10 + 1, 0, n6 - n10, n11, (String)object2, patternAnnotation.getText(), this.getColor(patternAnnotation.getType()));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    n9 += 2;
                }
            } else {
                if (patternRow == null) {
                    patternRow = new PatternRow(string, "nothing", this.patText.getWidth());
                }
                if ((patternAnnotationArray = pattern.getPatternAnnotations(string)) == null || patternAnnotationArray.length == 0) {
                    patternAnnotationArray = new PatternAnnotation[]{};
                }
                nArray = new int[patternAnnotationArray.length * 2];
                n9 = 0;
                n8 = 0;
                while (n9 < patternAnnotationArray.length) {
                    PatternAnnotation patternAnnotation = patternAnnotationArray[n9];
                    nArray[n8] = patternAnnotation.getStartOffset() - pattern.getLeftContextStartOffset();
                    nArray[n8 + 1] = patternAnnotation.getEndOffset() - pattern.getLeftContextStartOffset();
                    ++n9;
                    n8 += 2;
                }
                n9 = variableWidthJLabel.getPreferredSize().height;
                n8 = 0;
                for (int i = 0; i < patternAnnotationArray.length; ++i) {
                    try {
                        Rectangle rectangle = this.patText.modelToView(nArray[n8]);
                        n7 = (int)rectangle.getX();
                        n6 = (int)rectangle.getY();
                        rectangle = this.patText.modelToView(nArray[n8 + 1]);
                        int n12 = (int)rectangle.getX();
                        object2 = patternAnnotationArray[i];
                        patternRow.addPattern(n7, 0, n12 - n7, n9, ((PatternAnnotation)object2).getFeatures(), ((PatternAnnotation)object2).getText(), this.getColor(((PatternAnnotation)object2).getType()));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    n8 += 2;
                }
            }
            patternRow.repaintComps();
            this.currentPatternRows.add(patternRow);
        }
        this.guiCons.gridheight = 1;
        this.guiCons.gridx = 0;
        this.guiCons.gridy = 0;
        this.guiCons.weighty = 0.0;
        this.guiCons.weightx = 1.0;
        this.guiCons.fill = 2;
        this.guiCons.insets = new Insets(0, 0, 0, 0);
        if (this.guiPanel.getComponentCount() > 0) {
            this.guiPanel.removeAll();
            this.guiPanel.add((Component)this.titleTextPanel, this.guiCons);
        }
        n2 = 0;
        for (n = 1; n <= this.currentPatternRows.size(); ++n) {
            object = this.currentPatternRows.get(n - 1);
            if (((PatternRow)object).yGrids == 0) {
                ((PatternRow)object).yGrids = 1;
            }
            this.guiCons.gridy = n + n2;
            this.guiCons.weighty = 0.0;
            this.guiCons.gridheight = ((PatternRow)object).yGrids;
            this.guiPanel.add((Component)object, this.guiCons);
            n2 += ((PatternRow)object).yGrids - 1;
        }
        this.guiCons.weighty = 1.0;
        this.guiCons.fill = 1;
        this.guiPanel.add(Box.createVerticalGlue(), this.guiCons);
        this.guiPanel.validate();
        for (n = 0; n < this.currentPatternRows.size(); ++n) {
            object = this.currentPatternRows.get(n);
            ((PatternRow)object).updateDisplay();
        }
        this.validate();
        this.updateUI();
    }

    private Color getColor(String string) {
        Color color;
        Preferences preferences = null;
        try {
            preferences = Preferences.userNodeForPackage(Class.forName("gate.gui.docview.AnnotationSetsView"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = preferences.getInt(string, -1);
        if (n == -1) {
            float[] fArray = this.colorGenerator.getNextColor().getComponents(null);
            color = new Color(fArray[0], fArray[1], fArray[2], 0.5f);
            int n2 = color.getRGB();
            int n3 = color.getAlpha();
            n = n2 | n3 << 24;
            preferences.putInt(string, n);
        } else {
            color = new Color(n, true);
        }
        return color;
    }

    public void updateGui() {
        this.guiPanel.removeAll();
        this.guiPanel.validate();
        this.guiPanel.updateUI();
        this.annotTypesBox.removeAllItems();
        ArrayList<String> arrayList = new ArrayList<String>(this.annotTypes.keySet());
        for (int i = 0; i < arrayList.size(); ++i) {
            this.annotTypesBox.addItem(arrayList.get(i));
        }
        this.annotTypesBox.updateUI();
        this.featuresBox.removeAllItems();
        if (this.annotTypesBox.getItemCount() > 0) {
            ArrayList<String> arrayList2 = this.annotTypes.get(this.annotTypesBox.getItemAt(0));
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.featuresBox.addItem(arrayList2.get(i));
            }
        }
        this.featuresBox.updateUI();
        this.newQuery.setText(this.target.getSearcher().getQuery());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == this.annotTypesBox && (string = (String)this.annotTypesBox.getSelectedItem()) != null && !string.equals(this.previousChoice)) {
            this.previousChoice = string;
            ArrayList<String> arrayList = this.annotTypes.get(string);
            this.featuresBox.removeAllItems();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.featuresBox.addItem(arrayList.get(i));
            }
            this.featuresBox.updateUI();
        }
    }

    protected void initLocalData() {
        Hit[] hitArray = this.target.getSearcher().getHits();
        if (this.patterns == null) {
            this.patterns = new ArrayList();
        }
        this.patterns.clear();
        for (int i = 0; i < hitArray.length; ++i) {
            this.patterns.add(hitArray[i]);
        }
        hitArray = null;
        this.annotTypes = this.target.getSearcher().getAnnotationTypesMap();
    }

    public void setTarget(Object object) {
        if (!(object instanceof LuceneDataStoreImpl)) {
            throw new IllegalArgumentException("The GATE LuceneDataStoreSearchGUI can only be used with a GATE LuceneDataStores!\n" + object.getClass().toString() + " is not a GATE LuceneDataStore!");
        }
        this.target = (LuceneDataStoreImpl)object;
        this.target.addDatastoreListener(this);
        this.executeQuery.setEnabled(true);
        this.nextResults.setEnabled(true);
        this.newQuery.setToolTipText("Enter your new query here...");
        this.newQuery.setEnabled(true);
        this.corpusToSearchIn.setEnabled(true);
        try {
            List list = this.target.getLrIds(SerialCorpusImpl.class.getName());
            if (this.corpusIds != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string = this.target.getLrName(list.get(i));
                    this.corpusIds.add(list.get(i));
                    ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).addElement(string);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LuceneDataStoreSearchGUI.this.corpusToSearchIn.updateUI();
                }
            });
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        this.noOfPatternsField.setEnabled(true);
        this.contextWindowField.setEnabled(true);
        this.clearQueryTF.setEnabled(true);
        this.exportToHTML.setEnabled(true);
        this.allPatterns.setSelected(true);
        this.selectedPatterns.setSelected(true);
        this.updateDisplay();
    }

    public void progressChanged(int n) {
    }

    public void processFinished() {
        if (!this.explicitCall) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LuceneDataStoreSearchGUI.this.executeQuery.setEnabled(true);
                    LuceneDataStoreSearchGUI.this.nextResults.setEnabled(true);
                    LuceneDataStoreSearchGUI.this.newQuery.setToolTipText("Enter your new query here...");
                    LuceneDataStoreSearchGUI.this.newQuery.setEnabled(true);
                    LuceneDataStoreSearchGUI.this.corpusToSearchIn.setEnabled(true);
                    LuceneDataStoreSearchGUI.this.noOfPatternsField.setEnabled(true);
                    LuceneDataStoreSearchGUI.this.contextWindowField.setEnabled(true);
                    LuceneDataStoreSearchGUI.this.clearQueryTF.setEnabled(true);
                    LuceneDataStoreSearchGUI.this.exportToHTML.setEnabled(true);
                    LuceneDataStoreSearchGUI.this.allPatterns.setSelected(true);
                    LuceneDataStoreSearchGUI.this.selectedPatterns.setSelected(true);
                    LuceneDataStoreSearchGUI.this.updateDisplay();
                }
            });
        }
    }

    public void resourceAdopted(DatastoreEvent datastoreEvent) {
    }

    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        Resource resource = datastoreEvent.getResource();
        if (resource instanceof Corpus) {
            Object object = datastoreEvent.getResourceID();
            int n = this.corpusIds.indexOf(object);
            if (n < 0) {
                return;
            }
            ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).removeElementAt(++n);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LuceneDataStoreSearchGUI.this.corpusToSearchIn.updateUI();
                }
            });
        }
    }

    public void resourceWritten(DatastoreEvent datastoreEvent) {
        Object object;
        Resource resource = datastoreEvent.getResource();
        if (resource instanceof Corpus && !this.corpusIds.contains(object = datastoreEvent.getResourceID())) {
            this.corpusIds.add(object);
            ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).addElement(resource.getName());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LuceneDataStoreSearchGUI.this.corpusToSearchIn.updateUI();
                }
            });
        }
    }

    protected class VariableWidthJLabel
    extends JLabel {
        public VariableWidthJLabel() {
        }

        public VariableWidthJLabel(Icon icon, int n) {
            super(icon, n);
        }

        public VariableWidthJLabel(Icon icon) {
            super(icon);
        }

        public VariableWidthJLabel(String string, Icon icon, int n) {
            super(string, icon, n);
        }

        public VariableWidthJLabel(String string, int n) {
            super(string, n);
        }

        public VariableWidthJLabel(String string) {
            super(string);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(LuceneDataStoreSearchGUI.this.firstColumnWidth, dimension.height);
        }

        public Dimension getOriginalPreferredSize() {
            return super.getPreferredSize();
        }
    }

    protected class AnnotTypeFeatures {
        int x;
        int y;
        int width;
        int height;
        HashMap features;
        String text;
        Color color;

        protected AnnotTypeFeatures() {
        }

        public ArrayList getFeatures() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.features == null) {
                arrayList.add("No Feature Available");
                return arrayList;
            }
            Set set = this.features.keySet();
            if (set == null || set.size() == 0) {
                arrayList.add("No Feature Available");
                return arrayList;
            }
            ArrayList arrayList2 = new ArrayList(set);
            for (int i = 0; i < arrayList2.size(); ++i) {
                Object v = this.features.get(arrayList2.get(i));
                if (v == null) continue;
                arrayList.add((String)arrayList2.get(i) + "=" + v.toString());
            }
            return arrayList;
        }
    }

    protected class AnnotType {
        int x;
        int y;
        int width;
        int height;
        String featureVal;
        String text;
        Color color;

        protected AnnotType() {
        }
    }

    protected class PatternRow
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 3616730456989380917L;
        VariableWidthJLabel patternLabel;
        JButton removePattern;
        ArrayList subComponents;
        JPanel subGuiPanel;
        int maxY = 0;
        int width = 0;
        int yGrids = 0;
        String type;
        String feature;

        public void updateDisplay() {
            this.patternLabel.updateUI();
            this.removePattern.updateUI();
            int n = this.patternLabel.getPreferredSize().height;
            this.subGuiPanel.setPreferredSize(new Dimension(this.subGuiPanel.getPreferredSize().width, n * this.yGrids + this.yGrids));
            this.subGuiPanel.updateUI();
        }

        public PatternRow(String string, String string2, int n) {
            this.type = string;
            this.feature = string2;
            String string3 = string;
            if (!string2.equals("nothing")) {
                string3 = string3 + "." + string2;
            }
            this.width = n;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.patternLabel = new VariableWidthJLabel(string3 + ": ");
            this.patternLabel.setAlignmentY(0.0f);
            int n2 = this.patternLabel.getOriginalPreferredSize().width;
            if (n2 > LuceneDataStoreSearchGUI.this.firstColumnWidth) {
                LuceneDataStoreSearchGUI.this.firstColumnWidth = n2;
            }
            Box box = Box.createVerticalBox();
            box.add(this.patternLabel);
            box.add(Box.createVerticalGlue());
            this.add((Component)box, "West");
            this.removePattern = new JButton(MainFrame.getIcon("delete.gif"));
            this.removePattern.addActionListener(this);
            this.removePattern.setBorderPainted(true);
            this.removePattern.setMargin(new Insets(0, 0, 0, 0));
            this.removePattern.setAlignmentY(0.0f);
            Box box2 = Box.createVerticalBox();
            box2.add(this.removePattern);
            box2.add(Box.createVerticalGlue());
            this.add((Component)box2, "East");
            this.subGuiPanel = new JPanel();
            this.subGuiPanel.setLayout(null);
            this.subGuiPanel.setOpaque(false);
            this.subGuiPanel.setBorder(null);
            this.subGuiPanel.setAlignmentY(0.0f);
            this.add((Component)this.subGuiPanel, "Center");
            this.subComponents = new ArrayList();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < LuceneDataStoreSearchGUI.this.addedAnnotTypesInGUI.size(); ++i) {
                String string;
                String string2 = (String)LuceneDataStoreSearchGUI.this.addedAnnotTypesInGUI.get(i);
                if (!string2.equals(this.type) || !this.feature.equals(string = (String)LuceneDataStoreSearchGUI.this.addedAnnotFeatureInGUI.get(i))) continue;
                LuceneDataStoreSearchGUI.this.addedAnnotTypesInGUI.remove(i);
                LuceneDataStoreSearchGUI.this.addedAnnotFeatureInGUI.remove(i);
                break;
            }
            LuceneDataStoreSearchGUI.this.currentPatternRows.remove(this);
            LuceneDataStoreSearchGUI.this.tableValueChanged();
        }

        public void repaintComps() {
            this.subGuiPanel.removeAll();
            for (int i = 0; i < this.subComponents.size(); ++i) {
                Serializable serializable;
                Object object;
                if (this.subComponents.get(i) instanceof AnnotType) {
                    object = (AnnotType)this.subComponents.get(i);
                    serializable = new JLabel(((AnnotType)object).featureVal);
                    ((JComponent)serializable).setAlignmentX(0.5f);
                    ((JComponent)serializable).setAlignmentY(0.0f);
                    ((JComponent)serializable).setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                    ((JComponent)serializable).setBackground(((AnnotType)object).color);
                    ((JComponent)serializable).setOpaque(true);
                    ((JComponent)serializable).setMaximumSize(new Dimension(((AnnotType)object).width, ((AnnotType)object).height));
                    ((JComponent)serializable).setPreferredSize(new Dimension(((AnnotType)object).width, ((AnnotType)object).height));
                    ((Component)serializable).addMouseListener(new MouseListener((AnnotType)object, (JLabel)serializable){
                        JPopupMenu popup = null;
                        boolean visible = false;
                        final /* synthetic */ AnnotType val$patG;
                        final /* synthetic */ JLabel val$tLabel;
                        {
                            this.val$patG = annotType;
                            this.val$tLabel = jLabel;
                        }

                        public void mouseEntered(MouseEvent mouseEvent) {
                            this.visible = true;
                            this.popup = new JPopupMenu();
                            this.popup.setBackground(new Color(249, 253, 213));
                            this.popup.setOpaque(true);
                            this.popup.setLayout(new GridLayout(2, 1));
                            this.popup.add(new JLabel("Text : " + this.val$patG.text));
                            this.popup.add(new JLabel("Value : " + this.val$patG.featureVal));
                            this.popup.show(PatternRow.this.subGuiPanel, this.val$patG.x, this.val$patG.y + this.val$patG.height);
                        }

                        public void mouseClicked(MouseEvent mouseEvent) {
                            int n = LuceneDataStoreSearchGUI.this.newQuery.getCaretPosition();
                            if (n < 0) {
                                n = LuceneDataStoreSearchGUI.this.newQuery.getText().length();
                            }
                            String string = LuceneDataStoreSearchGUI.this.newQuery.getText();
                            string = string.substring(0, n) + "{" + PatternRow.this.type + (PatternRow.this.feature.equals("nothing") ? "" : "." + PatternRow.this.feature) + "==\"" + this.val$tLabel.getText() + "\"}" + string.substring(n, string.length());
                            LuceneDataStoreSearchGUI.this.newQuery.setText(string);
                        }

                        public void mousePressed(MouseEvent mouseEvent) {
                        }

                        public void mouseReleased(MouseEvent mouseEvent) {
                        }

                        public void mouseExited(MouseEvent mouseEvent) {
                            if (this.popup != null && this.visible) {
                                this.popup.setVisible(false);
                            }
                        }
                    });
                    this.subGuiPanel.add((Component)serializable);
                    ((Component)serializable).setBounds(((AnnotType)object).x + 4, ((AnnotType)object).y, ((AnnotType)object).width, ((AnnotType)object).height);
                    continue;
                }
                object = (AnnotTypeFeatures)this.subComponents.get(i);
                ArrayList<String> arrayList = new ArrayList<String>();
                serializable = new ArrayList(((AnnotTypeFeatures)object).features.keySet());
                for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                    arrayList.add(((ArrayList)serializable).get(j).toString() + "=" + ((AnnotTypeFeatures)object).features.get(((ArrayList)serializable).get(j)));
                }
                JLabel jLabel = new JLabel("");
                jLabel.setAlignmentX(0.5f);
                jLabel.setAlignmentY(0.0f);
                jLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                jLabel.setOpaque(true);
                jLabel.setBackground(((AnnotTypeFeatures)object).color);
                jLabel.setMaximumSize(new Dimension(((AnnotTypeFeatures)object).width, ((AnnotTypeFeatures)object).height));
                jLabel.setPreferredSize(new Dimension(((AnnotTypeFeatures)object).width, ((AnnotTypeFeatures)object).height));
                jLabel.addMouseListener(new MouseListener((AnnotTypeFeatures)object){
                    JPopupMenu popup = null;
                    boolean visible = false;
                    final /* synthetic */ AnnotTypeFeatures val$atf;
                    {
                        this.val$atf = annotTypeFeatures;
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                        this.visible = true;
                        this.popup = new JPopupMenu();
                        ArrayList arrayList = this.val$atf.getFeatures();
                        this.popup.setLayout(new GridLayout(arrayList.size() + 2, 1));
                        this.popup.setBackground(new Color(249, 253, 213));
                        this.popup.setOpaque(true);
                        this.popup.add(new JLabel("Text : " + this.val$atf.text));
                        this.popup.add(new JLabel("Features : "));
                        for (int i = 0; i < arrayList.size(); ++i) {
                            this.popup.add(new JLabel((String)arrayList.get(i)));
                        }
                        this.popup.show(PatternRow.this.subGuiPanel, this.val$atf.x, this.val$atf.y + this.val$atf.height);
                    }

                    public void mouseClicked(MouseEvent mouseEvent) {
                        int n = LuceneDataStoreSearchGUI.this.newQuery.getCaretPosition();
                        if (n < 0) {
                            n = LuceneDataStoreSearchGUI.this.newQuery.getText().length();
                        }
                        String string = LuceneDataStoreSearchGUI.this.newQuery.getText();
                        string = string.substring(0, n) + "{" + PatternRow.this.type + (PatternRow.this.feature.equals("nothing") ? "" : "." + PatternRow.this.feature) + "}" + string.substring(n, string.length());
                        LuceneDataStoreSearchGUI.this.newQuery.setText(string);
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        if (this.popup != null && this.visible) {
                            this.popup.setVisible(false);
                        }
                    }
                });
                this.subGuiPanel.add(jLabel);
                jLabel.setBounds(((AnnotTypeFeatures)object).x + 4, ((AnnotTypeFeatures)object).y, ((AnnotTypeFeatures)object).width, ((AnnotTypeFeatures)object).height);
            }
            this.subGuiPanel.validate();
        }

        public void addPattern(int n, int n2, int n3, int n4, String string, String string2, Color color) {
            if ((n2 = this.findOutY(n, n2, n3, n4)) == 0) {
                n2 += 2;
            }
            AnnotType annotType = new AnnotType();
            annotType.x = n;
            annotType.y = n2;
            annotType.width = n3;
            annotType.height = n4;
            annotType.featureVal = string;
            annotType.text = string2;
            annotType.color = color;
            this.subComponents.add(annotType);
        }

        public void addPattern(int n, int n2, int n3, int n4, HashMap hashMap, String string, Color color) {
            if ((n2 = this.findOutY(n, n2, n3, n4)) == 0) {
                n2 += 2;
            }
            AnnotTypeFeatures annotTypeFeatures = new AnnotTypeFeatures();
            annotTypeFeatures.x = n;
            annotTypeFeatures.y = n2;
            annotTypeFeatures.width = n3;
            annotTypeFeatures.height = n4;
            annotTypeFeatures.features = hashMap;
            annotTypeFeatures.text = string;
            annotTypeFeatures.color = color;
            this.subComponents.add(annotTypeFeatures);
        }

        private int findOutY(int n, int n2, int n3, int n4) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            for (int i = 0; i < this.subComponents.size(); ++i) {
                Rectangle rectangle2;
                Object object;
                if (this.subComponents.get(i) instanceof AnnotType) {
                    object = (AnnotType)this.subComponents.get(i);
                    rectangle2 = new Rectangle(((AnnotType)object).x, ((AnnotType)object).y, ((AnnotType)object).width, ((AnnotType)object).height);
                } else {
                    object = (AnnotTypeFeatures)this.subComponents.get(i);
                    rectangle2 = new Rectangle(((AnnotTypeFeatures)object).x, ((AnnotTypeFeatures)object).y, ((AnnotTypeFeatures)object).width, ((AnnotTypeFeatures)object).height);
                }
                if (!rectangle.intersects(rectangle2)) continue;
                rectangle.y = rectangle2.y + rectangle2.height;
            }
            if (rectangle.y + rectangle.height > this.maxY) {
                ++this.yGrids;
                this.maxY = rectangle.y + rectangle.height;
            }
            return rectangle.y;
        }
    }

    protected class PatternsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3977012959534854193L;
        private static final int DOC_NAME_COLUMN = 0;
        private static final int LEFT_CONTEXT_COLUMN = 1;
        private static final int PATTERN_COLUMN = 2;
        private static final int RIGHT_CONTEXT_COLUMN = 3;

        protected PatternsTableModel() {
        }

        public int getRowCount() {
            return LuceneDataStoreSearchGUI.this.patterns.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Document";
                }
                case 1: {
                    return "Left Context";
                }
                case 2: {
                    return "Pattern";
                }
                case 3: {
                    return "Right Context";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Pattern pattern = (Pattern)LuceneDataStoreSearchGUI.this.patterns.get(n);
            switch (n2) {
                case 0: {
                    return pattern.getDocumentID();
                }
                case 1: {
                    return pattern.getPatternText(pattern.getLeftContextStartOffset(), pattern.getStartOffset());
                }
                case 2: {
                    return pattern.getPatternText(pattern.getStartOffset(), pattern.getEndOffset());
                }
                case 3: {
                    return pattern.getPatternText(pattern.getEndOffset(), pattern.getRightContextEndOffset());
                }
            }
            return Object.class;
        }
    }

    protected class NextResultAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257005436719871288L;

        NextResultAction() {
            super("Next Page");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LuceneDataStoreSearchGUI.this.thisInstance.setEnabled(false);
                    Searcher searcher = LuceneDataStoreSearchGUI.this.target.getSearcher();
                    try {
                        searcher.next(Integer.parseInt(LuceneDataStoreSearchGUI.this.noOfPatternsField.getText()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LuceneDataStoreSearchGUI.this.thisInstance.setEnabled(true);
                    }
                    LuceneDataStoreSearchGUI.this.processFinished();
                    LuceneDataStoreSearchGUI.this.thisInstance.setEnabled(true);
                }
            });
        }
    }

    protected class ExecuteQueryAction
    extends AbstractAction {
        private static final long serialVersionUID = 3258128055204917812L;

        ExecuteQueryAction() {
            super("Execute");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LuceneDataStoreSearchGUI.this.thisInstance.setEnabled(false);
                    Searcher searcher = LuceneDataStoreSearchGUI.this.target.getSearcher();
                    HashMap<String, Object> hashMap = LuceneDataStoreSearchGUI.this.target.getSearcher().getParameters();
                    if (hashMap == null) {
                        hashMap = new HashMap<String, Object>();
                    }
                    String string = new File(((URL)LuceneDataStoreSearchGUI.this.target.getIndexer().getParameters().get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    Integer n = new Integer(LuceneDataStoreSearchGUI.this.noOfPatternsField.getText().trim());
                    Integer n2 = new Integer(LuceneDataStoreSearchGUI.this.contextWindowField.getText().trim());
                    String string2 = LuceneDataStoreSearchGUI.this.newQuery.getText().trim();
                    int n3 = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex();
                    String string3 = n3 == 0 ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(n3 - 1);
                    hashMap.put("INDEX_LOCATIONS", arrayList);
                    hashMap.put("CONTEXT_WINDOW", n2);
                    hashMap.put("CORPUS_ID", string3);
                    try {
                        if (searcher.search(string2, hashMap)) {
                            searcher.next(n);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LuceneDataStoreSearchGUI.this.thisInstance.setEnabled(true);
                    }
                    LuceneDataStoreSearchGUI.this.processFinished();
                    LuceneDataStoreSearchGUI.this.thisInstance.setEnabled(true);
                }
            });
        }
    }

    protected class ClearQueryAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257569516199228209L;

        ClearQueryAction() {
            super("Clear");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LuceneDataStoreSearchGUI.this.newQuery.setText("");
        }
    }

    private class ExportResultsAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257286928859412277L;

        ExportResultsAction() {
            super("Export Patterns");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Searcher searcher = LuceneDataStoreSearchGUI.this.target.getSearcher();
            Map map = LuceneDataStoreSearchGUI.this.target.getSearcher().getParameters();
            if (LuceneDataStoreSearchGUI.this.patterns == null || LuceneDataStoreSearchGUI.this.patterns.isEmpty()) {
                try {
                    JOptionPane.showMessageDialog(Main.getMainFrame(), "No patterns found to export");
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            try {
                Pattern pattern;
                int n;
                int n2;
                Object object;
                JFileChooser jFileChooser = new JFileChooser();
                String string = "HTML";
                jFileChooser.setDialogTitle(string + " File to export pattern results to...");
                jFileChooser.showSaveDialog(Main.getMainFrame());
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                FileWriter fileWriter = new FileWriter(file);
                ArrayList arrayList = LuceneDataStoreSearchGUI.this.patterns;
                if (LuceneDataStoreSearchGUI.this.allPatterns.isSelected()) {
                    LuceneDataStoreSearchGUI.this.explicitCall = true;
                    boolean bl = LuceneDataStoreSearchGUI.this.target.search(LuceneDataStoreSearchGUI.this.target.getSearcher().getQuery(), map);
                    object = LuceneDataStoreSearchGUI.this.target.getSearcher().next(-1);
                    if (LuceneDataStoreSearchGUI.this.patterns == null) {
                        LuceneDataStoreSearchGUI.this.patterns = new ArrayList();
                    }
                    LuceneDataStoreSearchGUI.this.patterns.clear();
                    for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                        LuceneDataStoreSearchGUI.this.patterns.add(object[n2]);
                    }
                    object = null;
                    LuceneDataStoreSearchGUI.this.explicitCall = false;
                }
                ArrayList arrayList2 = new ArrayList();
                if (LuceneDataStoreSearchGUI.this.selectedPatterns.isSelected()) {
                    object = LuceneDataStoreSearchGUI.this.patternTable.getSelectedRows();
                    for (n2 = 0; n2 < ((int[])object).length; ++n2) {
                        n = LuceneDataStoreSearchGUI.this.patternTable.rowViewToModel((int)object[n2]);
                        arrayList2.add(LuceneDataStoreSearchGUI.this.patterns.get(n));
                    }
                } else {
                    arrayList2 = LuceneDataStoreSearchGUI.this.patterns;
                }
                object = new BufferedWriter(fileWriter);
                ((Writer)object).write("<HTML><TITLE>ANNIC Output</TITLE><BODY>");
                ((Writer)object).write("<BR><B>Query Issued: " + searcher.getQuery() + "<BR>Context Window :" + (String)map.get("CONTEXT_WINDOW") + "</B><BR><BR>");
                ((Writer)object).write("<BR><B>Queries:</B>");
                String string2 = "";
                for (n = 0; n < arrayList2.size(); ++n) {
                    pattern = (Pattern)arrayList2.get(n);
                    if (pattern.getQueryString().equals(string2)) continue;
                    ((Writer)object).write("<BR><a href=\"#" + pattern.getQueryString() + "\">" + pattern.getQueryString() + "</a>");
                    string2 = pattern.getQueryString();
                }
                ((Writer)object).write("<BR><BR>");
                string2 = "";
                for (n = 0; n < arrayList2.size(); ++n) {
                    pattern = (Pattern)arrayList2.get(n);
                    if (!pattern.getQueryString().equals(string2)) {
                        if (!string2.equals("")) {
                            ((Writer)object).write("</TABLE><BR><BR>");
                        }
                        string2 = pattern.getQueryString();
                        ((Writer)object).write("<BR><B> <a name=\"" + pattern.getQueryString() + "\">Query Pattern : " + pattern.getQueryString() + "</a></B><BR>");
                        ((Writer)object).write("<BR><TABLE border=\"1\">");
                        ((Writer)object).write("<TR><TD><B> No. </B></TD>");
                        ((Writer)object).write("<TD><B> Document ID </B></TD>");
                        ((Writer)object).write("<TD><B> Left Context </B></TD>");
                        ((Writer)object).write("<TD><B> Pattern Text </B></TD>");
                        ((Writer)object).write("<TD><B> Right Context </B></TD>");
                        ((Writer)object).write("</TR>");
                    }
                    ((Writer)object).write("<TR><TD>" + (n + 1) + "</TD>");
                    ((Writer)object).write("<TD>" + pattern.getDocumentID() + "</TD>");
                    ((Writer)object).write("<TD>" + pattern.getPatternText(pattern.getLeftContextStartOffset(), pattern.getStartOffset()) + "</TD>");
                    ((Writer)object).write("<TD>" + pattern.getPatternText(pattern.getStartOffset(), pattern.getEndOffset()) + "</TD>");
                    ((Writer)object).write("<TD>" + pattern.getPatternText(pattern.getEndOffset(), pattern.getRightContextEndOffset()) + "</TD>");
                    ((Writer)object).write("</TR>");
                }
                ((Writer)object).write("</TABLE></BODY></HTML>");
                ((BufferedWriter)object).flush();
                ((BufferedWriter)object).close();
                LuceneDataStoreSearchGUI.this.patterns = arrayList;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected class AddAnnotTypeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3256438118801225013L;

        AddAnnotTypeAction() {
            super("Add Annotation Type");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int n = LuceneDataStoreSearchGUI.this.annotTypesBox.getSelectedIndex();
            if (n < 0 && LuceneDataStoreSearchGUI.this.annotTypesBox.getItemCount() > 0) {
                n = 0;
            }
            String string2 = (String)LuceneDataStoreSearchGUI.this.annotTypesBox.getItemAt(n);
            n = LuceneDataStoreSearchGUI.this.featuresBox.getSelectedIndex();
            if (n < 0 && LuceneDataStoreSearchGUI.this.featuresBox.getItemCount() > 0) {
                n = 0;
            }
            if ((string = (String)LuceneDataStoreSearchGUI.this.featuresBox.getItemAt(n)).equals("All")) {
                string = "nothing";
            }
            boolean bl = true;
            for (int i = 0; i < LuceneDataStoreSearchGUI.this.addedAnnotTypesInGUI.size(); ++i) {
                if (!((String)LuceneDataStoreSearchGUI.this.addedAnnotTypesInGUI.get(i)).equals(string2) || !((String)LuceneDataStoreSearchGUI.this.addedAnnotFeatureInGUI.get(i)).equals(string)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(null, "Already available in GUI");
                return;
            }
            LuceneDataStoreSearchGUI.this.addedAnnotTypesInGUI.add(string2);
            LuceneDataStoreSearchGUI.this.addedAnnotFeatureInGUI.add(string);
            LuceneDataStoreSearchGUI.this.patternTable.setRowSelectionInterval(LuceneDataStoreSearchGUI.this.patternTable.getSelectedRow(), LuceneDataStoreSearchGUI.this.patternTable.getSelectedRow());
            LuceneDataStoreSearchGUI.this.tableValueChanged();
        }
    }
}

