/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.FeatureMap;
import gate.creole.AbstractVisualResource;
import gate.gui.Handle;
import gate.gui.ObjectRenderer;
import gate.swing.XJTable;
import gate.util.FeatureBearer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class FeaturesEditor
extends AbstractVisualResource {
    XJTable table;
    FeaturesTableModel tableModel;
    private FeatureBearer resource;
    FeatureMap features;
    JTextField newFeatureField;
    JTextField newValueField;
    JButton addNewBtn;
    JButton delBtn;

    public FeaturesEditor() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData() {
        this.features = Factory.newFeatureMap();
    }

    protected void initGuiComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.tableModel = new FeaturesTableModel();
        this.table = new XJTable(this.tableModel);
        this.table.setDefaultRenderer(String.class, new ObjectRenderer());
        this.table.setDefaultRenderer(Object.class, new ObjectRenderer());
        this.table.setAutoResizeMode(0);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        defaultCellEditor.setClickCountToStart(0);
        this.table.setDefaultEditor(String.class, defaultCellEditor);
        this.table.setDefaultEditor(Object.class, defaultCellEditor);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setOpaque(true);
        Color color = this.table.getBackground();
        color = new Color(color.getRGB());
        this.table.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        this.add((Component)jScrollPane, "Center");
        this.add(Box.createVerticalStrut(5));
        Box box = Box.createHorizontalBox();
        this.newFeatureField = new JTextField(10);
        this.newFeatureField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.newFeatureField.getPreferredSize().height));
        Box box2 = Box.createVerticalBox();
        box2.add(new JLabel("New feature name"));
        box2.add(this.newFeatureField);
        box.add(box2);
        box.add(Box.createHorizontalStrut(5));
        this.newValueField = new JTextField(10);
        this.newValueField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.newValueField.getPreferredSize().height));
        box2 = Box.createVerticalBox();
        box2.add(new JLabel("New feature value"));
        box2.add(this.newValueField);
        box.add(box2);
        box.add(Box.createHorizontalStrut(5));
        this.addNewBtn = new JButton("Add feature");
        box.add(this.addNewBtn);
        box.add(Box.createHorizontalStrut(5));
        this.delBtn = new JButton("Delete");
        box.add(this.delBtn);
        this.add(box);
        this.add(Box.createVerticalGlue());
    }

    protected void initListeners() {
        this.addNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = FeaturesEditor.this.newFeatureField.getText();
                String string2 = FeaturesEditor.this.newValueField.getText();
                if (string != null) {
                    FeaturesEditor.this.features.put(string, string2);
                    FeaturesEditor.this.tableModel.fireTableDataChanged();
                    FeaturesEditor.this.newFeatureField.setText("");
                    FeaturesEditor.this.newValueField.setText("");
                }
            }
        });
        this.delBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = FeaturesEditor.this.newFeatureField.getText();
                String string2 = FeaturesEditor.this.newValueField.getText();
                if (string != null) {
                    FeaturesEditor.this.features.remove(string);
                    FeaturesEditor.this.tableModel.fireTableDataChanged();
                    FeaturesEditor.this.newFeatureField.setText("");
                    FeaturesEditor.this.newValueField.setText("");
                }
            }
        });
    }

    public void cleanup() {
        super.cleanup();
        this.features = null;
        this.resource = null;
    }

    public void setFeatureBearer(FeatureBearer featureBearer) {
        if (featureBearer == null) {
            this.resource = null;
            this.features = null;
        } else {
            this.resource = featureBearer;
            this.features = this.resource.getFeatures();
        }
        this.tableModel.fireTableDataChanged();
    }

    public void setTarget(Object object) {
        if (object != null && !(object instanceof FeatureBearer)) {
            throw new IllegalArgumentException("FeatureEditors can only be used with FeatureBearer!\n" + object.getClass().toString() + " is not a FeatureBearer!");
        }
        this.setFeatureBearer((FeatureBearer)object);
    }

    public void setHandle(Handle handle) {
    }

    public FeatureBearer getFeatureBearer() {
        return this.resource;
    }

    class FeaturesTableModel
    extends AbstractTableModel {
        FeaturesTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return FeaturesEditor.this.features == null ? 0 : FeaturesEditor.this.features.size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Feature";
                }
                case 1: {
                    return "Value";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isCellEditable(int n, int n2) {
            if (FeaturesEditor.this.features == null) {
                return false;
            }
            return n == FeaturesEditor.this.features.size() || !((String)FeaturesEditor.this.table.getModel().getValueAt(n, 0)).startsWith("gate.");
        }

        public Object getValueAt(int n, int n2) {
            if (FeaturesEditor.this.features == null) {
                return null;
            }
            ArrayList arrayList = new ArrayList(FeaturesEditor.this.features.keySet());
            Collections.sort(arrayList);
            Object e = arrayList.get(n);
            switch (n2) {
                case 0: {
                    return e;
                }
                case 1: {
                    return FeaturesEditor.this.features.get(e) == null ? "" : FeaturesEditor.this.features.get(e).toString();
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                String string = (String)this.getValueAt(n, 0);
                Object v = FeaturesEditor.this.features.remove(string);
                if (object != null && !object.equals("")) {
                    FeaturesEditor.this.features.put(object, v);
                }
            } else {
                FeaturesEditor.this.features.put(this.getValueAt(n, 0), object);
            }
            this.fireTableDataChanged();
        }
    }
}

