/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.creole.ir.IREngine;
import gate.gui.ListEditorDialog;
import gate.gui.MainFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateIndexGUI
extends JPanel {
    JComboBox irEngineCombo;
    JTextField indexLocationTextField;
    JCheckBox useContentChk;
    JTextField featuresListTextField;
    List featuresList;
    SortedMap engineByName;

    public CreateIndexGUI() {
        this.initLocalData();
        this.initGUIComponents();
        this.initListeners();
    }

    protected void initLocalData() {
        this.featuresList = new ArrayList();
        this.engineByName = new TreeMap();
    }

    protected void initGUIComponents() {
        Object object;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JLabel("IR Engine type:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        this.irEngineCombo = new JComboBox();
        this.add((Component)this.irEngineCombo, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JLabel("Index location:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        this.indexLocationTextField = new JTextField(40);
        this.add((Component)this.indexLocationTextField, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JButton(new SelectDirAction()), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JLabel("Features to index:"), gridBagConstraints);
        this.featuresListTextField = new JTextField(40);
        this.featuresListTextField.setEditable(false);
        gridBagConstraints.gridwidth = 4;
        this.add((Component)this.featuresListTextField, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JButton(new EditFeatureListAction()), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        this.useContentChk = new JCheckBox("Use document content", true);
        this.add((Component)this.useContentChk, gridBagConstraints);
        String string = (String)this.irEngineCombo.getSelectedItem();
        ArrayList arrayList = new ArrayList(Gate.getRegisteredIREngines());
        this.engineByName.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            try {
                object = Class.forName(string2, true, Gate.getClassLoader());
                IREngine iREngine = (IREngine)((Class)object).newInstance();
                this.engineByName.put(iREngine.getName(), iREngine);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        String[] stringArray = new String[this.engineByName.size()];
        int n = 0;
        object = this.engineByName.keySet().iterator();
        while (object.hasNext()) {
            stringArray[n++] = (String)object.next();
        }
        this.irEngineCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (string != null && this.engineByName.containsKey(string)) {
            this.irEngineCombo.setSelectedItem(string);
        } else if (this.engineByName.size() > 0) {
            this.irEngineCombo.setSelectedIndex(0);
        }
    }

    protected void initListeners() {
    }

    public boolean getUseDocumentContent() {
        return this.useContentChk.isSelected();
    }

    public List getFeaturesList() {
        return this.featuresList;
    }

    public String getIndexLocation() {
        return this.indexLocationTextField.getText();
    }

    public IREngine getIREngine() {
        return (IREngine)this.engineByName.get(this.irEngineCombo.getSelectedItem());
    }

    protected class EditFeatureListAction
    extends AbstractAction {
        public EditFeatureListAction() {
            super(null, MainFrame.getIcon("edit-list"));
            this.putValue("ShortDescription", "Click to edit list!");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListEditorDialog listEditorDialog = new ListEditorDialog(CreateIndexGUI.this, CreateIndexGUI.this.featuresList, "java.lang.String");
            List list = listEditorDialog.showDialog();
            if (list != null) {
                CreateIndexGUI.this.featuresList.clear();
                CreateIndexGUI.this.featuresList.addAll(list);
                if (CreateIndexGUI.this.featuresList.size() > 0) {
                    String string = "[" + CreateIndexGUI.this.featuresList.get(0).toString();
                    for (int i = 1; i < CreateIndexGUI.this.featuresList.size(); ++i) {
                        string = string + ", " + CreateIndexGUI.this.featuresList.get(i).toString();
                    }
                    string = string + "]";
                    CreateIndexGUI.this.featuresListTextField.setText(string);
                } else {
                    CreateIndexGUI.this.featuresListTextField.setText("");
                }
            }
        }
    }

    protected class SelectDirAction
    extends AbstractAction {
        public SelectDirAction() {
            super(null, MainFrame.getIcon("open-file"));
            this.putValue("ShortDescription", "Click to open a file chooser!");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = MainFrame.getFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Select a directory for the index files");
            int n = jFileChooser.showOpenDialog(CreateIndexGUI.this);
            if (n == 0) {
                CreateIndexGUI.this.indexLocationTextField.setText(jFileChooser.getSelectedFile().toString());
            }
        }
    }
}

