/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.creole.ir.DefaultIndexDefinition;
import gate.creole.ir.DocumentContentReader;
import gate.creole.ir.IndexException;
import gate.creole.ir.IndexField;
import gate.creole.ir.IndexedCorpus;
import gate.gui.MainFrame;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CreateIndexDialog
extends JDialog {
    private IndexedCorpus ic;
    protected JPanel panel1 = new JPanel();
    protected JLabel indexTypeLabel = new JLabel();
    protected JComboBox jComboIType = new JComboBox();
    protected JLabel locationLabel = new JLabel();
    protected JTextField locationTextField = new JTextField();
    protected JButton browse = new JButton();
    protected JLabel featureLable = new JLabel();
    protected JTextField featureTextField = new JTextField();
    protected JList jList1 = null;
    protected JScrollPane scrollPane = new JScrollPane();
    protected JButton addButton = new JButton();
    protected JCheckBox content = new JCheckBox();
    protected JButton createButton = new JButton();
    protected JButton cancelButton = new JButton();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Vector fields = new Vector();

    public CreateIndexDialog(Frame frame, IndexedCorpus indexedCorpus) {
        super(frame, true);
        this.ic = indexedCorpus;
        this.init();
        this.pack();
    }

    public CreateIndexDialog(Dialog dialog, IndexedCorpus indexedCorpus) {
        super(dialog, true);
        this.ic = indexedCorpus;
        this.init();
    }

    private void init() {
        this.panel1.setLayout(this.gridBagLayout1);
        this.indexTypeLabel.setText("Index Type");
        this.locationLabel.setText("Location");
        this.browse.setToolTipText("Browse location directory");
        this.browse.setText("Browse");
        this.featureLable.setText("Feature/Field  Name");
        this.addButton.setText("Add Field");
        this.content.setSelected(true);
        this.content.setText("Content");
        this.createButton.setText("Create");
        this.cancelButton.setText("Cancel");
        this.jComboIType.addItem("Lucene");
        this.jComboIType.setSelectedItem("Lucene");
        this.jList1 = new JList(this.fields);
        this.scrollPane.getViewport().setView(this.jList1);
        this.getContentPane().add((Component)this.panel1, "North");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndexDialog.this.cancelAction();
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndexDialog.this.createAction();
            }
        });
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndexDialog.this.browseAction();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateIndexDialog.this.addAction();
            }
        });
        this.panel1.add((Component)this.locationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.indexTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.featureLable, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.locationTextField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.jComboIType, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.browse, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.addButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.featureTextField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.jList1, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 185, 87));
        this.panel1.add((Component)this.content, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.createButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.cancelButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void cancelAction() {
        this.dispose();
    }

    private void createAction() {
        DefaultIndexDefinition defaultIndexDefinition = new DefaultIndexDefinition();
        String string = this.locationTextField.getText();
        defaultIndexDefinition.setIndexLocation(string);
        if (this.content.isSelected()) {
            defaultIndexDefinition.addIndexField(new IndexField("body", new DocumentContentReader(), false));
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            defaultIndexDefinition.addIndexField(new IndexField(this.fields.elementAt(i).toString(), null, false));
        }
        this.ic.setIndexDefinition(defaultIndexDefinition);
        try {
            this.ic.getIndexManager().deleteIndex();
            this.ic.getIndexManager().createIndex();
        }
        catch (IndexException indexException) {
            indexException.printStackTrace();
        }
        this.dispose();
    }

    private void browseAction() {
        JFileChooser jFileChooser = MainFrame.getFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Select location directory");
        jFileChooser.setSelectedFiles(null);
        int n = jFileChooser.showDialog(this, "Select");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.locationTextField.setText(file.getAbsolutePath());
        }
    }

    private void addAction() {
        this.fields.add(this.featureTextField.getText());
    }
}

