/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Corpus;
import gate.Document;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.gui.MainFrame;
import gate.swing.XJTable;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class CorpusEditor
extends AbstractVisualResource
implements CorpusListener {
    protected XJTable docTable;
    protected DocumentTableModel docTableModel;
    protected DocumentNameRenderer renderer;
    protected JToolBar toolbar;
    protected Corpus corpus;

    public Resource init() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
        this.docTableModel = new DocumentTableModel();
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.renderer = new DocumentNameRenderer();
        this.docTable = new XJTable(this.docTableModel);
        this.docTable.setSortable(true);
        this.docTable.setSortedColumn(0);
        this.docTable.setAutoResizeMode(0);
        this.docTable.getColumnModel().getColumn(1).setCellRenderer(this.renderer);
        JScrollPane jScrollPane = new JScrollPane(this.docTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getViewport().setBackground(this.docTable.getBackground());
        this.add(jScrollPane);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.add(new NewDocumentAction());
        this.toolbar.add(new RemoveDocumentsAction());
        this.toolbar.addSeparator();
        this.toolbar.add(new MoveUpAction());
        this.toolbar.add(new MoveDownAction());
        this.add((Component)this.toolbar, "North");
    }

    protected void initListeners() {
        this.docTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n = CorpusEditor.this.docTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
                    n = CorpusEditor.this.docTable.rowViewToModel(n);
                    Document document = (Document)CorpusEditor.this.corpus.get(n);
                    Component component = SwingUtilities.getRoot(CorpusEditor.this);
                    if (component instanceof MainFrame) {
                        MainFrame mainFrame = (MainFrame)component;
                        mainFrame.select(document);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
    }

    public void cleanup() {
        super.cleanup();
        this.corpus = null;
    }

    public void setTarget(Object object) {
        if (this.corpus != null && this.corpus != object) {
            this.corpus.removeCorpusListener(this);
        }
        if (!(object instanceof Corpus)) {
            throw new IllegalArgumentException("The GATE corpus editor can only be used with a GATE corpus!\n" + object.getClass().toString() + " is not a GATE corpus!");
        }
        this.corpus = (Corpus)object;
        this.corpus.addCorpusListener(this);
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusEditor.this.docTableModel.fireTableDataChanged();
            }
        });
    }

    public void documentAdded(final CorpusEvent corpusEvent) {
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusEditor.this.docTableModel.fireTableRowsInserted(corpusEvent.getDocumentIndex(), corpusEvent.getDocumentIndex());
            }
        });
    }

    public void documentRemoved(final CorpusEvent corpusEvent) {
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CorpusEditor.this.docTableModel.fireTableRowsDeleted(corpusEvent.getDocumentIndex(), corpusEvent.getDocumentIndex());
            }
        });
    }

    class RemoveDocumentsAction
    extends AbstractAction {
        public RemoveDocumentsAction() {
            super("Remove documents", MainFrame.getIcon("remove-document"));
            this.putValue("ShortDescription", "Removes selected documents from this corpus");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = CorpusEditor.this.docTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = CorpusEditor.this.docTable.rowViewToModel(nArray[n]);
            }
            Arrays.sort(nArray2);
            for (n = nArray2.length - 1; n >= 0; --n) {
                CorpusEditor.this.corpus.remove(nArray2[n]);
            }
        }
    }

    class NewDocumentAction
    extends AbstractAction {
        public NewDocumentAction() {
            super("Add document", MainFrame.getIcon("add-document"));
            this.putValue("ShortDescription", "Add a new document to this corpus");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                List<Resource> list = Gate.getCreoleRegister().getAllInstances("gate.Document");
                if (list == null || list.isEmpty()) {
                    JOptionPane.showMessageDialog(CorpusEditor.this, "There are no documents available in the system!\nPlease load some and try again!", "GATE", 0);
                    return;
                }
                Vector<String> vector = new Vector<String>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    vector.add(((Document)list.get(i)).getName());
                }
                JList jList = new JList(vector);
                jList.setCellRenderer(CorpusEditor.this.renderer);
                JOptionPane jOptionPane = new JOptionPane(new JScrollPane(jList), 3, 2);
                jOptionPane.createDialog(CorpusEditor.this, "Add document(s) to corpus").setVisible(true);
                if ((Integer)jOptionPane.getValue() == 0) {
                    int[] nArray = jList.getSelectedIndices();
                    for (int i = 0; i < nArray.length; ++i) {
                        CorpusEditor.this.corpus.add(list.get(nArray[i]));
                    }
                }
            }
            catch (GateException gateException) {
                throw new GateRuntimeException("gate.Document is not registered in the creole register!\nSomething must be terribly wrong...take a vacation!");
            }
        }
    }

    class MoveDownAction
    extends AbstractAction {
        public MoveDownAction() {
            super("Move down", MainFrame.getIcon("down"));
            this.putValue("ShortDescription", "Moves selected document(s) down.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = CorpusEditor.this.docTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = CorpusEditor.this.docTable.rowViewToModel(nArray[n]);
            }
            Arrays.sort(nArray2);
            for (n = nArray2.length - 1; n >= 0; --n) {
                if (nArray2[n] >= CorpusEditor.this.corpus.size() - 1) continue;
                Object e = CorpusEditor.this.corpus.remove(nArray2[n]);
                int n2 = n;
                nArray2[n2] = nArray2[n2] + 1;
                CorpusEditor.this.corpus.add(nArray2[n], e);
            }
            final int[] nArray3 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CorpusEditor.this.docTable.clearSelection();
                    for (int i = 0; i < nArray3.length; ++i) {
                        int n = CorpusEditor.this.docTable.rowModelToView(nArray3[i]);
                        CorpusEditor.this.docTable.getSelectionModel().addSelectionInterval(n, n);
                    }
                }
            });
        }
    }

    class MoveUpAction
    extends AbstractAction {
        public MoveUpAction() {
            super("Move up", MainFrame.getIcon("up"));
            this.putValue("ShortDescription", "Moves selected document(s) up.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = CorpusEditor.this.docTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = CorpusEditor.this.docTable.rowViewToModel(nArray[n]);
            }
            Arrays.sort(nArray2);
            for (n = 0; n < nArray2.length; ++n) {
                if (nArray2[n] <= 0) continue;
                Object e = CorpusEditor.this.corpus.remove(nArray2[n]);
                nArray2[n] = nArray2[n] - 1;
                CorpusEditor.this.corpus.add(nArray2[n], e);
            }
            final int[] nArray3 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CorpusEditor.this.docTable.clearSelection();
                    for (int i = 0; i < nArray3.length; ++i) {
                        int n = CorpusEditor.this.docTable.rowModelToView(nArray3[i]);
                        CorpusEditor.this.docTable.getSelectionModel().addSelectionInterval(n, n);
                    }
                }
            });
        }
    }

    class DocumentNameRenderer
    extends DefaultTableCellRenderer
    implements ListCellRenderer {
        public DocumentNameRenderer() {
            this.setIcon(MainFrame.getIcon("document"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return this.getTableCellRendererComponent(CorpusEditor.this.docTable, object, bl, bl2, n, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DocumentTableModel
    extends AbstractTableModel {
        private List<String> documentNames;
        private final String[] COLUMN_NAMES = new String[]{"Index", "Name"};
        private static final int COL_INDEX = 0;
        private static final int COL_NAME = 1;
        private static final int COLUMN_COUNT = 2;

        public DocumentTableModel() {
            this.documentNames = new ArrayList<String>();
        }

        private void dataChanged() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (CorpusEditor.this.corpus != null) {
                arrayList.addAll(CorpusEditor.this.corpus.getDocumentNames());
            }
            List<String> list = this.documentNames;
            this.documentNames = arrayList;
            list.clear();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.documentNames.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n >= this.documentNames.size() || n2 < 0 || n2 > 2) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return new Integer(n);
                }
                case 1: {
                    return this.documentNames.get(n);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

