/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.swing.JFontChooser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class AppearanceDialog
extends JDialog {
    JRadioButton menusRBtn;
    JRadioButton componentsRBtn;
    JRadioButton textComponentsRBtn;
    JFontChooser fontChooser;
    JButton okBtn;
    JButton applyBtn;
    JButton cancelBtn;
    ButtonGroup bGroup;
    Font menusFont;
    Font componentsFont;
    Font textComponentsFont;
    Font oldMenusFont;
    Font oldComponentsFont;
    Font oldTextComponentsFont;
    String currentFont;
    Component[] targets;
    public static String[] menuKeys = new String[]{"CheckBoxMenuItem.acceleratorFont", "CheckBoxMenuItem.font", "Menu.acceleratorFont", "Menu.font", "MenuBar.font", "MenuItem.acceleratorFont", "MenuItem.font", "RadioButtonMenuItem.acceleratorFont", "RadioButtonMenuItem.font"};
    public static String[] componentsKeys = new String[]{"Button.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "InternalFrame.titleFont", "Label.font", "List.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "ScrollPane.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font"};
    public static String[] textComponentsKeys = new String[]{"EditorPane.font", "TextArea.font", "TextField.font", "TextPane.font"};

    public AppearanceDialog(Frame frame, String string, boolean bl, Component[] componentArray) {
        super(frame, string, bl);
        this.targets = componentArray;
        this.init();
    }

    public AppearanceDialog(Dialog dialog, String string, boolean bl, Component[] componentArray) {
        super(dialog, string, bl);
        this.targets = componentArray;
        this.init();
    }

    protected void init() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.bGroup.setSelected(this.menusRBtn.getModel(), true);
        this.cancelBtn.getAction().actionPerformed(null);
    }

    protected void initLocalData() {
        Font font = Gate.getUserConfig().getFont("Menus_font");
        this.menusFont = font == null ? UIManager.getFont("Menu.font") : font;
        this.oldMenusFont = this.menusFont;
        font = Gate.getUserConfig().getFont("Other_components_font");
        this.componentsFont = font == null ? UIManager.getFont("Button.font") : font;
        this.oldComponentsFont = this.componentsFont;
        font = Gate.getUserConfig().getFont("Text_components_font");
        this.textComponentsFont = font == null ? UIManager.getFont("TextPane.font") : font;
        this.oldTextComponentsFont = this.textComponentsFont;
    }

    protected void initGuiComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        Box box = Box.createHorizontalBox();
        Box box2 = Box.createVerticalBox();
        this.bGroup = new ButtonGroup();
        this.menusRBtn = new JRadioButton("Menus", false);
        this.menusRBtn.setActionCommand("menus");
        this.bGroup.add(this.menusRBtn);
        box2.add(this.menusRBtn);
        this.componentsRBtn = new JRadioButton("Components", false);
        this.componentsRBtn.setActionCommand("components");
        this.bGroup.add(this.componentsRBtn);
        box2.add(this.componentsRBtn);
        this.textComponentsRBtn = new JRadioButton("Text components", false);
        this.textComponentsRBtn.setActionCommand("text components");
        this.bGroup.add(this.textComponentsRBtn);
        box2.add(this.textComponentsRBtn);
        box.add(box2);
        box.add(Box.createHorizontalGlue());
        this.getContentPane().add(box);
        this.fontChooser = new JFontChooser();
        this.getContentPane().add(this.fontChooser);
        box = Box.createHorizontalBox();
        this.okBtn = new JButton(new OKAction());
        box.add(this.okBtn);
        this.cancelBtn = new JButton(new CancelAction());
        box.add(this.cancelBtn);
        this.applyBtn = new JButton(new ApplyAction());
        box.add(this.applyBtn);
        this.getContentPane().add(box);
        this.setResizable(false);
    }

    protected void initListeners() {
        this.fontChooser.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                AppearanceDialog.this.pack();
            }
        });
        this.menusRBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AppearanceDialog.this.menusRBtn.isSelected()) {
                    AppearanceDialog.this.fontChooser.setFontValue(AppearanceDialog.this.menusFont);
                }
            }
        });
        this.componentsRBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AppearanceDialog.this.componentsRBtn.isSelected()) {
                    AppearanceDialog.this.fontChooser.setFontValue(AppearanceDialog.this.componentsFont);
                }
            }
        });
        this.textComponentsRBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AppearanceDialog.this.textComponentsRBtn.isSelected()) {
                    AppearanceDialog.this.fontChooser.setFontValue(AppearanceDialog.this.textComponentsFont);
                }
            }
        });
    }

    public void show(Component[] componentArray) {
        this.targets = componentArray;
        this.oldMenusFont = this.menusFont = UIManager.getFont("Menu.font");
        this.oldComponentsFont = this.componentsFont = UIManager.getFont("Button.font");
        this.oldTextComponentsFont = this.textComponentsFont = UIManager.getFont("TextPane.font");
        super.setVisible(true);
    }

    protected static void setUIDefaults(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            UIManager.put(objectArray[i], object);
        }
    }

    public static void setTextComponentsFont(Font font) {
        AppearanceDialog.setUIDefaults(textComponentsKeys, new FontUIResource(font));
        Gate.getUserConfig().put("Text_components_font", font);
    }

    public static void setMenuComponentsFont(Font font) {
        AppearanceDialog.setUIDefaults(menuKeys, new FontUIResource(font));
        Gate.getUserConfig().put("Menus_font", font);
    }

    public static void setComponentsFont(Font font) {
        AppearanceDialog.setUIDefaults(componentsKeys, new FontUIResource(font));
        Gate.getUserConfig().put("Other_components_font", font);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("Foo frame");
        final AppearanceDialog appearanceDialog = new AppearanceDialog((Frame)jFrame, "Font appearance", true, new Component[]{jFrame});
        appearanceDialog.pack();
        jFrame.setDefaultCloseOperation(2);
        JButton jButton = new JButton("Show dialog");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                appearanceDialog.setVisible(true);
            }
        });
        jFrame.getContentPane().add(jButton);
        jFrame.setSize(new Dimension(300, 300));
        jFrame.setVisible(true);
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AppearanceDialog.setUIDefaults(menuKeys, new FontUIResource(AppearanceDialog.this.oldMenusFont));
            AppearanceDialog.setUIDefaults(componentsKeys, new FontUIResource(AppearanceDialog.this.oldComponentsFont));
            AppearanceDialog.setUIDefaults(textComponentsKeys, new FontUIResource(AppearanceDialog.this.oldTextComponentsFont));
            SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(AppearanceDialog.this));
            for (int i = 0; i < AppearanceDialog.this.targets.length; ++i) {
                if (AppearanceDialog.this.targets[i] instanceof Window) {
                    SwingUtilities.updateComponentTreeUI(AppearanceDialog.this.targets[i]);
                    continue;
                }
                SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(AppearanceDialog.this.targets[i]));
            }
            AppearanceDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            super("OK");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AppearanceDialog.this.applyBtn.getAction().actionPerformed(actionEvent);
            AppearanceDialog.this.setVisible(false);
        }
    }

    class ApplyAction
    extends AbstractAction {
        ApplyAction() {
            super("Apply");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AppearanceDialog.setMenuComponentsFont(AppearanceDialog.this.menusFont);
            AppearanceDialog.setComponentsFont(AppearanceDialog.this.componentsFont);
            AppearanceDialog.setTextComponentsFont(AppearanceDialog.this.textComponentsFont);
            SwingUtilities.updateComponentTreeUI(AppearanceDialog.this);
            for (int i = 0; i < AppearanceDialog.this.targets.length; ++i) {
                if (AppearanceDialog.this.targets[i] instanceof Window) {
                    SwingUtilities.updateComponentTreeUI(AppearanceDialog.this.targets[i]);
                    continue;
                }
                SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(AppearanceDialog.this.targets[i]));
            }
        }
    }
}

