/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Gate;
import gate.gui.MainFrame;
import gate.swing.XJTable;
import gate.util.AnnotationDiffer;
import gate.util.ExtensionFileFilter;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class AnnotationDiffGUI
extends JFrame {
    protected AnnotationDiffer differ;
    protected List pairings;
    protected Document keyDoc;
    protected Document resDoc;
    protected Set significantFeatures;
    protected List documents;
    protected List keySets;
    protected List resSets;
    protected AnnotationSet keySet;
    protected AnnotationSet resSet;
    protected JList featuresList;
    protected DefaultListModel featureslistModel;
    protected DiffTableModel diffTableModel;
    protected XJTable diffTable;
    protected JScrollPane scroller;
    protected JComboBox keyDocCombo;
    protected JComboBox keySetCombo;
    protected JComboBox annTypeCombo;
    protected JComboBox resDocCombo;
    protected JComboBox resSetCombo;
    protected JProgressBar progressBar;
    protected JRadioButton allFeaturesBtn;
    protected JRadioButton someFeaturesBtn;
    protected JRadioButton noFeaturesBtn;
    protected JTextField weightTxt;
    protected JButton doDiffBtn;
    protected JPanel resultsPane;
    protected JLabel correctLbl;
    protected JLabel partiallyCorrectLbl;
    protected JLabel missingLbl;
    protected JLabel falsePozLbl;
    protected JLabel recallStrictLbl;
    protected JLabel precisionStrictLbl;
    protected JLabel fmeasureStrictLbl;
    protected JLabel recallLenientLbl;
    protected JLabel precisionLenientLbl;
    protected JLabel fmeasureLenientLbl;
    protected JLabel recallAveLbl;
    protected JLabel precisionAveLbl;
    protected JLabel fmeasureAveLbl;
    protected static final Color PARTIALLY_CORRECT_BG = new Color(173, 215, 255);
    protected static final Color MISSING_BG = new Color(255, 173, 181);
    protected static final Color FALSE_POZITIVE_BG = new Color(255, 231, 173);
    protected static final String[] matchLabel = new String[5];

    public AnnotationDiffGUI(String string) {
        super(string);
        MainFrame.getGuiRoots().add(this);
        this.setDefaultCloseOperation(2);
        this.initLocalData();
        this.initGUI();
        this.initListeners();
        this.populateGUI();
    }

    protected void initLocalData() {
        this.differ = new AnnotationDiffer();
        this.pairings = new ArrayList();
        this.significantFeatures = new HashSet();
        this.keyDoc = null;
        this.resDoc = null;
    }

    protected void initGUI() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.gridx = 1;
        this.getContentPane().add((Component)new JLabel("Document"), gridBagConstraints);
        gridBagConstraints.gridx = -1;
        this.getContentPane().add((Component)new JLabel("Annotation Set"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)new JLabel("Key:"), gridBagConstraints);
        this.keyDocCombo = new JComboBox();
        this.getContentPane().add((Component)this.keyDocCombo, gridBagConstraints);
        this.keySetCombo = new JComboBox();
        this.getContentPane().add((Component)this.keySetCombo, gridBagConstraints);
        this.getContentPane().add((Component)new JLabel("Annotation Type:"), gridBagConstraints);
        this.annTypeCombo = new JComboBox();
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.annTypeCombo, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)new JLabel("F-Measure Weight"), gridBagConstraints);
        gridBagConstraints.gridheight = 2;
        this.doDiffBtn = new JButton(new DiffAction());
        this.getContentPane().add((Component)this.doDiffBtn, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        this.getContentPane().add((Component)new JLabel("Response:"), gridBagConstraints);
        gridBagConstraints.gridx = -1;
        this.resDocCombo = new JComboBox();
        this.getContentPane().add((Component)this.resDocCombo, gridBagConstraints);
        this.resSetCombo = new JComboBox();
        this.getContentPane().add((Component)this.resSetCombo, gridBagConstraints);
        this.getContentPane().add((Component)new JLabel("Features:"), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.allFeaturesBtn = new JRadioButton("All");
        this.allFeaturesBtn.setOpaque(false);
        buttonGroup.add(this.allFeaturesBtn);
        this.getContentPane().add((Component)this.allFeaturesBtn, gridBagConstraints);
        this.someFeaturesBtn = new JRadioButton("Some");
        this.someFeaturesBtn.setOpaque(false);
        buttonGroup.add(this.someFeaturesBtn);
        this.getContentPane().add((Component)this.someFeaturesBtn, gridBagConstraints);
        this.noFeaturesBtn = new JRadioButton("None");
        this.noFeaturesBtn.setOpaque(false);
        buttonGroup.add(this.noFeaturesBtn);
        this.getContentPane().add((Component)this.noFeaturesBtn, gridBagConstraints);
        this.noFeaturesBtn.setSelected(true);
        this.weightTxt = new JTextField("1.00");
        this.getContentPane().add((Component)this.weightTxt, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.diffTableModel = new DiffTableModel();
        this.diffTable = new XJTable(this.diffTableModel);
        this.diffTable.setDefaultRenderer(String.class, new DiffTableCellRenderer());
        this.diffTable.setAutoResizeMode(0);
        this.diffTable.setComparator(4, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                int n = 0;
                while (!string.equals(matchLabel[n])) {
                    ++n;
                }
                int n2 = 0;
                while (!string2.equals(matchLabel[n2])) {
                    ++n2;
                }
                return n - n2;
            }
        });
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                String string = (String)object;
                String string2 = (String)object2;
                if (string.trim().equals("") && string2.trim().equals("")) {
                    return 0;
                }
                if (string.trim().equals("")) {
                    return -1;
                }
                if (string2.trim().equals("")) {
                    return 1;
                }
                int n2 = Integer.parseInt(string);
                if (n2 == (n = Integer.parseInt(string2))) {
                    return 0;
                }
                if (n2 > n) {
                    return 1;
                }
                return -1;
            }
        };
        this.diffTable.setComparator(0, comparator);
        this.diffTable.setComparator(1, comparator);
        this.diffTable.setComparator(5, comparator);
        this.diffTable.setComparator(6, comparator);
        this.diffTable.setSortable(true);
        this.diffTable.setSortedColumn(4);
        this.diffTable.setAscending(false);
        this.scroller = new JScrollPane(this.diffTable);
        this.getContentPane().add((Component)this.scroller, gridBagConstraints);
        this.resultsPane = new JPanel();
        this.resultsPane.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel("Correct:");
        jLabel.setBackground(this.diffTable.getBackground());
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Partially Correct:");
        jLabel.setBackground(PARTIALLY_CORRECT_BG);
        jLabel.setOpaque(true);
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Missing:");
        jLabel.setBackground(MISSING_BG);
        jLabel.setOpaque(true);
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("False Positives:");
        jLabel.setBackground(FALSE_POZITIVE_BG);
        jLabel.setOpaque(true);
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.correctLbl = new JLabel("0");
        this.resultsPane.add((Component)this.correctLbl, gridBagConstraints);
        this.partiallyCorrectLbl = new JLabel("0");
        this.resultsPane.add((Component)this.partiallyCorrectLbl, gridBagConstraints);
        this.missingLbl = new JLabel("0");
        this.resultsPane.add((Component)this.missingLbl, gridBagConstraints);
        this.falsePozLbl = new JLabel("0");
        this.resultsPane.add((Component)this.falsePozLbl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(4, 30, 4, 4);
        this.resultsPane.add(Box.createGlue());
        jLabel = new JLabel("Strict:");
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Lenient:");
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Average:");
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jLabel = new JLabel("Recall");
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        this.recallStrictLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.recallStrictLbl, gridBagConstraints);
        this.recallLenientLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.recallLenientLbl, gridBagConstraints);
        this.recallAveLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.recallAveLbl, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jLabel = new JLabel("Precision");
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        this.precisionStrictLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.precisionStrictLbl, gridBagConstraints);
        this.precisionLenientLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.precisionLenientLbl, gridBagConstraints);
        this.precisionAveLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.precisionAveLbl, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        jLabel = new JLabel("F-Measure");
        this.resultsPane.add((Component)jLabel, gridBagConstraints);
        this.fmeasureStrictLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.fmeasureStrictLbl, gridBagConstraints);
        this.fmeasureLenientLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.fmeasureLenientLbl, gridBagConstraints);
        this.fmeasureAveLbl = new JLabel("0.0000");
        this.resultsPane.add((Component)this.fmeasureAveLbl, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        this.resultsPane.add((Component)new JButton(new HTMLExportAction()), gridBagConstraints);
        this.resultsPane.setBackground(Color.red);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)this.resultsPane, gridBagConstraints);
        this.progressBar = new JProgressBar();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        Color color = this.diffTable.getBackground();
        this.getContentPane().setBackground(color);
        this.scroller.setBackground(color);
        this.scroller.getViewport().setBackground(color);
        this.resultsPane.setBackground(color);
        this.featureslistModel = new DefaultListModel();
        this.featuresList = new JList(this.featureslistModel);
        this.featuresList.setSelectionMode(2);
    }

    protected void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                MainFrame.getGuiRoots().remove(AnnotationDiffGUI.this);
                AnnotationDiffGUI.this.dispose();
            }
        });
        this.keyDocCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Document document = (Document)AnnotationDiffGUI.this.documents.get(AnnotationDiffGUI.this.keyDocCombo.getSelectedIndex());
                if (AnnotationDiffGUI.this.keyDoc != document) {
                    AnnotationDiffGUI.this.pairings.clear();
                    AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                    AnnotationDiffGUI.this.keyDoc = document;
                    AnnotationDiffGUI.this.keySets = new ArrayList();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    AnnotationDiffGUI.this.keySets.add(AnnotationDiffGUI.this.keyDoc.getAnnotations());
                    arrayList.add("[Default set]");
                    if (AnnotationDiffGUI.this.keyDoc.getNamedAnnotationSets() != null) {
                        for (String string : AnnotationDiffGUI.this.keyDoc.getNamedAnnotationSets().keySet()) {
                            arrayList.add(string);
                            AnnotationDiffGUI.this.keySets.add(AnnotationDiffGUI.this.keyDoc.getAnnotations(string));
                        }
                    }
                    AnnotationDiffGUI.this.keySetCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                    if (!arrayList.isEmpty()) {
                        AnnotationDiffGUI.this.keySetCombo.setSelectedIndex(0);
                    }
                }
            }
        });
        this.resDocCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Document document = (Document)AnnotationDiffGUI.this.documents.get(AnnotationDiffGUI.this.resDocCombo.getSelectedIndex());
                if (AnnotationDiffGUI.this.resDoc != document) {
                    AnnotationDiffGUI.this.resDoc = document;
                    AnnotationDiffGUI.this.pairings.clear();
                    AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                    AnnotationDiffGUI.this.resSets = new ArrayList();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    AnnotationDiffGUI.this.resSets.add(AnnotationDiffGUI.this.resDoc.getAnnotations());
                    arrayList.add("[Default set]");
                    if (AnnotationDiffGUI.this.resDoc.getNamedAnnotationSets() != null) {
                        for (String string : AnnotationDiffGUI.this.resDoc.getNamedAnnotationSets().keySet()) {
                            arrayList.add(string);
                            AnnotationDiffGUI.this.resSets.add(AnnotationDiffGUI.this.resDoc.getAnnotations(string));
                        }
                    }
                    AnnotationDiffGUI.this.resSetCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                    if (!arrayList.isEmpty()) {
                        AnnotationDiffGUI.this.resSetCombo.setSelectedIndex(0);
                    }
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationDiffGUI.this.keySet = AnnotationDiffGUI.this.keySets == null || AnnotationDiffGUI.this.keySets.isEmpty() ? null : (AnnotationSet)AnnotationDiffGUI.this.keySets.get(AnnotationDiffGUI.this.keySetCombo.getSelectedIndex());
                AnnotationDiffGUI.this.resSet = AnnotationDiffGUI.this.resSets == null || AnnotationDiffGUI.this.resSets.isEmpty() ? null : (AnnotationSet)AnnotationDiffGUI.this.resSets.get(AnnotationDiffGUI.this.resSetCombo.getSelectedIndex());
                HashSet hashSet = AnnotationDiffGUI.this.keySet == null || AnnotationDiffGUI.this.keySet.isEmpty() ? new HashSet() : AnnotationDiffGUI.this.keySet.getAllTypes();
                HashSet hashSet2 = AnnotationDiffGUI.this.resSet == null || AnnotationDiffGUI.this.resSet.isEmpty() ? new HashSet() : AnnotationDiffGUI.this.resSet.getAllTypes();
                HashSet hashSet3 = new HashSet(hashSet);
                hashSet3.retainAll(hashSet2);
                ArrayList arrayList = new ArrayList(hashSet3);
                Collections.sort(arrayList);
                AnnotationDiffGUI.this.annTypeCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                if (arrayList.size() > 0) {
                    AnnotationDiffGUI.this.annTypeCombo.setSelectedIndex(0);
                }
            }
        };
        this.keySetCombo.addActionListener(actionListener);
        this.resSetCombo.addActionListener(actionListener);
        this.someFeaturesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AnnotationDiffGUI.this.someFeaturesBtn.isSelected()) {
                    Object object;
                    Serializable serializable;
                    if (AnnotationDiffGUI.this.keySet == null || AnnotationDiffGUI.this.keySet.isEmpty() || AnnotationDiffGUI.this.annTypeCombo.getSelectedItem() == null) {
                        return;
                    }
                    Iterator<Annotation> iterator = AnnotationDiffGUI.this.keySet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem()).iterator();
                    HashSet hashSet = new HashSet();
                    while (iterator.hasNext()) {
                        serializable = iterator.next();
                        object = serializable.getFeatures();
                        if (object == null) continue;
                        hashSet.addAll(object.keySet());
                    }
                    serializable = new ArrayList(hashSet);
                    Collections.sort(serializable);
                    AnnotationDiffGUI.this.featureslistModel.clear();
                    object = serializable.iterator();
                    int n = 0;
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        AnnotationDiffGUI.this.featureslistModel.addElement(string);
                        if (AnnotationDiffGUI.this.significantFeatures.contains(string)) {
                            AnnotationDiffGUI.this.featuresList.addSelectionInterval(n, n);
                        }
                        ++n;
                    }
                    int n2 = JOptionPane.showConfirmDialog(AnnotationDiffGUI.this, new JScrollPane(AnnotationDiffGUI.this.featuresList), "Select features", 2, 3);
                    if (n2 == 0) {
                        AnnotationDiffGUI.this.significantFeatures.clear();
                        int[] nArray = AnnotationDiffGUI.this.featuresList.getSelectedIndices();
                        for (int i = 0; i < nArray.length; ++i) {
                            AnnotationDiffGUI.this.significantFeatures.add(AnnotationDiffGUI.this.featureslistModel.get(nArray[i]));
                        }
                    }
                }
            }
        });
    }

    public void pack() {
        super.pack();
        this.setSize(this.getWidth(), this.getHeight() + 100);
    }

    protected void populateGUI() {
        try {
            this.documents = Gate.getCreoleRegister().getAllInstances("gate.Document");
        }
        catch (GateException gateException) {
            throw new GateRuntimeException(gateException);
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.documents.size());
        for (int i = 0; i < this.documents.size(); ++i) {
            Document document = (Document)this.documents.get(i);
            arrayList.add(document.getName());
        }
        this.keyDocCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.resDocCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (!this.documents.isEmpty()) {
            this.keyDocCombo.setSelectedIndex(0);
            this.resDocCombo.setSelectedIndex(0);
        }
    }

    static {
        AnnotationDiffGUI.matchLabel[0] = "=";
        AnnotationDiffGUI.matchLabel[1] = "~";
        AnnotationDiffGUI.matchLabel[4] = "<>";
        AnnotationDiffGUI.matchLabel[2] = "?-";
        AnnotationDiffGUI.matchLabel[3] = "-?";
    }

    protected class DiffTableModel
    extends AbstractTableModel {
        protected static final int COL_CNT = 9;
        protected static final int COL_KEY_START = 0;
        protected static final int COL_KEY_END = 1;
        protected static final int COL_KEY_STRING = 2;
        protected static final int COL_KEY_FEATURES = 3;
        protected static final int COL_MATCH = 4;
        protected static final int COL_RES_START = 5;
        protected static final int COL_RES_END = 6;
        protected static final int COL_RES_STRING = 7;
        protected static final int COL_RES_FEATURES = 8;

        protected DiffTableModel() {
        }

        public int getRowCount() {
            return AnnotationDiffGUI.this.pairings.size();
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public int getColumnCount() {
            return 9;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Start";
                }
                case 1: {
                    return "End";
                }
                case 2: {
                    return "Key";
                }
                case 3: {
                    return "Features";
                }
                case 4: {
                    return "";
                }
                case 5: {
                    return "Start";
                }
                case 6: {
                    return "End";
                }
                case 7: {
                    return "Response";
                }
                case 8: {
                    return "Features";
                }
            }
            return "?";
        }

        public Color getBackgroundAt(int n, int n2) {
            AnnotationDiffer.Pairing pairing = (AnnotationDiffer.Pairing)AnnotationDiffGUI.this.pairings.get(n);
            switch (pairing.getType()) {
                case 0: {
                    return AnnotationDiffGUI.this.diffTable.getBackground();
                }
                case 1: {
                    return PARTIALLY_CORRECT_BG;
                }
                case 4: {
                    if (n2 < 4) {
                        return MISSING_BG;
                    }
                    if (n2 > 4) {
                        return FALSE_POZITIVE_BG;
                    }
                    return AnnotationDiffGUI.this.diffTable.getBackground();
                }
                case 3: {
                    return MISSING_BG;
                }
                case 2: {
                    return FALSE_POZITIVE_BG;
                }
            }
            return AnnotationDiffGUI.this.diffTable.getBackground();
        }

        public Object getValueAt(int n, int n2) {
            AnnotationDiffer.Pairing pairing = (AnnotationDiffer.Pairing)AnnotationDiffGUI.this.pairings.get(n);
            Annotation annotation = pairing.getKey();
            String string = "";
            try {
                if (annotation != null && AnnotationDiffGUI.this.keyDoc != null) {
                    string = AnnotationDiffGUI.this.keyDoc.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                }
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
            Annotation annotation2 = pairing.getResponse();
            String string2 = "";
            try {
                if (annotation2 != null && AnnotationDiffGUI.this.resDoc != null) {
                    string2 = AnnotationDiffGUI.this.resDoc.getContent().getContent(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()).toString();
                }
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
            switch (n2) {
                case 0: {
                    return annotation == null ? "" : annotation.getStartNode().getOffset().toString();
                }
                case 1: {
                    return annotation == null ? "" : annotation.getEndNode().getOffset().toString();
                }
                case 2: {
                    return string;
                }
                case 3: {
                    return annotation == null ? "" : annotation.getFeatures().toString();
                }
                case 4: {
                    return matchLabel[pairing.getType()];
                }
                case 5: {
                    return annotation2 == null ? "" : annotation2.getStartNode().getOffset().toString();
                }
                case 6: {
                    return annotation2 == null ? "" : annotation2.getEndNode().getOffset().toString();
                }
                case 7: {
                    return string2;
                }
                case 8: {
                    return annotation2 == null ? "" : annotation2.getFeatures().toString();
                }
            }
            return "?";
        }
    }

    protected class DiffTableCellRenderer
    extends DefaultTableCellRenderer {
        protected DiffTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
            component.setBackground(bl ? jTable.getSelectionBackground() : AnnotationDiffGUI.this.diffTableModel.getBackgroundAt(AnnotationDiffGUI.this.diffTable.rowViewToModel(n), n2));
            component.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            return component;
        }
    }

    protected class HTMLExportAction
    extends AbstractAction {
        static final String HEADER_1 = "<html><head><title>";
        static final String HEADER_2 = "</title></head><body>";
        static final String HEADER_3 = "<table cellpadding=\"0\" border=\"1\">";
        static final String FOOTER = "</table></body></html>";

        public HTMLExportAction() {
            super("Export to HTML");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = MainFrame.getFileChooser();
            File file = jFileChooser.getSelectedFile();
            String string = Strings.getNl();
            String string2 = file != null ? file.getParent() : System.getProperty("user.home");
            String string3 = AnnotationDiffGUI.this.resDoc.getSourceUrl() != null ? AnnotationDiffGUI.this.resDoc.getSourceUrl().getFile() : AnnotationDiffGUI.this.resDoc.getName();
            string3 = string3 + "_" + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString();
            string3 = string3 + ".html";
            jFileChooser.setSelectedFile(new File(string2, string3));
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
            extensionFileFilter.addExtension(".html");
            jFileChooser.setFileFilter(extensionFileFilter);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showSaveDialog(AnnotationDiffGUI.this);
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                try {
                    int n2;
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                    bufferedWriter.write(HEADER_1);
                    bufferedWriter.write(AnnotationDiffGUI.this.resDoc.getName() + " " + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString() + " annotations");
                    bufferedWriter.write(HEADER_2 + string);
                    bufferedWriter.write("<H2>Annotation Diff - comparing " + AnnotationDiffGUI.this.annTypeCombo.getSelectedItem().toString() + " annotations" + "</H2>");
                    bufferedWriter.write("<TABLE cellpadding=\"5\" border=\"0\"");
                    bufferedWriter.write(string);
                    bufferedWriter.write("<TR>" + string);
                    bufferedWriter.write("\t<TH align=\"left\">&nbsp;</TH>" + string);
                    bufferedWriter.write("\t<TH align=\"left\">Document</TH>" + string);
                    bufferedWriter.write("\t<TH align=\"left\">Annotation Set</TH>" + string);
                    bufferedWriter.write("</TR>" + string);
                    bufferedWriter.write("<TR>" + string);
                    bufferedWriter.write("\t<TH align=\"left\">Key</TH>" + string);
                    bufferedWriter.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.keyDoc.getName() + "</TD>" + string);
                    bufferedWriter.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.keySet.getName() + "</TD>" + string);
                    bufferedWriter.write("</TR>" + string);
                    bufferedWriter.write("<TR>" + string);
                    bufferedWriter.write("\t<TH align=\"left\">Response</TH>" + string);
                    bufferedWriter.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.resDoc.getName() + "</TD>" + string);
                    bufferedWriter.write("\t<TD align=\"left\">" + AnnotationDiffGUI.this.resSet.getName() + "</TD>" + string);
                    bufferedWriter.write("</TR>" + string);
                    bufferedWriter.write("</TABLE>" + string);
                    bufferedWriter.write("<BR><BR><BR>" + string);
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(4);
                    bufferedWriter.write("Recall: " + numberFormat.format(AnnotationDiffGUI.this.differ.getRecallStrict()) + "<br>" + string);
                    bufferedWriter.write("Precision: " + numberFormat.format(AnnotationDiffGUI.this.differ.getPrecisionStrict()) + "<br>" + string);
                    bufferedWriter.write("F-measure: " + numberFormat.format(AnnotationDiffGUI.this.differ.getFMeasureStrict(1.0)) + "<br>" + string);
                    bufferedWriter.write("<br>");
                    bufferedWriter.write("Correct matches: " + AnnotationDiffGUI.this.differ.getCorrectMatches() + "<br>" + string);
                    bufferedWriter.write("Partially Correct matches: " + AnnotationDiffGUI.this.differ.getPartiallyCorrectMatches() + "<br>" + string);
                    bufferedWriter.write("Missing: " + AnnotationDiffGUI.this.differ.getMissing() + "<br>" + string);
                    bufferedWriter.write("False positives: " + AnnotationDiffGUI.this.differ.getSpurious() + "<br>" + string);
                    int[] nArray = new int[AnnotationDiffGUI.this.diffTableModel.getColumnCount()];
                    int n3 = -1;
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (AnnotationDiffGUI.this.diffTable.isColumnHidden(n2)) continue;
                        nArray[++n3] = n2;
                    }
                    bufferedWriter.write(HEADER_3 + string + "<TR>" + string);
                    for (n2 = 0; n2 <= n3; ++n2) {
                        bufferedWriter.write("\t<TH align=\"left\">" + AnnotationDiffGUI.this.diffTable.getColumnName(nArray[n2]) + "</TH>" + string);
                    }
                    bufferedWriter.write("</TR>");
                    n2 = AnnotationDiffGUI.this.diffTableModel.getRowCount();
                    for (int i = 0; i < n2; ++i) {
                        bufferedWriter.write("<TR>");
                        for (int j = 0; j <= n3; ++j) {
                            Color color = AnnotationDiffGUI.this.diffTableModel.getBackgroundAt(AnnotationDiffGUI.this.diffTable.rowViewToModel(i), AnnotationDiffGUI.this.diffTable.convertColumnIndexToModel(nArray[j]));
                            bufferedWriter.write("\t<TD bgcolor=\"#" + Integer.toHexString(color.getRGB()).substring(2) + "\">" + AnnotationDiffGUI.this.diffTable.getValueAt(i, nArray[j]) + "</TD>" + string);
                        }
                        bufferedWriter.write("</TR>");
                    }
                    bufferedWriter.write(FOOTER);
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(AnnotationDiffGUI.this, iOException.toString(), "GATE", 0);
                    iOException.printStackTrace();
                }
            }
        }
    }

    protected class DiffAction
    extends AbstractAction {
        public DiffAction() {
            super("Do Diff");
            this.putValue("ShortDescription", "Performs the diff");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationDiffGUI.this.progressBar.setIndeterminate(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    Cloneable cloneable = AnnotationDiffGUI.this.keySet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem());
                    Cloneable cloneable2 = AnnotationDiffGUI.this.resSet.get((String)AnnotationDiffGUI.this.annTypeCombo.getSelectedItem());
                    if (cloneable == null) {
                        cloneable = new HashSet();
                    }
                    if (cloneable2 == null) {
                        cloneable2 = new HashSet();
                    }
                    if (AnnotationDiffGUI.this.someFeaturesBtn.isSelected()) {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(AnnotationDiffGUI.this.significantFeatures);
                    } else if (AnnotationDiffGUI.this.allFeaturesBtn.isSelected()) {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(null);
                    } else {
                        AnnotationDiffGUI.this.differ.setSignificantFeaturesSet(new HashSet());
                    }
                    AnnotationDiffGUI.this.pairings.clear();
                    AnnotationDiffGUI.this.pairings.addAll(AnnotationDiffGUI.this.differ.calculateDiff((Collection)((Object)cloneable), (Collection)((Object)cloneable2)));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AnnotationDiffGUI.this.diffTableModel.fireTableDataChanged();
                            AnnotationDiffGUI.this.correctLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getCorrectMatches()));
                            AnnotationDiffGUI.this.partiallyCorrectLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getPartiallyCorrectMatches()));
                            AnnotationDiffGUI.this.missingLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getMissing()));
                            AnnotationDiffGUI.this.falsePozLbl.setText(Integer.toString(AnnotationDiffGUI.this.differ.getSpurious()));
                            NumberFormat numberFormat = NumberFormat.getInstance();
                            numberFormat.setMaximumFractionDigits(4);
                            numberFormat.setMinimumFractionDigits(2);
                            AnnotationDiffGUI.this.recallStrictLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getRecallStrict()));
                            AnnotationDiffGUI.this.recallLenientLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getRecallLenient()));
                            AnnotationDiffGUI.this.recallAveLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getRecallAverage()));
                            AnnotationDiffGUI.this.precisionStrictLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getPrecisionStrict()));
                            AnnotationDiffGUI.this.precisionLenientLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getPrecisionLenient()));
                            AnnotationDiffGUI.this.precisionAveLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getPrecisionAverage()));
                            double d = Double.parseDouble(AnnotationDiffGUI.this.weightTxt.getText());
                            AnnotationDiffGUI.this.fmeasureStrictLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getFMeasureStrict(d)));
                            AnnotationDiffGUI.this.fmeasureLenientLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getFMeasureLenient(d)));
                            AnnotationDiffGUI.this.fmeasureAveLbl.setText(numberFormat.format(AnnotationDiffGUI.this.differ.getFMeasureAverage(d)));
                            AnnotationDiffGUI.this.progressBar.setIndeterminate(false);
                        }
                    });
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(1);
            thread.start();
        }
    }
}

