/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.fsm.Transition;
import gate.jape.BasicPatternElement;
import gate.jape.JapeConstants;
import gate.jape.RightHandSide;
import gate.util.SimpleArraySet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
implements JapeConstants {
    private static final boolean DEBUG = false;
    private SimpleArraySet<Transition> transitions = new SimpleArraySet();
    protected boolean isFinal = false;
    protected RightHandSide action = null;
    protected int myIndex = index++;
    protected static int index = 0;
    protected int fileIndex = 0;
    protected int priority = -1;

    public boolean isFinal() {
        return this.isFinal;
    }

    public SimpleArraySet<Transition> getTransitions() {
        return this.transitions;
    }

    protected void setAction(RightHandSide rightHandSide) {
        this.action = rightHandSide;
        this.isFinal = this.action != null;
    }

    protected void setFileIndex(int n) {
        this.fileIndex = n;
    }

    protected void setPriority(int n) {
        this.priority = n;
    }

    public RightHandSide getAction() {
        return this.action;
    }

    int getFileIndex() {
        return this.fileIndex;
    }

    int getPriority() {
        return this.priority;
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    protected int getIndex() {
        return this.myIndex;
    }

    public String getEdgesGML() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        for (Transition transition : this.transitions) {
            stringBuffer.append("edge [ source ");
            stringBuffer.append(this.myIndex);
            stringBuffer.append(" target ");
            stringBuffer.append(transition.getTarget().getIndex());
            stringBuffer.append(" label \"");
            stringBuffer.append(transition.shortDesc());
            stringBuffer.append(":");
            BasicPatternElement basicPatternElement = transition.getConstraints();
            if (basicPatternElement == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(basicPatternElement.shortDesc());
            }
            stringBuffer.append(" :");
            stringBuffer.append(transition.getBindings());
            stringBuffer.append("\" ]\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.isFinal()) {
            stringBuffer.append("\nFinal!");
        }
        stringBuffer.append("\nTransitions:\n");
        Iterator<Transition> iterator = this.transitions.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Object)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }
}

