/*
 * Decompiled with CFR 0.152.
 */
package gate.fsm;

import gate.FeatureMap;
import gate.Gate;
import gate.fsm.State;
import gate.fsm.Transition;
import gate.jape.BasicPatternElement;
import gate.jape.ComplexPatternElement;
import gate.jape.Constraint;
import gate.jape.JapeConstants;
import gate.jape.LeftHandSide;
import gate.jape.PatternElement;
import gate.jape.PrioritisedRuleList;
import gate.jape.RightHandSide;
import gate.jape.Rule;
import gate.jape.SinglePhaseTransducer;
import gate.util.SimpleArraySet;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSM
implements JapeConstants {
    private static final boolean DEBUG = false;
    protected State currentState;
    protected Transition currentTransition;
    private State initialState;
    protected State finalState;
    private transient Collection allStates = new HashSet();
    private transient Map<AbstractSet, State> newStates = new HashMap<AbstractSet, State>();
    private transient Set<AbstractSet> dStates = new HashSet<AbstractSet>();
    int bpeId = 0;
    public HashMap<String, String> ruleHash = new HashMap();

    protected FSM() {
        this.initialState = new State();
    }

    public FSM(SinglePhaseTransducer singlePhaseTransducer) {
        this();
        this.addRules(singlePhaseTransducer.getRules());
    }

    protected void addRules(PrioritisedRuleList prioritisedRuleList) {
        Iterator iterator = prioritisedRuleList.iterator();
        while (iterator.hasNext()) {
            FSM fSM = this.spawn((Rule)iterator.next());
            if (Gate.isEnableJapeDebug()) {
                this.ruleHash.putAll(fSM.ruleHash);
            }
            this.initialState.addTransition(new Transition(null, fSM.getInitialState()));
        }
        this.eliminateVoidTransitions();
    }

    public FSM(Rule rule) {
        this();
        this.setRule(rule);
    }

    protected void setRule(Rule rule) {
        PatternElement[][] patternElementArray;
        LeftHandSide leftHandSide = rule.getLHS();
        LinkedList<String> linkedList = new LinkedList<String>();
        if (Gate.isEnableJapeDebug()) {
            patternElementArray = this.currentLHSBinding(leftHandSide);
            linkedList.add((String)patternElementArray);
            this.ruleHash.put(rule.getName(), (String)patternElementArray);
        }
        patternElementArray = leftHandSide.getConstraintGroup().getPatternElementDisjunction();
        State state = new State();
        for (int i = 0; i < patternElementArray.length; ++i) {
            State state2 = this.initialState;
            for (int j = 0; j < patternElementArray[i].length; ++j) {
                PatternElement patternElement = patternElementArray[i][j];
                State state3 = new State();
                state2.addTransition(new Transition(null, state3));
                state2 = state3;
                if (patternElement instanceof BasicPatternElement) {
                    State state4 = new State();
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    if (Gate.isEnableJapeDebug()) {
                        linkedList2.add(this.currentBasicBinding((BasicPatternElement)patternElement));
                        state2.addTransition(new Transition((BasicPatternElement)patternElement, state4, linkedList2));
                    } else {
                        state2.addTransition(new Transition((BasicPatternElement)patternElement, state4));
                    }
                    state2 = state4;
                    continue;
                }
                if (patternElement instanceof ComplexPatternElement) {
                    if (Gate.isEnableJapeDebug()) {
                        state2 = this.convertComplexPE(state2, (ComplexPatternElement)patternElement, linkedList);
                        continue;
                    }
                    state2 = this.convertComplexPE(state2, (ComplexPatternElement)patternElement, new LinkedList<String>());
                    continue;
                }
                throw new RuntimeException("Strange looking pattern: " + patternElement);
            }
            state2.addTransition(new Transition(null, state));
            state.setAction(rule.getRHS());
            state.setFileIndex(rule.getPosition());
            state.setPriority(rule.getPriority());
        }
    }

    protected FSM(ComplexPatternElement complexPatternElement) {
        this();
        this.finalState = this.convertComplexPE(this.initialState, complexPatternElement, new LinkedList<String>());
        this.finalState.isFinal = true;
    }

    protected FSM spawn(Rule rule) {
        return new FSM(rule);
    }

    protected FSM spawn(ComplexPatternElement complexPatternElement) {
        return new FSM(complexPatternElement);
    }

    public State getInitialState() {
        return this.initialState;
    }

    private State convertComplexPE(State state, ComplexPatternElement complexPatternElement, LinkedList<String> linkedList) {
        int n;
        LinkedList linkedList2 = (LinkedList)linkedList.clone();
        String string = complexPatternElement.getBindingName();
        if (string != null) {
            linkedList2.add(string);
        }
        PatternElement[][] patternElementArray = complexPatternElement.getConstraintGroup().getPatternElementDisjunction();
        State state2 = new State();
        for (n = 0; n < patternElementArray.length; ++n) {
            State state3 = state;
            for (int i = 0; i < patternElementArray[n].length; ++i) {
                State state4 = new State();
                state3.addTransition(new Transition(null, state4));
                state3 = state4;
                PatternElement patternElement = patternElementArray[n][i];
                if (patternElement instanceof BasicPatternElement) {
                    State state5 = new State();
                    if (Gate.isEnableJapeDebug()) {
                        linkedList2.add(this.currentBasicBinding((BasicPatternElement)patternElement));
                    }
                    state3.addTransition(new Transition((BasicPatternElement)patternElement, state5, linkedList2));
                    state3 = state5;
                    continue;
                }
                if (patternElement instanceof ComplexPatternElement) {
                    state3 = this.convertComplexPE(state3, (ComplexPatternElement)patternElement, linkedList2);
                    continue;
                }
                throw new RuntimeException("Strange looking pattern:" + patternElement);
            }
            state3.addTransition(new Transition(null, state2));
        }
        n = complexPatternElement.getKleeneOp();
        switch (n) {
            case 0: {
                break;
            }
            case 3: {
                state.addTransition(new Transition(null, state2));
                break;
            }
            case 2: {
                state2.addTransition(new Transition(null, state));
                break;
            }
            case 1: {
                state.addTransition(new Transition(null, state2));
                state2.addTransition(new Transition(null, state));
                break;
            }
            default: {
                throw new RuntimeException("Unknown Kleene operator" + n);
            }
        }
        return state2;
    }

    public void eliminateVoidTransitions() {
        this.dStates.clear();
        LinkedList<AbstractSet> linkedList = new LinkedList<AbstractSet>();
        AbstractSet abstractSet = new HashSet<State>();
        this.newStates.clear();
        abstractSet.add(this.initialState);
        abstractSet = this.lambdaClosure(abstractSet);
        this.dStates.add(abstractSet);
        linkedList.add(abstractSet);
        this.initialState = new State();
        this.newStates.put(abstractSet, this.initialState);
        Iterator iterator = abstractSet.iterator();
        RightHandSide rightHandSide = null;
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            if (!state.isFinal()) continue;
            rightHandSide = state.getAction();
            this.initialState.setAction(rightHandSide);
            this.initialState.setFileIndex(state.getFileIndex());
            this.initialState.setPriority(state.getPriority());
            break;
        }
        while (!linkedList.isEmpty()) {
            abstractSet = (AbstractSet)linkedList.removeFirst();
            for (State state : abstractSet) {
                for (Transition transition : state.getTransitions()) {
                    State state22;
                    State state3;
                    if (transition.getConstraints() == null) continue;
                    State state4 = transition.getTarget();
                    AbstractSet abstractSet2 = new HashSet<State>();
                    abstractSet2.add(state4);
                    abstractSet2 = this.lambdaClosure(abstractSet2);
                    if (!this.dStates.contains(abstractSet2)) {
                        this.dStates.add(abstractSet2);
                        linkedList.add(abstractSet2);
                        state3 = new State();
                        this.newStates.put(abstractSet2, state3);
                        for (State state22 : abstractSet2) {
                            if (!state22.isFinal()) continue;
                            state3.setAction(state22.getAction());
                            state3.setFileIndex(state22.getFileIndex());
                            state3.setPriority(state22.getPriority());
                            break;
                        }
                    }
                    state3 = this.newStates.get(abstractSet);
                    state22 = this.newStates.get(abstractSet2);
                    state3.addTransition(new Transition(transition.getConstraints(), state22, transition.getBindings()));
                }
            }
        }
        this.allStates = this.newStates.values();
    }

    private AbstractSet<State> lambdaClosure(AbstractSet<State> abstractSet) {
        LinkedList<State> linkedList = new LinkedList<State>(abstractSet);
        HashSet<State> hashSet = new HashSet<State>(abstractSet);
        while (!linkedList.isEmpty()) {
            State state = linkedList.removeFirst();
            for (Transition transition : state.getTransitions()) {
                State state2;
                if (transition.getConstraints() != null || ((AbstractCollection)hashSet).contains(state2 = transition.getTarget())) continue;
                ((AbstractCollection)hashSet).add(state2);
                linkedList.addFirst(state2);
            }
        }
        return hashSet;
    }

    protected void forEachState(Runnable runnable) {
        HashSet<State> hashSet = new HashSet<State>();
        HashSet<State> hashSet2 = new HashSet<State>();
        hashSet.add(this.initialState);
        while (!hashSet.isEmpty()) {
            this.currentState = (State)hashSet.iterator().next();
            hashSet.remove(this.currentState);
            hashSet2.add(this.currentState);
            Iterator<Transition> iterator = this.currentState.getTransitions().iterator();
            while (iterator.hasNext()) {
                Transition transition;
                this.currentTransition = transition = iterator.next();
                State state = this.currentTransition.getTarget();
                if (hashSet2.contains(state) || hashSet.contains(state)) continue;
                hashSet.add(state);
                runnable.run();
            }
        }
    }

    public Map<State, SimpleArraySet<Transition>> getAllStates() {
        HashMap<State, SimpleArraySet<Transition>> hashMap = new HashMap<State, SimpleArraySet<Transition>>();
        HashSet<State> hashSet = new HashSet<State>();
        HashSet<State> hashSet2 = new HashSet<State>();
        hashSet.add(this.initialState);
        while (!hashSet.isEmpty()) {
            this.currentState = (State)hashSet.iterator().next();
            hashSet.remove(this.currentState);
            hashSet2.add(this.currentState);
            SimpleArraySet<Transition> simpleArraySet = this.currentState.getTransitions();
            hashMap.put(this.currentState, simpleArraySet);
            for (Transition this.currentTransition : simpleArraySet) {
                State state = this.currentTransition.getTarget();
                if (hashSet2.contains(state) || hashSet.contains(state)) continue;
                hashSet.add(state);
            }
        }
        return hashMap;
    }

    public String asGraphViz(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph G {\n");
        for (State state : this.getAllStates().keySet()) {
            int n = state.getIndex();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("shape", state == this.initialState ? "diamond" : "circle");
            hashMap.put("color", state == this.initialState ? "green" : (state.isFinal() ? "red" : "black"));
            if (state.isFinal()) {
                hashMap.put("peripheries", "2");
            }
            stringBuffer.append("  " + n + " [" + this.encodeForGraphViz(hashMap) + "]" + ";\n");
            for (Transition transition : state.getTransitions()) {
                String string = bl ? " [label=\"" + transition.toString(false) + "\"]" : "";
                stringBuffer.append("  " + n + " -> " + transition.getTarget().getIndex() + string + ";\n");
            }
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    String encodeForGraphViz(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            string2 = string2.replaceAll("\r\n", "\\\\l");
            string2 = string2.replaceAll("\"", "\\\\\"");
            arrayList.add(string + "=\"" + string2 + "\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    public String getGML() {
        String string = "graph[ \ndirected 1\n";
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        for (State state : this.allStates) {
            int n = state.getIndex();
            stringBuffer.append("node[ id ");
            stringBuffer.append(n);
            stringBuffer.append(" label \"");
            stringBuffer.append(n);
            if (state.isFinal()) {
                stringBuffer.append(",F\\n" + state.getAction().shortDesc());
            }
            stringBuffer.append("\"  ]\n");
            stringBuffer2.append(state.getEdgesGML());
        }
        string = string + stringBuffer.toString() + stringBuffer2.toString() + "]\n";
        return string;
    }

    public String toString() {
        String string = "Starting from:" + this.initialState.getIndex() + "\n";
        Iterator iterator = this.allStates.iterator();
        while (iterator.hasNext()) {
            string = string + "\n\n" + iterator.next();
        }
        return string;
    }

    private String currentBinding(ComplexPatternElement complexPatternElement, int n) {
        if (n == 0) {
            this.bpeId = 0;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "   ";
        }
        String string2 = string + "(\n";
        PatternElement[][] patternElementArray = complexPatternElement.getConstraintGroup().getPatternElementDisjunction();
        for (int i = 0; i < patternElementArray.length; ++i) {
            PatternElement[] patternElementArray2 = patternElementArray[i];
            for (int j = 0; j < patternElementArray2.length; ++j) {
                PatternElement patternElement;
                PatternElement patternElement2 = patternElementArray2[j];
                if (patternElement2 instanceof ComplexPatternElement) {
                    patternElement = (ComplexPatternElement)patternElement2;
                    string2 = string2 + this.currentBinding((ComplexPatternElement)patternElement, n + 1);
                    continue;
                }
                string2 = string2 + string + "   {";
                patternElement = (BasicPatternElement)patternElement2;
                Constraint[] constraintArray = ((BasicPatternElement)patternElement).getConstraints();
                for (int k = 0; k < constraintArray.length; ++k) {
                    Constraint constraint = constraintArray[k];
                    String string3 = constraint.getAnnotType();
                    FeatureMap featureMap = constraint.getAttributeSeq();
                    Iterator iterator = featureMap.keySet().iterator();
                    if (!iterator.hasNext()) {
                        string2 = string2 + string3 + ",";
                    }
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        string2 = string2 + string3 + "." + string4 + "==\"" + featureMap.get(string4) + "\",";
                    }
                }
                string2 = string2.substring(0, string2.length() - 1);
                string2 = string2 + "} *" + this.bpeId++ + "*" + "\n";
            }
            string2 = string2 + string + "   |\n";
        }
        String string5 = "";
        int n2 = complexPatternElement.getKleeneOp();
        if (n2 == 2) {
            string5 = "+";
        }
        if (n2 == 3) {
            string5 = "?";
        }
        if (n2 == 1) {
            string5 = "*";
        }
        string2 = string2.substring(0, string2.length() - 5);
        string2 = string2 + ")" + string5 + "\n";
        if (n == 0) {
            this.bpeId = 0;
        }
        return string2;
    }

    private String currentBasicBinding(BasicPatternElement basicPatternElement) {
        String string = "";
        string = string + "{";
        Constraint[] constraintArray = basicPatternElement.getConstraints();
        for (int i = 0; i < constraintArray.length; ++i) {
            Constraint constraint = constraintArray[i];
            String string2 = constraint.getAnnotType();
            FeatureMap featureMap = constraint.getAttributeSeq();
            Iterator iterator = featureMap.keySet().iterator();
            if (!iterator.hasNext()) {
                string = string + string2 + ",";
            }
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                string = string + string2 + "." + string3 + "==\"" + featureMap.get(string3) + "\",";
            }
        }
        string = string.substring(0, string.length() - 1);
        string = string + "} *" + this.bpeId++ + "*";
        return string;
    }

    private String currentLHSBinding(LeftHandSide leftHandSide) {
        String string = "(\n";
        PatternElement[][] patternElementArray = leftHandSide.getConstraintGroup().getPatternElementDisjunction();
        for (int i = 0; i < patternElementArray.length; ++i) {
            PatternElement[] patternElementArray2 = patternElementArray[i];
            for (int j = 0; j < patternElementArray2.length; ++j) {
                PatternElement patternElement;
                PatternElement patternElement2 = patternElementArray2[j];
                if (patternElement2 instanceof ComplexPatternElement) {
                    patternElement = (ComplexPatternElement)patternElement2;
                    string = string + this.currentBinding((ComplexPatternElement)patternElement, 1);
                    continue;
                }
                string = string + "   {";
                patternElement = (BasicPatternElement)patternElement2;
                Constraint[] constraintArray = ((BasicPatternElement)patternElement).getConstraints();
                for (int k = 0; k < constraintArray.length; ++k) {
                    Constraint constraint = constraintArray[k];
                    String string2 = constraint.getAnnotType();
                    FeatureMap featureMap = constraint.getAttributeSeq();
                    Iterator iterator = featureMap.keySet().iterator();
                    if (!iterator.hasNext()) {
                        string = string + string2 + ",";
                    }
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        string = string + string2 + "." + string3 + "==\"" + featureMap.get(string3) + "\",";
                    }
                }
                string = string.substring(0, string.length() - 1);
                string = string + "} *" + this.bpeId++ + "*" + "\n";
            }
            string = string + "   |\n";
        }
        string = string.substring(0, string.length() - 5);
        string = string + ")\n";
        this.bpeId = 0;
        return string;
    }
}

