/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.tokeniser;

import gate.creole.tokeniser.InvalidRuleException;
import gate.creole.tokeniser.SimpleTokeniser;
import gate.creole.tokeniser.TokeniserException;
import gate.creole.tokeniser.UnicodeType;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.StringTokenizer;

class DFSMState
implements Serializable {
    private static final boolean DEBUG = false;
    String[][] tokenDesc;
    DFSMState[] transitionFunction = new DFSMState[SimpleTokeniser.maxTypeId];
    String rhs;
    int myIndex = index++;
    static int index = 0;

    public DFSMState(SimpleTokeniser simpleTokeniser) {
        simpleTokeniser.dfsmStates.add(this);
    }

    void put(UnicodeType unicodeType, DFSMState dFSMState) {
        this.put(unicodeType.type, dFSMState);
    }

    void put(int n, DFSMState dFSMState) {
        this.transitionFunction[n] = dFSMState;
    }

    DFSMState next(int n) {
        return this.transitionFunction[n];
    }

    String getEdgesGML() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        for (int i = 0; i < this.transitionFunction.length; ++i) {
            DFSMState dFSMState = this.transitionFunction[i];
            if (null == dFSMState) continue;
            stringBuffer.append("edge [ source ");
            stringBuffer.append(this.myIndex);
            stringBuffer.append(" target ");
            stringBuffer.append(dFSMState.getIndex());
            stringBuffer.append(" label \"");
            stringBuffer.append(SimpleTokeniser.typeMnemonics[i]);
            stringBuffer.append("\" ]\n");
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void buildTokenDesc() throws TokeniserException {
        String string = " \t\f";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.rhs, string + "\\\";=", true);
        boolean bl = false;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = SimpleTokeniser.skipIgnoreTokens(stringTokenizer);
            if (string2.equals("\\")) {
                if (null == stringBuffer) {
                    stringBuffer = new StringBuffer(stringTokenizer.nextToken());
                    continue;
                }
                stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            if (null != stringBuffer) {
                stringBuffer2.append(stringBuffer.toString());
                stringBuffer = null;
            }
            if (string2.equals("\"")) {
                stringBuffer2 = new StringBuffer(stringTokenizer.nextToken("\""));
                if (stringBuffer2.equals("\"")) {
                    stringBuffer2 = new StringBuffer(1024);
                } else {
                    stringTokenizer.nextToken(string + "\\\";=");
                }
            } else if (string2.equals("=")) {
                if (n != true) throw new TokeniserException("Invalid attribute format: " + stringBuffer2);
                string4 = stringBuffer2.toString();
                stringBuffer2 = new StringBuffer(1024);
                n = 2;
            } else if (string2.equals(";")) {
                if (n == 0) {
                    string3 = stringBuffer2.toString();
                    stringBuffer2 = new StringBuffer(1024);
                    linkedList.addLast(string3);
                    linkedList2.addLast("");
                    n = 1;
                } else {
                    if (n != 2) throw new TokeniserException("Invalid value format: " + stringBuffer2);
                    string5 = stringBuffer2.toString();
                    stringBuffer2 = new StringBuffer(1024);
                    n = 3;
                }
            } else {
                stringBuffer2.append(string2);
            }
            if (n != 3) continue;
            linkedList.addLast(string4);
            linkedList2.addLast(string5);
            n = 1;
        }
        if (linkedList.size() < 1) {
            throw new InvalidRuleException("Invalid right hand side " + this.rhs);
        }
        this.tokenDesc = new String[linkedList.size()][2];
        for (int i = 0; i < linkedList.size(); ++i) {
            this.tokenDesc[i][0] = (String)linkedList.get(i);
            this.tokenDesc[i][1] = (String)linkedList2.get(i);
        }
    }

    void setRhs(String string) {
        this.rhs = string;
    }

    String getRhs() {
        return this.rhs;
    }

    boolean isFinal() {
        return null != this.rhs;
    }

    int getIndex() {
        return this.myIndex;
    }

    String[][] getTokenDesc() {
        return this.tokenDesc;
    }
}

