/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.splitter;

import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.AbstractProcessingResource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ResourceInstantiationException;
import gate.creole.Transducer;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.event.StatusListener;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.net.URL;

public class SentenceSplitter
extends AbstractLanguageAnalyser {
    public static final String SPLIT_DOCUMENT_PARAMETER_NAME = "document";
    public static final String SPLIT_INPUT_AS_PARAMETER_NAME = "inputASName";
    public static final String SPLIT_OUTPUT_AS_PARAMETER_NAME = "outputASName";
    public static final String SPLIT_ENCODING_PARAMETER_NAME = "encoding";
    public static final String SPLIT_GAZ_URL_PARAMETER_NAME = "gazetteerListsURL";
    public static final String SPLIT_TRANSD_URL_PARAMETER_NAME = "transducerURL";
    DefaultGazetteer gazetteer;
    Transducer transducer;
    private URL transducerURL;
    private String encoding;
    private URL gazetteerListsURL;
    private static final boolean DEBUG = false;
    private String inputASName;
    private String outputASName;

    public Resource init() throws ResourceInstantiationException {
        this.fireStatusChanged("Creating the gazetteer");
        FeatureMap featureMap = Factory.newFeatureMap();
        if (this.gazetteerListsURL != null) {
            featureMap.put("listsURL", this.gazetteerListsURL);
        }
        featureMap.put(SPLIT_ENCODING_PARAMETER_NAME, this.encoding);
        FeatureMap featureMap2 = Factory.newFeatureMap();
        Gate.setHiddenAttribute(featureMap2, true);
        this.gazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", featureMap, featureMap2);
        this.gazetteer.setName("Gazetteer " + System.currentTimeMillis());
        this.fireProgressChanged(10);
        this.fireStatusChanged("Creating the JAPE transducer");
        featureMap = Factory.newFeatureMap();
        if (this.transducerURL != null) {
            featureMap.put("grammarURL", this.transducerURL);
        }
        featureMap.put(SPLIT_ENCODING_PARAMETER_NAME, this.encoding);
        featureMap2 = Factory.newFeatureMap();
        Gate.setHiddenAttribute(featureMap2, true);
        this.transducer = (Transducer)Factory.createResource("gate.creole.Transducer", featureMap, featureMap2);
        this.transducer.setName("Transducer " + System.currentTimeMillis());
        this.fireProgressChanged(100);
        this.fireProcessFinished();
        return this;
    }

    public void execute() throws ExecutionException {
        AnnotationSet annotationSet;
        AnnotationSet annotationSet2;
        this.interrupted = false;
        if (this.inputASName != null && this.inputASName.equals("")) {
            this.inputASName = null;
        }
        if (this.outputASName != null && this.outputASName.equals("")) {
            this.outputASName = null;
        }
        try {
            this.fireProgressChanged(0);
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put(SPLIT_DOCUMENT_PARAMETER_NAME, this.document);
            featureMap.put("annotationSetName", this.inputASName);
            this.gazetteer.setParameterValues(featureMap);
            featureMap = Factory.newFeatureMap();
            featureMap.put(SPLIT_DOCUMENT_PARAMETER_NAME, this.document);
            featureMap.put(SPLIT_INPUT_AS_PARAMETER_NAME, this.inputASName);
            featureMap.put(SPLIT_OUTPUT_AS_PARAMETER_NAME, this.inputASName);
            this.transducer.setParameterValues(featureMap);
        }
        catch (Exception exception) {
            throw new ExecutionException(exception);
        }
        AbstractProcessingResource.IntervalProgressListener intervalProgressListener = null;
        StatusListener statusListener = null;
        this.fireProgressChanged(5);
        if (this.isInterrupted()) {
            throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" sentence splitter has been abruptly interrupted!");
        }
        intervalProgressListener = new AbstractProcessingResource.IntervalProgressListener(5, 10);
        statusListener = new StatusListener(){

            public void statusChanged(String string) {
                SentenceSplitter.this.fireStatusChanged(string);
            }
        };
        this.gazetteer.addProgressListener(intervalProgressListener);
        this.gazetteer.addStatusListener(statusListener);
        this.gazetteer.execute();
        this.gazetteer.removeProgressListener(intervalProgressListener);
        this.gazetteer.removeStatusListener(statusListener);
        if (this.isInterrupted()) {
            throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" sentence splitter has been abruptly interrupted!");
        }
        intervalProgressListener = new AbstractProcessingResource.IntervalProgressListener(11, 90);
        this.transducer.addProgressListener(intervalProgressListener);
        this.transducer.addStatusListener(statusListener);
        this.transducer.execute();
        this.transducer.removeProgressListener(intervalProgressListener);
        this.transducer.removeStatusListener(statusListener);
        AnnotationSet annotationSet3 = this.inputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.inputASName);
        AnnotationSet annotationSet4 = annotationSet2 = this.outputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName);
        if (annotationSet3 != annotationSet2) {
            annotationSet2.addAll(annotationSet3.get("Sentence"));
        }
        if ((annotationSet = annotationSet2.get("Sentence")) == null || annotationSet.isEmpty()) {
            try {
                annotationSet2.add(new Long(0L), this.document.getContent().size(), "Sentence", Factory.newFeatureMap());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
        Long l = annotationSet.lastNode().getOffset();
        AnnotationSet annotationSet5 = annotationSet3.get("Token", l, annotationSet3.lastNode().getOffset());
        if (annotationSet5 != null && !annotationSet5.isEmpty()) {
            try {
                annotationSet2.add(annotationSet5.firstNode().getOffset(), annotationSet5.lastNode().getOffset(), "Sentence", Factory.newFeatureMap());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new ExecutionException(invalidOffsetException);
            }
        }
        this.fireProcessFinished();
    }

    public synchronized void interrupt() {
        this.interrupted = true;
        this.gazetteer.interrupt();
        this.transducer.interrupt();
    }

    public void setTransducerURL(URL uRL) {
        this.transducerURL = uRL;
    }

    public URL getTransducerURL() {
        return this.transducerURL;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setGazetteerListsURL(URL uRL) {
        this.gazetteerListsURL = uRL;
    }

    public URL getGazetteerListsURL() {
        return this.gazetteerListsURL;
    }

    public void setInputASName(String string) {
        this.inputASName = string;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    public void setOutputASName(String string) {
        this.outputASName = string;
    }

    public String getOutputASName() {
        return this.outputASName;
    }
}

