/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.orthomatcher;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.SimpleAnnotation;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import gate.util.Out;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrthoMatcher
extends AbstractLanguageAnalyser
implements ANNIEConstants {
    public static final String OM_DOCUMENT_PARAMETER_NAME = "document";
    public static final String OM_ANN_SET_PARAMETER_NAME = "annotationSetName";
    public static final String OM_CASE_SENSITIVE_PARAMETER_NAME = "caseSensitive";
    public static final String OM_ANN_TYPES_PARAMETER_NAME = "annotationTypes";
    public static final String OM_ORG_TYPE_PARAMETER_NAME = "organizationType";
    public static final String OM_PERSON_TYPE_PARAMETER_NAME = "personType";
    public static final String OM_EXT_LISTS_PARAMETER_NAME = "extLists";
    protected static final String CDGLISTNAME = "cdg";
    protected static final String ALIASLISTNAME = "alias";
    protected static final String ARTLISTNAME = "def_art";
    protected static final String PREPLISTNAME = "prepos";
    protected static final String CONNECTORLISTNAME = "connector";
    protected static final String SPURLISTNAME = "spur_match";
    protected static final String PUNCTUATION_VALUE = "punctuation";
    protected static final String THE_VALUE = "The";
    protected String annotationSetName;
    protected List annotationTypes = new ArrayList(10);
    protected String organizationType = "Organization";
    protected String personType = "Person";
    protected String unknownType = "Unknown";
    protected boolean extLists = true;
    protected boolean matchingUnknowns = true;
    private boolean allMatchingNeeded = false;
    protected boolean caseSensitive = false;
    protected FeatureMap queryFM = Factory.newFeatureMap();
    protected HashMap alias = new HashMap(100);
    protected HashSet cdg = new HashSet(50);
    protected HashMap spur_match = new HashMap(100);
    protected HashMap def_art = new HashMap(20);
    protected HashMap connector = new HashMap(20);
    protected HashMap prepos = new HashMap(30);
    protected AnnotationSet nameAllAnnots = null;
    protected HashMap processedAnnots = new HashMap(150);
    protected HashMap annots2Remove = new HashMap(75);
    protected List matchesDocFeature = new ArrayList();
    protected HashMap tokensMap = new HashMap(150);
    protected Annotation shortAnnot;
    protected Annotation longAnnot;
    protected ArrayList tokensLongAnnot;
    protected ArrayList tokensShortAnnot;
    protected FeatureMap tempMap = Factory.newFeatureMap();
    private static final int BUFF_SIZE = 65000;
    private URL definitionFileURL;
    private String encoding;

    public OrthoMatcher() {
        this.annotationTypes.add(this.organizationType);
        this.annotationTypes.add(this.personType);
        this.annotationTypes.add("Location");
        this.annotationTypes.add("Date");
    }

    public Resource init() throws ResourceInstantiationException {
        if (this.definitionFileURL == null) {
            throw new ResourceInstantiationException("No URL provided for the definition file!");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.definitionFileURL.openStream(), this.encoding));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(":");
                if (n == -1) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                this.createAnnotList(string2, string3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ExecutionException {
        try {
            if (this.document == null) {
                throw new ExecutionException("No document for namematch!");
            }
            this.nameAllAnnots = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
            if (this.nameAllAnnots == null || this.nameAllAnnots.isEmpty()) {
                Out.prln("OrthoMatcher Warning: No annotations found for processing");
                return;
            }
            this.docCleanup();
            HashMap<String, List> hashMap = (HashMap<String, List>)this.document.getFeatures().get("MatchesAnnots");
            if (!this.extLists) {
                this.buildTables(this.nameAllAnnots);
            }
            this.matchNameAnnotations();
            if (this.matchingUnknowns) {
                this.matchUnknown();
            }
            if (!this.matchesDocFeature.isEmpty()) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, List>();
                }
                hashMap.put(this.nameAllAnnots.getName(), this.matchesDocFeature);
                this.document.getFeatures().put("MatchesAnnots", hashMap);
                this.matchesDocFeature = new ArrayList();
            }
        }
        finally {
            this.nameAllAnnots = null;
            this.processedAnnots.clear();
            this.annots2Remove.clear();
            this.tokensMap.clear();
            this.matchesDocFeature = new ArrayList();
            this.longAnnot = null;
            this.shortAnnot = null;
            this.tokensLongAnnot = null;
            this.tokensShortAnnot = null;
        }
    }

    protected void matchNameAnnotations() throws ExecutionException {
        for (String string : this.annotationTypes) {
            AnnotationSet annotationSet;
            AnnotationSet annotationSet2 = this.nameAllAnnots.get(string);
            if (annotationSet2.isEmpty() || (annotationSet = this.nameAllAnnots.get("Token")).isEmpty()) continue;
            for (Annotation annotation : annotationSet2) {
                ArrayList<Annotation> arrayList;
                Integer n = annotation.getId();
                String string2 = null;
                try {
                    string2 = this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                    string2 = string2.replaceAll("\\s+", " ");
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new ExecutionException("Invalid offset of the annotation");
                }
                if (!this.caseSensitive) {
                    string2 = string2.toLowerCase();
                }
                if ((arrayList = new ArrayList<Annotation>(annotationSet.getContained(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()))).isEmpty()) continue;
                Collections.sort(arrayList, new OffsetComparator());
                this.tokensMap.put(annotation.getId(), arrayList);
                if (this.processedAnnots.containsValue(string2)) {
                    this.updateMatches(annotation, string2);
                    this.processedAnnots.put(annotation.getId(), string2);
                    continue;
                }
                if (this.processedAnnots.isEmpty()) {
                    this.processedAnnots.put(annotation.getId(), string2);
                    continue;
                }
                if (annotation.getType().equals(this.personType)) {
                    string2 = this.containTitle(string2, annotation);
                } else if (annotation.getType().equals(this.organizationType)) {
                    string2 = this.stripCDG(string2, annotation);
                }
                if (null == string2 || "".equals(string2)) continue;
                this.matchWithPrevious(annotation, string2);
                this.processedAnnots.put(annotation.getId(), string2);
            }
        }
    }

    protected void matchUnknown() throws ExecutionException {
        Comparable<Integer> comparable;
        Serializable serializable;
        AnnotationSet annotationSet = this.nameAllAnnots.get(this.unknownType);
        if (annotationSet.isEmpty()) {
            return;
        }
        AnnotationSet annotationSet2 = this.nameAllAnnots.get("Token");
        if (annotationSet2.isEmpty()) {
            return;
        }
        Iterator<Annotation> iterator = annotationSet.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            Object object = null;
            try {
                object = this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                object = ((String)object).replaceAll("\\s+", " ");
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new ExecutionException("Invalid offset of the annotation");
            }
            if (!this.caseSensitive) {
                object = ((String)object).toLowerCase();
            }
            if ((serializable = new ArrayList<Annotation>(annotationSet2.getContained(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()))).isEmpty()) continue;
            Collections.sort(serializable, new OffsetComparator());
            this.tokensMap.put(annotation.getId(), serializable);
            if (this.processedAnnots.containsValue(object)) {
                comparable = this.updateMatches(annotation, (String)object);
                if (comparable.getType().equals(this.unknownType)) {
                    this.annots2Remove.put(annotation.getId(), this.annots2Remove.get(comparable.getId()));
                } else {
                    this.annots2Remove.put(annotation.getId(), comparable.getType());
                }
                this.processedAnnots.put(annotation.getId(), object);
                annotation.getFeatures().put("NMRule", this.unknownType);
                continue;
            }
            if (serializable.size() == 1 && "hyphen".equals(annotation.getFeatures().get("kind")) && this.matchHyphenatedUnknowns(annotation, (String)object, iterator)) continue;
            this.matchWithPrevious(annotation, (String)object);
        }
        if (!this.annots2Remove.isEmpty()) {
            for (Object object : this.annots2Remove.keySet()) {
                serializable = this.nameAllAnnots.get((Integer)object);
                comparable = this.nameAllAnnots.add(serializable.getStartNode(), serializable.getEndNode(), (String)this.annots2Remove.get(object), serializable.getFeatures());
                this.nameAllAnnots.remove(serializable);
                List list = (List)serializable.getFeatures().get("matches");
                list.remove(object);
                list.add(comparable);
            }
        }
    }

    private boolean matchHyphenatedUnknowns(Annotation annotation, String string, Iterator iterator) {
        boolean bl = false;
        int n = string.indexOf("-");
        if (this.processedAnnots.containsValue(string = string.substring(0, n))) {
            bl = true;
            Annotation annotation2 = this.updateMatches(annotation, string);
            iterator.remove();
            String string2 = annotation2.getType().equals(this.unknownType) ? (String)this.annots2Remove.get(annotation2.getId()) : annotation2.getType();
            Integer n2 = new Integer(-1);
            try {
                n2 = this.nameAllAnnots.add(annotation.getStartNode().getOffset(), new Long(annotation.getStartNode().getOffset() + (long)n), string2, annotation.getFeatures());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException.getMessage());
            }
            this.nameAllAnnots.remove(annotation);
            List list = (List)annotation.getFeatures().get("matches");
            list.remove(annotation.getId());
            list.add(n2);
        }
        return bl;
    }

    protected void matchWithPrevious(Annotation annotation, String string) {
        boolean bl = false;
        for (Integer n : this.processedAnnots.keySet()) {
            Annotation annotation2 = this.nameAllAnnots.get(n);
            if (annotation2 == null || !annotation2.getType().equals(annotation.getType()) && !annotation.getType().equals(this.unknownType) || annotation.getType().equals(this.unknownType) && annotation2.getType().equals(this.unknownType) || this.matchedAlready(annotation, annotation2)) continue;
            if (annotation2.getType().equals(this.personType)) {
                String string2 = (String)annotation2.getFeatures().get("gender");
                String string3 = (String)annotation.getFeatures().get("gender");
                if (string2 != null && string3 != null && (string3.equalsIgnoreCase("female") && string2.equalsIgnoreCase("male") || string2.equalsIgnoreCase("female") && string3.equalsIgnoreCase("male"))) continue;
            }
            if (!this.matchAnnotations(annotation, string, annotation2)) continue;
            this.updateMatches(annotation, annotation2);
            if (!annotation.getType().equals(this.unknownType)) break;
            bl = true;
            if (annotation2.getType().equals(this.unknownType)) {
                this.annots2Remove.put(annotation.getId(), this.annots2Remove.get(annotation2.getId()));
            } else {
                this.annots2Remove.put(annotation.getId(), annotation2.getType());
            }
            annotation.getFeatures().put("NMRule", this.unknownType);
            break;
        }
        if (bl) {
            this.processedAnnots.put(annotation.getId(), string);
        }
    }

    protected boolean matchAnnotations(Annotation annotation, String string, Annotation annotation2) {
        Serializable serializable;
        Object object;
        String string2;
        if (annotation.overlaps(annotation2)) {
            return false;
        }
        String string3 = string2 = (String)this.processedAnnots.get(annotation2.getId());
        String string4 = string;
        this.longAnnot = annotation2;
        this.shortAnnot = annotation;
        if (string4.length() > string3.length()) {
            object = string3;
            string3 = string4;
            string4 = object;
            serializable = this.longAnnot;
            this.longAnnot = this.shortAnnot;
            this.shortAnnot = serializable;
        }
        this.tokensLongAnnot = (ArrayList)this.tokensMap.get(this.longAnnot.getId());
        this.tokensShortAnnot = (ArrayList)this.tokensMap.get(this.shortAnnot.getId());
        object = (List)annotation2.getFeatures().get("matches");
        if (object == null || object.isEmpty()) {
            return this.apply_rules_namematch(annotation2.getType(), string4, string3);
        }
        if (this.apply_rules_namematch(annotation2.getType(), string4, string3)) {
            if (this.allMatchingNeeded) {
                this.allMatchingNeeded = false;
                serializable = new ArrayList(object);
                serializable.remove(annotation2.getId());
                return this.matchOtherAnnots((List)((Object)serializable), annotation, string);
            }
            return true;
        }
        return false;
    }

    protected boolean matchOtherAnnots(List list, Annotation annotation, String string) {
        if (list.isEmpty()) {
            return true;
        }
        boolean bl = true;
        for (int i = 0; bl && i < list.size(); ++i) {
            Annotation annotation2 = this.nameAllAnnots.get((Integer)list.get(i));
            String string2 = (String)this.processedAnnots.get(annotation2.getId());
            if (string2 == null) {
                try {
                    string2 = this.document.getContent().getContent(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()).toString();
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    return false;
                }
            }
            String string3 = string2;
            String string4 = string;
            this.longAnnot = annotation2;
            this.shortAnnot = annotation;
            if (string4.length() >= string3.length()) {
                String string5 = string3;
                string3 = string4;
                string4 = string5;
                Annotation annotation3 = this.longAnnot;
                this.longAnnot = this.shortAnnot;
                this.shortAnnot = annotation3;
            }
            this.tokensLongAnnot = (ArrayList)this.tokensMap.get(this.longAnnot.getId());
            this.tokensShortAnnot = (ArrayList)this.tokensMap.get(this.shortAnnot.getId());
            bl = this.apply_rules_namematch(annotation2.getType(), string4, string3);
        }
        return bl;
    }

    protected boolean matchedAlready(Annotation annotation, Annotation annotation2) {
        List list = (List)annotation.getFeatures().get("matches");
        if (list == null || list.isEmpty()) {
            return false;
        }
        return list.contains(annotation2.getId());
    }

    protected Annotation updateMatches(Annotation annotation, String string) {
        Object object;
        SimpleAnnotation simpleAnnotation = null;
        for (Integer n : this.processedAnnots.keySet()) {
            object = (String)this.processedAnnots.get(n);
            if (!string.equals(object)) continue;
            simpleAnnotation = this.nameAllAnnots.get(n);
            break;
        }
        if (simpleAnnotation == null) {
            return null;
        }
        if (!simpleAnnotation.getType().equals(annotation.getType()) && !annotation.getType().equals(this.unknownType)) {
            return simpleAnnotation;
        }
        object = (List)simpleAnnotation.getFeatures().get("matches");
        if (object == null || object.isEmpty()) {
            if (object == null) {
                object = new ArrayList<Integer>();
                simpleAnnotation.getFeatures().put("matches", object);
                this.matchesDocFeature.add(object);
            }
            object.add(simpleAnnotation.getId());
            object.add(annotation.getId());
        } else {
            object.add(annotation.getId());
        }
        annotation.getFeatures().put("matches", object);
        return simpleAnnotation;
    }

    protected void updateMatches(Annotation annotation, Annotation annotation2) {
        ArrayList<Integer> arrayList = (ArrayList<Integer>)annotation2.getFeatures().get("matches");
        if (arrayList == null || arrayList.isEmpty()) {
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                annotation2.getFeatures().put("matches", arrayList);
                this.matchesDocFeature.add(arrayList);
            }
            arrayList.add(annotation2.getId());
            arrayList.add(annotation.getId());
        } else {
            arrayList.add(annotation.getId());
        }
        annotation.getFeatures().put("matches", arrayList);
        if (annotation2.getType().equals(this.personType)) {
            String string = (String)annotation2.getFeatures().get("gender");
            String string2 = (String)annotation.getFeatures().get("gender");
            boolean bl = this.isUnknownGender(string);
            boolean bl2 = this.isUnknownGender(string2);
            if (bl && !bl2) {
                annotation2.getFeatures().put("gender", string2);
            } else if (bl2 && !bl) {
                annotation.getFeatures().put("gender", string);
            }
        }
    }

    protected void docCleanup() {
        Object v = this.document.getFeatures().get("MatchesAnnots");
        if (v != null && v instanceof Map) {
            ((Map)v).remove(this.nameAllAnnots.getName());
        } else if (v != null) {
            this.document.getFeatures().put("MatchesAnnots", new HashMap());
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("matches");
        AnnotationSet annotationSet = this.nameAllAnnots.get(null, hashSet);
        if (annotationSet == null || annotationSet.isEmpty()) {
            return;
        }
        Iterator<Annotation> iterator = annotationSet.iterator();
        while (iterator.hasNext()) {
            while (iterator.hasNext()) {
                iterator.next().getFeatures().remove("matches");
            }
        }
    }

    protected String containTitle(String string, Annotation annotation) throws ExecutionException {
        Long l = annotation.getStartNode().getOffset();
        Long l2 = annotation.getEndNode().getOffset();
        this.queryFM.clear();
        this.queryFM.put("majorType", "title");
        AnnotationSet annotationSet = this.nameAllAnnots.getContained(l, l2);
        if (annotationSet == null || annotationSet.isEmpty()) {
            return string;
        }
        AnnotationSet annotationSet2 = annotationSet.get("Lookup", this.queryFM);
        if (annotationSet2 != null && !annotationSet2.isEmpty()) {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet2);
            Collections.sort(arrayList, new OffsetComparator());
            for (Annotation annotation2 : arrayList) {
                if (annotation2.getStartNode().getOffset().compareTo(l) != 0) {
                    return string;
                }
                try {
                    String string2 = this.document.getContent().getContent(annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()).toString();
                    if (string2.length() >= string.length()) continue;
                    ((ArrayList)this.tokensMap.get(annotation.getId())).remove(0);
                    return string.substring(string2.length() + 1, string.length());
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new ExecutionException("Invalid offset of the annotation");
                }
            }
        }
        return string;
    }

    protected String stripCDG(String string, Annotation annotation) {
        ArrayList arrayList = (ArrayList)this.tokensMap.get(annotation.getId());
        if (((String)((Annotation)arrayList.get(0)).getFeatures().get("string")).equalsIgnoreCase(THE_VALUE)) {
            arrayList.remove(0);
        }
        if (arrayList.size() > 1 && this.cdg.contains(((Annotation)arrayList.get(arrayList.size() - 1)).getFeatures().get("string"))) {
            arrayList.remove(arrayList.size() - 1);
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append((String)((Annotation)arrayList.get(i)).getFeatures().get("string"));
            if (i == arrayList.size() - 1) continue;
            stringBuffer.append(" ");
        }
        if (this.caseSensitive) {
            return stringBuffer.toString();
        }
        return stringBuffer.toString().toLowerCase();
    }

    protected void createAnnotList(String string, String string2) throws IOException {
        URL uRL = new URL(this.definitionFileURL, string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), this.encoding));
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string2.compareTo(CDGLISTNAME) == 0) {
                if (this.caseSensitive) {
                    this.cdg.add(string3);
                    continue;
                }
                this.cdg.add(string3.toLowerCase());
                continue;
            }
            int n = string3.indexOf("\u00a3");
            if (n == -1) continue;
            String string4 = string3.substring(0, n);
            if (!this.caseSensitive) {
                string4 = string4.toLowerCase();
            }
            String string5 = string3.substring(n + 1, string3.length());
            if (string2.equals(ALIASLISTNAME)) {
                this.alias.put(string4, string5);
                continue;
            }
            if (string2.equals(ARTLISTNAME)) {
                this.def_art.put(string4, string5);
                continue;
            }
            if (string2.equals(PREPLISTNAME)) {
                this.prepos.put(string4, string5);
                continue;
            }
            if (string2.equals(CONNECTORLISTNAME)) {
                this.connector.put(string4, string5);
                continue;
            }
            if (!string2.equals(SPURLISTNAME)) continue;
            this.spur_match.put(string4, string5);
        }
    }

    private boolean apply_rules_namematch(String string, String string2, String string3) {
        if (this.matchRule0(string3, string2)) {
            return false;
        }
        return this.matchRule2(string3, string2) || this.matchRule3(string3, string2) || (string.equals(this.organizationType) || string.equals("Facility")) && (this.matchRule4(string3, string2) || this.matchRule5(string3, string2) || this.matchRule6(string3, string2) || this.matchRule7(string3, string2) || this.matchRule9(string3, string2) || this.matchRule10(string3, string2) || this.matchRule11(string3, string2) || this.matchRule12(string3, string2) || this.matchRule13(string2, string3)) || string.equals(this.personType) && (this.matchRule4(string3, string2) || this.matchRule5(string3, string2) || this.matchRule14(string3, string2) || this.matchRule15(string3, string2));
    }

    public void setExtLists(Boolean bl) {
        this.extLists = bl;
    }

    public void setCaseSensitive(Boolean bl) {
        this.caseSensitive = bl;
    }

    public void setAnnotationSetName(String string) {
        this.annotationSetName = string;
    }

    public void setAnnotationTypes(List list) {
        this.annotationTypes = list;
    }

    public void setProcessUnknown(Boolean bl) {
        this.matchingUnknowns = bl;
    }

    public void setOrganizationType(String string) {
        this.organizationType = string;
    }

    public void setPersonType(String string) {
        this.personType = string;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public List getAnnotationTypes() {
        return this.annotationTypes;
    }

    public String getOrganizationType() {
        return this.organizationType;
    }

    public String getPersonType() {
        return this.personType;
    }

    public Boolean getExtLists() {
        return new Boolean(this.extLists);
    }

    public Boolean getCaseSensitive() {
        return new Boolean(this.caseSensitive);
    }

    public Boolean getProcessUnknown() {
        return new Boolean(this.matchingUnknowns);
    }

    protected boolean isUnknownGender(String string) {
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase("male") && !string.equalsIgnoreCase("female");
    }

    public boolean matchRule0(String string, String string2) {
        if (this.spur_match.containsKey(string) && this.spur_match.containsKey(string2)) {
            return this.spur_match.get(string).toString().equals(this.spur_match.get(string2).toString());
        }
        return false;
    }

    public boolean matchRule1(String string, String string2, boolean bl) {
        boolean bl2 = false;
        bl2 = !bl ? string.equalsIgnoreCase(string2) : string.equals(string2);
        return bl2;
    }

    public boolean matchRule2(String string, String string2) {
        if (this.alias.containsKey(string) && this.alias.containsKey(string2)) {
            return this.alias.get(string).toString().equals(this.alias.get(string2).toString());
        }
        return false;
    }

    public boolean matchRule3(String string, String string2) {
        if (string2.endsWith("'s") || string2.endsWith("'") || string.endsWith("'s") || string.endsWith("'")) {
            String string3 = null;
            string3 = !string2.endsWith("'s") ? string2.concat("'s") : string2.concat("'");
            if (string3 != null && this.matchRule1(string, string3, this.caseSensitive)) {
                return true;
            }
            String string4 = (String)((Annotation)this.tokensLongAnnot.get(0)).getFeatures().get("string");
            string3 = !string4.endsWith("'s") ? string4.concat("'s") : string4.concat("'");
            if (string3 != null && this.matchRule1(string3, string2, this.caseSensitive)) {
                return true;
            }
        }
        return false;
    }

    public boolean matchRule4(String string, String string2) {
        boolean bl = true;
        Iterator iterator = this.tokensLongAnnot.iterator();
        Iterator iterator2 = this.tokensShortAnnot.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (((String)annotation.getFeatures().get("kind")).equals(PUNCTUATION_VALUE) || annotation.getFeatures().get("string").equals(((Annotation)iterator2.next()).getFeatures().get("string"))) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean matchRule5(String string, String string2) {
        if (this.tokensLongAnnot.size() > 1 && ((Annotation)this.tokensLongAnnot.get(0)).getFeatures().get("kind").equals("number")) {
            return false;
        }
        if ((this.shortAnnot.getType().equals(this.personType) || this.longAnnot.getType().equals(this.personType)) && this.tokensShortAnnot.size() > 1) {
            return false;
        }
        if (this.tokensLongAnnot.size() <= 1) {
            return false;
        }
        boolean bl = this.matchRule1((String)((Annotation)this.tokensLongAnnot.get(0)).getFeatures().get("string"), string2, this.caseSensitive);
        return bl;
    }

    public boolean matchRule6(String string, String string2) {
        if (string2.indexOf(" ") > 0) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (int i = 0; i < this.tokensLongAnnot.size(); ++i) {
            String string3 = ((String)((Annotation)this.tokensLongAnnot.get(i)).getFeatures().get("string")).substring(0, 1);
            stringBuffer.append(string3);
            stringBuffer2.append(string3);
            stringBuffer2.append(".");
        }
        return this.matchRule1(stringBuffer.toString(), string2, this.caseSensitive) || this.matchRule1(stringBuffer2.toString(), string2, this.caseSensitive);
    }

    public boolean matchRule7(String string, String string2) {
        if (this.tokensShortAnnot.size() != 1) {
            return false;
        }
        String string3 = null;
        for (int i = 0; i < this.tokensLongAnnot.size(); ++i) {
            if (!this.connector.containsKey(((Annotation)this.tokensLongAnnot.get(i)).getFeatures().get("string"))) continue;
            string3 = (String)((Annotation)this.tokensLongAnnot.get(i - 1)).getFeatures().get("string");
            break;
        }
        if (string3 != null) {
            return this.matchRule1(string3, string2, this.caseSensitive);
        }
        return false;
    }

    public boolean matchRule8(String string, String string2) {
        Out.prln("OrthoMatcher warning: This rule has been discontinued!");
        return false;
    }

    public boolean matchRule9(String string, String string2) {
        String string3 = (String)((Annotation)this.tokensLongAnnot.get(this.tokensLongAnnot.size() - 1)).getFeatures().get("string");
        if (this.tokensLongAnnot.size() > 1) {
            boolean bl = this.matchRule1(string3, string2, this.caseSensitive);
            if (bl) {
                this.allMatchingNeeded = true;
            }
            return bl;
        }
        return false;
    }

    public boolean matchRule10(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        if (this.tokensLongAnnot.size() >= 3 && this.tokensShortAnnot.size() >= 2) {
            int n;
            for (n = 0; n < this.tokensLongAnnot.size(); ++n) {
                string3 = (String)((Annotation)this.tokensLongAnnot.get(n)).getFeatures().get("string");
                if (this.prepos.containsKey(string3)) {
                    bl = true;
                    break;
                }
                string4 = string3;
            }
            if (!bl) {
                return false;
            }
            if (n >= this.tokensLongAnnot.size() || string4 == null) {
                return false;
            }
            string5 = (String)((Annotation)this.tokensLongAnnot.get(n++)).getFeatures().get("string");
            String string6 = (String)((Annotation)this.tokensShortAnnot.get(0)).getFeatures().get("string");
            String string7 = (String)((Annotation)this.tokensShortAnnot.get(1)).getFeatures().get("string");
            if (this.matchRule1(string5, string6, this.caseSensitive) && this.matchRule1(string4, string7, this.caseSensitive)) {
                return true;
            }
        }
        return false;
    }

    public boolean matchRule11(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (this.tokensLongAnnot.size() < 2) {
            return false;
        }
        string3 = (String)((Annotation)this.tokensLongAnnot.get(0)).getFeatures().get("string");
        string4 = (String)((Annotation)this.tokensLongAnnot.get(1)).getFeatures().get("string");
        if (this.tokensShortAnnot.size() == 2) {
            string5 = (String)((Annotation)this.tokensShortAnnot.get(0)).getFeatures().get("string");
            string6 = (String)((Annotation)this.tokensShortAnnot.get(0)).getFeatures().get("string");
            if (string3.startsWith(string5) && string4.startsWith(string6)) {
                return true;
            }
        } else if (this.tokensShortAnnot.size() == 1 && string2.length() >= 3) {
            for (int i = 2; i < string2.length(); ++i) {
                string5 = string2.substring(0, i + 1);
                string6 = string2.substring(i + 1);
                if (!string3.startsWith(string5) || !string4.startsWith(string6)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchRule12(String string, String string2) {
        if (this.tokensLongAnnot.size() > 1 && this.tokensShortAnnot.size() > 1) {
            String string3;
            String string4 = (String)((Annotation)this.tokensLongAnnot.get(0)).getFeatures().get("string");
            if (!this.matchRule1(string4, string3 = (String)((Annotation)this.tokensShortAnnot.get(0)).getFeatures().get("string"), this.caseSensitive)) {
                return false;
            }
            String string5 = (String)((Annotation)this.tokensLongAnnot.get(this.tokensLongAnnot.size() - 1)).getFeatures().get("string");
            String string6 = (String)((Annotation)this.tokensShortAnnot.get(this.tokensShortAnnot.size() - 1)).getFeatures().get("string");
            return this.matchRule1(string5, string6, this.caseSensitive);
        }
        return false;
    }

    public boolean matchRule13(String string, String string2) {
        Object var3_3 = null;
        Object var4_4 = null;
        int n = 0;
        int n2 = 0;
        if (this.tokensLongAnnot.size() < 3 || this.tokensShortAnnot.size() < 2) {
            return false;
        }
        int n3 = 0;
        for (int i = 0; i < this.tokensShortAnnot.size() && n2 < 2; ++i) {
            if (((Annotation)this.tokensLongAnnot.get(n3)).getFeatures().get("string").equals(((Annotation)this.tokensShortAnnot.get(i)).getFeatures().get("string"))) {
                ++n;
                ++n3;
                continue;
            }
            ++n2;
        }
        return n >= this.tokensLongAnnot.size() - 1;
    }

    public boolean matchRule14(String string, String string2) {
        String string3 = (String)((Annotation)this.tokensLongAnnot.get(this.tokensLongAnnot.size() - 1)).getFeatures().get("string");
        if (this.tokensLongAnnot.size() > 1) {
            return this.matchRule1(string3, string2, this.caseSensitive);
        }
        return false;
    }

    public boolean matchRule15(String string, String string2) {
        int n = 0;
        for (int i = 0; i < this.tokensShortAnnot.size() && n == 0; ++i) {
            Annotation annotation = (Annotation)this.tokensShortAnnot.get(i);
            if (annotation.getFeatures().get("kind").equals(PUNCTUATION_VALUE)) continue;
            for (int j = 0; j < this.tokensLongAnnot.size() && n == 0; ++j) {
                Annotation annotation2 = (Annotation)this.tokensLongAnnot.get(j);
                if (annotation2.getFeatures().get("kind").equals(PUNCTUATION_VALUE) || !annotation.getFeatures().get("string").equals(annotation2.getFeatures().get("string"))) continue;
                ++n;
            }
        }
        return n == this.tokensShortAnnot.size();
    }

    private void buildTables(AnnotationSet annotationSet) {
        this.cdg.clear();
        if (!this.extLists) {
            this.tempMap.clear();
            this.tempMap.put("majorType", CDGLISTNAME);
            AnnotationSet annotationSet2 = annotationSet.get("Lookup", this.tempMap);
            if (annotationSet2 == null || annotationSet2.isEmpty()) {
                return;
            }
            for (Annotation annotation : annotationSet2) {
                Long l = annotation.getStartNode().getOffset();
                Long l2 = annotation.getEndNode().getOffset();
                try {
                    Document document = annotationSet.getDocument();
                    String string = document.getContent().getContent(l, l2).toString();
                    this.cdg.add(string);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    invalidOffsetException.printStackTrace(Err.getPrintWriter());
                }
            }
        }
    }

    public void setDefinitionFileURL(URL uRL) {
        this.definitionFileURL = uRL;
    }

    public URL getDefinitionFileURL() {
        return this.definitionFileURL;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private static class Class1 {
        private Class1() {
        }
    }
}

