/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.creole.ontology.AllValuesFromRestriction;
import gate.creole.ontology.CardinalityRestriction;
import gate.creole.ontology.HasValueRestriction;
import gate.creole.ontology.MaxCardinalityRestriction;
import gate.creole.ontology.MinCardinalityRestriction;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.Restriction;
import gate.creole.ontology.SomeValuesFromRestriction;
import gate.creole.ontology.URI;
import gate.creole.ontology.owlim.AllValuesFromRestrictionImpl;
import gate.creole.ontology.owlim.AnnotationPropertyImpl;
import gate.creole.ontology.owlim.AnonymousClassImpl;
import gate.creole.ontology.owlim.CardinalityRestrictionImpl;
import gate.creole.ontology.owlim.DatatypePropertyImpl;
import gate.creole.ontology.owlim.HasValueRestrictionImpl;
import gate.creole.ontology.owlim.MaxCardinalityRestrictionImpl;
import gate.creole.ontology.owlim.MinCardinalityRestrictionImpl;
import gate.creole.ontology.owlim.OClassImpl;
import gate.creole.ontology.owlim.OInstanceImpl;
import gate.creole.ontology.owlim.OWLIM;
import gate.creole.ontology.owlim.ObjectPropertyImpl;
import gate.creole.ontology.owlim.RDFPropertyImpl;
import gate.creole.ontology.owlim.SomeValuesFromRestrictionImpl;
import gate.creole.ontology.owlim.SymmetricPropertyImpl;
import gate.creole.ontology.owlim.TransitivePropertyImpl;
import gate.util.GateRuntimeException;

public class Utils {
    public static RDFProperty createOProperty(String string, Ontology ontology, OWLIM oWLIM, String string2, byte by) {
        RDFProperty rDFProperty = (RDFProperty)ontology.getOResourceFromMap(string2);
        if (rDFProperty != null) {
            return rDFProperty;
        }
        switch (by) {
            case 5: {
                rDFProperty = new AnnotationPropertyImpl(new URI(string2, false), ontology, string, oWLIM);
                break;
            }
            case 0: {
                rDFProperty = new RDFPropertyImpl(new URI(string2, false), ontology, string, oWLIM);
                break;
            }
            case 1: {
                rDFProperty = new ObjectPropertyImpl(new URI(string2, false), ontology, string, oWLIM);
                break;
            }
            case 3: {
                rDFProperty = new SymmetricPropertyImpl(new URI(string2, false), ontology, string, oWLIM);
                break;
            }
            case 4: {
                rDFProperty = new TransitivePropertyImpl(new URI(string2, false), ontology, string, oWLIM);
                break;
            }
            case 2: {
                rDFProperty = new DatatypePropertyImpl(new URI(string2, false), ontology, string, oWLIM);
            }
        }
        ontology.addOResourceToMap(string2, rDFProperty);
        return rDFProperty;
    }

    public static OClass createOClass(String string, Ontology ontology, OWLIM oWLIM, String string2, byte by) {
        OClass oClass = (OClass)ontology.getOResourceFromMap(string2);
        if (oClass != null) {
            return oClass;
        }
        switch (by) {
            case 4: {
                oClass = new HasValueRestrictionImpl(new URI(string2, true), ontology, string, oWLIM);
                break;
            }
            case 5: {
                oClass = new AllValuesFromRestrictionImpl(new URI(string2, true), ontology, string, oWLIM);
                break;
            }
            case 6: {
                oClass = new SomeValuesFromRestrictionImpl(new URI(string2, true), ontology, string, oWLIM);
                break;
            }
            case 1: {
                oClass = new CardinalityRestrictionImpl(new URI(string2, true), ontology, string, oWLIM);
                break;
            }
            case 2: {
                oClass = new MinCardinalityRestrictionImpl(new URI(string2, true), ontology, string, oWLIM);
                break;
            }
            case 3: {
                oClass = new MaxCardinalityRestrictionImpl(new URI(string2, true), ontology, string, oWLIM);
                break;
            }
            case 7: {
                oClass = new AnonymousClassImpl(new URI(string2, true), ontology, string, oWLIM);
                break;
            }
            default: {
                oClass = new OClassImpl(new URI(string2, false), ontology, string, oWLIM);
            }
        }
        ontology.addOResourceToMap(string2, oClass);
        return oClass;
    }

    public static String getRestrictionName(byte by) {
        String string = "Unknown";
        switch (by) {
            case 4: {
                string = "http://www.w3.org/2002/07/owl#hasValue";
                break;
            }
            case 5: {
                string = "http://www.w3.org/2002/07/owl#allValuesFrom";
                break;
            }
            case 6: {
                string = "http://www.w3.org/2002/07/owl#someValuesFrom";
                break;
            }
            case 1: {
                string = "http://www.w3.org/2002/07/owl#cardinality";
                break;
            }
            case 2: {
                string = "http://www.w3.org/2002/07/owl#minCardinality";
                break;
            }
            case 3: {
                string = "http://www.w3.org/2002/07/owl#minCardinality";
                break;
            }
            case 7: {
                string = "Annonymous";
            }
        }
        return string;
    }

    public static String getRestrictionName(Restriction restriction) {
        String string = "Unknown";
        if (restriction instanceof HasValueRestriction) {
            string = "http://www.w3.org/2002/07/owl#hasValue";
        } else if (restriction instanceof AllValuesFromRestriction) {
            string = "http://www.w3.org/2002/07/owl#allValuesFrom";
        } else if (restriction instanceof SomeValuesFromRestriction) {
            string = "http://www.w3.org/2002/07/owl#someValuesFrom";
        } else if (restriction instanceof CardinalityRestriction) {
            string = "http://www.w3.org/2002/07/owl#cardinality";
        } else if (restriction instanceof MinCardinalityRestriction) {
            string = "http://www.w3.org/2002/07/owl#minCardinality";
        } else if (restriction instanceof MaxCardinalityRestriction) {
            string = "http://www.w3.org/2002/07/owl#maxCardinality";
        } else if (restriction instanceof AnonymousClassImpl) {
            string = "Annonymous";
        }
        return string;
    }

    public static OInstance createOInstance(String string, Ontology ontology, OWLIM oWLIM, String string2) {
        OInstance oInstance = (OInstance)ontology.getOResourceFromMap(string2);
        if (oInstance != null) {
            return oInstance;
        }
        oInstance = new OInstanceImpl(new URI(string2, false), ontology, string, oWLIM);
        ontology.addOResourceToMap(string2, oInstance);
        return oInstance;
    }

    public static void warning(String string) {
        System.err.println("WARNING :" + string);
    }

    public static void error(String string) {
        throw new GateRuntimeException("ERROR :" + string);
    }

    public static boolean hasSystemNameSpace(String string) {
        if (string.startsWith("http://www.w3.org/2002/07/owl#")) {
            return true;
        }
        if (string.startsWith("http://www.w3.org/2001/XMLSchema#")) {
            return true;
        }
        if (string.startsWith("http://www.w3.org/2000/01/rdf-schema#")) {
            return true;
        }
        return string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    }
}

