/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.URI;
import gate.creole.ontology.owlim.OResourceImpl;
import gate.creole.ontology.owlim.OWLIM;
import gate.creole.ontology.owlim.Property;
import gate.creole.ontology.owlim.ResourceInfo;
import gate.creole.ontology.owlim.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFPropertyImpl
extends OResourceImpl
implements RDFProperty {
    public RDFPropertyImpl(URI uRI, Ontology ontology, String string, OWLIM oWLIM) {
        super(uRI, ontology, string, oWLIM);
    }

    @Override
    public void setEquivalentPropertyAs(RDFProperty rDFProperty) {
        if (this == rDFProperty) {
            Utils.warning("setEquivalentPropertyAs(RDFProperty) : The source and the argument properties refer to the same property and therefore cannot be set as equivalent");
            return;
        }
        this.owlim.setEquivalentPropertyAs(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 17);
    }

    @Override
    public Set<RDFProperty> getEquivalentPropertyAs() {
        Property[] propertyArray = this.owlim.getEquivalentPropertyAs(this.repositoryID, this.uri.toString());
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add(Utils.createOProperty(this.repositoryID, this.ontology, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isEquivalentPropertyAs(RDFProperty rDFProperty) {
        return this.owlim.isEquivalentPropertyAs(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString());
    }

    @Override
    public Set<RDFProperty> getSuperProperties(byte by) {
        Property[] propertyArray = this.owlim.getSuperProperties(this.repositoryID, this.uri.toString(), by);
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add(Utils.createOProperty(this.repositoryID, this.ontology, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isSuperPropertyOf(RDFProperty rDFProperty, byte by) {
        return this.owlim.isSuperPropertyOf(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString(), by);
    }

    @Override
    public void addSubProperty(RDFProperty rDFProperty) {
        if (this == rDFProperty) {
            Utils.warning("addSubProperty(RDFProperty) : The super and sub properties are same.");
            return;
        }
        if (this.isSubPropertyOf(rDFProperty, (byte)1)) {
            Utils.warning(rDFProperty.getURI().toString() + " is a super property of " + this.getURI().toString());
            return;
        }
        if (!this.getClass().getName().equals(rDFProperty.getClass().getName())) {
            Utils.warning(this.getURI().toString() + " and " + rDFProperty.getURI().toString() + " must be of the same property type " + this.getURI().toString());
            return;
        }
        this.owlim.addSubProperty(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 18);
    }

    @Override
    public void removeSubProperty(RDFProperty rDFProperty) {
        this.owlim.removeSubProperty(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 20);
    }

    @Override
    public Set<RDFProperty> getSubProperties(byte by) {
        Property[] propertyArray = this.owlim.getSubProperties(this.repositoryID, this.uri.toString(), by);
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add(Utils.createOProperty(this.repositoryID, this.ontology, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isSubPropertyOf(RDFProperty rDFProperty, byte by) {
        return this.owlim.isSubPropertyOf(this.repositoryID, rDFProperty.getURI().toString(), this.uri.toString(), by);
    }

    @Override
    public boolean isFunctional() {
        return this.owlim.isFunctional(this.repositoryID, this.uri.toString());
    }

    @Override
    public void setFunctional(boolean bl) {
        this.owlim.setFunctional(this.repositoryID, this.uri.toString(), bl);
    }

    @Override
    public boolean isInverseFunctional() {
        return this.owlim.isInverseFunctional(this.repositoryID, this.uri.toString());
    }

    @Override
    public void setInverseFunctional(boolean bl) {
        this.owlim.setInverseFunctional(this.repositoryID, this.uri.toString(), bl);
    }

    @Override
    public boolean isValidRange(OResource oResource) {
        ResourceInfo[] resourceInfoArray = this.owlim.getRange(this.repositoryID, this.uri.toString());
        if (resourceInfoArray.length == 0) {
            return true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            arrayList.add(resourceInfoArray[i].getUri());
        }
        if (arrayList.contains(oResource.getURI().toString())) {
            return true;
        }
        if (oResource instanceof OInstance) {
            ResourceInfo[] resourceInfoArray2 = this.owlim.getClassesOfIndividual(this.repositoryID, oResource.getURI().toString(), (byte)1);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < resourceInfoArray2.length; ++i) {
                arrayList2.add(resourceInfoArray2[i].getUri());
            }
            return !Collections.disjoint(arrayList2, arrayList);
        }
        if (oResource instanceof OClass) {
            ResourceInfo[] resourceInfoArray3 = this.owlim.getSuperClasses(this.repositoryID, oResource.getURI().toString(), (byte)1);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < resourceInfoArray3.length; ++i) {
                arrayList3.add(resourceInfoArray3[i].getUri());
            }
            return !Collections.disjoint(arrayList3, arrayList);
        }
        if (oResource instanceof RDFProperty && !(oResource instanceof AnnotationProperty)) {
            Property[] propertyArray = this.owlim.getSuperProperties(this.repositoryID, oResource.getURI().toString(), (byte)1);
            for (int i = 0; i < propertyArray.length; ++i) {
                if (!arrayList.contains(propertyArray[i].getUri())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValidDomain(OResource oResource) {
        Object object;
        ResourceInfo[] resourceInfoArray = this.owlim.getDomain(this.repositoryID, this.uri.toString());
        if (resourceInfoArray.length == 0) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            Iterator<OResource> iterator;
            Set<OResource> set;
            hashSet.add(resourceInfoArray[i].getUri().toString());
            object = this.ontology.getOResourceFromMap(resourceInfoArray[i].getUri());
            if (object != null && object instanceof OClass) {
                set = ((OClass)object).getSubClasses((byte)1);
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next().getURI().toString());
                }
                continue;
            }
            if (object == null || !(object instanceof RDFProperty) || object instanceof AnnotationProperty) continue;
            set = ((RDFProperty)object).getSubProperties((byte)1);
            iterator = set.iterator();
            while (iterator.hasNext()) {
                hashSet.add(((RDFProperty)iterator.next()).getURI().toString());
            }
        }
        if (hashSet.contains(oResource.getURI().toString())) {
            return true;
        }
        if (oResource instanceof OInstance) {
            ResourceInfo[] resourceInfoArray2 = this.owlim.getClassesOfIndividual(this.repositoryID, oResource.getURI().toString(), (byte)0);
            object = new HashSet();
            for (int i = 0; i < resourceInfoArray2.length; ++i) {
                object.add(resourceInfoArray2[i].getUri());
            }
            return hashSet.containsAll((Collection<?>)object);
        }
        if (oResource instanceof OClass) {
            return hashSet.contains(oResource);
        }
        return oResource instanceof RDFProperty && !(oResource instanceof AnnotationProperty) && hashSet.contains(oResource.getURI().toString());
    }

    @Override
    public Set<OResource> getDomain() {
        ResourceInfo[] resourceInfoArray = this.owlim.getDomain(this.repositoryID, this.uri.toString());
        HashSet<OResource> hashSet = new HashSet<OResource>();
        List<String> list = Arrays.asList(this.owlim.getIndividuals(this.repositoryID));
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            OResource oResource = this.ontology.getOResourceFromMap(resourceInfoArray[i].getUri());
            if (oResource != null) {
                hashSet.add(oResource);
                continue;
            }
            if (list.contains(resourceInfoArray[i])) {
                hashSet.add(Utils.createOInstance(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri()));
                continue;
            }
            if (this.owlim.hasClass(this.repositoryID, resourceInfoArray[i].getUri())) {
                hashSet.add(Utils.createOClass(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
                continue;
            }
            Property property = this.owlim.getPropertyFromOntology(this.repositoryID, resourceInfoArray[i].getUri());
            hashSet.add(Utils.createOProperty(this.repositoryID, this.ontology, this.owlim, property.getUri(), property.getType()));
        }
        return hashSet;
    }

    @Override
    public Set<OResource> getRange() {
        ResourceInfo[] resourceInfoArray = this.owlim.getRange(this.repositoryID, this.uri.toString());
        HashSet<OResource> hashSet = new HashSet<OResource>();
        List<String> list = Arrays.asList(this.owlim.getIndividuals(this.repositoryID));
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            OResource oResource = this.ontology.getOResourceFromMap(resourceInfoArray[i].getUri());
            if (oResource != null) {
                hashSet.add(oResource);
                continue;
            }
            if (list.contains(resourceInfoArray[i])) {
                hashSet.add(Utils.createOInstance(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri()));
                continue;
            }
            if (this.owlim.hasClass(this.repositoryID, resourceInfoArray[i].getUri())) {
                hashSet.add(Utils.createOClass(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
                continue;
            }
            Property property = this.owlim.getPropertyFromOntology(this.repositoryID, resourceInfoArray[i].getUri());
            hashSet.add(Utils.createOProperty(this.repositoryID, this.ontology, this.owlim, property.getUri(), property.getType()));
        }
        return hashSet;
    }
}

