/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.creole.ontology.GateOntologyException;
import gate.creole.ontology.OntologyUtilities;
import gate.creole.ontology.owlim.OWLIM;
import gate.creole.ontology.owlim.Property;
import gate.creole.ontology.owlim.PropertyValue;
import gate.creole.ontology.owlim.ResourceInfo;
import gate.creole.ontology.owlim.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.n3.N3Writer;
import org.openrdf.rio.ntriples.NTriplesWriter;
import org.openrdf.rio.rdfxml.RdfXmlWriter;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.RepositoryInfo;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.config.UserInfo;
import org.openrdf.sesame.config.handlers.SystemConfigFileHandler;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.RepositoryList;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.OWLIMSchemaRepository;
import org.openrdf.sesame.server.SesameServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIMServiceImpl
implements OWLIM,
ServiceLifecycle,
AdminListener {
    private HashMap<String, RepositoryDetails> mapToRepositoryDetails = new HashMap();
    private static boolean DEBUG = false;
    private static boolean initiated = false;
    private OWLIMSchemaRepository sail;
    private SesameRepository currentRepository;
    private final String OWLIM_LOG_FILE = "log.html";
    private final String OWLIM_SCHEMA_REPOSITORY_CLASS = "org.openrdf.sesame.sailimpl.OWLIMSchemaRepository";
    private static URL systemConf = null;
    private static URL owlRDFS = null;
    private static URL rdfSchema = null;
    private String ontologyUrl;
    private boolean returnSystemStatements;
    private static URL gosHome;
    private LocalService service;

    public void error(String string, int n, int n2, Statement statement) {
        System.err.println("ERROR :" + string + "\n at line number :" + n + " column number :" + n2);
        if (statement != null) {
            System.err.println("With Statement <");
            if (statement.getSubject() != null) {
                System.err.println("Subject :" + statement.getSubject().toString());
            } else {
                System.err.println("Subject : not available");
            }
            if (statement.getPredicate() != null) {
                System.err.println("Predicate :" + statement.getPredicate().toString());
            } else {
                System.err.println("Predicate : not available");
            }
            if (statement.getObject() != null) {
                System.err.println("Object :" + statement.getObject().toString());
            } else {
                System.err.println("Object : not available");
            }
        }
        throw new RuntimeException("Some Error Occured");
    }

    public void notification(String string, int n, int n2, Statement statement) {
    }

    public void status(String string, int n, int n2) {
    }

    public void transactionEnd() {
    }

    public void transactionStart() {
    }

    public void warning(String string, int n, int n2, Statement statement) {
        System.err.println("WARNING :" + string + "\n at line number :" + n + " column number :" + n2);
        if (statement != null) {
            System.err.println("With Statement <");
            if (statement.getSubject() != null) {
                System.err.println("Subject :" + statement.getSubject().toString());
            } else {
                System.err.println("Subject : not available");
            }
            if (statement.getPredicate() != null) {
                System.err.println("Predicate :" + statement.getPredicate().toString());
            } else {
                System.err.println("Predicate : not available");
            }
            if (statement.getObject() != null) {
                System.err.println("Object :" + statement.getObject().toString());
            } else {
                System.err.println("Object : not available");
            }
        }
    }

    public void init(ServletContext servletContext) throws GateOntologyException {
        if (!initiated) {
            try {
                URL uRL;
                if (DEBUG) {
                    System.out.println("Initiating OWLIMService...");
                }
                if ((uRL = this.getClass().getResource("/" + this.getClass().getName().replace('.', '/') + ".class")).getProtocol().equals("jar")) {
                    String string = uRL.getFile();
                    URL uRL2 = new URL(string.substring(0, string.indexOf(33)));
                    gosHome = new URL(uRL2, "..");
                } else {
                    gosHome = uRL.getProtocol().equals("file") ? new URL(uRL, "../../../../..") : null;
                }
                systemConf = new URL(gosHome, "system.conf");
                owlRDFS = new URL(gosHome, "owl.rdfs");
                rdfSchema = new URL(gosHome, "rdf-schema.xml");
                SesameServer.setSystemConfig((SystemConfig)this.readConfiguration());
                this.service = SesameServer.getLocalService();
                initiated = true;
            }
            catch (IOException iOException) {
                throw new GateOntologyException(iOException);
            }
        }
    }

    public void init(URL uRL) throws GateOntologyException {
        try {
            if (DEBUG) {
                System.out.println("Initiating OWLIMService...");
            }
            gosHome = uRL;
            systemConf = null;
            owlRDFS = new URL(gosHome, "owl.rdfs");
            rdfSchema = new URL(gosHome, "rdf-schema.xml");
            SystemConfig systemConfig = this.readConfiguration();
            this.service = new LocalService(systemConfig);
        }
        catch (IOException iOException) {
            throw new GateOntologyException(iOException);
        }
    }

    public void init(Object object) throws ServiceException {
        if (object instanceof ServletEndpointContext) {
            ServletEndpointContext servletEndpointContext = (ServletEndpointContext)object;
            ServletContext servletContext = servletEndpointContext.getServletContext();
            try {
                this.init(servletContext);
            }
            catch (GateOntologyException gateOntologyException) {
                throw new ServiceException((Throwable)gateOntologyException);
            }
        }
    }

    @Override
    public String getDefaultNameSpace(String string) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        NamespaceIterator namespaceIterator = this.sail.getNamespaces();
        while (namespaceIterator.hasNext()) {
            namespaceIterator.next();
            if (namespaceIterator.getPrefix() != null && namespaceIterator.getPrefix().trim().length() != 0) continue;
            return namespaceIterator.getName();
        }
        return null;
    }

    @Override
    public void addOntologyData(String string, String string2, String string3, byte by) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        try {
            this.startTransaction(string);
            this.currentRepository.addData(string2, string3, this.getRDFFormat(by), true, (AdminListener)this);
            this.endTransaction(string);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new GateOntologyException(accessDeniedException);
        }
        catch (IOException iOException) {
            throw new GateOntologyException(iOException);
        }
    }

    public void writeOntologyData(String string, OutputStream outputStream, byte by) throws Exception {
        this.loadRepositoryDetails(string);
        if (this.sail.transactionStarted()) {
            this.sail.commitTransaction();
        }
        N3Writer n3Writer = null;
        switch (by) {
            case 0: {
                n3Writer = new N3Writer(outputStream);
                break;
            }
            case 1: {
                n3Writer = new NTriplesWriter(outputStream);
                break;
            }
            case 3: {
                n3Writer = new TurtleWriter(outputStream);
                break;
            }
            default: {
                n3Writer = new RdfXmlWriter(outputStream);
            }
        }
        n3Writer.startDocument();
        this.writeData((RdfDocumentWriter)n3Writer);
        switch (by) {
            case 0: {
                n3Writer.endDocument();
                break;
            }
            case 1: {
                ((NTriplesWriter)n3Writer).endDocument();
                break;
            }
            case 3: {
                ((TurtleWriter)n3Writer).endDocument();
                break;
            }
            default: {
                ((RdfXmlWriter)n3Writer).endDocument();
            }
        }
    }

    public void writeOntologyData(String string, Writer writer, byte by) throws Exception {
        this.loadRepositoryDetails(string);
        if (this.sail.transactionStarted()) {
            this.sail.commitTransaction();
        }
        N3Writer n3Writer = null;
        switch (by) {
            case 0: {
                n3Writer = new N3Writer(writer);
                break;
            }
            case 1: {
                n3Writer = new NTriplesWriter(writer);
                break;
            }
            case 3: {
                n3Writer = new TurtleWriter(writer);
                break;
            }
            default: {
                n3Writer = new RdfXmlWriter(writer);
            }
        }
        n3Writer.startDocument();
        this.writeData((RdfDocumentWriter)n3Writer);
        switch (by) {
            case 0: {
                n3Writer.endDocument();
                break;
            }
            case 1: {
                ((NTriplesWriter)n3Writer).endDocument();
                break;
            }
            case 3: {
                ((TurtleWriter)n3Writer).endDocument();
                break;
            }
            default: {
                ((RdfXmlWriter)n3Writer).endDocument();
            }
        }
    }

    private void writeData(RdfDocumentWriter rdfDocumentWriter) throws IOException {
        rdfDocumentWriter.writeComment("Ontology Generated from GATE");
        NamespaceIterator namespaceIterator = this.sail.getNamespaces();
        while (namespaceIterator.hasNext()) {
            namespaceIterator.next();
            rdfDocumentWriter.setNamespace(namespaceIterator.getPrefix(), namespaceIterator.getName());
        }
        StatementIterator statementIterator = this.sail.getStatements(null, null, null);
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            rdfDocumentWriter.writeStatement(statement.getSubject(), statement.getPredicate(), statement.getObject());
        }
    }

    @Override
    public boolean isSuperClassOf(String string, String string2, String string3, byte by) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        if (by == 0) {
            return this.sail.getDirectSubClassOf(this.getResource(string3), this.getResource(string2)).hasNext();
        }
        return this.sail.getSubClassOf(this.getResource(string3), this.getResource(string2)).hasNext();
    }

    @Override
    public boolean isSubClassOf(String string, String string2, String string3, byte by) {
        return this.isSuperClassOf(string, string2, string3, by);
    }

    @Override
    public Property getPropertyFromOntology(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        return this.createPropertyObject(string, string2);
    }

    @Override
    public boolean isEquivalentClassAs(String string, String string2, String string3) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#equivalentClass"), (Value)this.getResource(string3));
    }

    @Override
    public void addAnnotationProperty(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#AnnotationProperty");
    }

    @Override
    public Property[] getAnnotationProperties(String string, String string2) throws GateOntologyException {
        Property[] propertyArray;
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#AnnotationProperty"));
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            propertyArray = statement.getSubject();
            if (!this.sail.getStatements(this.getResource(string2), this.getURI(propertyArray.toString()), null).hasNext()) continue;
            arrayList.add(new Property(5, propertyArray.toString()));
        }
        boolean bl = this.returnSystemStatements;
        this.returnSystemStatements = true;
        propertyArray = this.listToPropertyArray(arrayList);
        this.returnSystemStatements = bl;
        return propertyArray;
    }

    @Override
    public Property[] getRDFProperties(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"));
        ResourceInfo[] resourceInfoArray = new ResourceInfo[]{};
        if (this.hasClass(string, string2)) {
            resourceInfoArray = this.getSuperClasses(string, string2, (byte)1);
        }
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Resource resource = statement.getSubject();
            if (this.isAnnotationProperty(string, resource.toString()) || this.isDatatypeProperty(string, resource.toString()) || this.isObjectProperty(string, resource.toString())) continue;
            if (this.sail.getStatements(this.getResource(string2), this.getURI(resource.toString()), null).hasNext()) {
                arrayList.add(new Property(0, resource.toString()));
            }
            for (int i = 0; i < resourceInfoArray.length; ++i) {
                if (!this.sail.getStatements(this.getResource(resourceInfoArray[i].getUri()), this.getURI(resource.toString()), null).hasNext()) continue;
                arrayList.add(new Property(0, resource.toString()));
            }
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getDatatypeProperties(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#DatatypeProperty"));
        ResourceInfo[] resourceInfoArray = new ResourceInfo[]{};
        if (this.hasClass(string, string2)) {
            resourceInfoArray = this.getSuperClasses(string, string2, (byte)1);
        }
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Resource resource = statement.getSubject();
            if (this.sail.getStatements(this.getResource(string2), this.getURI(resource.toString()), null).hasNext()) {
                arrayList.add(new Property(2, resource.toString()));
            }
            for (int i = 0; i < resourceInfoArray.length; ++i) {
                if (!this.sail.getStatements(this.getResource(resourceInfoArray[i].getUri()), this.getURI(resource.toString()), null).hasNext()) continue;
                arrayList.add(new Property(2, resource.toString()));
            }
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getObjectProperties(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#ObjectProperty"));
        ResourceInfo[] resourceInfoArray = new ResourceInfo[]{};
        if (this.hasClass(string, string2)) {
            resourceInfoArray = this.getSuperClasses(string, string2, (byte)1);
        }
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Resource resource = statement.getSubject();
            if (this.sail.getStatements(this.getResource(string2), this.getURI(resource.toString()), null).hasNext()) {
                arrayList.add(new Property(1, resource.toString()));
            }
            for (int i = 0; i < resourceInfoArray.length; ++i) {
                if (!this.sail.getStatements(this.getResource(resourceInfoArray[i].getUri()), this.getURI(resource.toString()), null).hasNext()) continue;
                arrayList.add(new Property(1, resource.toString()));
            }
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getTransitiveProperties(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#TransitiveProperty"));
        ResourceInfo[] resourceInfoArray = new ResourceInfo[]{};
        if (this.hasClass(string, string2)) {
            resourceInfoArray = this.getSuperClasses(string, string2, (byte)1);
        }
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Resource resource = statement.getSubject();
            if (this.sail.getStatements(this.getResource(string2), this.getURI(resource.toString()), null).hasNext()) {
                arrayList.add(new Property(4, resource.toString()));
            }
            for (int i = 0; i < resourceInfoArray.length; ++i) {
                if (!this.sail.getStatements(this.getResource(resourceInfoArray[i].getUri()), this.getURI(resource.toString()), null).hasNext()) continue;
                arrayList.add(new Property(4, resource.toString()));
            }
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getSymmetricProperties(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#SymmetricProperty"));
        ResourceInfo[] resourceInfoArray = new ResourceInfo[]{};
        if (this.hasClass(string, string2)) {
            resourceInfoArray = this.getSuperClasses(string, string2, (byte)1);
        }
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Resource resource = statement.getSubject();
            if (this.sail.getStatements(this.getResource(string2), this.getURI(resource.toString()), null).hasNext()) {
                arrayList.add(new Property(3, resource.toString()));
            }
            for (int i = 0; i < resourceInfoArray.length; ++i) {
                if (!this.sail.getStatements(this.getResource(resourceInfoArray[i].getUri()), this.getURI(resource.toString()), null).hasNext()) continue;
                arrayList.add(new Property(4, resource.toString()));
            }
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public boolean isAnnotationProperty(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#AnnotationProperty"));
    }

    @Override
    public void addAnnotationPropertyValue(String string, String string2, String string3, String string4, String string5) throws GateOntologyException {
        if (!this.isAnnotationProperty(string, string3)) {
            throw new GateOntologyException("No annotation property found with the URI :" + string3);
        }
        this.addUULStatement(string2, string3, string4, string5);
    }

    @Override
    public PropertyValue[] getAnnotationPropertyValues(String string, String string2, String string3) throws GateOntologyException {
        if (!this.isAnnotationProperty(string, string3)) {
            throw new GateOntologyException("No annotation property found with the URI :" + string3);
        }
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string3), null);
        while (statementIterator.hasNext()) {
            PropertyValue propertyValue;
            Statement statement = statementIterator.next();
            if (statement.getObject() instanceof Literal) {
                Literal literal = (Literal)statement.getObject();
                propertyValue = new PropertyValue(literal.getLanguage(), literal.getLabel());
            } else {
                propertyValue = new PropertyValue(null, statement.getObject().toString());
            }
            arrayList.add(propertyValue);
        }
        return this.listToPropertyValueArray(arrayList);
    }

    @Override
    public String getAnnotationPropertyValue(String string, String string2, String string3, String string4) throws GateOntologyException {
        if (!this.isAnnotationProperty(string, string3)) {
            throw new GateOntologyException("No annotation property found with the URI :" + string3);
        }
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string3), null);
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Literal literal = (Literal)statement.getObject();
            if (string4 != null && !literal.getLanguage().equals(string4)) continue;
            return literal.getLabel();
        }
        return null;
    }

    @Override
    public void removeAnnotationPropertyValue(String string, String string2, String string3, String string4, String string5) throws GateOntologyException {
        if (!this.isAnnotationProperty(string, string3)) {
            throw new GateOntologyException("No annotation property found with the URI :" + string3);
        }
        this.startTransaction(string);
        this.removeUULStatement(string2, string3, string4, string5);
        this.endTransaction(string);
    }

    @Override
    public void removeAnnotationPropertyValues(String string, String string2, String string3) throws GateOntologyException {
        try {
            if (!this.isAnnotationProperty(string, string3)) {
                throw new GateOntologyException("No annotation property found with the URI :" + string3);
            }
            this.startTransaction(string);
            this.sail.removeStatements(this.getResource(string2), this.getURI(string3), null);
            this.endTransaction(string);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
    }

    @Override
    public void addRDFProperty(String string, String string2, String[] stringArray, String[] stringArray2) throws GateOntologyException {
        int n;
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#domain", stringArray[n]);
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#range", stringArray2[n]);
            }
        }
    }

    @Override
    public boolean isRDFProperty(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"));
    }

    @Override
    public void addDataTypeProperty(String string, String string2, String[] stringArray, String string3) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#DatatypeProperty");
        this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#range", string3);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#domain", stringArray[i]);
            }
        }
    }

    @Override
    public String getDatatype(String string, String string2) throws GateOntologyException {
        if (!this.isDatatypeProperty(string, string2)) {
            throw new GateOntologyException("Invalid DatatypeProperty :" + string2);
        }
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI("http://www.w3.org/2000/01/rdf-schema#range"), null);
        String string3 = null;
        while (statementIterator.hasNext()) {
            string3 = statementIterator.next().getObject().toString();
            if (OntologyUtilities.getDataType(string3) == null) continue;
            return string3;
        }
        return null;
    }

    @Override
    public void addSymmetricProperty(String string, String string2, String[] stringArray) throws GateOntologyException {
        if (DEBUG) {
            this.print("addSymmetricProperty");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#SymmetricProperty");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#domain", stringArray[i]);
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#range", stringArray[i]);
            }
        }
    }

    @Override
    public boolean isEquivalentPropertyAs(String string, String string2, String string3) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#equivalentProperty"), (Value)this.getResource(string3));
    }

    @Override
    public Property[] getSuperProperties(String string, String string2, byte by) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = by == 0 ? this.sail.getDirectSubPropertyOf(this.getResource(string2), null) : this.sail.getSubPropertyOf(this.getResource(string2), null);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            String string3 = statement.getObject().toString();
            if (string3.equals(string2)) continue;
            byte by2 = this.getPropertyType(string, string3);
            arrayList.add(new Property(by2, string3));
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getSubProperties(String string, String string2, byte by) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = by == 0 ? this.sail.getDirectSubPropertyOf(null, this.getResource(string2)) : this.sail.getSubPropertyOf(null, this.getResource(string2));
        ArrayList<Property> arrayList = new ArrayList<Property>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            String string3 = statement.getSubject().toString();
            if (string3.equals(string2)) continue;
            byte by2 = this.getPropertyType(string, string3);
            arrayList.add(new Property(by2, string3));
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public boolean isSuperPropertyOf(String string, String string2, String string3, byte by) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = by == 0 ? this.sail.getDirectSubPropertyOf(this.getResource(string3), this.getResource(string2)) : this.sail.getSubPropertyOf(this.getResource(string3), this.getResource(string2));
        return statementIterator.hasNext();
    }

    @Override
    public boolean isSubPropertyOf(String string, String string2, String string3, byte by) throws GateOntologyException {
        return this.isSuperPropertyOf(string, string2, string3, by);
    }

    @Override
    public boolean hasIndividual(String string, String string2, String string3, byte by) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = by == 0 ? this.sail.getDirectType(this.getResource(string3), this.getResource(string2)) : this.sail.getType(this.getResource(string3), this.getResource(string2));
        return statementIterator.hasNext();
    }

    @Override
    public boolean isDifferentIndividualFrom(String string, String string2, String string3) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#differentFrom"), (Value)this.getResource(string3));
    }

    @Override
    public boolean isSameIndividualAs(String string, String string2, String string3) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#differentFrom"), (Value)this.getResource(string3));
    }

    @Override
    public void addRDFPropertyValue(String string, String string2, String string3, String string4) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, string3, string4);
    }

    @Override
    public void removeRDFPropertyValue(String string, String string2, String string3, String string4) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        this.startTransaction(string);
        this.removeUUUStatement(string2, string3, string4);
        this.endTransaction(string);
    }

    @Override
    public ResourceInfo[] getRDFPropertyValues(String string, String string2, String string3) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string3), null);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            arrayList.add(statement.getObject());
        }
        return this.listToResourceInfoArray(arrayList);
    }

    @Override
    public void removeRDFPropertyValues(String string, String string2, String string3) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        try {
            this.startTransaction(string);
            this.sail.removeStatements(this.getResource(string2), this.getURI(string3), null);
            this.endTransaction(string);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
    }

    @Override
    public void addDatatypePropertyValue(String string, String string2, String string3, String string4, String string5) throws GateOntologyException {
        if (!this.isDatatypeProperty(string, string3)) {
            throw new GateOntologyException("No datatype property exists with URI :" + string3);
        }
        this.addUUDStatement(string2, string3, string5, string4);
    }

    @Override
    public void removeDatatypePropertyValue(String string, String string2, String string3, String string4, String string5) throws GateOntologyException {
        if (!this.isDatatypeProperty(string, string3)) {
            throw new GateOntologyException("No datatype property exists with URI :" + string3);
        }
        this.startTransaction(string);
        this.removeUUDStatement(string2, string3, string5, string4);
        this.endTransaction(string);
    }

    @Override
    public PropertyValue[] getDatatypePropertyValues(String string, String string2, String string3) throws GateOntologyException {
        if (!this.isDatatypeProperty(string, string3)) {
            throw new GateOntologyException("No datatype property exists with URI :" + string3);
        }
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string3), null);
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Literal literal = (Literal)statement.getObject();
            String string4 = "http://www.w3.org/2001/XMLSchema#string";
            if (literal.getDatatype() != null) {
                string4 = literal.getDatatype().toString();
            }
            arrayList.add(new PropertyValue(string4, literal.getLabel()));
        }
        return this.listToPropertyValueArray(arrayList);
    }

    @Override
    public void removeDatatypePropertyValues(String string, String string2, String string3) throws GateOntologyException {
        if (!this.isDatatypeProperty(string, string3)) {
            throw new GateOntologyException("No datatype property exists with URI :" + string3);
        }
        this.startTransaction(string);
        this.removeUUUStatement(string2, string3, null);
        this.endTransaction(string);
    }

    @Override
    public void addObjectPropertyValue(String string, String string2, String string3, String string4) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        if (!this.sail.hasStatement(this.getResource(string3), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#ObjectProperty"))) {
            throw new GateOntologyException("No object property exists with URI :" + string3);
        }
        this.addUUUStatement(string2, string3, string4);
    }

    @Override
    public void removeObjectPropertyValue(String string, String string2, String string3, String string4) throws GateOntologyException {
        if (!this.isObjectProperty(string, string3)) {
            throw new GateOntologyException("No object property exists with URI :" + string3);
        }
        this.startTransaction(string);
        this.removeUUUStatement(string2, string3, string4);
        this.endTransaction(string);
    }

    @Override
    public String[] getObjectPropertyValues(String string, String string2, String string3) throws GateOntologyException {
        if (!(this.isObjectProperty(string, string3) || this.isTransitiveProperty(string, string3) || this.isSymmetricProperty(string, string3))) {
            throw new GateOntologyException("No object/transitive/symmetric property exists with URI :" + string3);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string3), null);
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            arrayList.add(statement.getObject().toString());
        }
        return this.listToArray(arrayList);
    }

    @Override
    public void removeObjectPropertyValues(String string, String string2, String string3) throws GateOntologyException {
        if (!this.isObjectProperty(string, string3)) {
            throw new GateOntologyException("No object property exists with URI :" + string3);
        }
        this.startTransaction(string);
        this.removeUUUStatement(string2, string3, null);
        this.endTransaction(string);
    }

    public void destroy() {
    }

    @Override
    public boolean login(String string, String string2) {
        if (DEBUG) {
            this.print("login");
        }
        try {
            this.service.login(string, string2);
        }
        catch (AccessDeniedException accessDeniedException) {
            return false;
        }
        int n = this.getUserID(string, string2);
        return n != -1;
    }

    @Override
    public void logout(String string) throws GateOntologyException {
        if (DEBUG) {
            this.print("logout");
        }
        this.mapToRepositoryDetails.remove(string);
        this.service.logout();
        this.service.shutDown();
        this.currentRepository = null;
        this.sail = null;
        System.gc();
    }

    @Override
    public String[] getRepositoryList() throws GateOntologyException {
        RepositoryList repositoryList;
        List list;
        if (DEBUG) {
            this.print("getRepositoryList");
        }
        if ((list = (repositoryList = this.service.getRepositoryList()).getRepositories()) == null) {
            return new String[0];
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            RepositoryInfo repositoryInfo = (RepositoryInfo)list.get(i);
            stringArray[i] = repositoryInfo.getRepositoryId();
        }
        return stringArray;
    }

    @Override
    public void setCurrentRepositoryID(String string) throws GateOntologyException {
        if (DEBUG) {
            this.print("setCurrentRepository");
        }
        if (this.sail != null && this.sail.transactionStarted()) {
            this.sail.commitTransaction();
        }
        try {
            LocalRepository localRepository = (LocalRepository)this.service.getRepository(string);
            if (localRepository == null) {
                throw new GateOntologyException("Repository ID " + string + " does not exist!");
            }
            if (!(localRepository.getSail() instanceof OWLIMSchemaRepository)) {
                throw new GateOntologyException("Repository ID " + string + "is not an OWLIMSchemaRepository!");
            }
            this.currentRepository = localRepository;
            this.sail = (OWLIMSchemaRepository)localRepository.getSail();
            RepositoryDetails repositoryDetails = this.mapToRepositoryDetails.get(string);
            if (repositoryDetails == null) {
                repositoryDetails = new RepositoryDetails();
                repositoryDetails.repository = this.currentRepository;
                repositoryDetails.sail = this.sail;
                repositoryDetails.ontologyUrl = this.ontologyUrl;
                repositoryDetails.returnSystemStatements = this.returnSystemStatements;
                this.mapToRepositoryDetails.put(string, repositoryDetails);
            } else {
                this.ontologyUrl = repositoryDetails.ontologyUrl;
            }
        }
        catch (ConfigurationException configurationException) {
            throw new GateOntologyException(configurationException);
        }
        catch (UnknownRepositoryException unknownRepositoryException) {
            throw new GateOntologyException(unknownRepositoryException);
        }
    }

    @Override
    public String getCurrentRepositoryID() {
        if (DEBUG) {
            this.print("getCurrentRepository");
        }
        return this.currentRepository.getRepositoryId();
    }

    @Override
    public String createRepository(String string, String string2, String string3, String string4, String string5, byte by, String string6, boolean bl, boolean bl2) throws GateOntologyException {
        if (DEBUG) {
            this.print("createRepository");
        }
        if (string6 == null) {
            try {
                string6 = new File(gosHome.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new GateOntologyException("Cannot construct persistence location from gosHome", uRISyntaxException);
            }
        }
        if (string3 == null) {
            string3 = "";
        }
        this.createNewUser(string2, string3);
        this.returnSystemStatements = bl2;
        boolean bl3 = this.setRepository(string, string4, true, string5, by, string6, bl);
        if (bl3) {
            return string;
        }
        RepositoryConfig repositoryConfig = this.createNewRepository(string, string4, true, string5, bl, string6, string2, string3, by, false);
        this.addOntologyData(string, string4, true, string5, by);
        this.service.getSystemConfig().addRepositoryConfig(repositoryConfig);
        if (bl) {
            this.saveConfiguration();
        }
        if (DEBUG) {
            System.out.println("Repository created!");
        }
        this.loadRepositoryDetails(string);
        return string;
    }

    @Override
    public String createRepositoryFromUrl(String string, String string2, String string3, String string4, String string5, byte by, String string6, boolean bl, boolean bl2) throws GateOntologyException {
        if (DEBUG) {
            this.print("createRepository");
        }
        if (string6 == null) {
            try {
                string6 = new File(gosHome.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new GateOntologyException("Cannot construct persistence location from gosHome", uRISyntaxException);
            }
        }
        if (string3 == null) {
            string3 = "";
        }
        this.createNewUser(string2, string3);
        this.returnSystemStatements = bl2;
        boolean bl3 = this.setRepository(string, string4, false, string5, by, string6, bl);
        if (bl3) {
            return string;
        }
        RepositoryConfig repositoryConfig = this.createNewRepository(string, string4, false, string5, bl, string6, string2, string3, by, false);
        this.addOntologyData(string, string4, false, string5, by);
        this.service.getSystemConfig().addRepositoryConfig(repositoryConfig);
        if (bl) {
            this.saveConfiguration();
        }
        if (DEBUG) {
            System.out.println("Repository created!");
        }
        this.ontologyUrl = string4;
        this.loadRepositoryDetails(string);
        return string;
    }

    @Override
    public void removeRepository(String string, boolean bl) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        this.startTransaction(null);
        if (this.currentRepository == null) {
            return;
        }
        try {
            this.sail.clearRepository();
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
        this.service.getSystemConfig().removeRepository(this.currentRepository.getRepositoryId());
        if (bl) {
            this.saveConfiguration();
        }
        this.endTransaction(null);
        this.mapToRepositoryDetails.remove(string);
    }

    @Override
    public void cleanOntology(String string) throws GateOntologyException {
        if (DEBUG) {
            this.print("cleanOntology");
        }
        this.loadRepositoryDetails(string);
        if (this.currentRepository == null) {
            return;
        }
        RepositoryConfig repositoryConfig = this.service.getSystemConfig().getRepositoryConfig(this.currentRepository.getRepositoryId());
        if (repositoryConfig == null) {
            return;
        }
        this.startTransaction(string);
        try {
            this.sail.clearRepository();
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
        this.endTransaction(string);
    }

    @Override
    public String getOntologyData(String string, byte by) throws GateOntologyException {
        if (DEBUG) {
            this.print("getOntologyData");
        }
        this.loadRepositoryDetails(string);
        if (this.sail.transactionStarted()) {
            this.sail.commitTransaction();
        }
        try {
            InputStream inputStream = this.currentRepository.extractRDF(this.getRDFFormat(by), true, true, true, true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = bufferedReader.readLine();
            StringBuffer stringBuffer = new StringBuffer(1028);
            while (string2 != null) {
                stringBuffer.append(string2 + "\n");
                string2 = bufferedReader.readLine();
            }
            return stringBuffer.toString();
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new GateOntologyException(accessDeniedException);
        }
        catch (IOException iOException) {
            throw new GateOntologyException(iOException);
        }
    }

    @Override
    public void setVersion(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        if (DEBUG) {
            this.print("setVersion");
        }
        this.addUULStatement(this.ontologyUrl, "http://www.w3.org/2002/07/owl#versionInfo", string2, null);
    }

    @Override
    public String getVersion(String string) throws GateOntologyException {
        if (DEBUG) {
            this.print("getVersion");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(this.ontologyUrl), this.getURI("http://www.w3.org/2002/07/owl#versionInfo"), null);
        if (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            return statement.getObject().toString();
        }
        return null;
    }

    @Override
    public void addClass(String string, String string2, byte by) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        if (DEBUG) {
            this.print("addClass");
        }
        switch (by) {
            case 0: {
                this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#Class");
                return;
            }
        }
        this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#Restriction");
    }

    @Override
    public String[] removeClass(String string, String string2) throws GateOntologyException {
        String[] stringArray;
        Resource resource;
        Statement statement;
        this.loadRepositoryDetails(string);
        if (DEBUG) {
            this.print("removeClass");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.removeUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", null) == 0) {
            throw new GateOntologyException(string2 + " is not an explicit resource");
        }
        arrayList.add(string2);
        try {
            this.startTransaction(string);
            this.sail.removeStatements(this.getResource(string2), this.getURI("http://www.w3.org/2000/01/rdf-schema#subClassOf"), null);
            this.endTransaction(string);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException.getMessage());
        }
        ResourceInfo[] resourceInfoArray = this.getSubClasses(string, string2, (byte)0);
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            String[] stringArray2 = this.removeClass(string, resourceInfoArray[i].getUri());
            arrayList.addAll(Arrays.asList(stringArray2));
        }
        String[] stringArray3 = this.getIndividuals(string, string2, (byte)0);
        for (int i = 0; i < stringArray3.length; ++i) {
            statement = this.removeIndividual(string, stringArray3[i]);
            arrayList.addAll(Arrays.asList(statement));
        }
        this.startTransaction(string);
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/2000/01/rdf-schema#domain"), (Value)this.getResource(string2));
        this.endTransaction(string);
        while (statementIterator.hasNext()) {
            statement = statementIterator.next();
            resource = statement.getSubject();
            stringArray = this.removePropertyFromOntology(string, resource.toString());
            arrayList.addAll(Arrays.asList(stringArray));
        }
        this.startTransaction(string);
        statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/2000/01/rdf-schema#range"), (Value)this.getResource(string2));
        this.endTransaction(string);
        while (statementIterator.hasNext()) {
            statement = statementIterator.next();
            resource = statement.getSubject();
            stringArray = this.removePropertyFromOntology(string, resource.toString());
            arrayList.addAll(Arrays.asList(stringArray));
        }
        try {
            this.startTransaction(string);
            this.sail.removeStatements(this.getResource(string2), null, null);
            if (!(this.getResource(string2) instanceof BNode)) {
                this.sail.removeStatements(null, this.getURI(string2), null);
            }
            this.sail.removeStatements(null, null, (Value)this.getResource(string2));
            this.endTransaction(string);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
        return this.listToArray(arrayList);
    }

    @Override
    public boolean hasClass(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("hasClass");
        }
        this.loadRepositoryDetails(string);
        return this.sail.isClass(this.getResource(string2));
    }

    @Override
    public ResourceInfo[] getClasses(String string, boolean bl) throws GateOntologyException {
        if (DEBUG) {
            this.print("getClasses");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getClasses();
        ArrayList<Value> arrayList = new ArrayList<Value>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Resource resource = null;
            resource = this.getResource(statement.getSubject().toString());
            if (bl && !this.isTopClass(string, resource.toString())) continue;
            arrayList.add((Value)resource);
        }
        if (DEBUG) {
            System.out.println("Top Classes : " + arrayList.size());
        }
        return this.listToResourceInfoArray(arrayList);
    }

    @Override
    public boolean isTopClass(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("isTopClass");
        }
        this.loadRepositoryDetails(string);
        Resource resource = this.getResource(string2);
        StatementIterator statementIterator = this.sail.getSubClassOf(resource, null);
        boolean bl = true;
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            if (statement.getObject().toString().equalsIgnoreCase(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void addSubClass(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("addSubClass");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string3, "http://www.w3.org/2000/01/rdf-schema#subClassOf", string2);
    }

    @Override
    public void addSuperClass(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("addSuperClass");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string3, "http://www.w3.org/2000/01/rdf-schema#subClassOf", string2);
    }

    @Override
    public void removeSubClass(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("removeSubClass");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getDirectType(null, this.getResource(string3));
        this.removeUUUStatement(string3, "http://www.w3.org/2000/01/rdf-schema#subClassOf", string2);
    }

    @Override
    public void removeSuperClass(String string, String string2, String string3) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        if (DEBUG) {
            this.print("removeSuperClass");
        }
        this.removeUUUStatement(string3, "http://www.w3.org/2000/01/rdf-schema#subClassOf", string2);
    }

    @Override
    public ResourceInfo[] getSubClasses(String string, String string2, byte by) throws GateOntologyException {
        if (DEBUG) {
            this.print("getSubClasses");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = by == 0 ? this.sail.getDirectSubClassOf(null, this.getResource(string2)) : this.sail.getSubClassOf(null, this.getResource(string2));
        ArrayList<Value> arrayList = new ArrayList<Value>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            if (statement.getSubject().toString().equals(string2)) continue;
            arrayList.add((Value)statement.getSubject());
        }
        return this.listToResourceInfoArray(arrayList);
    }

    @Override
    public ResourceInfo[] getSuperClasses(String string, String string2, byte by) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        if (DEBUG) {
            this.print("getSuperClasses");
        }
        StatementIterator statementIterator = null;
        statementIterator = by == 0 ? this.sail.getDirectSubClassOf(this.getResource(string2), null) : this.sail.getSubClassOf(this.getResource(string2), null);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            if (statement.getObject().toString().equals(string2)) continue;
            arrayList.add(statement.getObject());
        }
        return this.listToResourceInfoArray(arrayList);
    }

    @Override
    public void setDisjointClassWith(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("setDisjointWith");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/2002/07/owl#disjointWith", string3);
    }

    @Override
    public void setEquivalentClassAs(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("setEquivalentClassAs");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/2002/07/owl#equivalentClass", string3);
    }

    @Override
    public String[] getDisjointClasses(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("setDisjointClasses");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#disjointWith"), null);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            arrayList.add(statement.getObject().toString());
        }
        return this.listToArray(arrayList);
    }

    @Override
    public ResourceInfo[] getEquivalentClasses(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("getSameClasses");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#equivalentClass"), null);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            arrayList.add(statement.getObject());
        }
        return this.listToResourceInfoArray(arrayList);
    }

    @Override
    public String[] removePropertyFromOntology(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("removePropertyWithName");
        }
        this.loadRepositoryDetails(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.removeUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", null) == 0) {
            throw new GateOntologyException(string2 + " is not an explicit Property");
        }
        arrayList.add(string2);
        try {
            this.startTransaction(string);
            this.sail.removeStatements(null, this.getURI(string2), null);
            this.sail.removeStatements(this.getResource(string2), this.getURI("http://www.w3.org/2000/01/rdf-schema#subPropertyOf"), null);
            this.endTransaction(string);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
        Property[] propertyArray = this.getSubProperties(string, string2, (byte)0);
        for (int i = 0; i < propertyArray.length; ++i) {
            if (this.sail.hasExplicitStatement(this.getResource(propertyArray[i].getUri()), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null)) continue;
            String[] stringArray = this.removePropertyFromOntology(string, propertyArray[i].getUri());
            arrayList.addAll(Arrays.asList(stringArray));
        }
        this.removeUUUStatement(string2, null, null);
        this.removeUUUStatement(null, string2, null);
        this.removeUUUStatement(null, null, string2);
        return this.listToArray(arrayList);
    }

    @Override
    public void addObjectProperty(String string, String string2, String[] stringArray, String[] stringArray2) throws GateOntologyException {
        int n;
        if (DEBUG) {
            this.print("addObjectProperty");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#ObjectProperty");
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#domain", stringArray[n]);
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#range", stringArray2[n]);
            }
        }
    }

    @Override
    public void addTransitiveProperty(String string, String string2, String[] stringArray, String[] stringArray2) throws GateOntologyException {
        int n;
        if (DEBUG) {
            this.print("addTransitiveProperty");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#TransitiveProperty");
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#domain", stringArray[n]);
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.addUUUStatement(string2, "http://www.w3.org/2000/01/rdf-schema#range", stringArray2[n]);
            }
        }
    }

    @Override
    public Property[] getRDFProperties(String string) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"));
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            if (this.isObjectProperty(string, statement.getSubject().toString()) || this.isAnnotationProperty(string, statement.getSubject().toString()) || this.isDatatypeProperty(string, statement.getSubject().toString())) continue;
            Property property = new Property(0, statement.getSubject().toString());
            arrayList.add(property);
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getObjectProperties(String string) throws GateOntologyException {
        Property property;
        Statement statement;
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#ObjectProperty"));
        while (statementIterator.hasNext()) {
            statement = statementIterator.next();
            property = new Property(1, statement.getSubject().toString());
            arrayList.add(property);
        }
        statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#SymmetricProperty"));
        while (statementIterator.hasNext()) {
            statement = statementIterator.next();
            property = new Property(3, statement.getSubject().toString());
            arrayList.add(property);
        }
        statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#TransitiveProperty"));
        while (statementIterator.hasNext()) {
            statement = statementIterator.next();
            property = new Property(4, statement.getSubject().toString());
            arrayList.add(property);
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getSymmetricProperties(String string) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#SymmetricProperty"));
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Property property = new Property(3, statement.getSubject().toString());
            arrayList.add(property);
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getTransitiveProperties(String string) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#TransitiveProperty"));
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Property property = new Property(4, statement.getSubject().toString());
            arrayList.add(property);
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getDatatypeProperties(String string) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#DatatypeProperty"));
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Property property = new Property(2, statement.getSubject().toString());
            arrayList.add(property);
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getAnnotationProperties(String string) throws GateOntologyException {
        Property[] propertyArray;
        this.loadRepositoryDetails(string);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#AnnotationProperty"));
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            propertyArray = new Property(5, statement.getSubject().toString());
            arrayList.add((Property)propertyArray);
        }
        boolean bl = this.returnSystemStatements;
        this.returnSystemStatements = true;
        propertyArray = this.listToPropertyArray(arrayList);
        this.returnSystemStatements = bl;
        return propertyArray;
    }

    @Override
    public ResourceInfo[] getDomain(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("getDomain");
        }
        if (this.isAnnotationProperty(string, string2)) {
            throw new GateOntologyException("AnnotationProperties do no specify any domain or range");
        }
        StatementIterator statementIterator = this.sail.getDomain(this.getResource(string2), null);
        ArrayList<ResourceInfo> arrayList = new ArrayList<ResourceInfo>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Resource resource = this.getResource(statement.getObject().toString());
            boolean bl = this.sail.hasStatement(resource, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#Restriction"));
            int n = 0;
            if (bl) {
                if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#hasValue"), null)) {
                    n = 4;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#someValuesFrom"), null)) {
                    n = 6;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#allValuesFrom"), null)) {
                    n = 5;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#cardinality"), null)) {
                    n = 1;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#minCardinality"), null)) {
                    n = 2;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#maxCardinality"), null)) {
                    n = 3;
                }
            } else if (resource instanceof BNode) {
                n = 7;
            }
            arrayList.add(new ResourceInfo(statement.getObject().toString(), (byte)n));
        }
        return this.reduceToMostSpecificClasses(string, arrayList);
    }

    @Override
    public ResourceInfo[] getRange(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("getRange");
        }
        if (this.isAnnotationProperty(string, string2)) {
            throw new GateOntologyException("AnnotationProperties do no specify any domain or range");
        }
        if (this.isDatatypeProperty(string, string2)) {
            throw new GateOntologyException("Please use getDatatype(String repositoryID, String theDatatypeProerptyURI) method instead");
        }
        StatementIterator statementIterator = this.sail.getRange(this.getResource(string2), null);
        ArrayList<ResourceInfo> arrayList = new ArrayList<ResourceInfo>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            Resource resource = this.getResource(statement.getObject().toString());
            boolean bl = this.sail.hasStatement(resource, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#Restriction"));
            int n = 0;
            if (bl) {
                if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#hasValue"), null)) {
                    n = 4;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#someValuesFrom"), null)) {
                    n = 6;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#allValuesFrom"), null)) {
                    n = 5;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#cardinality"), null)) {
                    n = 1;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#minCardinality"), null)) {
                    n = 2;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#maxCardinality"), null)) {
                    n = 3;
                }
            } else if (resource instanceof BNode) {
                n = 7;
            }
            arrayList.add(new ResourceInfo(statement.getObject().toString(), (byte)n));
        }
        return this.reduceToMostSpecificClasses(string, arrayList);
    }

    @Override
    public boolean isFunctional(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("isFunctional");
        }
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#FunctionalProperty"));
    }

    @Override
    public void setFunctional(String string, String string2, boolean bl) throws GateOntologyException {
        if (DEBUG) {
            this.print("setFunctional");
        }
        this.loadRepositoryDetails(string);
        if (bl) {
            this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#FunctionalProperty");
        } else {
            this.removeUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#FunctionalProperty");
        }
    }

    @Override
    public boolean isInverseFunctional(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("isInverseFunctional");
        }
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#InverseFunctionalProperty"));
    }

    @Override
    public void setInverseFunctional(String string, String string2, boolean bl) throws GateOntologyException {
        if (DEBUG) {
            this.print("setInverseFunctional");
        }
        this.loadRepositoryDetails(string);
        if (bl) {
            this.addUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#InverseFunctionalProperty");
        } else {
            this.removeUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#InverseFunctionalProperty");
        }
    }

    @Override
    public boolean isSymmetricProperty(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("isSymmetricProperty");
        }
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#SymmetricProperty"));
    }

    @Override
    public boolean isTransitiveProperty(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("isTransitiveProperty");
        }
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#TransitiveProperty"));
    }

    @Override
    public boolean isDatatypeProperty(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("isDatatypeProperty");
        }
        this.loadRepositoryDetails(string);
        return this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#DatatypeProperty"));
    }

    @Override
    public boolean isObjectProperty(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("isObjectProperty");
        }
        this.loadRepositoryDetails(string);
        boolean bl = this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#ObjectProperty"));
        if (!bl) {
            bl = this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#SymmetricProperty"));
        }
        if (!bl) {
            bl = this.sail.hasStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#TransitiveProperty"));
        }
        return bl;
    }

    @Override
    public void setEquivalentPropertyAs(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("setEquivalentPropertyAs");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/2002/07/owl#equivalentProperty", string3);
    }

    @Override
    public Property[] getEquivalentPropertyAs(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("getEquivalentPropertyAs");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#equivalentProperty"), null);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            arrayList.add(this.createPropertyObject(string, statement.getObject().toString()));
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public void addSuperProperty(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("addSuperProperty");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string3, "http://www.w3.org/2000/01/rdf-schema#subPropertyOf", string2);
    }

    @Override
    public void removeSuperProperty(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("removeSuperProperty");
        }
        this.loadRepositoryDetails(string);
        this.removeUUUStatement(string3, "http://www.w3.org/2000/01/rdf-schema#subPropertyOf", string2);
    }

    @Override
    public void addSubProperty(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("addSubProperty");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string3, "http://www.w3.org/2000/01/rdf-schema#subPropertyOf", string2);
    }

    @Override
    public void removeSubProperty(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("removeSubProperty");
        }
        this.loadRepositoryDetails(string);
        this.removeUUUStatement(string3, "http://www.w3.org/2000/01/rdf-schema#subPropertyOf", string2);
    }

    @Override
    public Property[] getSuperProperties(String string, String string2, boolean bl) throws GateOntologyException {
        if (DEBUG) {
            this.print("getSuperProperties");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = bl ? this.sail.getDirectSubPropertyOf(this.getResource(string2), null) : this.sail.getSubPropertyOf(this.getResource(string2), null);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            if (statement.getObject().toString().equalsIgnoreCase(string2)) continue;
            arrayList.add(this.createPropertyObject(string, statement.getObject().toString()));
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getSubProperties(String string, String string2, boolean bl) throws GateOntologyException {
        if (DEBUG) {
            this.print("getSubProperties");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = bl ? this.sail.getDirectSubPropertyOf(null, this.getResource(string2)) : this.sail.getSubPropertyOf(null, this.getResource(string2));
        ArrayList<Property> arrayList = new ArrayList<Property>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            if (statement.getSubject().toString().equals(string2)) continue;
            arrayList.add(this.createPropertyObject(string, statement.getSubject().toString()));
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public Property[] getInverseProperties(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("getInverseProperties");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#inverseOf"), null);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        while (statementIterator.hasNext()) {
            arrayList.add(this.createPropertyObject(string, statementIterator.next().getObject().toString()));
        }
        return this.listToPropertyArray(arrayList);
    }

    @Override
    public void setInverseOf(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("setInverseOf");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/2002/07/owl#inverseOf", string3);
    }

    @Override
    public void addIndividual(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("addIndividual");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string3, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", string2);
    }

    @Override
    public String[] removeIndividual(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("removeIndividual");
        }
        this.loadRepositoryDetails(string);
        int n = this.removeUUUStatement(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", null);
        if (n == 0) {
            throw new GateOntologyException(string2 + " is not an explicit Individual");
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.addAll(Arrays.asList(this.getObjectProperties(string)));
        try {
            this.startTransaction(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.sail.removeStatements(null, this.getURI(((Property)arrayList.get(i)).getUri()), (Value)this.getResource(string2));
            }
            this.endTransaction(string);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
        this.removeUUUStatement(string2, null, null);
        this.removeUUUStatement(null, null, string2);
        this.removeUUUStatement(null, string2, null);
        return new String[]{string2};
    }

    @Override
    public String[] getIndividuals(String string, String string2, byte by) throws GateOntologyException {
        if (DEBUG) {
            this.print("getIndividulas");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = by == 0 ? this.sail.getDirectType(null, this.getResource(string2)) : this.sail.getType(null, this.getResource(string2));
        ArrayList<String> arrayList = new ArrayList<String>();
        while (statementIterator.hasNext()) {
            Resource resource = statementIterator.next().getSubject();
            String string3 = resource.toString();
            if (this.hasClass(string, string3)) continue;
            arrayList.add(string3);
        }
        return this.listToArray(arrayList);
    }

    @Override
    public String[] getIndividuals(String string) throws GateOntologyException {
        if (DEBUG) {
            this.print("getIndividuals");
        }
        this.loadRepositoryDetails(string);
        ResourceInfo[] resourceInfoArray = this.getClasses(string, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            if (this.hasSystemNameSpace(resourceInfoArray[i].getUri())) continue;
            String[] stringArray = this.getIndividuals(string, resourceInfoArray[i].getUri(), (byte)0);
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
        }
        return this.listToArray(arrayList);
    }

    @Override
    public boolean hasIndividual(String string, String string2, String string3, boolean bl) throws GateOntologyException {
        if (DEBUG) {
            this.print("hasIndividual");
        }
        this.loadRepositoryDetails(string);
        if (bl) {
            return this.sail.isDirectType(this.getResource(string3), this.getResource(string2));
        }
        return this.sail.isType(this.getResource(string3), this.getResource(string2));
    }

    @Override
    public ResourceInfo[] getClassesOfIndividual(String string, String string2, byte by) throws GateOntologyException {
        if (DEBUG) {
            this.print("getClassesOfIndividual");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = null;
        statementIterator = by == 0 ? this.sail.getDirectType(this.getResource(string2), null) : this.sail.getType(this.getResource(string2), null);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            arrayList.add(statement.getObject());
        }
        return this.listToResourceInfoArray(arrayList);
    }

    @Override
    public void setDifferentIndividualFrom(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("setDifferentIndividualFrom");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/2002/07/owl#differentFrom", string3);
    }

    @Override
    public String[] getDifferentIndividualFrom(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("getDifferentIndividualFrom");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#differentFrom"), null);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (statementIterator.hasNext()) {
            arrayList.add(statementIterator.next().getObject().toString());
        }
        return this.listToArray(arrayList);
    }

    @Override
    public void setSameIndividualAs(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("setSameIndividualAs");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/2002/07/owl#sameAs", string3);
    }

    @Override
    public String[] getSameIndividualAs(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("getSameIndividualAs");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#sameAs"), null);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (statementIterator.hasNext()) {
            Value value = statementIterator.next().getObject();
            arrayList.add(value.toString());
        }
        return this.listToArray(arrayList);
    }

    @Override
    public Property getOnPropertyValue(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("getOnPropertyValue");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI("http://www.w3.org/2002/07/owl#onProperty"), null);
        if (statementIterator.hasNext()) {
            return this.createPropertyObject(string, statementIterator.next().getObject().toString());
        }
        return null;
    }

    @Override
    public void setOnPropertyValue(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("setOnPropertyValue");
        }
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, "http://www.w3.org/2002/07/owl#onProperty", string3);
    }

    @Override
    public PropertyValue getPropertyValue(String string, String string2, byte by) throws GateOntologyException {
        Value value;
        if (DEBUG) {
            this.print("getDataType");
        }
        this.loadRepositoryDetails(string);
        String string3 = null;
        switch (by) {
            case 1: {
                string3 = "http://www.w3.org/2002/07/owl#cardinality";
                break;
            }
            case 3: {
                string3 = "http://www.w3.org/2002/07/owl#maxCardinality";
                break;
            }
            case 2: {
                string3 = "http://www.w3.org/2002/07/owl#minCardinality";
                break;
            }
            default: {
                throw new GateOntologyException("Invalid restriction type");
            }
        }
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string3), null);
        if (statementIterator.hasNext() && (value = statementIterator.next().getObject()) instanceof Literal) {
            return new PropertyValue(((Literal)value).getDatatype().toString(), ((Literal)value).getLabel());
        }
        return null;
    }

    @Override
    public void setPropertyValue(String string, String string2, byte by, String string3, String string4) throws GateOntologyException {
        Statement statement;
        Value value;
        if (DEBUG) {
            this.print("getDataType");
        }
        this.loadRepositoryDetails(string);
        String string5 = null;
        switch (by) {
            case 1: {
                string5 = "http://www.w3.org/2002/07/owl#cardinality";
                break;
            }
            case 3: {
                string5 = "http://www.w3.org/2002/07/owl#maxCardinality";
                break;
            }
            case 2: {
                string5 = "http://www.w3.org/2002/07/owl#minCardinality";
                break;
            }
            default: {
                throw new GateOntologyException("Invalid restriction type");
            }
        }
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string5), null);
        Statement statement2 = null;
        if (statementIterator.hasNext() && (value = (statement = statementIterator.next()).getObject()) instanceof Literal && ((Literal)value).getDatatype().toString().equals(string4)) {
            statement2 = statement;
        }
        if (statement2 != null) {
            statement = (Literal)statement2.getObject();
            this.removeUUDStatement(string2, string5, statement.getLabel(), statement.getDatatype().toString());
        }
        this.addUUDStatement(string2, string5, string3, string4);
    }

    @Override
    public ResourceInfo getRestrictionValue(String string, String string2, byte by) throws GateOntologyException {
        if (DEBUG) {
            this.print("getRestrictionValue");
        }
        this.loadRepositoryDetails(string);
        String string3 = null;
        switch (by) {
            case 5: {
                string3 = "http://www.w3.org/2002/07/owl#allValuesFrom";
                break;
            }
            case 4: {
                string3 = "http://www.w3.org/2002/07/owl#hasValue";
                break;
            }
            case 6: {
                string3 = "http://www.w3.org/2002/07/owl#someValuesFrom";
                break;
            }
            default: {
                throw new GateOntologyException("Invalid restriction type");
            }
        }
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string3), null);
        if (statementIterator.hasNext()) {
            String string4 = statementIterator.next().getObject().toString();
            Resource resource = this.getResource(string4);
            boolean bl = this.sail.hasStatement(resource, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#Restriction"));
            int n = 0;
            if (bl) {
                if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#hasValue"), null)) {
                    n = 4;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#someValuesFrom"), null)) {
                    n = 6;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#allValuesFrom"), null)) {
                    n = 5;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#cardinality"), null)) {
                    n = 1;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#minCardinality"), null)) {
                    n = 2;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#maxCardinality"), null)) {
                    n = 3;
                }
            }
            return new ResourceInfo(string4, (byte)n);
        }
        return null;
    }

    @Override
    public void setRestrictionValue(String string, String string2, byte by, String string3) throws GateOntologyException {
        Object object;
        if (DEBUG) {
            this.print("setRestrictionValue");
        }
        this.loadRepositoryDetails(string);
        String string4 = null;
        switch (by) {
            case 5: {
                string4 = "http://www.w3.org/2002/07/owl#allValuesFrom";
                break;
            }
            case 4: {
                string4 = "http://www.w3.org/2002/07/owl#hasValue";
                break;
            }
            case 6: {
                string4 = "http://www.w3.org/2002/07/owl#someValuesFrom";
                break;
            }
            default: {
                throw new GateOntologyException("Invalid restriction type");
            }
        }
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string4), null);
        Object object2 = null;
        if (statementIterator.hasNext()) {
            object = statementIterator.next();
            Value value = object.getObject();
            object2 = object;
        }
        if (object2 != null) {
            object = object2.getObject().toString();
            this.removeUUUStatement(string2, string4, (String)object);
        }
        this.addUUUStatement(string2, string4, string3);
    }

    @Override
    public byte getClassType(String string, String string2) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        int n = -1;
        Resource resource = this.getResource(string2);
        if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#hasValue"), null)) {
            n = 4;
        } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#someValuesFrom"), null)) {
            n = 6;
        } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#allValuesFrom"), null)) {
            n = 5;
        } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#cardinality"), null)) {
            n = 1;
        } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#minCardinality"), null)) {
            n = 2;
        } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#maxCardinality"), null)) {
            n = 3;
        } else if (this.hasClass(string, string2)) {
            n = resource instanceof BNode ? 7 : 0;
        }
        return (byte)n;
    }

    @Override
    public void addStatement(String string, String string2, String string3, String string4) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        this.addUUUStatement(string2, string3, string4);
    }

    @Override
    public void removeStatement(String string, String string2, String string3, String string4) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        this.removeUUUStatement(string2, string3, string4);
    }

    private void addUUUStatement(String string, String string2, String string3) throws GateOntologyException {
        try {
            this.startTransaction(null);
            Resource resource = string != null ? this.getResource(string) : null;
            URI uRI = string2 != null ? this.sail.getValueFactory().createURI(string2) : null;
            Resource resource2 = string3 != null ? this.getResource(string3) : null;
            this.sail.addStatement(resource, uRI, (Value)resource2);
            this.endTransaction(null);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
    }

    private void addUULStatement(String string, String string2, String string3, String string4) throws GateOntologyException {
        try {
            this.startTransaction(null);
            Resource resource = string != null ? this.getResource(string) : null;
            URI uRI = string2 != null ? this.sail.getValueFactory().createURI(string2) : null;
            Literal literal = null;
            literal = string4 == null ? (string3 != null ? this.sail.getValueFactory().createLiteral(string3) : null) : (string3 != null ? this.sail.getValueFactory().createLiteral(string3, string4) : null);
            this.sail.addStatement(resource, uRI, (Value)literal);
            this.endTransaction(null);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
    }

    private void addUUDStatement(String string, String string2, String string3, String string4) throws GateOntologyException {
        try {
            this.startTransaction(null);
            Resource resource = string != null ? this.getResource(string) : null;
            URI uRI = string2 != null ? this.sail.getValueFactory().createURI(string2) : null;
            URI uRI2 = this.sail.getValueFactory().createURI(string4);
            Literal literal = string3 != null ? this.sail.getValueFactory().createLiteral(string3, uRI2) : null;
            this.sail.addStatement(resource, uRI, (Value)literal);
            this.endTransaction(null);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
    }

    private int removeUUUStatement(String string, String string2, String string3) throws GateOntologyException {
        try {
            this.startTransaction(null);
            Resource resource = string != null ? this.getResource(string) : null;
            URI uRI = string2 != null ? this.sail.getValueFactory().createURI(string2) : null;
            Resource resource2 = string3 != null ? this.getResource(string3) : null;
            int n = this.sail.removeStatements(resource, uRI, (Value)resource2);
            this.endTransaction(null);
            return n;
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
    }

    private void removeUULStatement(String string, String string2, String string3, String string4) throws GateOntologyException {
        try {
            this.startTransaction(null);
            Resource resource = string != null ? this.getResource(string) : null;
            URI uRI = string2 != null ? this.sail.getValueFactory().createURI(string2) : null;
            Literal literal = null;
            literal = string4 == null ? (string3 != null ? this.sail.getValueFactory().createLiteral(string3) : null) : (string3 != null ? this.sail.getValueFactory().createLiteral(string3, string4) : null);
            this.sail.removeStatements(resource, uRI, (Value)literal);
            this.endTransaction(null);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
    }

    private void removeUUDStatement(String string, String string2, String string3, String string4) throws GateOntologyException {
        try {
            this.startTransaction(null);
            Resource resource = string != null ? this.getResource(string) : null;
            URI uRI = string2 != null ? this.sail.getValueFactory().createURI(string2) : null;
            URI uRI2 = this.sail.getValueFactory().createURI(string4);
            Literal literal = string3 != null ? this.sail.getValueFactory().createLiteral(string3) : null;
            this.sail.removeStatements(resource, uRI, (Value)literal);
            literal = string3 != null ? this.sail.getValueFactory().createLiteral(string3, uRI2) : null;
            this.sail.removeStatements(resource, uRI, (Value)literal);
            this.endTransaction(null);
        }
        catch (SailUpdateException sailUpdateException) {
            throw new GateOntologyException(sailUpdateException);
        }
    }

    public void startTransaction(String string) throws GateOntologyException {
        if (string != null) {
            this.loadRepositoryDetails(string);
        }
        if (!this.sail.transactionStarted()) {
            this.sail.startTransaction();
        }
    }

    public void endTransaction(String string) throws GateOntologyException {
        if (string != null) {
            this.loadRepositoryDetails(string);
        }
        if (this.sail.transactionStarted()) {
            this.sail.commitTransaction();
        }
    }

    public boolean transactionStarted(String string) throws GateOntologyException {
        if (string != null) {
            this.loadRepositoryDetails(string);
        }
        return this.sail.transactionStarted();
    }

    public void commitTransaction(String string) throws GateOntologyException {
        if (string != null) {
            this.loadRepositoryDetails(string);
        }
        if (this.sail != null && this.sail.transactionStarted()) {
            this.sail.commitTransaction();
        }
    }

    private Property[] listToPropertyArray(List<Property> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (int i = 0; i < list.size(); ++i) {
            if (this.hasSystemNameSpace(list.get(i).getUri())) continue;
            arrayList.add(list.get(i));
        }
        Property[] propertyArray = new Property[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            propertyArray[i] = (Property)arrayList.get(i);
        }
        return propertyArray;
    }

    private PropertyValue[] listToPropertyValueArray(List<PropertyValue> list) {
        if (list == null) {
            return null;
        }
        PropertyValue[] propertyValueArray = new PropertyValue[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            propertyValueArray[i] = list.get(i);
        }
        return propertyValueArray;
    }

    private ResourceInfo[] listToResourceInfoArray(List<Value> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ResourceInfo> arrayList = new ArrayList<ResourceInfo>();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof BNode && list.get(i).toString().startsWith("FictiveNode_") || arrayList.contains(list.get(i)) || this.hasSystemNameSpace(list.get(i).toString())) continue;
            String string = list.get(i).toString();
            Resource resource = this.getResource(string);
            boolean bl = this.sail.hasStatement(resource, this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)this.getResource("http://www.w3.org/2002/07/owl#Restriction"));
            int n = 0;
            if (bl) {
                if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#hasValue"), null)) {
                    n = 4;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#someValuesFrom"), null)) {
                    n = 6;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#allValuesFrom"), null)) {
                    n = 5;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#cardinality"), null)) {
                    n = 1;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#minCardinality"), null)) {
                    n = 2;
                } else if (this.sail.hasStatement(resource, this.getURI("http://www.w3.org/2002/07/owl#maxCardinality"), null)) {
                    n = 3;
                }
            } else if (resource instanceof BNode) {
                n = 7;
            }
            arrayList.add(new ResourceInfo(list.get(i).toString(), (byte)n));
        }
        ResourceInfo[] resourceInfoArray = new ResourceInfo[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            resourceInfoArray[i] = (ResourceInfo)arrayList.get(i);
        }
        return resourceInfoArray;
    }

    @Override
    public boolean isImplicitResource(String string, String string2) throws GateOntologyException {
        if (string != null) {
            this.loadRepositoryDetails(string);
        }
        return !this.sail.hasExplicitStatement(this.getResource(string2), this.getURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null);
    }

    private String[] listToArray(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (arrayList.contains(list.get(i)) || this.hasSystemNameSpace(list.get(i))) continue;
            arrayList.add(list.get(i));
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private URI getURI(String string) {
        return this.sail.getValueFactory().createURI(string);
    }

    private Resource getResource(String string) {
        try {
            return this.sail.getValueFactory().createURI(string);
        }
        catch (Exception exception) {
            return this.sail.getValueFactory().createBNode(string);
        }
    }

    private int getUserID(String string, String string2) {
        List list = this.service.getSystemConfig().getUserInfoList();
        for (int i = 0; i < list.size(); ++i) {
            UserInfo userInfo = (UserInfo)list.get(i);
            if (!userInfo.getLogin().equals(string) || !userInfo.getPassword().equals(string2)) continue;
            return userInfo.getID();
        }
        return -1;
    }

    private int createUser(String string, String string2) throws GateOntologyException {
        int n = this.service.getSystemConfig().getUnusedUserId();
        this.service.getSystemConfig().addUser(n, string, string, string2);
        return n;
    }

    private void saveConfiguration() throws GateOntologyException {
        try {
            if (systemConf == null) {
                return;
            }
            if (DEBUG) {
                System.out.println("System conf : " + systemConf);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(systemConf.toURI())));
            SystemConfigFileHandler.writeConfiguration((SystemConfig)this.service.getSystemConfig(), (Writer)bufferedWriter);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            throw new GateOntologyException(iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new GateOntologyException(uRISyntaxException);
        }
    }

    private SystemConfig readConfiguration() throws IOException {
        if (systemConf == null) {
            String string = "<?xml version='1.0'?><system-conf><admin password=''/><log dir='plugins/Ontology_Tools/logs' level='3'/><tmp dir='plugins/Ontology_Tools/tmp'/><rmi-factory enabled='false' class='com.ontotext.util.rmi.CustomRMIFactory' port='1099'/><userlist><user id='1' login='admin'><fullname>Admin</fullname><password>admin</password></user><user id='3' login='guest'><fullname>Guest</fullname><password>guest</password></user></userlist><repositorylist></repositorylist></system-conf>";
            StringReader stringReader = new StringReader(string);
            SystemConfig systemConfig = SystemConfigFileHandler.readConfiguration((Reader)stringReader);
            ((Reader)stringReader).close();
            return systemConfig;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(systemConf.openStream()));
        SystemConfig systemConfig = SystemConfigFileHandler.readConfiguration((Reader)bufferedReader);
        ((Reader)bufferedReader).close();
        return systemConfig;
    }

    private RDFFormat getRDFFormat(byte by) {
        switch (by) {
            case 0: {
                return RDFFormat.N3;
            }
            case 1: {
                return RDFFormat.NTRIPLES;
            }
            case 2: {
                return RDFFormat.RDFXML;
            }
        }
        return RDFFormat.TURTLE;
    }

    private Property createPropertyObject(String string, String string2) throws GateOntologyException {
        int n = 5;
        if (this.isObjectProperty(string, string2)) {
            n = 1;
        } else if (this.isDatatypeProperty(string, string2)) {
            n = 2;
        } else if (this.isTransitiveProperty(string, string2)) {
            n = 4;
        } else if (this.isSymmetricProperty(string, string2)) {
            n = 3;
        } else if (this.sail.isProperty(this.getResource(string2))) {
            n = 0;
        } else {
            return null;
        }
        return new Property((byte)n, string2);
    }

    private void print(String string) {
        System.out.println(string + " called.");
    }

    private boolean setRepository(String string, String string2, boolean bl, String string3, byte by, String string4, boolean bl2) {
        if (DEBUG) {
            this.print("setRepository");
        }
        boolean bl3 = false;
        try {
            this.setCurrentRepositoryID(string);
            RepositoryConfig repositoryConfig = this.service.getSystemConfig().getRepositoryConfig(string);
            if (repositoryConfig != null) {
                HashSet<String> hashSet = this.getImportValues(string, string2, string3, by, string4, bl, new HashSet<String>());
                SailConfig sailConfig = repositoryConfig.getSail("org.openrdf.sesame.sailimpl.OWLIMSchemaRepository");
                if (sailConfig != null) {
                    String string52;
                    String string6 = "ntriples";
                    switch (by) {
                        case 0: {
                            string6 = "n3";
                            break;
                        }
                        case 1: {
                            string6 = "ntriples";
                            break;
                        }
                        case 3: {
                            string6 = "turtle";
                            break;
                        }
                        default: {
                            string6 = "rdfxml";
                        }
                    }
                    HashMap<String, String> hashMap = sailConfig.getConfigParameters();
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    hashMap.put("noPersist", Boolean.toString(!bl2));
                    hashMap.put("compressFile", "no");
                    hashMap.put("dataFormat", string6);
                    String string7 = (String)hashMap.get("imports");
                    String string8 = (String)hashMap.get("defaultNS");
                    if (string7 == null) {
                        string7 = "";
                    }
                    if (string8 == null) {
                        string8 = "";
                    }
                    if (string7.length() > 0) {
                        for (String string52 : hashSet) {
                            string7 = string7 + ";" + string52;
                            string8 = string8 + ";" + string52 + "#";
                        }
                    } else {
                        string7 = owlRDFS.toExternalForm();
                        string8 = "http://www.w3.org/2002/07/owl#";
                    }
                    hashMap.put("imports", string7);
                    hashMap.put("defaultNS", string8);
                    String string9 = string4 == null || string4.trim().length() == 0 ? new File(string + ".nt").getAbsolutePath() : new File(new File(string4), string + ".nt").getAbsolutePath();
                    string52 = new File(new File(string4), string + "-tripples.nt").getAbsolutePath();
                    hashMap.put("file", string9);
                    hashMap.put("new-triples-file", string52);
                    hashMap.put("auto-write-time-minutes", "0");
                    sailConfig.setConfigParameters(hashMap);
                }
            }
            if (string2 != null && string2.trim().length() != 0) {
                this.currentRepository.addData(string2, string3, this.getRDFFormat(by), true, (AdminListener)this);
                if (bl2) {
                    this.saveConfiguration();
                }
                if (DEBUG) {
                    System.out.println("Data added!");
                }
            }
            bl3 = true;
        }
        catch (AccessDeniedException accessDeniedException) {
            if (DEBUG) {
                accessDeniedException.printStackTrace();
            }
            bl3 = false;
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            bl3 = false;
        }
        catch (GateOntologyException gateOntologyException) {
            if (DEBUG) {
                gateOntologyException.printStackTrace();
            }
            bl3 = false;
        }
        return bl3;
    }

    private HashSet<String> getImportValues(String string, String string2, String string3, byte by, String string4, boolean bl, Set<String> set) {
        Object object;
        ArrayList<String> arrayList;
        block25: {
            String string5 = string2;
            System.out.println(string5);
            arrayList = new ArrayList<String>();
            try {
                object = "dummy" + Math.random();
                this.createNewRepository((String)object, string2, bl, string3, false, string4, "admin", "admin", by, true);
                this.setCurrentRepositoryID((String)object);
                if (string2 != null && string2.trim().length() != 0) {
                    if (bl) {
                        this.currentRepository.addData(string2, string3, this.getRDFFormat(by), true, (AdminListener)this);
                    } else if (string2.startsWith("file:")) {
                        this.currentRepository.addData(new File(new URL(string2).getFile()), string3, this.getRDFFormat(by), true, (AdminListener)this);
                    } else {
                        this.currentRepository.addData(new URL(string2), string3, this.getRDFFormat(by), true, (AdminListener)this);
                    }
                    StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/2002/07/owl#imports"), null);
                    if (statementIterator.hasNext()) {
                        this.ontologyUrl = string2 = statementIterator.next().getSubject().toString();
                    } else {
                        string2 = null;
                    }
                    if (string2 != null) {
                        PropertyValue[] propertyValueArray = this.getPropertyValues((String)object, string2, "http://www.w3.org/2002/07/owl#imports");
                        for (int i = 0; i < propertyValueArray.length; ++i) {
                            int n;
                            String string6 = propertyValueArray[i].getValue();
                            if (string6.equalsIgnoreCase("http://www.w3.org/2000/01/rdf-schema") || string6.equalsIgnoreCase("www.w3.org/2000/01/rdf-schema")) {
                                string6 = rdfSchema.toExternalForm();
                            }
                            try {
                                new URL(string6).openStream();
                                if (set.contains(string6)) continue;
                                arrayList.add(string6);
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            int iOException = 0;
                            boolean bl2 = true;
                            for (iOException = 0; iOException < string6.length() && iOException < string3.length(); ++iOException) {
                                if (string6.charAt(iOException) == string3.charAt(iOException)) continue;
                                bl2 = false;
                                break;
                            }
                            if (bl2) continue;
                            String string7 = string5;
                            int n2 = string7.lastIndexOf("/");
                            if (n2 > 0) {
                                string7 = string7.substring(0, n2);
                            }
                            string6 = string6.substring(iOException, string6.length());
                            String string8 = string3.substring(iOException, string3.length());
                            int n3 = 0;
                            int n4 = 0;
                            while ((n4 = string8.indexOf(47, n4)) != -1) {
                                ++n4;
                                ++n3;
                            }
                            for (iOException = 0; iOException < n3; ++iOException) {
                                n = string7.lastIndexOf("/");
                                if (n <= 0) {
                                    throw new GateOntologyException("Invalid Import :" + string6);
                                }
                                string7 = string7.substring(0, n);
                            }
                            while ((n = string6.indexOf("..")) == 0) {
                                string6 = string6.substring(n + 3, string6.length());
                                n = string7.lastIndexOf("/");
                                string7 = string7.substring(0, n + 1);
                            }
                            string6 = string7 + (string7.endsWith("/") ? "" : "/") + string6;
                            if (set.contains(string6)) continue;
                            arrayList.add(string6);
                        }
                    }
                }
                this.removeRepository((String)object, false);
                if (string != null) {
                    this.loadRepositoryDetails(string);
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                if (DEBUG) {
                    accessDeniedException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block25;
                iOException.printStackTrace();
            }
        }
        object = new HashSet();
        ((AbstractCollection)object).addAll(arrayList);
        set.addAll(arrayList);
        for (String string9 : arrayList) {
            ((AbstractCollection)object).addAll(this.getImportValues(string, string9, string3, by, string4, bl, set));
        }
        return object;
    }

    private int createNewUser(String string, String string2) throws GateOntologyException {
        if (DEBUG) {
            this.print("createUser");
        }
        int n = -1;
        if (string != null && (n = this.getUserID(string, string2)) == -1) {
            n = this.createUser(string, string2);
        }
        return n;
    }

    private RepositoryConfig createNewRepository(String string, String string2, boolean bl, String string3, boolean bl2, String string4, String string5, String string6, byte by, boolean bl3) throws GateOntologyException {
        try {
            Object object;
            Object object2;
            RepositoryConfig repositoryConfig = new RepositoryConfig(string);
            repositoryConfig.setTitle(string);
            SailConfig sailConfig = new SailConfig("org.openrdf.sesame.sailimpl.OWLIMSchemaRepository");
            HashMap<String, Object> hashMap = sailConfig.getConfigParameters();
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            String string7 = "ntriples";
            switch (by) {
                case 0: {
                    string7 = "n3";
                    break;
                }
                case 1: {
                    string7 = "ntriples";
                    break;
                }
                case 3: {
                    string7 = "turtle";
                    break;
                }
                default: {
                    string7 = "rdfxml";
                }
            }
            String string8 = owlRDFS.toExternalForm();
            String string9 = "http://www.w3.org/2002/07/owl#";
            if (!bl3) {
                object2 = this.getImportValues(null, string2, string3, by, string4, bl, new HashSet<String>());
                object = object2.iterator();
                while (object.hasNext()) {
                    String string10 = (String)object.next();
                    string8 = string8 + ";" + string10;
                    string9 = string9 + ";" + string10 + "#";
                }
            }
            hashMap.put("imports", string8);
            hashMap.put("defaultNS", string9);
            hashMap.put("ruleset", "owl-max");
            hashMap.put("partialRDFS", "true");
            hashMap.put("dropOnRemove", "false");
            hashMap.put("base-URL", string3);
            hashMap.put("indexSize", "100000");
            hashMap.put("stackSafe", "true");
            hashMap.put("noPersist", Boolean.toString(!bl2));
            hashMap.put("compressFile", "no");
            hashMap.put("dataFormat", string7);
            object2 = string4 == null || string4.trim().length() == 0 ? new File(string + ".nt").getAbsolutePath() : new File(new File(string4), string + ".nt").getAbsolutePath();
            object = new File(new File(string4), string + "tripples.nt").getAbsolutePath();
            hashMap.put("file", object2);
            hashMap.put("new-triples-file", object);
            hashMap.put("auto-write-time-minutes", "0");
            sailConfig.setConfigParameters(hashMap);
            repositoryConfig.addSail(sailConfig);
            repositoryConfig.setWorldReadable(true);
            repositoryConfig.setWorldWriteable(true);
            this.service.createRepository(repositoryConfig);
            this.setCurrentRepositoryID(string);
            if (string5 != null) {
                this.service.getSystemConfig().setReadAccess(string, string5, true);
                this.service.getSystemConfig().setWriteAccess(string, string5, true);
            }
            return repositoryConfig;
        }
        catch (ConfigurationException configurationException) {
            throw new GateOntologyException(configurationException);
        }
    }

    private void addOntologyData(String string, String string2, boolean bl, String string3, byte by) throws GateOntologyException {
        try {
            if (string2 != null && string2.trim().length() != 0) {
                boolean bl2 = false;
                if (bl) {
                    this.currentRepository.addData(string2, string3, this.getRDFFormat(by), true, (AdminListener)this);
                    bl2 = true;
                } else if (string2.startsWith("file:")) {
                    this.currentRepository.addData(new File(new URL(string2).getFile()), string3, this.getRDFFormat(by), true, (AdminListener)this);
                    bl2 = true;
                } else {
                    this.currentRepository.addData(new URL(string2), string3, this.getRDFFormat(by), true, (AdminListener)this);
                }
                StatementIterator statementIterator = this.sail.getStatements(null, this.getURI("http://www.w3.org/2002/07/owl#imports"), null);
                if (statementIterator.hasNext()) {
                    this.ontologyUrl = string2 = statementIterator.next().getSubject().toString();
                } else {
                    string2 = null;
                }
                if (DEBUG) {
                    System.out.println("Data added!");
                }
            }
        }
        catch (IOException iOException) {
            throw new GateOntologyException(iOException);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new GateOntologyException(accessDeniedException);
        }
    }

    private ResourceInfo[] reduceToMostSpecificClasses(String string, List<ResourceInfo> list) throws GateOntologyException {
        int n;
        if (list == null || list.isEmpty()) {
            return new ResourceInfo[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < list.size(); ++n) {
            arrayList.add(list.get(n).getUri());
        }
        block1: for (n = 0; n < arrayList.size(); ++n) {
            String string2 = (String)arrayList.get(n);
            ResourceInfo[] resourceInfoArray = this.getSubClasses(string, string2, (byte)1);
            for (int i = 0; i < resourceInfoArray.length; ++i) {
                if (!arrayList.contains(resourceInfoArray[i].getUri())) continue;
                arrayList.remove(n);
                list.remove(n);
                --n;
                continue block1;
            }
        }
        ResourceInfo[] resourceInfoArray = new ResourceInfo[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            resourceInfoArray[i] = list.get(i);
        }
        return resourceInfoArray;
    }

    private void loadRepositoryDetails(String string) throws GateOntologyException {
        RepositoryDetails repositoryDetails = this.mapToRepositoryDetails.get(string);
        if (repositoryDetails == null) {
            throw new GateOntologyException("Repository :" + string + " does not exist");
        }
        this.currentRepository = repositoryDetails.repository;
        this.sail = repositoryDetails.sail;
        this.ontologyUrl = repositoryDetails.ontologyUrl;
        this.returnSystemStatements = repositoryDetails.returnSystemStatements;
    }

    private byte getPropertyType(String string, String string2) throws GateOntologyException {
        if (this.isDatatypeProperty(string, string2)) {
            return 2;
        }
        if (this.isTransitiveProperty(string, string2)) {
            return 4;
        }
        if (this.isSymmetricProperty(string, string2)) {
            return 3;
        }
        if (this.isObjectProperty(string, string2)) {
            return 1;
        }
        if (this.isAnnotationProperty(string, string2)) {
            return 5;
        }
        return 0;
    }

    private PropertyValue[] getPropertyValues(String string, String string2, String string3) throws GateOntologyException {
        if (DEBUG) {
            this.print("getPropertyValues");
        }
        this.loadRepositoryDetails(string);
        StatementIterator statementIterator = this.sail.getStatements(this.getResource(string2), this.getURI(string3), null);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.next();
            PropertyValue propertyValue = new PropertyValue(String.class.getName(), statement.getObject().toString());
            arrayList.add(propertyValue);
        }
        return this.listToPropertyValueArray(arrayList);
    }

    public boolean hasSystemNameSpace(String string) {
        if (this.returnSystemStatements) {
            return false;
        }
        if (string.equalsIgnoreCase("http://www.w3.org/2002/07/owl#Thing")) {
            return false;
        }
        return Utils.hasSystemNameSpace(string);
    }

    public SesameRepository getSesameRepository(String string) throws GateOntologyException {
        this.loadRepositoryDetails(string);
        return this.currentRepository;
    }

    class RepositoryDetails {
        OWLIMSchemaRepository sail;
        SesameRepository repository;
        private String ontologyUrl;
        private boolean returnSystemStatements;

        RepositoryDetails() {
        }
    }
}

