/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.Gate;
import gate.Resource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.ontology.owlim.AbstractOWLIMOntologyImpl;
import gate.creole.ontology.owlim.OWLIMServiceImpl;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.ActionsPublisher;
import gate.gui.MainFrame;
import gate.util.GateRuntimeException;
import gate.util.Out;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.openrdf.sesame.repository.SesameRepository;

public class OWLIMOntologyLR
extends AbstractOWLIMOntologyImpl
implements ActionsPublisher,
CreoleListener {
    private static final long serialVersionUID = 3761129327521051696L;
    private static final boolean DEBUG = false;
    protected URL rdfXmlURL;
    protected URL ntriplesURL;
    protected URL n3URL;
    protected URL turtleURL;
    protected URL persistLocation;
    protected List<AbstractAction> actionsList = new ArrayList<AbstractAction>();

    public OWLIMOntologyLR() {
        this.actionsList.add(new SaveAsNTRIPLESAction("Save in NTRIPLES format"));
        this.actionsList.add(new SaveAsRDFXMLAction("Save in RDFXML format"));
        this.actionsList.add(new SaveAsTURTLEAction("Save in TURTLE format"));
    }

    public Resource init() throws ResourceInstantiationException {
        this.load();
        Gate.getCreoleRegister().addCreoleListener(this);
        return this;
    }

    public void load() throws ResourceInstantiationException {
        try {
            if (this.defaultNameSpace == null || this.defaultNameSpace.trim().length() == 0) {
                this.defaultNameSpace = "http://gate.ac.uk/owlim#";
            }
            byte by = 2;
            if (this.rdfXmlURL != null && this.rdfXmlURL.toString().trim().length() > 0) {
                this.ontologyURL = this.rdfXmlURL;
            } else if (this.ntriplesURL != null && this.ntriplesURL.toString().trim().length() > 0) {
                this.ontologyURL = this.ntriplesURL;
                by = 1;
            } else if (this.n3URL != null && this.n3URL.toString().trim().length() > 0) {
                this.ontologyURL = this.n3URL;
                by = 0;
            } else if (this.turtleURL != null && this.turtleURL.toString().trim().length() > 0) {
                this.ontologyURL = this.turtleURL;
                by = 3;
            } else {
                this.ontologyURL = null;
                by = 2;
            }
            String string = this.ontologyURL == null ? "" : this.ontologyURL.toExternalForm();
            this.owlim = new OWLIMServiceImpl();
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(this.getClass().getName());
            URL uRL = resourceData.getXmlFileUrl();
            URL uRL2 = new URL(uRL, ".");
            ((OWLIMServiceImpl)this.owlim).init(uRL2);
            ((OWLIMServiceImpl)this.owlim).login("admin", "admin");
            String string2 = null;
            if (this.persistLocation != null && this.persistLocation.toString().trim().length() != 0) {
                string2 = new File(this.persistLocation.getFile()).getAbsolutePath();
            } else {
                if (this.persistRepository.booleanValue()) {
                    throw new ResourceInstantiationException("As you've set the parameter 'persistRepository' to 'true', you must provide a valid path for where you want to preserve your data!");
                }
                string2 = File.createTempFile("abc", "abc").getParentFile().getAbsolutePath();
            }
            this.sesameRepositoryID = string.length() == 0 ? this.owlim.createRepository("owlim" + this.hashCode(), "admin", "admin", "", this.defaultNameSpace, by, string2, this.persistRepository, false) : this.owlim.createRepositoryFromUrl("owlim" + this.hashCode(), "admin", "admin", string, this.defaultNameSpace, by, string2, this.persistRepository, false);
            if (this.sesameRepositoryID == null) {
                throw new ResourceInstantiationException("repository cannot be created!");
            }
            this.getOClasses(false);
            this.getOInstances();
            this.getPropertyDefinitions();
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
    }

    public void cleanup() {
        super.cleanup();
    }

    public List getActions() {
        return this.actionsList;
    }

    public void resourceLoaded(CreoleEvent creoleEvent) {
    }

    public void datastoreClosed(CreoleEvent creoleEvent) {
    }

    public void resourceRenamed(Resource resource, String string, String string2) {
    }

    public void datastoreOpened(CreoleEvent creoleEvent) {
    }

    public void datastoreCreated(CreoleEvent creoleEvent) {
    }

    public void resourceUnloaded(CreoleEvent creoleEvent) {
        if (creoleEvent.getResource() == this) {
            this.unload();
            Gate.getCreoleRegister().removeCreoleListener(this);
        }
    }

    public void unload() {
        if (!this.getPersistRepository().booleanValue()) {
            this.owlim.removeRepository(this.getSesameRepositoryID(), this.getPersistRepository());
            this.owlim.logout(this.sesameRepositoryID);
            this.owlim = null;
        }
    }

    private File askForFile() {
        JFileChooser jFileChooser = MainFrame.getFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle("Select document to save ...");
        jFileChooser.setSelectedFiles(null);
        int n = jFileChooser.showDialog(null, "Save");
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public void startTransaction() {
        try {
            ((OWLIMServiceImpl)this.owlim).startTransaction(this.sesameRepositoryID);
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    public void commitTransaction() {
        try {
            ((OWLIMServiceImpl)this.owlim).commitTransaction(this.sesameRepositoryID);
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    public boolean transationStarted() {
        try {
            return ((OWLIMServiceImpl)this.owlim).transactionStarted(this.sesameRepositoryID);
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    public void writeOntologyData(OutputStream outputStream, byte by) {
        try {
            ((OWLIMServiceImpl)this.owlim).writeOntologyData(this.sesameRepositoryID, outputStream, by);
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    public void writeOntologyData(Writer writer, byte by) {
        try {
            ((OWLIMServiceImpl)this.owlim).writeOntologyData(this.sesameRepositoryID, writer, by);
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    public SesameRepository getSesameRepository() {
        return ((OWLIMServiceImpl)this.owlim).getSesameRepository(this.sesameRepositoryID);
    }

    public URL getNtriplesURL() {
        return this.ntriplesURL;
    }

    public void setNtriplesURL(URL uRL) {
        this.ntriplesURL = uRL;
    }

    public URL getRdfXmlURL() {
        return this.rdfXmlURL;
    }

    public void setRdfXmlURL(URL uRL) {
        this.rdfXmlURL = uRL;
    }

    public URL getN3URL() {
        return this.n3URL;
    }

    public void setN3URL(URL uRL) {
        this.n3URL = uRL;
    }

    public URL getTurtleURL() {
        return this.turtleURL;
    }

    public void setTurtleURL(URL uRL) {
        this.turtleURL = uRL;
    }

    public URL getPersistLocation() {
        return this.persistLocation;
    }

    public void setPersistLocation(URL uRL) {
        this.persistLocation = uRL;
    }

    public String toString() {
        String string = this.owlim.getOntologyData(this.sesameRepositoryID, (byte)1);
        List<String> list = Arrays.asList(string.split(System.getProperty("line.separator")));
        Collections.sort(list);
        string = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : list) {
            stringBuffer = stringBuffer.append(string2).append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public class SaveAsN3Action
    extends AbstractAction {
        private static final long serialVersionUID = 4051328924770382905L;

        public SaveAsN3Action(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    File file = OWLIMOntologyLR.this.askForFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        MainFrame.lockGUI("Saving...");
                        String string = OWLIMOntologyLR.this.owlim.getOntologyData(OWLIMOntologyLR.this.sesameRepositoryID, (byte)0);
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(string);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(Out.getPrintWriter());
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }

    public class SaveAsTURTLEAction
    extends AbstractAction {
        private static final long serialVersionUID = 3905801980944136247L;

        public SaveAsTURTLEAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    File file = OWLIMOntologyLR.this.askForFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        MainFrame.lockGUI("Saving...");
                        String string = OWLIMOntologyLR.this.owlim.getOntologyData(OWLIMOntologyLR.this.sesameRepositoryID, (byte)3);
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(string);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(Out.getPrintWriter());
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }

    public class SaveAsRDFXMLAction
    extends AbstractAction {
        private static final long serialVersionUID = 3834305146426570290L;

        public SaveAsRDFXMLAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    File file = OWLIMOntologyLR.this.askForFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        MainFrame.lockGUI("Saving...");
                        String string = OWLIMOntologyLR.this.owlim.getOntologyData(OWLIMOntologyLR.this.sesameRepositoryID, (byte)2);
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(string);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(Out.getPrintWriter());
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }

    public class SaveAsNTRIPLESAction
    extends AbstractAction {
        private static final long serialVersionUID = 3257002159693444913L;

        public SaveAsNTRIPLESAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    File file = OWLIMOntologyLR.this.askForFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        MainFrame.lockGUI("Saving...");
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        String string = OWLIMOntologyLR.this.owlim.getOntologyData(OWLIMOntologyLR.this.sesameRepositoryID, (byte)1);
                        bufferedWriter.write(string);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(Out.getPrintWriter());
                    }
                    finally {
                        MainFrame.unlockGUI();
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }
}

