/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.GateOntologyException;
import gate.creole.ontology.Literal;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyUtilities;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.URI;
import gate.creole.ontology.owlim.AnnotationPropertyImpl;
import gate.creole.ontology.owlim.OWLIM;
import gate.creole.ontology.owlim.Property;
import gate.creole.ontology.owlim.PropertyValue;
import gate.creole.ontology.owlim.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OResourceImpl
implements OResource {
    protected String repositoryID;
    protected OWLIM owlim;
    protected URI uri;
    protected Ontology ontology;

    public OResourceImpl(URI uRI, Ontology ontology, String string, OWLIM oWLIM) {
        this.uri = uRI;
        this.repositoryID = string;
        this.owlim = oWLIM;
        this.ontology = ontology;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void setURI(URI uRI) {
        throw new GateOntologyException("This operation is not allowed in this version!");
    }

    @Override
    public Set<Literal> getLabels() {
        PropertyValue[] propertyValueArray = this.owlim.getAnnotationPropertyValues(this.repositoryID, this.uri.toString(), "http://www.w3.org/2000/01/rdf-schema#label");
        HashSet<Literal> hashSet = new HashSet<Literal>();
        for (PropertyValue propertyValue : propertyValueArray) {
            hashSet.add(new Literal(propertyValue.getValue(), OntologyUtilities.getLocale(propertyValue.getDatatype())));
        }
        return hashSet;
    }

    @Override
    public Set<Literal> getComments() {
        PropertyValue[] propertyValueArray = this.owlim.getAnnotationPropertyValues(this.repositoryID, this.uri.toString(), "http://www.w3.org/2000/01/rdf-schema#comment");
        HashSet<Literal> hashSet = new HashSet<Literal>();
        for (PropertyValue propertyValue : propertyValueArray) {
            hashSet.add(new Literal(propertyValue.getValue(), OntologyUtilities.getLocale(propertyValue.getDatatype())));
        }
        return hashSet;
    }

    @Override
    public String getComment(Locale locale) {
        return this.owlim.getAnnotationPropertyValue(this.repositoryID, this.uri.toString(), "http://www.w3.org/2000/01/rdf-schema#comment", locale != null ? locale.getLanguage() : null);
    }

    @Override
    public void setComment(String string, Locale locale) {
        this.owlim.addAnnotationPropertyValue(this.repositoryID, this.uri.toString(), "http://www.w3.org/2000/01/rdf-schema#comment", string, locale != null ? locale.getLanguage() : null);
        this.ontology.fireOntologyModificationEvent(this, 5);
    }

    @Override
    public String getLabel(Locale locale) {
        return this.owlim.getAnnotationPropertyValue(this.repositoryID, this.uri.toString(), "http://www.w3.org/2000/01/rdf-schema#label", locale != null ? locale.getLanguage() : null);
    }

    @Override
    public void setLabel(String string, Locale locale) {
        this.owlim.addAnnotationPropertyValue(this.repositoryID, this.uri.toString(), "http://www.w3.org/2000/01/rdf-schema#label", string, locale != null ? locale.getLanguage() : null);
        this.ontology.fireOntologyModificationEvent(this, 6);
    }

    @Override
    public String getName() {
        return this.uri.getResourceName();
    }

    @Override
    public Ontology getOntology() {
        return this.ontology;
    }

    @Override
    public void addAnnotationPropertyValue(AnnotationProperty annotationProperty, Literal literal) {
        OResource oResource = this.ontology.getOResourceFromMap(annotationProperty.getURI().toString());
        if (oResource == null) {
            Utils.error(annotationProperty.getURI().toString() + " does not exist");
            return;
        }
        if (!(oResource instanceof AnnotationProperty)) {
            Utils.error(annotationProperty.getURI().toString() + " is not a registered annotation property");
            return;
        }
        this.owlim.addAnnotationPropertyValue(this.repositoryID, this.uri.toString(), annotationProperty.getURI().toString(), literal.getValue(), literal.getLanguage() != null ? literal.getLanguage().getLanguage() : null);
        this.ontology.fireOntologyModificationEvent(this, 7);
    }

    @Override
    public List<Literal> getAnnotationPropertyValues(AnnotationProperty annotationProperty) {
        PropertyValue[] propertyValueArray = this.owlim.getAnnotationPropertyValues(this.repositoryID, this.uri.toString(), annotationProperty.getURI().toString());
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        for (int i = 0; i < propertyValueArray.length; ++i) {
            Literal literal = new Literal(propertyValueArray[i].getValue(), OntologyUtilities.getLocale(propertyValueArray[i].getDatatype()));
            arrayList.add(literal);
        }
        return arrayList;
    }

    @Override
    public void removeAnnotationPropertyValue(AnnotationProperty annotationProperty, Literal literal) {
        this.owlim.removeAnnotationPropertyValue(this.repositoryID, this.uri.toString(), annotationProperty.getURI().toString(), literal.getValue(), literal.getLanguage() != null ? literal.getLanguage().getLanguage() : null);
        this.ontology.fireOntologyModificationEvent(this, 11);
    }

    @Override
    public void removeAnnotationPropertyValues(AnnotationProperty annotationProperty) {
        this.owlim.removeAnnotationPropertyValues(this.repositoryID, this.uri.toString(), annotationProperty.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 11);
    }

    @Override
    public Set<AnnotationProperty> getSetAnnotationProperties() {
        Property[] propertyArray = this.owlim.getAnnotationProperties(this.repositoryID, this.uri.toString());
        HashSet<AnnotationProperty> hashSet = new HashSet<AnnotationProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].getType() != 5) {
                throw new GateOntologyException("The property :" + propertyArray[i].getUri() + " returned from the repository is not an AnnotationProperty");
            }
            String string = propertyArray[i].getUri();
            OResource oResource = this.ontology.getOResourceFromMap(string);
            if (oResource == null) {
                oResource = new AnnotationPropertyImpl(new URI(string, false), this.ontology, this.repositoryID, this.owlim);
                this.ontology.addOResourceToMap(string, oResource);
            }
            hashSet.add((AnnotationProperty)oResource);
        }
        return hashSet;
    }

    @Override
    public boolean hasAnnotationPropertyWithValue(AnnotationProperty annotationProperty, Literal literal) {
        List<Literal> list = this.getAnnotationPropertyValues(annotationProperty);
        for (Literal literal2 : list) {
            if (!literal2.getValue().equals(literal.getValue()) || (literal2.getDataType() != null ? literal.getDataType() == null || !literal.getDataType().getXmlSchemaURI().equals(literal2.getDataType().getXmlSchemaURI()) : literal.getDataType() != null)) continue;
            if (literal2.getLanguage() == null ? literal.getLanguage() != null : literal.getLanguage() == null || !literal.getLanguage().equals(literal2.getLanguage())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<RDFProperty> getAllSetProperties() {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        hashSet.addAll(this.getSetAnnotationProperties());
        return hashSet;
    }

    @Override
    public Set<RDFProperty> getPropertiesWithResourceAsDomain() {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        Set<RDFProperty> set = this.ontology.getPropertyDefinitions();
        if (set != null) {
            block0: for (RDFProperty rDFProperty : set) {
                if (rDFProperty instanceof AnnotationProperty) {
                    hashSet.add(rDFProperty);
                    continue;
                }
                if (rDFProperty instanceof ObjectProperty || rDFProperty instanceof DatatypeProperty) {
                    if (this instanceof OClass) {
                        Set<OResource> set2 = rDFProperty.getDomain();
                        if (set2.size() == 0) {
                            hashSet.add(rDFProperty);
                            continue;
                        }
                        for (OResource oResource : set2) {
                            OClass oClass = (OClass)oResource;
                            if (!oClass.equals(this) && !((OClass)((Object)this)).isSubClassOf(oClass, (byte)1)) continue;
                            hashSet.add(rDFProperty);
                            continue block0;
                        }
                        continue;
                    }
                    if (!(this instanceof OInstance) || !rDFProperty.isValidDomain((OInstance)((Object)this))) continue;
                    hashSet.add(rDFProperty);
                    continue;
                }
                if (!rDFProperty.isValidDomain(this)) continue;
                hashSet.add(rDFProperty);
            }
        }
        return hashSet;
    }

    @Override
    public Set<RDFProperty> getPropertiesWithResourceAsRange() {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        Set<RDFProperty> set = this.ontology.getPropertyDefinitions();
        if (set != null) {
            block0: for (RDFProperty rDFProperty : set) {
                if (rDFProperty instanceof AnnotationProperty) {
                    hashSet.add(rDFProperty);
                    continue;
                }
                if (rDFProperty instanceof ObjectProperty) {
                    if (this instanceof OClass) {
                        Set<OResource> set2 = rDFProperty.getRange();
                        if (set2.size() == 0) {
                            hashSet.add(rDFProperty);
                            continue;
                        }
                        for (OResource oResource : set2) {
                            OClass oClass = (OClass)oResource;
                            if (!oClass.equals(this) && !((OClass)((Object)this)).isSubClassOf(oClass, (byte)1)) continue;
                            hashSet.add(rDFProperty);
                            continue block0;
                        }
                        continue;
                    }
                    if (!(this instanceof OInstance) || !rDFProperty.isValidRange((OInstance)((Object)this))) continue;
                    hashSet.add(rDFProperty);
                    continue;
                }
                if (rDFProperty instanceof DatatypeProperty || !rDFProperty.isValidRange(this)) continue;
                hashSet.add(rDFProperty);
            }
        }
        return hashSet;
    }

    public String toString() {
        return this.getName();
    }

    public int hashcode() {
        return this.getURI().toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof OResource) {
            return ((OResource)object).getURI().toString().equals(this.getURI().toString());
        }
        return false;
    }
}

