/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.creole.ontology.DataType;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.GateOntologyException;
import gate.creole.ontology.InvalidValueException;
import gate.creole.ontology.Literal;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyUtilities;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.URI;
import gate.creole.ontology.owlim.DatatypePropertyImpl;
import gate.creole.ontology.owlim.OResourceImpl;
import gate.creole.ontology.owlim.OWLIM;
import gate.creole.ontology.owlim.ObjectPropertyImpl;
import gate.creole.ontology.owlim.Property;
import gate.creole.ontology.owlim.PropertyValue;
import gate.creole.ontology.owlim.RDFPropertyImpl;
import gate.creole.ontology.owlim.ResourceInfo;
import gate.creole.ontology.owlim.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OInstanceImpl
extends OResourceImpl
implements OInstance {
    public OInstanceImpl(URI uRI, Ontology ontology, String string, OWLIM oWLIM) {
        super(uRI, ontology, string, oWLIM);
    }

    @Override
    public Set<OClass> getOClasses(byte by) {
        ResourceInfo[] resourceInfoArray = this.owlim.getClassesOfIndividual(this.repositoryID, this.uri.toString(), by);
        HashSet<OClass> hashSet = new HashSet<OClass>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            hashSet.add(Utils.createOClass(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
        }
        return hashSet;
    }

    @Override
    public boolean isInstanceOf(OClass oClass, byte by) {
        return this.owlim.hasIndividual(this.repositoryID, oClass.getURI().toString(), this.uri.toString(), by);
    }

    @Override
    public void setDifferentFrom(OInstance oInstance) {
        if (this == oInstance) {
            Utils.warning("setDifferentFrom(theInstance) : the source and the argument instances refer to the same instance and therefore cannot be set as different from each other");
            return;
        }
        this.owlim.setDifferentIndividualFrom(this.repositoryID, this.uri.toString(), oInstance.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 15);
    }

    @Override
    public Set<OInstance> getDifferentInstances() {
        String[] stringArray = this.owlim.getDifferentIndividualFrom(this.repositoryID, this.uri.toString());
        HashSet<OInstance> hashSet = new HashSet<OInstance>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(Utils.createOInstance(this.repositoryID, this.ontology, this.owlim, stringArray[i]));
        }
        return hashSet;
    }

    @Override
    public boolean isDifferentFrom(OInstance oInstance) {
        return this.owlim.isDifferentIndividualFrom(this.repositoryID, this.uri.toString(), oInstance.getURI().toString());
    }

    @Override
    public void setSameInstanceAs(OInstance oInstance) {
        if (this == oInstance) {
            Utils.warning("setDifferentFrom(theInstance) : the source and the argument instances refer to the same instance and therefore cannot be set as same");
            return;
        }
        this.owlim.setSameIndividualAs(this.repositoryID, this.uri.toString(), oInstance.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 16);
    }

    @Override
    public Set<OInstance> getSameInstance() {
        String[] stringArray = this.owlim.getSameIndividualAs(this.repositoryID, this.uri.toString());
        HashSet<OInstance> hashSet = new HashSet<OInstance>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(Utils.createOInstance(this.repositoryID, this.ontology, this.owlim, stringArray[i]));
        }
        return hashSet;
    }

    @Override
    public boolean isSameInstanceAs(OInstance oInstance) {
        return this.owlim.isSameIndividualAs(this.repositoryID, this.uri.toString(), oInstance.getURI().toString());
    }

    @Override
    public void addRDFPropertyValue(RDFProperty rDFProperty, OResource oResource) throws InvalidValueException {
        if (!rDFProperty.isValidDomain(this)) {
            Utils.error(this.getURI().toString() + " is not a valid domain for the property " + rDFProperty.getURI().toString());
            return;
        }
        if (!rDFProperty.isValidRange(oResource)) {
            Utils.error(oResource.getURI().toString() + " is not a valid range for the property " + rDFProperty.getURI().toString());
            return;
        }
        this.owlim.addRDFPropertyValue(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString(), oResource.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 10);
    }

    @Override
    public void removeRDFPropertyValue(RDFProperty rDFProperty, OResource oResource) {
        this.owlim.removeRDFPropertyValue(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString(), oResource.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 14);
    }

    @Override
    public List<OResource> getRDFPropertyValues(RDFProperty rDFProperty) {
        ResourceInfo[] resourceInfoArray = this.owlim.getRDFPropertyValues(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString());
        ArrayList<OResource> arrayList = new ArrayList<OResource>();
        List<String> list = Arrays.asList(this.owlim.getIndividuals(this.repositoryID));
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            OResource oResource = this.ontology.getOResourceFromMap(resourceInfoArray[i].getUri());
            if (oResource != null) {
                arrayList.add(oResource);
                continue;
            }
            if (list.contains(resourceInfoArray[i])) {
                arrayList.add(Utils.createOInstance(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri()));
                continue;
            }
            if (this.owlim.hasClass(this.repositoryID, resourceInfoArray[i].getUri())) {
                arrayList.add(Utils.createOClass(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
                continue;
            }
            Property property = this.owlim.getPropertyFromOntology(this.repositoryID, resourceInfoArray[i].getUri());
            arrayList.add(Utils.createOProperty(this.repositoryID, this.ontology, this.owlim, property.getUri(), property.getType()));
        }
        return arrayList;
    }

    @Override
    public Set<RDFProperty> getSetRDFProperties() {
        Property[] propertyArray = this.owlim.getRDFProperties(this.repositoryID, this.uri.toString());
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].getType() != 0) {
                throw new GateOntologyException("The property :" + propertyArray[i].getUri() + " returned from the repository is not an RDFProperty");
            }
            String string = propertyArray[i].getUri();
            OResource oResource = this.ontology.getOResourceFromMap(string);
            if (oResource == null) {
                oResource = new RDFPropertyImpl(new URI(string, false), this.ontology, this.repositoryID, this.owlim);
                this.ontology.addOResourceToMap(string, oResource);
            }
            hashSet.add((RDFProperty)oResource);
        }
        return hashSet;
    }

    @Override
    public boolean hasRDFPropertyWithValue(RDFProperty rDFProperty, OResource oResource) {
        List<OResource> list = this.getRDFPropertyValues(rDFProperty);
        for (OResource oResource2 : list) {
            if (!oResource2.equals(oResource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeRDFPropertyValues(RDFProperty rDFProperty) {
        this.owlim.removeRDFPropertyValues(this.repositoryID, this.uri.toString(), rDFProperty.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 14);
    }

    @Override
    public void addDatatypePropertyValue(DatatypeProperty datatypeProperty, Literal literal) throws InvalidValueException {
        if (!datatypeProperty.isValidDomain(this)) {
            Utils.error(this.getURI().toString() + " is not a valid domain for the property " + datatypeProperty.getURI().toString());
            return;
        }
        DataType dataType = datatypeProperty.getDataType();
        if (literal.getDataType() == null) {
            dataType = datatypeProperty.getDataType();
        } else if (!dataType.getXmlSchemaURI().toString().equals(literal.getDataType().getXmlSchemaURI().toString())) {
            throw new GateOntologyException("Datatype :" + literal.getDataType().getXmlSchemaURI().toString() + " doesn't match with the property's datatype :" + dataType.getXmlSchemaURI().toString());
        }
        this.owlim.addDatatypePropertyValue(this.repositoryID, this.uri.toString(), datatypeProperty.getURI().toString(), dataType.getXmlSchemaURI().toString(), literal.getValue());
        this.ontology.fireOntologyModificationEvent(this, 8);
    }

    @Override
    public void removeDatatypePropertyValue(DatatypeProperty datatypeProperty, Literal literal) {
        this.owlim.removeDatatypePropertyValue(this.repositoryID, this.uri.toString(), datatypeProperty.getURI().toString(), literal.getDataType().getXmlSchemaURI().toString(), literal.getValue());
        this.ontology.fireOntologyModificationEvent(this, 12);
    }

    @Override
    public List<Literal> getDatatypePropertyValues(DatatypeProperty datatypeProperty) {
        try {
            PropertyValue[] propertyValueArray = this.owlim.getDatatypePropertyValues(this.repositoryID, this.uri.toString(), datatypeProperty.getURI().toString());
            ArrayList<Literal> arrayList = new ArrayList<Literal>();
            for (int i = 0; i < propertyValueArray.length; ++i) {
                arrayList.add(new Literal(propertyValueArray[i].getValue(), OntologyUtilities.getDataType(propertyValueArray[i].getDatatype())));
            }
            return arrayList;
        }
        catch (InvalidValueException invalidValueException) {
            throw new GateOntologyException(invalidValueException);
        }
    }

    @Override
    public void removeDatatypePropertyValues(DatatypeProperty datatypeProperty) {
        this.owlim.removeDatatypePropertyValues(this.repositoryID, this.uri.toString(), datatypeProperty.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 12);
    }

    @Override
    public Set<DatatypeProperty> getSetDatatypeProperties() {
        Property[] propertyArray = this.owlim.getDatatypeProperties(this.repositoryID, this.uri.toString());
        HashSet<DatatypeProperty> hashSet = new HashSet<DatatypeProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].getType() != 2) {
                throw new GateOntologyException("The property :" + propertyArray[i].getUri() + " returned from the repository is not an DatatypeProperty");
            }
            String string = propertyArray[i].getUri();
            OResource oResource = this.ontology.getOResourceFromMap(string);
            if (oResource == null) {
                oResource = new DatatypePropertyImpl(new URI(string, false), this.ontology, this.repositoryID, this.owlim);
                this.ontology.addOResourceToMap(string, oResource);
            }
            hashSet.add((DatatypeProperty)oResource);
        }
        return hashSet;
    }

    @Override
    public boolean hasDatatypePropertyWithValue(DatatypeProperty datatypeProperty, Literal literal) {
        List<Literal> list = this.getDatatypePropertyValues(datatypeProperty);
        for (Literal literal2 : list) {
            if (!literal2.getValue().equals(literal.getValue()) || (literal2.getDataType() != null ? literal.getDataType() == null || !literal.getDataType().getXmlSchemaURI().equals(literal2.getDataType().getXmlSchemaURI()) : literal.getDataType() != null)) continue;
            if (literal2.getLanguage() == null ? literal.getLanguage() != null : literal.getLanguage() == null || !literal.getLanguage().equals(literal2.getLanguage())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addObjectPropertyValue(ObjectProperty objectProperty, OInstance oInstance) throws InvalidValueException {
        if (!objectProperty.isValidDomain(this)) {
            Utils.error(this.getURI().toString() + " is not a valid domain for the property " + objectProperty.getURI().toString());
            return;
        }
        if (!objectProperty.isValidRange(oInstance)) {
            Utils.error(oInstance.getURI().toString() + " is not a valid range for the property " + objectProperty.getURI().toString());
            return;
        }
        this.owlim.addObjectPropertyValue(this.repositoryID, this.uri.toString(), objectProperty.getURI().toString(), oInstance.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 9);
    }

    @Override
    public void removeObjectPropertyValue(ObjectProperty objectProperty, OInstance oInstance) {
        this.owlim.removeObjectPropertyValue(this.repositoryID, this.uri.toString(), objectProperty.getURI().toString(), oInstance.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 13);
    }

    @Override
    public List<OInstance> getObjectPropertyValues(ObjectProperty objectProperty) {
        String[] stringArray = this.owlim.getObjectPropertyValues(this.repositoryID, this.uri.toString(), objectProperty.getURI().toString());
        ArrayList<OInstance> arrayList = new ArrayList<OInstance>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(Utils.createOInstance(this.repositoryID, this.ontology, this.owlim, stringArray[i]));
        }
        return arrayList;
    }

    @Override
    public void removeObjectPropertyValues(ObjectProperty objectProperty) {
        this.owlim.removeObjectPropertyValues(this.repositoryID, this.uri.toString(), objectProperty.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 13);
    }

    @Override
    public Set<ObjectProperty> getSetObjectProperties() {
        Property[] propertyArray = this.owlim.getObjectProperties(this.repositoryID, this.uri.toString());
        HashSet<ObjectProperty> hashSet = new HashSet<ObjectProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].getType() != 1) {
                throw new GateOntologyException("The property :" + propertyArray[i].getUri() + " returned from the repository is not an ObjectProperty");
            }
            String string = propertyArray[i].getUri();
            OResource oResource = this.ontology.getOResourceFromMap(string);
            if (oResource == null) {
                oResource = new ObjectPropertyImpl(new URI(string, false), this.ontology, this.repositoryID, this.owlim);
                this.ontology.addOResourceToMap(string, oResource);
            }
            hashSet.add((ObjectProperty)oResource);
        }
        return hashSet;
    }

    @Override
    public boolean hasObjectPropertyWithValue(ObjectProperty objectProperty, OInstance oInstance) {
        List<OInstance> list = this.getObjectPropertyValues(objectProperty);
        for (OInstance oInstance2 : list) {
            if (!oInstance2.equals(oInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<RDFProperty> getAllSetProperties() {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        hashSet.addAll(this.getSetAnnotationProperties());
        hashSet.addAll(this.getSetDatatypeProperties());
        hashSet.addAll(this.getSetObjectProperties());
        hashSet.addAll(this.getSetRDFProperties());
        return hashSet;
    }
}

