/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.creole.ontology.OClass;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.creole.ontology.owlim.OResourceImpl;
import gate.creole.ontology.owlim.OWLIM;
import gate.creole.ontology.owlim.ResourceInfo;
import gate.creole.ontology.owlim.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OClassImpl
extends OResourceImpl
implements OClass {
    public OClassImpl(URI uRI, Ontology ontology, String string, OWLIM oWLIM) {
        super(uRI, ontology, string, oWLIM);
    }

    @Override
    public void addSubClass(OClass oClass) {
        if (this == oClass) {
            Utils.warning("addSubClass(subClass) : The super and sub classes are same.");
            return;
        }
        if (this.isSubClassOf(oClass, (byte)1)) {
            Utils.warning(oClass.getURI().toString() + " is a super class of " + this.getURI().toString());
            return;
        }
        if (this.isSuperClassOf(oClass, (byte)0)) {
            Utils.warning(oClass.getURI().toString() + " is already a sub class of " + this.getURI().toString());
            return;
        }
        this.owlim.addSubClass(this.repositoryID, this.uri.toString(), oClass.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 0);
    }

    @Override
    public void removeSubClass(OClass oClass) {
        if (this == oClass) {
            Utils.warning("addSubClass(subClass) : The super and sub classes are same.");
            return;
        }
        if (!oClass.isSubClassOf(this, (byte)0)) {
            Utils.warning(oClass.getURI().toString() + " is not a direct subclass of " + this.getURI().toString());
            return;
        }
        this.owlim.removeSubClass(this.repositoryID, this.uri.toString(), oClass.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 2);
    }

    @Override
    public Set<OClass> getSubClasses(byte by) {
        ResourceInfo[] resourceInfoArray = this.owlim.getSubClasses(this.repositoryID, this.uri.toString(), by);
        HashSet<OClass> hashSet = new HashSet<OClass>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            hashSet.add(Utils.createOClass(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
        }
        return hashSet;
    }

    @Override
    public Set<OClass> getSuperClasses(byte by) {
        ResourceInfo[] resourceInfoArray = this.owlim.getSuperClasses(this.repositoryID, this.uri.toString(), by);
        HashSet<OClass> hashSet = new HashSet<OClass>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            hashSet.add(Utils.createOClass(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
        }
        return hashSet;
    }

    @Override
    public boolean isSuperClassOf(OClass oClass, byte by) {
        return this.owlim.isSuperClassOf(this.repositoryID, this.uri.toString(), oClass.getURI().toString(), by);
    }

    @Override
    public boolean isSubClassOf(OClass oClass, byte by) {
        return this.owlim.isSubClassOf(this.repositoryID, oClass.getURI().toString(), this.uri.toString(), by);
    }

    @Override
    public boolean isTopClass() {
        return this.owlim.isTopClass(this.repositoryID, this.uri.toString());
    }

    @Override
    public void setEquivalentClassAs(OClass oClass) {
        if (this == oClass) {
            Utils.warning("setEquivalentClassAs(theClass) : Both the source and the argument classes refer to the same instance of class");
            return;
        }
        this.owlim.setEquivalentClassAs(this.repositoryID, this.uri.toString(), oClass.getURI().toString());
        this.ontology.fireOntologyModificationEvent(this, 4);
    }

    @Override
    public Set<OClass> getEquivalentClasses() {
        ResourceInfo[] resourceInfoArray = this.owlim.getEquivalentClasses(this.repositoryID, this.uri.toString());
        HashSet<OClass> hashSet = new HashSet<OClass>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            hashSet.add(Utils.createOClass(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
        }
        return hashSet;
    }

    @Override
    public boolean isEquivalentClassAs(OClass oClass) {
        return this.owlim.isEquivalentClassAs(this.repositoryID, this.uri.toString(), oClass.getURI().toString());
    }

    @Override
    public ArrayList<Set<OClass>> getSuperClassesVSDistance() {
        boolean bl;
        ArrayList<Set<OClass>> arrayList = new ArrayList<Set<OClass>>();
        int n = 0;
        HashSet<OClassImpl> hashSet = new HashSet<OClassImpl>();
        hashSet.add(this);
        boolean bl2 = bl = 0 < this.owlim.getSuperClasses(this.repositoryID, this.uri.toString(), (byte)0).length;
        while (bl) {
            HashSet<OClass> hashSet2 = new HashSet<OClass>();
            for (OClass oClass : hashSet) {
                hashSet2.addAll(oClass.getSuperClasses((byte)0));
            }
            if (0 < hashSet2.size()) {
                arrayList.add(n++, hashSet2);
            }
            bl = 0 < (hashSet = hashSet2).size();
        }
        return arrayList;
    }

    @Override
    public ArrayList<Set<OClass>> getSubClassesVsDistance() {
        boolean bl;
        ArrayList<Set<OClass>> arrayList = new ArrayList<Set<OClass>>();
        int n = 0;
        HashSet<OClassImpl> hashSet = new HashSet<OClassImpl>();
        hashSet.add(this);
        boolean bl2 = bl = 0 < this.owlim.getSubClasses(this.repositoryID, this.uri.toString(), (byte)0).length;
        while (bl) {
            HashSet<OClass> hashSet2 = new HashSet<OClass>();
            for (OClass oClass : hashSet) {
                hashSet2.addAll(oClass.getSubClasses((byte)0));
            }
            if (0 < hashSet2.size()) {
                arrayList.add(n++, hashSet2);
            }
            bl = 0 < (hashSet = hashSet2).size();
        }
        return arrayList;
    }
}

