/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.creole.ontology.DataType;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.GateOntologyException;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyUtilities;
import gate.creole.ontology.URI;
import gate.creole.ontology.owlim.OWLIM;
import gate.creole.ontology.owlim.RDFPropertyImpl;
import gate.creole.ontology.owlim.ResourceInfo;
import gate.creole.ontology.owlim.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypePropertyImpl
extends RDFPropertyImpl
implements DatatypeProperty {
    public DatatypePropertyImpl(URI uRI, Ontology ontology, String string, OWLIM oWLIM) {
        super(uRI, ontology, string, oWLIM);
    }

    @Override
    public DataType getDataType() {
        String string = this.owlim.getDatatype(this.repositoryID, this.uri.toString());
        if (string == null) {
            return DataType.getStringDataType();
        }
        return OntologyUtilities.getDataType(string);
    }

    @Override
    public boolean isValidDataTypeValue(String string) {
        return this.getDataType().isValidValue(string);
    }

    @Override
    public boolean isValidDomain(OInstance oInstance) {
        Object object;
        ResourceInfo[] resourceInfoArray = this.owlim.getDomain(this.repositoryID, this.uri.toString());
        if (resourceInfoArray.length == 0) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            hashSet.add(resourceInfoArray[i].getUri());
            object = this.ontology.getOResourceFromMap(resourceInfoArray[i].getUri());
            if (object == null || !(object instanceof OClass)) continue;
            Set<OClass> set = ((OClass)object).getSubClasses((byte)1);
            Iterator<OClass> iterator = set.iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next().getURI().toString());
            }
        }
        ResourceInfo[] resourceInfoArray2 = this.owlim.getClassesOfIndividual(this.repositoryID, oInstance.getURI().toString(), (byte)0);
        object = new HashSet();
        for (int i = 0; i < resourceInfoArray2.length; ++i) {
            object.add(resourceInfoArray2[i].getUri());
        }
        return hashSet.containsAll((Collection<?>)object);
    }

    @Override
    public boolean isValidRange(OResource oResource) {
        throw new GateOntologyException("Datatype Properties do not have Range, but a Datatype. Please use the isValidDatatypeValue(String value) method.");
    }

    @Override
    public boolean isValidDomain(OResource oResource) {
        if (oResource instanceof OInstance) {
            return this.isValidDomain((OInstance)oResource);
        }
        return false;
    }

    @Override
    public Set<OResource> getDomain() {
        ResourceInfo[] resourceInfoArray = this.owlim.getDomain(this.repositoryID, this.uri.toString());
        HashSet<OResource> hashSet = new HashSet<OResource>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            hashSet.add(Utils.createOClass(this.repositoryID, this.ontology, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
        }
        return hashSet;
    }

    @Override
    public Set<OResource> getRange() {
        throw new GateOntologyException("Datatype Properties do not have Range, but a Datatype specified. Please use the getDatatype() method.");
    }
}

