/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology.owlim;

import gate.creole.AbstractLanguageResource;
import gate.creole.ontology.AllValuesFromRestriction;
import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.CardinalityRestriction;
import gate.creole.ontology.DataType;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.HasValueRestriction;
import gate.creole.ontology.InvalidValueException;
import gate.creole.ontology.Literal;
import gate.creole.ontology.MaxCardinalityRestriction;
import gate.creole.ontology.MinCardinalityRestriction;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyModificationListener;
import gate.creole.ontology.OntologyUtilities;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.SomeValuesFromRestriction;
import gate.creole.ontology.SymmetricProperty;
import gate.creole.ontology.TransitiveProperty;
import gate.creole.ontology.URI;
import gate.creole.ontology.owlim.OWLIM;
import gate.creole.ontology.owlim.Property;
import gate.creole.ontology.owlim.ResourceInfo;
import gate.creole.ontology.owlim.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.sesame.repository.SesameRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOWLIMOntologyImpl
extends AbstractLanguageResource
implements Ontology {
    protected String sesameRepositoryID;
    protected OWLIM owlim;
    protected URL ontologyURL;
    protected byte format;
    protected String defaultNameSpace;
    protected boolean isModified;
    protected transient List<OntologyModificationListener> modificationListeners;
    protected Boolean persistRepository;
    protected Map<String, OResource> urisToOResouceMap = new HashMap<String, OResource>();
    protected Map<String, List<OResource>> resourceNamesToOResourcesMap = new HashMap<String, List<OResource>>();
    protected static int anonymousNodeCounter = 0;
    protected static String restrictionPrefix = "Restriction";
    private boolean callFromCleanup = false;

    public AbstractOWLIMOntologyImpl() {
        this.persistRepository = new Boolean(false);
    }

    public String getAutoGeneratedRestrictionName() {
        List<OResource> list;
        String string = null;
        while ((list = this.resourceNamesToOResourcesMap.get(string = restrictionPrefix + ++anonymousNodeCounter)) != null && !list.isEmpty()) {
        }
        return string;
    }

    @Override
    public void cleanOntology() {
        this.owlim.cleanOntology(this.sesameRepositoryID);
        this.urisToOResouceMap.clear();
        this.resourceNamesToOResourcesMap.clear();
        if (!this.callFromCleanup) {
            this.fireOntologyReset();
        } else {
            this.callFromCleanup = false;
        }
    }

    @Override
    public String getOntologyData(byte by) {
        return this.owlim.getOntologyData(this.sesameRepositoryID, by);
    }

    @Override
    public abstract void writeOntologyData(OutputStream var1, byte var2);

    @Override
    public abstract void writeOntologyData(Writer var1, byte var2);

    @Override
    public URL getURL() {
        return this.ontologyURL;
    }

    @Override
    public void setURL(URL uRL) {
        this.ontologyURL = uRL;
    }

    @Override
    public void setDefaultNameSpace(String string) {
        this.defaultNameSpace = string;
        if (this.defaultNameSpace != null && -1 == this.defaultNameSpace.indexOf(35)) {
            this.defaultNameSpace = this.defaultNameSpace + '#';
        }
    }

    @Override
    public String getDefaultNameSpace() {
        return this.defaultNameSpace;
    }

    @Override
    public void setVersion(String string) {
        this.owlim.setVersion(this.sesameRepositoryID, string);
    }

    @Override
    public String getVersion() {
        return this.owlim.getVersion(this.sesameRepositoryID);
    }

    @Override
    public OClass addOClass(URI uRI, byte by) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            return (OClass)oResource;
        }
        this.owlim.addClass(this.sesameRepositoryID, uRI.toString(), by);
        OClass oClass = Utils.createOClass(this.sesameRepositoryID, this, this.owlim, uRI.toString(), by);
        this.fireOntologyResourceAdded(oClass);
        oClass.setLabel(uRI.getResourceName(), null);
        return oClass;
    }

    @Override
    public OClass addOClass(URI uRI) {
        return this.addOClass(uRI, (byte)0);
    }

    @Override
    public OClass getOClass(URI uRI) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            return (OClass)oResource;
        }
        if (this.owlim.hasClass(this.sesameRepositoryID, uRI.toString())) {
            byte by = this.owlim.getClassType(this.sesameRepositoryID, uRI.toString());
            return Utils.createOClass(this.sesameRepositoryID, this, this.owlim, uRI.toString(), by);
        }
        return null;
    }

    @Override
    public void removeOClass(OClass oClass) {
        if (!this.containsOClass(oClass.getURI())) {
            Utils.warning(oClass.getURI().toString() + " does not exist");
            return;
        }
        String[] stringArray = this.owlim.removeClass(this.sesameRepositoryID, oClass.getURI().toString());
        this.fireOntologyResourcesRemoved(stringArray);
    }

    @Override
    public boolean containsOClass(URI uRI) {
        return this.owlim.hasClass(this.sesameRepositoryID, uRI.toString());
    }

    @Override
    public boolean containsOClass(OClass oClass) {
        return this.containsOClass(oClass.getURI());
    }

    @Override
    public Set<OClass> getOClasses(boolean bl) {
        ResourceInfo[] resourceInfoArray = this.owlim.getClasses(this.sesameRepositoryID, bl);
        HashSet<OClass> hashSet = new HashSet<OClass>();
        for (int i = 0; i < resourceInfoArray.length; ++i) {
            hashSet.add(Utils.createOClass(this.sesameRepositoryID, this, this.owlim, resourceInfoArray[i].getUri(), resourceInfoArray[i].getClassType()));
        }
        return hashSet;
    }

    @Override
    public int getDistance(OClass oClass, OClass oClass2) {
        int n;
        if (!this.containsOClass(oClass.getURI())) {
            Utils.warning(oClass.getURI().toString() + " does not exist");
            return -1;
        }
        if (!this.containsOClass(oClass2.getURI())) {
            Utils.warning(oClass2.getURI().toString() + " does not exist");
            return -1;
        }
        int n2 = 0;
        ArrayList<Set<OClass>> arrayList = oClass.getSuperClassesVSDistance();
        ArrayList<Set<OClass>> arrayList2 = oClass2.getSuperClassesVSDistance();
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).contains(oClass2)) continue;
            n2 = n + 1;
            break;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            if (!arrayList2.get(n).contains(oClass)) continue;
            n2 = n + 1;
            break;
        }
        if (0 == n2) {
            for (n = 0; n < arrayList.size(); ++n) {
                block3: for (int i = 0; i < arrayList2.size(); ++i) {
                    Set<OClass> set = arrayList.get(n);
                    Set<OClass> set2 = arrayList2.get(i);
                    for (OClass oClass3 : set) {
                        if (!set2.contains(oClass3)) continue;
                        n2 = n + i + 2;
                        n = arrayList.size();
                        i = arrayList2.size();
                        continue block3;
                    }
                }
            }
        }
        return n2;
    }

    @Override
    public OInstance addOInstance(URI uRI, OClass oClass) {
        if (!this.containsOClass(oClass.getURI())) {
            Utils.error(oClass.getURI().toString() + " does not exist");
            return null;
        }
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null && !(oResource instanceof OInstance)) {
            Utils.error(oResource.getURI().toString() + " already exists but " + " is not an ontology instance!");
            return null;
        }
        if (oResource != null && ((OInstance)oResource).getOClasses((byte)1).contains(oClass)) {
            Utils.warning(uRI.toString() + " is already registered as an instanceof " + oClass.getURI().toString());
            return (OInstance)oResource;
        }
        this.owlim.addIndividual(this.sesameRepositoryID, oClass.getURI().toString(), uRI.toString());
        OInstance oInstance = Utils.createOInstance(this.sesameRepositoryID, this, this.owlim, uRI.toString());
        this.fireOntologyResourceAdded(oInstance);
        oInstance.setLabel(uRI.getResourceName(), null);
        return oInstance;
    }

    @Override
    public void removeOInstance(OInstance oInstance) {
        if (!this.containsOInstance(oInstance.getURI())) {
            Utils.warning(oInstance.getURI().toString() + " does not exist");
            return;
        }
        String[] stringArray = this.owlim.removeIndividual(this.sesameRepositoryID, oInstance.getURI().toString());
        this.fireOntologyResourcesRemoved(stringArray);
    }

    @Override
    public Set<OInstance> getOInstances() {
        String[] stringArray = this.owlim.getIndividuals(this.sesameRepositoryID);
        HashSet<OInstance> hashSet = new HashSet<OInstance>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(Utils.createOInstance(this.sesameRepositoryID, this, this.owlim, stringArray[i]));
        }
        return hashSet;
    }

    @Override
    public Set<OInstance> getOInstances(OClass oClass, byte by) {
        String[] stringArray = this.owlim.getIndividuals(this.sesameRepositoryID, oClass.getURI().toString(), by);
        HashSet<OInstance> hashSet = new HashSet<OInstance>();
        if (!this.containsOClass(oClass.getURI())) {
            Utils.warning(oClass.getURI().toString() + " does not exist");
            return hashSet;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(Utils.createOInstance(this.sesameRepositoryID, this, this.owlim, stringArray[i]));
        }
        return hashSet;
    }

    @Override
    public OInstance getOInstance(URI uRI) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            return (OInstance)oResource;
        }
        List<String> list = Arrays.asList(this.owlim.getIndividuals(this.sesameRepositoryID));
        if (list.contains(uRI.toString())) {
            return Utils.createOInstance(this.sesameRepositoryID, this, this.owlim, uRI.toString());
        }
        return null;
    }

    @Override
    public boolean containsOInstance(OInstance oInstance) {
        return this.containsOInstance(oInstance.getURI());
    }

    @Override
    public boolean containsOInstance(URI uRI) {
        List<String> list = Arrays.asList(this.owlim.getIndividuals(this.sesameRepositoryID));
        return list.contains(uRI.toString());
    }

    @Override
    public RDFProperty addRDFProperty(URI uRI, Set<OResource> set, Set<OResource> set2) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            if (oResource instanceof RDFProperty) {
                Utils.warning(uRI.toString() + " already exists");
                return (RDFProperty)oResource;
            }
            Utils.error(uRI.toString() + " already exists but it is not an RDFProperty");
            return null;
        }
        String[] stringArray = new String[set.size()];
        String[] stringArray2 = new String[set2.size()];
        Iterator<OResource> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().getURI().toString();
        }
        iterator = set2.iterator();
        n = 0;
        while (iterator.hasNext()) {
            stringArray2[n] = iterator.next().getURI().toString();
        }
        this.owlim.addRDFProperty(this.sesameRepositoryID, uRI.toString(), stringArray, stringArray2);
        RDFProperty rDFProperty = Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, uRI.toString(), (byte)0);
        this.fireOntologyResourceAdded(rDFProperty);
        rDFProperty.setLabel(uRI.getResourceName(), null);
        return rDFProperty;
    }

    @Override
    public Set<RDFProperty> getRDFProperties() {
        Property[] propertyArray = this.owlim.getRDFProperties(this.sesameRepositoryID);
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add(Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isRDFProperty(URI uRI) {
        return this.owlim.isRDFProperty(this.sesameRepositoryID, uRI.toString());
    }

    @Override
    public AnnotationProperty addAnnotationProperty(URI uRI) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            if (oResource instanceof AnnotationProperty) {
                Utils.warning(uRI.toString() + " already exists");
                return (AnnotationProperty)oResource;
            }
            Utils.error(uRI.toString() + " already exists but it is not an AnnotationProperty");
            return null;
        }
        this.owlim.addAnnotationProperty(this.sesameRepositoryID, uRI.toString());
        AnnotationProperty annotationProperty = (AnnotationProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, uRI.toString(), (byte)5);
        this.fireOntologyResourceAdded(annotationProperty);
        annotationProperty.setLabel(uRI.getResourceName(), null);
        return annotationProperty;
    }

    @Override
    public Set<AnnotationProperty> getAnnotationProperties() {
        Property[] propertyArray = this.owlim.getAnnotationProperties(this.sesameRepositoryID);
        HashSet<AnnotationProperty> hashSet = new HashSet<AnnotationProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add((AnnotationProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isAnnotationProperty(URI uRI) {
        return this.owlim.isAnnotationProperty(this.sesameRepositoryID, uRI.toString());
    }

    @Override
    public DatatypeProperty addDatatypeProperty(URI uRI, Set<OClass> set, DataType dataType) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            if (oResource instanceof DatatypeProperty) {
                Utils.warning(uRI.toString() + " already exists");
                return (DatatypeProperty)oResource;
            }
            Utils.error(uRI.toString() + " already exists but it is not a DatatypeProperty");
            return null;
        }
        String[] stringArray = new String[set.size()];
        Iterator<OClass> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().getURI().toString();
        }
        this.owlim.addDataTypeProperty(this.sesameRepositoryID, uRI.toString(), stringArray, dataType.getXmlSchemaURI().toString());
        DatatypeProperty datatypeProperty = (DatatypeProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, uRI.toString(), (byte)2);
        this.fireOntologyResourceAdded(datatypeProperty);
        datatypeProperty.setLabel(uRI.getResourceName(), null);
        return datatypeProperty;
    }

    @Override
    public Set<DatatypeProperty> getDatatypeProperties() {
        Property[] propertyArray = this.owlim.getDatatypeProperties(this.sesameRepositoryID);
        HashSet<DatatypeProperty> hashSet = new HashSet<DatatypeProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add((DatatypeProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isDatatypeProperty(URI uRI) {
        return this.owlim.isDatatypeProperty(this.sesameRepositoryID, uRI.toString());
    }

    @Override
    public ObjectProperty addObjectProperty(URI uRI, Set<OClass> set, Set<OClass> set2) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            if (oResource instanceof ObjectProperty) {
                Utils.warning(uRI.toString() + " already exists");
                return (ObjectProperty)oResource;
            }
            Utils.error(uRI.toString() + " already exists but it is not an ObjectProperty");
            return null;
        }
        String[] stringArray = new String[set.size()];
        String[] stringArray2 = new String[set2.size()];
        Iterator<OClass> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().getURI().toString();
            ++n;
        }
        iterator = set2.iterator();
        n = 0;
        while (iterator.hasNext()) {
            stringArray2[n] = iterator.next().getURI().toString();
            ++n;
        }
        this.owlim.addObjectProperty(this.sesameRepositoryID, uRI.toString(), stringArray, stringArray2);
        ObjectProperty objectProperty = (ObjectProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, uRI.toString(), (byte)1);
        this.fireOntologyResourceAdded(objectProperty);
        objectProperty.setLabel(uRI.getResourceName(), null);
        return objectProperty;
    }

    @Override
    public Set<ObjectProperty> getObjectProperties() {
        Property[] propertyArray = this.owlim.getObjectProperties(this.sesameRepositoryID);
        HashSet<ObjectProperty> hashSet = new HashSet<ObjectProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add((ObjectProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isObjectProperty(URI uRI) {
        return this.owlim.isObjectProperty(this.sesameRepositoryID, uRI.toString());
    }

    @Override
    public SymmetricProperty addSymmetricProperty(URI uRI, Set<OClass> set) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            if (oResource instanceof SymmetricProperty) {
                Utils.warning(uRI.toString() + " already exists");
                return (SymmetricProperty)oResource;
            }
            Utils.error(uRI.toString() + " already exists but it is not an SymmetricProperty");
            return null;
        }
        String[] stringArray = new String[set.size()];
        Iterator<OClass> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().getURI().toString();
            ++n;
        }
        this.owlim.addSymmetricProperty(this.sesameRepositoryID, uRI.toString(), stringArray);
        SymmetricProperty symmetricProperty = (SymmetricProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, uRI.toString(), (byte)3);
        this.fireOntologyResourceAdded(symmetricProperty);
        symmetricProperty.setLabel(uRI.getResourceName(), null);
        return symmetricProperty;
    }

    @Override
    public Set<SymmetricProperty> getSymmetricProperties() {
        Property[] propertyArray = this.owlim.getSymmetricProperties(this.sesameRepositoryID);
        HashSet<SymmetricProperty> hashSet = new HashSet<SymmetricProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add((SymmetricProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isSymmetricProperty(URI uRI) {
        return this.owlim.isSymmetricProperty(this.sesameRepositoryID, uRI.toString());
    }

    @Override
    public TransitiveProperty addTransitiveProperty(URI uRI, Set<OClass> set, Set<OClass> set2) {
        OResource oResource = this.getOResourceFromMap(uRI.toString());
        if (oResource != null) {
            if (oResource instanceof TransitiveProperty) {
                Utils.warning(uRI.toString() + " already exists");
                return (TransitiveProperty)oResource;
            }
            Utils.error(uRI.toString() + " already exists but it is not a TransitiveProperty");
            return null;
        }
        String[] stringArray = new String[set.size()];
        String[] stringArray2 = new String[set2.size()];
        Iterator<OClass> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().getURI().toString();
            ++n;
        }
        iterator = set2.iterator();
        n = 0;
        while (iterator.hasNext()) {
            stringArray2[n] = iterator.next().getURI().toString();
            ++n;
        }
        this.owlim.addTransitiveProperty(this.sesameRepositoryID, uRI.toString(), stringArray, stringArray2);
        TransitiveProperty transitiveProperty = (TransitiveProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, uRI.toString(), (byte)4);
        this.fireOntologyResourceAdded(transitiveProperty);
        transitiveProperty.setLabel(uRI.getResourceName(), null);
        return transitiveProperty;
    }

    @Override
    public Set<TransitiveProperty> getTransitiveProperties() {
        Property[] propertyArray = this.owlim.getTransitiveProperties(this.sesameRepositoryID);
        HashSet<TransitiveProperty> hashSet = new HashSet<TransitiveProperty>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashSet.add((TransitiveProperty)Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, propertyArray[i].getUri(), propertyArray[i].getType()));
        }
        return hashSet;
    }

    @Override
    public boolean isTransitiveProperty(URI uRI) {
        return this.owlim.isTransitiveProperty(this.sesameRepositoryID, uRI.toString());
    }

    @Override
    public Set<RDFProperty> getPropertyDefinitions() {
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        hashSet.addAll(this.getAnnotationProperties());
        hashSet.addAll(this.getDatatypeProperties());
        hashSet.addAll(this.getObjectProperties());
        hashSet.addAll(this.getRDFProperties());
        return hashSet;
    }

    @Override
    public RDFProperty getProperty(URI uRI) {
        Property property = this.owlim.getPropertyFromOntology(this.sesameRepositoryID, uRI.toString());
        if (property == null) {
            return null;
        }
        return Utils.createOProperty(this.sesameRepositoryID, this, this.owlim, uRI.toString(), property.getType());
    }

    @Override
    public void removeProperty(RDFProperty rDFProperty) {
        OResource oResource = this.getOResourceFromMap(rDFProperty.getURI().toString());
        if (oResource == null) {
            Utils.warning(rDFProperty.getURI().toString() + " does not exist");
            return;
        }
        String[] stringArray = this.owlim.removePropertyFromOntology(this.sesameRepositoryID, rDFProperty.getURI().toString());
        this.fireOntologyResourcesRemoved(stringArray);
    }

    @Override
    public MinCardinalityRestriction addMinCardinalityRestriction(RDFProperty rDFProperty, String string) throws InvalidValueException {
        String string2 = this.getAutoGeneratedRestrictionName();
        DataType dataType = OntologyUtilities.getDataType("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        this.owlim.addClass(this.sesameRepositoryID, string2, (byte)2);
        this.owlim.setOnPropertyValue(this.sesameRepositoryID, string2, rDFProperty.getURI().toString());
        if (!dataType.isValidValue(string)) {
            throw new InvalidValueException(string + " is not valid for datatype " + dataType.getXmlSchemaURI().toString());
        }
        this.owlim.setPropertyValue(this.sesameRepositoryID, string2, (byte)2, string, dataType.getXmlSchemaURI().toString());
        MinCardinalityRestriction minCardinalityRestriction = (MinCardinalityRestriction)Utils.createOClass(this.sesameRepositoryID, this, this.owlim, string2, (byte)2);
        this.fireOntologyResourceAdded(minCardinalityRestriction);
        return minCardinalityRestriction;
    }

    @Override
    public MaxCardinalityRestriction addMaxCardinalityRestriction(RDFProperty rDFProperty, String string) throws InvalidValueException {
        String string2 = this.getAutoGeneratedRestrictionName();
        DataType dataType = OntologyUtilities.getDataType("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        this.owlim.addClass(this.sesameRepositoryID, string2, (byte)3);
        this.owlim.setOnPropertyValue(this.sesameRepositoryID, string2, rDFProperty.getURI().toString());
        if (!dataType.isValidValue(string)) {
            throw new InvalidValueException(string + " is not valid for datatype " + dataType.getXmlSchemaURI().toString());
        }
        this.owlim.setPropertyValue(this.sesameRepositoryID, string2, (byte)3, string, dataType.getXmlSchemaURI().toString());
        MaxCardinalityRestriction maxCardinalityRestriction = (MaxCardinalityRestriction)Utils.createOClass(this.sesameRepositoryID, this, this.owlim, string2, (byte)3);
        this.fireOntologyResourceAdded(maxCardinalityRestriction);
        return maxCardinalityRestriction;
    }

    @Override
    public CardinalityRestriction addCardinalityRestriction(RDFProperty rDFProperty, String string) throws InvalidValueException {
        String string2 = this.getAutoGeneratedRestrictionName();
        DataType dataType = OntologyUtilities.getDataType("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        this.owlim.addClass(this.sesameRepositoryID, string2, (byte)1);
        this.owlim.setOnPropertyValue(this.sesameRepositoryID, string2, rDFProperty.getURI().toString());
        if (!dataType.isValidValue(string)) {
            throw new InvalidValueException(string + " is not valid for datatype " + dataType.getXmlSchemaURI().toString());
        }
        this.owlim.setPropertyValue(this.sesameRepositoryID, string2, (byte)1, string, dataType.getXmlSchemaURI().toString());
        CardinalityRestriction cardinalityRestriction = (CardinalityRestriction)Utils.createOClass(this.sesameRepositoryID, this, this.owlim, string2, (byte)1);
        this.fireOntologyResourceAdded(cardinalityRestriction);
        return cardinalityRestriction;
    }

    @Override
    public HasValueRestriction addHasValueRestriction(RDFProperty rDFProperty, OResource oResource) {
        String string = this.getAutoGeneratedRestrictionName();
        this.owlim.addClass(this.sesameRepositoryID, string, (byte)4);
        this.owlim.setOnPropertyValue(this.sesameRepositoryID, string, rDFProperty.getURI().toString());
        this.owlim.setRestrictionValue(this.sesameRepositoryID, string, (byte)4, oResource.getURI().toString());
        HasValueRestriction hasValueRestriction = (HasValueRestriction)Utils.createOClass(this.sesameRepositoryID, this, this.owlim, string, (byte)4);
        this.fireOntologyResourceAdded(hasValueRestriction);
        return hasValueRestriction;
    }

    @Override
    public AllValuesFromRestriction addAllValuesFromRestriction(RDFProperty rDFProperty, OResource oResource) {
        String string = this.getAutoGeneratedRestrictionName();
        this.owlim.addClass(this.sesameRepositoryID, string, (byte)5);
        this.owlim.setOnPropertyValue(this.sesameRepositoryID, string, rDFProperty.getURI().toString());
        this.owlim.setRestrictionValue(this.sesameRepositoryID, string, (byte)5, oResource.getURI().toString());
        AllValuesFromRestriction allValuesFromRestriction = (AllValuesFromRestriction)Utils.createOClass(this.sesameRepositoryID, this, this.owlim, string, (byte)5);
        this.fireOntologyResourceAdded(allValuesFromRestriction);
        return allValuesFromRestriction;
    }

    @Override
    public SomeValuesFromRestriction addSomeValuesFromRestriction(RDFProperty rDFProperty, OResource oResource) {
        String string = this.getAutoGeneratedRestrictionName();
        this.owlim.addClass(this.sesameRepositoryID, string, (byte)6);
        this.owlim.setOnPropertyValue(this.sesameRepositoryID, string, rDFProperty.getURI().toString());
        this.owlim.setRestrictionValue(this.sesameRepositoryID, string, (byte)6, oResource.getURI().toString());
        SomeValuesFromRestriction someValuesFromRestriction = (SomeValuesFromRestriction)Utils.createOClass(this.sesameRepositoryID, this, this.owlim, string, (byte)6);
        this.fireOntologyResourceAdded(someValuesFromRestriction);
        return someValuesFromRestriction;
    }

    @Override
    public void setModified(boolean bl) {
        this.isModified = bl;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public synchronized void addOntologyModificationListener(OntologyModificationListener ontologyModificationListener) {
        ArrayList<OntologyModificationListener> arrayList = new ArrayList<OntologyModificationListener>();
        if (this.modificationListeners != null) {
            arrayList.addAll(this.modificationListeners);
        }
        arrayList.add(ontologyModificationListener);
        this.modificationListeners = arrayList;
    }

    @Override
    public synchronized void removeOntologyModificationListener(OntologyModificationListener ontologyModificationListener) {
        if (this.modificationListeners == null || !this.modificationListeners.contains(ontologyModificationListener)) {
            return;
        }
        ArrayList<OntologyModificationListener> arrayList = new ArrayList<OntologyModificationListener>();
        for (OntologyModificationListener ontologyModificationListener2 : this.modificationListeners) {
            if (ontologyModificationListener2 == ontologyModificationListener) continue;
            arrayList.add(ontologyModificationListener2);
        }
        this.modificationListeners = arrayList;
    }

    @Override
    public void fireOntologyModificationEvent(OResource oResource, int n) {
        List<OntologyModificationListener> list = this.modificationListeners;
        if (list != null) {
            for (OntologyModificationListener ontologyModificationListener : list) {
                ontologyModificationListener.ontologyModified(this, oResource, n);
            }
        }
    }

    @Override
    public void fireOntologyReset() {
        List<OntologyModificationListener> list = this.modificationListeners;
        if (list != null) {
            for (OntologyModificationListener ontologyModificationListener : list) {
                ontologyModificationListener.ontologyReset(this);
            }
        }
    }

    @Override
    public void fireOntologyResourceAdded(OResource oResource) {
        List<OntologyModificationListener> list = this.modificationListeners;
        if (list != null) {
            for (OntologyModificationListener ontologyModificationListener : list) {
                ontologyModificationListener.resourceAdded(this, oResource);
            }
        }
    }

    @Override
    public void fireOntologyResourcesRemoved(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.removeOResourceFromMap(stringArray[i]);
        }
        List<OntologyModificationListener> list = this.modificationListeners;
        if (list != null) {
            for (OntologyModificationListener ontologyModificationListener : list) {
                ontologyModificationListener.resourcesRemoved(this, stringArray);
            }
        }
    }

    @Override
    public abstract void startTransaction();

    @Override
    public abstract void commitTransaction();

    @Override
    public abstract boolean transationStarted();

    @Override
    public abstract SesameRepository getSesameRepository();

    @Override
    public String getSesameRepositoryID() {
        return this.sesameRepositoryID;
    }

    @Override
    public OResource getOResourceFromMap(String string) {
        return this.urisToOResouceMap.get(string);
    }

    @Override
    public void addOResourceToMap(String string, OResource oResource) {
        this.urisToOResouceMap.put(string, oResource);
        String string2 = OntologyUtilities.getResourceName(string);
        List<OResource> list = this.resourceNamesToOResourcesMap.get(string2);
        if (list == null) {
            list = new ArrayList<OResource>();
            this.resourceNamesToOResourcesMap.put(string2, list);
        }
        list.add(oResource);
    }

    @Override
    public void removeOResourceFromMap(String string) {
        this.urisToOResouceMap.remove(string);
        String string2 = OntologyUtilities.getResourceName(string);
        this.resourceNamesToOResourcesMap.remove(string2);
    }

    @Override
    public void cleanup() {
        if (this.owlim != null && !this.getPersistRepository().booleanValue()) {
            this.callFromCleanup = true;
            this.cleanOntology();
            this.owlim.removeRepository(this.sesameRepositoryID, this.getPersistRepository());
        }
        this.urisToOResouceMap.clear();
    }

    public OWLIM getOwlim() {
        return this.owlim;
    }

    public void setOwlim(OWLIM oWLIM) {
        this.owlim = oWLIM;
    }

    public Boolean getPersistRepository() {
        return this.persistRepository;
    }

    public void setPersistRepository(Boolean bl) {
        this.persistRepository = bl;
    }

    @Override
    public OResource getOResourceByName(String string) {
        List<OResource> list = this.resourceNamesToOResourcesMap.get(string);
        if (list != null) {
            if (list.size() > 1) {
                System.err.print("Warning : there are more than one resources matching with the name " + string);
            }
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<OResource> getOResourcesByName(String string) {
        List<OResource> list = this.resourceNamesToOResourcesMap.get(string);
        if (list == null) {
            return null;
        }
        ArrayList<OResource> arrayList = new ArrayList<OResource>();
        arrayList.addAll(list);
        return arrayList;
    }

    @Override
    public List<OResource> getAllResources() {
        this.getOClasses(false);
        this.getOInstances();
        this.getPropertyDefinitions();
        ArrayList<OResource> arrayList = new ArrayList<OResource>();
        Iterator<String> iterator = this.resourceNamesToOResourcesMap.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll((Collection<OResource>)this.resourceNamesToOResourcesMap.get(iterator.next()));
        }
        return arrayList;
    }

    @Override
    public void store(File file) throws IOException {
        String string = this.owlim.getOntologyData(this.sesameRepositoryID, (byte)1);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    @Override
    public List<OResource> getOResourcesWith(RDFProperty rDFProperty, Literal literal) {
        ArrayList<OResource> arrayList = new ArrayList<OResource>();
        int n = 1;
        if (rDFProperty instanceof AnnotationProperty) {
            n = 1;
        } else if (rDFProperty instanceof DatatypeProperty) {
            n = 2;
        } else {
            return arrayList;
        }
        List<OResource> list = this.getAllResources();
        for (OResource oResource : list) {
            switch (n) {
                case 1: {
                    if (!oResource.hasAnnotationPropertyWithValue((AnnotationProperty)rDFProperty, literal)) break;
                    arrayList.add(oResource);
                    break;
                }
                case 2: {
                    if (!(oResource instanceof OInstance) || !((OInstance)oResource).hasDatatypePropertyWithValue((DatatypeProperty)rDFProperty, literal)) break;
                    arrayList.add(oResource);
                }
            }
        }
        return arrayList;
    }

    @Override
    public List<OResource> getOResourcesWith(RDFProperty rDFProperty, OResource oResource) {
        ArrayList<OResource> arrayList = new ArrayList<OResource>();
        int n = 1;
        if (rDFProperty instanceof ObjectProperty) {
            n = 1;
        } else if (!(rDFProperty instanceof DatatypeProperty)) {
            n = 2;
        } else {
            return arrayList;
        }
        List<OResource> list = this.getAllResources();
        for (OResource oResource2 : list) {
            switch (n) {
                case 1: {
                    if (!(oResource2 instanceof OInstance) || !(oResource instanceof OInstance) || !((OInstance)oResource2).hasObjectPropertyWithValue((ObjectProperty)rDFProperty, (OInstance)oResource)) break;
                    arrayList.add(oResource2);
                    break;
                }
                case 2: {
                    if (!(oResource2 instanceof OInstance) || !((OInstance)oResource2).hasRDFPropertyWithValue(rDFProperty, oResource)) break;
                    arrayList.add(oResource2);
                }
            }
        }
        return arrayList;
    }
}

