/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import gate.creole.ontology.InvalidURIException;

public class URI {
    protected String namespace;
    protected String aResourceName;
    protected String uri;
    protected boolean isAnonymousResource;

    public URI(String string, boolean bl) throws InvalidURIException {
        this.isAnonymousResource = bl;
        if (!this.isAnonymousResource) {
            int n = string.lastIndexOf(35);
            if (n < 0) {
                n = string.lastIndexOf(47);
                if (n < 0) {
                    throw new InvalidURIException("Invalid URI :" + string);
                }
                if (n + 2 > string.length()) {
                    throw new InvalidURIException("Invalid URI :" + string);
                }
                this.uri = string;
                this.namespace = "";
                this.aResourceName = string.substring(n + 1, string.length());
            } else {
                this.uri = string;
                this.namespace = string.substring(0, n + 1);
                this.aResourceName = string.substring(n + 1, string.length());
            }
        } else {
            this.uri = string;
            this.namespace = "";
            this.aResourceName = "[" + string + "]";
        }
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public String getResourceName() {
        return this.aResourceName;
    }

    public String toString() {
        return this.uri;
    }

    public boolean isAnonymousResource() {
        return this.isAnonymousResource;
    }
}

