/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.ResourceInstantiationException;
import gate.creole.ontology.OClass;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOntologyAPI
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run(TestOntologyAPI.class);
    }

    public TestOntologyAPI(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        File file = new File(System.getProperty("gate.home"), "plugins");
        Gate.getCreoleRegister().registerDirectories(new File(file, "Ontology_Tools").toURI().toURL());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLoadingOWLOntology() throws MalformedURLException, ResourceInstantiationException {
        FeatureMap featureMap = Factory.newFeatureMap();
        URL uRL = new URL("http://gate.ac.uk/tests/demo.owl");
        featureMap.put("rdfXmlURL", uRL);
        featureMap.put("defaultNameSpace", "http://www.owl-ontologies.com/unnamed.owl");
        Ontology ontology = (Ontology)Factory.createResource("gate.creole.ontology.owlim.OWLIMOntologyLR", featureMap);
        int n = ontology.getOClasses(false).size();
        TestOntologyAPI.assertEquals((int)n, (int)21);
        Set<OClass> set = ontology.getOClasses(true);
        TestOntologyAPI.assertEquals((int)set.size(), (int)6);
        OClass oClass = ontology.getOClass(new URI(ontology.getDefaultNameSpace() + "Department", false));
        TestOntologyAPI.assertNotNull((Object)oClass);
        Set<OClass> set2 = oClass.getSuperClasses((byte)1);
        TestOntologyAPI.assertEquals((int)set2.size(), (int)2);
        oClass = ontology.getOClass(new URI(ontology.getDefaultNameSpace() + "Organization", false));
        TestOntologyAPI.assertNotNull((Object)oClass);
        TestOntologyAPI.assertTrue((boolean)oClass.isTopClass());
        Set<OClass> set3 = oClass.getSubClasses((byte)1);
        TestOntologyAPI.assertEquals((int)set3.size(), (int)5);
        Factory.deleteResource(ontology);
    }

    public static Test suite() {
        return new TestSuite(TestOntologyAPI.class);
    }
}

