/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import gate.creole.ontology.DataType;
import gate.creole.ontology.InvalidValueException;
import java.util.Locale;

public class Literal {
    private String value;
    private Locale language;
    private DataType dataType;

    public Literal(String string) {
        this.value = string;
    }

    public Literal(String string, Locale locale) {
        this.value = string;
        this.language = locale;
    }

    public Literal(String string, DataType dataType) throws InvalidValueException {
        this.value = string;
        this.dataType = dataType;
        if (!dataType.isValidValue(this.value)) {
            throw new InvalidValueException("The value :\"" + this.value + "\" is not compatible with the dataType \"" + dataType.getXmlSchemaURI() + "\"");
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getValue() {
        return this.value;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public String toString() {
        return "value : " + this.value + "\nlanguage :" + this.language + "\ndatatype :" + this.dataType.xmlSchemaURI;
    }
}

