/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import gate.creole.ontology.BooleanDT;
import gate.creole.ontology.ByteDT;
import gate.creole.ontology.DoubleDT;
import gate.creole.ontology.FloatDT;
import gate.creole.ontology.IntegerDT;
import gate.creole.ontology.InvalidURIException;
import gate.creole.ontology.LongDT;
import gate.creole.ontology.NegativeIntegerDT;
import gate.creole.ontology.NonNegativeIntegerDT;
import gate.creole.ontology.ShortDT;
import gate.creole.ontology.URI;
import gate.creole.ontology.UnsignedByteDT;
import gate.creole.ontology.UnsignedLongDT;
import gate.creole.ontology.UnsignedShortDT;

public class DataType {
    protected URI xmlSchemaURI;

    public DataType(URI uRI) {
        this.xmlSchemaURI = uRI;
    }

    public static DataType getBooleanDataType() {
        try {
            return new BooleanDT(new URI("http://www.w3.org/2001/XMLSchema#boolean", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getByteDataType() {
        try {
            return new ByteDT(new URI("http://www.w3.org/2001/XMLSchema#byte", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getDateDataType() {
        try {
            return new DataType(new URI("http://www.w3.org/2001/XMLSchema#date", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getDecimalDataType() {
        try {
            return new DoubleDT(new URI("http://www.w3.org/2001/XMLSchema#decimal", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getDoubleDataType() {
        try {
            return new DoubleDT(new URI("http://www.w3.org/2001/XMLSchema#double", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getDurationDataType() {
        try {
            return new LongDT(new URI("http://www.w3.org/2001/XMLSchema#duration", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getFloatDataType() {
        try {
            return new FloatDT(new URI("http://www.w3.org/2001/XMLSchema#float", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getIntDataType() {
        try {
            return new IntegerDT(new URI("http://www.w3.org/2001/XMLSchema#int", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getIntegerDataType() {
        try {
            return new IntegerDT(new URI("http://www.w3.org/2001/XMLSchema#integer", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getLongDataType() {
        try {
            return new LongDT(new URI("http://www.w3.org/2001/XMLSchema#long", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getNegativeIntegerDataType() {
        try {
            return new NegativeIntegerDT(new URI("http://www.w3.org/2001/XMLSchema#negativeInteger", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getNonNegativeIntegerDataType() {
        try {
            return new NonNegativeIntegerDT(new URI("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getNonPositiveIntegerDataType() {
        try {
            return new NegativeIntegerDT(new URI("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getPositiveIntegerDataType() {
        try {
            return new NonNegativeIntegerDT(new URI("http://www.w3.org/2001/XMLSchema#positiveInteger", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getShortDataType() {
        try {
            return new ShortDT(new URI("http://www.w3.org/2001/XMLSchema#short", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getStringDataType() {
        try {
            return new DataType(new URI("http://www.w3.org/2001/XMLSchema#string", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getTimeDataType() {
        try {
            return new DataType(new URI("http://www.w3.org/2001/XMLSchema#time", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getUnsignedByteDataType() {
        try {
            return new UnsignedByteDT(new URI("http://www.w3.org/2001/XMLSchema#unsignedByte", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getUnsignedIntDataType() {
        try {
            return new NonNegativeIntegerDT(new URI("http://www.w3.org/2001/XMLSchema#unsignedInt", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getUnsignedLongDataType() {
        try {
            return new UnsignedLongDT(new URI("http://www.w3.org/2001/XMLSchema#unsignedLong", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public static DataType getUnsignedShortDataType() {
        try {
            return new UnsignedShortDT(new URI("http://www.w3.org/2001/XMLSchema#unsignedShort", false));
        }
        catch (InvalidURIException invalidURIException) {
            return null;
        }
    }

    public URI getXmlSchemaURI() {
        return this.xmlSchemaURI;
    }

    public boolean equals(Object object) {
        if (object instanceof DataType) {
            DataType dataType = (DataType)object;
            return this.xmlSchemaURI.getNameSpace().equals(dataType.xmlSchemaURI.getNameSpace()) && this.xmlSchemaURI.getResourceName().equals(dataType.xmlSchemaURI.getResourceName());
        }
        return false;
    }

    public boolean isValidValue(String string) {
        return true;
    }
}

