/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.nerc;

import gate.Annotation;
import gate.Document;
import gate.util.InvalidOffsetException;
import java.io.Serializable;

public class EntityDescriptor
implements Serializable {
    String string;
    String category;
    int[] offsets;

    public EntityDescriptor(String string, String string2, int n, int n2) {
        this.string = this.normaliseString(string);
        this.category = string2;
        this.offsets = new int[2];
        this.offsets[0] = n;
        this.offsets[1] = n2;
    }

    public EntityDescriptor(Document document, Annotation annotation) {
        this.offsets = new int[2];
        this.offsets[0] = annotation.getStartNode().getOffset().intValue();
        this.offsets[1] = annotation.getEndNode().getOffset().intValue();
        try {
            this.string = this.normaliseString(document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString());
        }
        catch (InvalidOffsetException invalidOffsetException) {
            invalidOffsetException.printStackTrace();
        }
        this.category = annotation.getType();
    }

    public String getString() {
        return this.string;
    }

    public String getCategory() {
        return this.category;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public String toString() {
        return this.category + " " + this.offsets[0] + " " + this.offsets[1] + " " + this.string;
    }

    protected String normaliseString(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (string == null) {
            return null;
        }
        boolean bl = false;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        while (n < string.length()) {
            if (Character.isWhitespace(string.charAt(n))) {
                bl = true;
            } else {
                if (bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string.charAt(n));
                bl = false;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

