/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.morph;

import gate.Annotation;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.creole.ExecutionException;
import gate.creole.morph.Morph;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.util.Files;
import gate.util.OffsetComparator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMorph
extends TestCase {
    private Morph morpher;
    private Document verbDocumentToTest;
    private Document verbDocumentWithAnswers;
    private Document nounDocumentToTest;
    private Document nounDocumentWithAnswers;
    public static int count = 0;
    private DefaultTokeniser tokeniser;

    public TestMorph(String string) {
        super(string);
    }

    protected void setUp() {
        try {
            File file = new File(System.getProperty("gate.home"), "plugins");
            Gate.getCreoleRegister().registerDirectories(new File(file, "Tools").toURI().toURL());
            this.verbDocumentToTest = Factory.newDocument(Files.getGateResource("/gate.ac.uk/tests/morph/verbTest.dat"));
            this.verbDocumentWithAnswers = Factory.newDocument(Files.getGateResource("/gate.ac.uk/tests/morph/verbAnswer.dat"));
            this.nounDocumentToTest = Factory.newDocument(Files.getGateResource("/gate.ac.uk/tests/morph/nounTest.dat"));
            this.nounDocumentWithAnswers = Factory.newDocument(Files.getGateResource("/gate.ac.uk/tests/morph/nounAnswer.dat"));
            this.morpher = (Morph)Factory.createResource("gate.creole.morph.Morph");
            this.morpher.setAffixFeatureName("affix");
            this.morpher.setRootFeatureName("root");
            this.tokeniser = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser");
        }
        catch (Exception exception) {
            TestMorph.fail((String)"Resources cannot be created");
        }
    }

    public void testAll() {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.tokeniser.setDocument(this.verbDocumentToTest);
        this.tokeniser.setAnnotationSetName("TokeniserAS");
        try {
            this.tokeniser.execute();
        }
        catch (ExecutionException executionException) {
            TestMorph.fail((String)"Error while executing Tokenizer on the test document");
        }
        this.tokeniser.setDocument(this.verbDocumentWithAnswers);
        this.tokeniser.setAnnotationSetName("TokeniserAS");
        try {
            this.tokeniser.execute();
        }
        catch (ExecutionException executionException) {
            TestMorph.fail((String)"Error while executing Tokenizer on the test document");
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(this.verbDocumentToTest.getAnnotations("TokeniserAS").get("Token"));
        Collections.sort(arrayList, new OffsetComparator());
        ArrayList<Annotation> arrayList2 = new ArrayList<Annotation>(this.verbDocumentWithAnswers.getAnnotations("TokeniserAS").get("Token"));
        Collections.sort(arrayList2, new OffsetComparator());
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            object4 = (Annotation)iterator.next();
            object3 = (String)object4.getFeatures().get("string");
            object2 = (Annotation)iterator2.next();
            object = (String)object2.getFeatures().get("string");
            string = this.morpher.findBaseWord((String)object3, "VB");
            TestMorph.assertEquals((String)string, (String)object);
        }
        this.tokeniser.setDocument(this.nounDocumentToTest);
        this.tokeniser.setAnnotationSetName("TokeniserAS");
        try {
            this.tokeniser.execute();
        }
        catch (ExecutionException executionException) {
            TestMorph.fail((String)"Error while executing Tokenizer on the test document");
        }
        this.tokeniser.setDocument(this.nounDocumentWithAnswers);
        this.tokeniser.setAnnotationSetName("TokeniserAS");
        try {
            this.tokeniser.execute();
        }
        catch (ExecutionException executionException) {
            TestMorph.fail((String)"Error while executing Tokenizer on the test document");
        }
        TestMorph.assertTrue((!this.nounDocumentToTest.getAnnotations("TokeniserAS").isEmpty() ? 1 : 0) != 0);
        TestMorph.assertTrue((!this.nounDocumentWithAnswers.getAnnotations("TokeniserAS").isEmpty() ? 1 : 0) != 0);
        arrayList = new ArrayList<Annotation>(this.nounDocumentToTest.getAnnotations("TokeniserAS").get("Token"));
        object4 = new OffsetComparator();
        Collections.sort(arrayList, object4);
        arrayList2 = new ArrayList<Annotation>(this.nounDocumentWithAnswers.getAnnotations("TokeniserAS").get("Token"));
        Collections.sort(arrayList2, object4);
        iterator = arrayList.iterator();
        iterator2 = arrayList2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            object3 = (Annotation)iterator.next();
            object2 = (String)object3.getFeatures().get("string");
            object = (Annotation)iterator2.next();
            string = (String)object.getFeatures().get("string");
            String string2 = this.morpher.findBaseWord((String)object2, "NN");
            TestMorph.assertEquals((String)string2, (String)string);
        }
    }

    public static Test suite() {
        return new TestSuite(TestMorph.class);
    }
}

