/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.morph;

import gate.creole.ResourceInstantiationException;
import gate.creole.morph.CharacterRange;
import gate.creole.morph.CharacterSet;
import gate.creole.morph.ParsingFunctions;
import gate.creole.morph.PatternPart;
import gate.creole.morph.RHS;
import gate.creole.morph.Storage;
import gate.creole.morph.StringSet;
import gate.creole.morph.Variable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class PatternParser {
    private static Storage variables = new Storage();

    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            PatternParser.variableDeclarationCommand("A ==> [abcdefghijklmnopqrstuvwxyz0123456789-]");
            PatternParser.variableDeclarationCommand("V ==> [aeiou]");
            PatternParser.variableDeclarationCommand("VI ==> [aeiouy]");
            PatternParser.variableDeclarationCommand("C ==> [bcdfghjklmnpqrstvwxyz]");
            PatternParser.variableDeclarationCommand("CX ==> [bcdfghjklmnpqrstvwxz]");
            PatternParser.variableDeclarationCommand("CX2 ==> \"bb\" OR \"cc\" OR \"dd\" OR \"ff\" OR \"gg\" OR \"hh\" OR \"jj\" OR \"kk\" OR \"ll\" OR \"mm\" OR \"nn\" OR \"pp\" OR \"qq\" OR \"rr\" OR \"ss\" OR \"tt\" OR \"vv\" OR \"ww\" OR \"xx\" OR \"zz\"");
            PatternParser.variableDeclarationCommand("CX2S ==> \"ff\" OR \"ss\" OR \"zz\"");
            PatternParser.variableDeclarationCommand("S ==> \"s\" OR \"x\" OR \"ch\" OR \"sh\"");
            PatternParser.variableDeclarationCommand("PRE ==> \"be\" OR \"ex\" OR \"in\" OR \"mis\" OR \"pre\" OR \"pro\" OR \"re\"");
            PatternParser.variableDeclarationCommand("EDING ==> \"ed\" OR \"ing\"");
            PatternParser.variableDeclarationCommand("ESEDING ==> \"es\" OR \"ed\" OR \"ing\"");
            while (true) {
                System.out.print("Query: ");
                String string = bufferedReader.readLine();
                if (string.length() != -1) {
                    PatternParser.getPattern(string);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void getPattern(String string) {
        int n;
        String[] stringArray = string.split("==>");
        String string2 = stringArray[1].trim();
        String string3 = "";
        for (n = 1; n < stringArray[0].length() && stringArray[0].charAt(n) != '>'; ++n) {
            string3 = string3 + stringArray[0].charAt(n);
        }
        RHS rHS = new RHS(stringArray[1], string3);
        stringArray[0] = stringArray[0].substring(n + 1, stringArray[0].length()).trim();
        String string4 = ParsingFunctions.convertToRegExp(stringArray[0], variables);
        String[] stringArray2 = ParsingFunctions.normlizePattern(string4);
        for (int i = 0; i < stringArray2.length; ++i) {
            PatternPart[] patternPartArray = ParsingFunctions.getPatternParts(stringArray2[i].trim());
            for (int j = 0; j < patternPartArray.length; ++j) {
                System.out.println(patternPartArray[j].getPartString() + "=>" + patternPartArray[j].getType());
            }
        }
    }

    private static void variableDeclarationCommand(String string) throws ResourceInstantiationException {
        String string2 = string.split("==>")[0].trim();
        String string3 = string.split("==>")[1].trim();
        int n = ParsingFunctions.findVariableType(string3.trim());
        Variable variable = null;
        switch (n) {
            case 1: {
                variable = new CharacterRange();
                break;
            }
            case 2: {
                variable = new CharacterSet();
                break;
            }
            case 0: {
                variable = new StringSet();
            }
        }
        if (!variable.set(string2, string3)) {
            // empty if block
        }
        if (!variables.add(string2, variable.getPattern())) {
            // empty if block
        }
        variable.resetPointer();
    }

    public static ArrayList parsePattern(String string) {
        int n;
        ArrayList arrayList = new ArrayList();
        string = string.trim();
        string = "( " + string + " )";
        arrayList.add(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2;
            String string2 = (String)arrayList.get(i);
            char c = ' ';
            char c2 = ' ';
            boolean bl = false;
            int n3 = 0;
            boolean bl2 = false;
            String string3 = "";
            for (n2 = 0; n2 < string2.length(); ++n2) {
                c2 = c;
                c = string2.charAt(n2);
                if (PatternParser.isOpenBracket(c, c2)) {
                    int n4 = PatternParser.findBracketClosingPosition(n2 + 1, string2);
                    ArrayList arrayList2 = PatternParser.findOrTokens(string2.substring(n2 + 1, n4));
                    if (arrayList2.size() > 1) {
                        String string4 = "";
                        if (!bl && string3.length() > 0) {
                            string4 = string3;
                            string3 = "";
                        } else {
                            string4 = i == arrayList.size() - 1 ? "" : (String)arrayList.get(arrayList.size() - 1);
                        }
                        arrayList = PatternParser.duplicate(arrayList, string4, n3, arrayList2.size());
                        arrayList = PatternParser.writeTokens(arrayList2, arrayList, n3);
                        bl = true;
                        if (n3 == 0) {
                            n3 = 1;
                        }
                        n3 *= arrayList2.size();
                    } else {
                        if (n3 == 0) {
                            if (string3.length() == 0) {
                                arrayList.add("");
                            } else {
                                arrayList.add(string3);
                            }
                            bl = true;
                            string3 = "";
                            n3 = 1;
                        }
                        arrayList = PatternParser.writeStringInAll("<" + string2.substring(n2 + 1, n4) + ">", n3, arrayList);
                    }
                    n2 = n4;
                    continue;
                }
                if (bl) {
                    arrayList = PatternParser.writeCharInAll(c, n3, arrayList);
                    continue;
                }
                string3 = string3 + "" + c;
            }
            n2 = PatternParser.scanQueryForOrOrBracket(string2) ? 1 : 0;
            if (n2 == 0) continue;
            arrayList.remove(i);
            --i;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            String string5 = (String)arrayList.get(n);
            if (string5.trim().length() == 0 || arrayList3.contains(string5.trim())) continue;
            arrayList3.add(string5.trim());
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            String string6 = (String)arrayList3.get(n);
            string6 = string6.replaceAll("<", "(");
            string6 = string6.replaceAll(">", ")");
            string6 = string6.substring(1, string6.length() - 1);
            arrayList3.set(n, string6.trim());
        }
        return arrayList3;
    }

    public static boolean scanQueryForOrOrBracket(String string) {
        int n = 0;
        int n2 = 0;
        do {
            if ((n = string.indexOf(124, n)) == 0) {
                return true;
            }
            if (n > 0 && string.charAt(n - 1) != '\\') {
                return true;
            }
            if ((n2 = string.indexOf(40, n2)) == 0) {
                return true;
            }
            if (n2 <= 0 || string.charAt(n2 - 1) == '\\') continue;
            return true;
        } while (n >= 0 && n2 >= 0);
        return false;
    }

    public static ArrayList writeTokens(ArrayList arrayList, ArrayList arrayList2, int n) {
        int n2;
        if (n == 0) {
            n = 1;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 1; i <= arrayList.size(); ++i) {
                String string = (String)arrayList.get(i - 1);
                if (string.trim().equals("{__o__}")) {
                    string = " ";
                }
                String string2 = (String)arrayList2.get(arrayList2.size() - (n2 * arrayList.size() + i));
                arrayList3.add(string2);
                string2 = string2 + string;
                arrayList2.set(arrayList2.size() - (n2 * arrayList.size() + i), string2);
            }
        }
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            arrayList2.remove(arrayList3.get(n2));
        }
        return arrayList2;
    }

    public static ArrayList duplicate(ArrayList arrayList, String string, int n, int n2) {
        int n3;
        if (string == null) {
            string = "";
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (n == 0) {
            arrayList2.add(string);
        } else {
            for (n3 = 0; n3 < n; ++n3) {
                arrayList2.add((String)arrayList.get(arrayList.size() - (n3 + 1)));
            }
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            for (int i = 0; i < n2; ++i) {
                arrayList.add(arrayList2.get(n3));
            }
        }
        return arrayList;
    }

    public static ArrayList findOrTokens(String string) {
        int n = 0;
        char c = ' ';
        char c2 = ' ';
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            c = c2;
            c2 = string.charAt(i);
            if (PatternParser.isOpenBracket(c2, c)) {
                ++n;
                string2 = string2 + "" + c2;
                continue;
            }
            if (PatternParser.isClosingBracket(c2, c) && n > 0) {
                --n;
                string2 = string2 + "" + c2;
                continue;
            }
            if (PatternParser.isOrSym(c2, c)) {
                if (n > 0) {
                    string2 = string2 + "" + c2;
                    continue;
                }
                arrayList.add(string2);
                string2 = "";
                continue;
            }
            string2 = string2 + "" + c2;
        }
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static int findBracketClosingPosition(int n, String string) {
        int n2 = 0;
        char c = ' ';
        char c2 = ' ';
        for (int i = n; i < string.length(); ++i) {
            c = c2;
            c2 = string.charAt(i);
            if (PatternParser.isOpenBracket(c2, c)) {
                ++n2;
                continue;
            }
            if (!PatternParser.isClosingBracket(c2, c)) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            return i;
        }
        return -1;
    }

    public static ArrayList writeCharInAll(char c, int n, ArrayList arrayList) {
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(arrayList.size() - (i + 1));
            string = string + "" + c;
            arrayList.set(arrayList.size() - (i + 1), string);
        }
        return arrayList;
    }

    public static ArrayList writeStringInAll(String string, int n, ArrayList arrayList) {
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList.get(arrayList.size() - (i + 1));
            string2 = string2 + "" + string;
            arrayList.set(arrayList.size() - (i + 1), string2);
        }
        return arrayList;
    }

    public static boolean isOpenBracket(char c, char c2) {
        return c == '(' && c2 != '\\';
    }

    public static boolean isClosingBracket(char c, char c2) {
        return c == ')' && c2 != '\\';
    }

    public static boolean isOrSym(char c, char c2) {
        return c == '|' && c2 != '\\';
    }
}

