/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.morph;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.morph.Interpret;
import gate.util.GateRuntimeException;
import java.net.URL;
import java.util.Iterator;

public class Morph
extends AbstractLanguageAnalyser
implements ProcessingResource {
    private Document document;
    private URL rulesFile;
    private Interpret interpret;
    private String rootFeatureName;
    private String affixFeatureName;
    private String annotationSetName;
    private Boolean caseSensitive;
    private Boolean considerPOSTag;

    public Resource init() throws ResourceInstantiationException {
        this.interpret = new Interpret();
        if (this.rulesFile == null) {
            throw new ResourceInstantiationException("\n\n No Rule File Provided");
        }
        this.fireStatusChanged("Reading Rule File...");
        this.interpret.init(this.rulesFile);
        this.fireStatusChanged("Morpher created!");
        this.fireProcessFinished();
        return this;
    }

    public void execute() throws ExecutionException {
        this.fireProgressChanged(0);
        if (this.document == null) {
            this.fireProcessFinished();
            throw new GateRuntimeException("No document to process!");
        }
        AnnotationSet annotationSet = this.annotationSetName == null || this.annotationSetName.length() == 0 ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
        AnnotationSet annotationSet2 = annotationSet.get("Token");
        if (annotationSet2 == null || annotationSet2.isEmpty()) {
            this.fireProcessFinished();
            throw new ExecutionException("Either " + this.document.getName() + " does not have any contents or \n run the POS Tagger first and then Morpher");
        }
        Iterator<Annotation> iterator = annotationSet2.iterator();
        int n = annotationSet2.size();
        int n2 = 0;
        int n3 = 0;
        while (iterator != null && iterator.hasNext()) {
            Annotation annotation = iterator.next();
            String string = (String)annotation.getFeatures().get("string");
            if (this.considerPOSTag != null && this.considerPOSTag.booleanValue() && !annotation.getFeatures().containsKey("category")) {
                this.fireProcessFinished();
                throw new ExecutionException("please run the POS Tagger first and then Morpher");
            }
            String string2 = (String)annotation.getFeatures().get("category");
            if (string2 == null) {
                string2 = "*";
            }
            if (this.considerPOSTag == null || !this.considerPOSTag.booleanValue()) {
                string2 = "*";
            }
            if (!this.caseSensitive.booleanValue()) {
                string = string.toLowerCase();
            }
            String string3 = this.interpret.runMorpher(string, string2);
            String string4 = this.interpret.getAffix();
            if (string4 != null) {
                annotation.getFeatures().put(this.affixFeatureName, string4);
            }
            annotation.getFeatures().put(this.rootFeatureName, string3);
            if (++n2 - n3 <= 100) continue;
            n3 = n2;
            this.fireProgressChanged(n2 * 100 / n);
        }
        this.fireProcessFinished();
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public String findBaseWord(String string, String string2) {
        return this.interpret.runMorpher(string, string2);
    }

    public String findAffix(String string, String string2) {
        this.interpret.runMorpher(string, string2);
        return this.interpret.getAffix();
    }

    public Document getDocument() {
        return this.document;
    }

    public void setRulesFile(URL uRL) {
        this.rulesFile = uRL;
    }

    public URL getRulesFile() {
        return this.rulesFile;
    }

    public String getRootFeatureName() {
        return this.rootFeatureName;
    }

    public void setRootFeatureName(String string) {
        this.rootFeatureName = string;
    }

    public String getAffixFeatureName() {
        return this.affixFeatureName;
    }

    public void setAffixFeatureName(String string) {
        this.affixFeatureName = string;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void setAnnotationSetName(String string) {
        this.annotationSetName = string;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean bl) {
        this.caseSensitive = bl;
    }

    public Boolean getConsiderPOSTag() {
        return this.considerPOSTag;
    }

    public void setConsiderPOSTag(Boolean bl) {
        this.considerPOSTag = bl;
    }
}

