/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ir.lucene;

import gate.creole.ir.IndexException;
import gate.creole.ir.IndexedCorpus;
import gate.creole.ir.QueryResult;
import gate.creole.ir.QueryResultList;
import gate.creole.ir.Search;
import gate.creole.ir.SearchException;
import gate.creole.ir.Term;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class LuceneSearch
implements Search {
    private IndexedCorpus indexedCorpus;

    public void setCorpus(IndexedCorpus indexedCorpus) {
        this.indexedCorpus = indexedCorpus;
    }

    public QueryResultList search(String string) throws IndexException, SearchException {
        return this.search(string, -1);
    }

    public QueryResultList search(String string, int n) throws IndexException, SearchException {
        return this.search(string, n, null);
    }

    public QueryResultList search(String string, List list) throws IndexException, SearchException {
        return this.search(string, -1, list);
    }

    public QueryResultList search(String string, int n, List list) throws IndexException, SearchException {
        Vector<QueryResult> vector = new Vector<QueryResult>();
        try {
            IndexSearcher indexSearcher = new IndexSearcher(this.indexedCorpus.getIndexDefinition().getIndexLocation());
            Query query = QueryParser.parse((String)string, (String)"body", (Analyzer)new SimpleAnalyzer());
            Hits hits = indexSearcher.search(query);
            int n2 = hits.length();
            if (n > -1) {
                n2 = Math.min(n, n2);
            }
            Vector<Term> vector2 = null;
            for (int i = 0; i < n2; ++i) {
                if (list != null) {
                    vector2 = new Vector<Term>();
                    for (int j = 0; j < list.size(); ++j) {
                        vector2.add(new Term(list.get(j).toString(), hits.doc(i).get(list.get(j).toString())));
                    }
                }
                vector.add(new QueryResult(hits.doc(i).get("DOCUMENT_ID"), hits.score(i), vector2));
            }
            indexSearcher.close();
            return new QueryResultList(string, this.indexedCorpus, vector);
        }
        catch (IOException iOException) {
            throw new IndexException(iOException.getMessage());
        }
        catch (ParseException parseException) {
            throw new SearchException(parseException.getMessage());
        }
    }
}

