/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ir;

import gate.Corpus;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.corpora.TestDocument;
import gate.creole.ir.DefaultIndexDefinition;
import gate.creole.ir.DocumentContentReader;
import gate.creole.ir.IndexException;
import gate.creole.ir.IndexField;
import gate.creole.ir.IndexedCorpus;
import gate.creole.ir.QueryResultList;
import gate.creole.ir.SearchException;
import gate.creole.ir.lucene.LuceneIREngine;
import gate.creole.ir.lucene.LuceneSearch;
import gate.util.GateException;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIndex
extends TestCase {
    private static String TEMP_LOCATION = null;
    private Corpus corpus = null;
    private DataStore sds = null;

    public TestIndex(String string) throws GateException {
        super(string);
    }

    public void setUp() throws Exception {
        try {
            Object object;
            File file = File.createTempFile("TestIndex__", "__StorageDir");
            if (null == TEMP_LOCATION) {
                object = File.createTempFile("LuceneIndex__", "__Dir");
                TEMP_LOCATION = ((File)object).getAbsolutePath();
            }
            file.delete();
            this.sds = Factory.createDataStore("gate.persist.SerialDataStore", file.toURI().toURL().toString());
            this.sds.open();
            object = TestDocument.getTestServerName();
            Document document = Factory.newDocument(new URL((String)object + "tests/doc0.html"));
            document.getFeatures().put("author", "John Smit");
            Corpus corpus = Factory.newCorpus("LuceneTestCorpus");
            corpus.add(document);
            this.corpus = (Corpus)this.sds.adopt(corpus, null);
            this.sds.sync(this.corpus);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GateException(exception.getMessage());
        }
    }

    public void tearDown() throws Exception {
        this.sds.delete();
    }

    public static Test suite() {
        return new TestSuite(TestIndex.class);
    }

    public void testIndex_01() throws IndexException {
        IndexedCorpus indexedCorpus = (IndexedCorpus)this.corpus;
        DefaultIndexDefinition defaultIndexDefinition = new DefaultIndexDefinition();
        defaultIndexDefinition.setIrEngineClassName(LuceneIREngine.class.getName());
        defaultIndexDefinition.setIndexLocation(TEMP_LOCATION);
        defaultIndexDefinition.addIndexField(new IndexField("content", new DocumentContentReader(), false));
        defaultIndexDefinition.addIndexField(new IndexField("author", null, false));
        indexedCorpus.setIndexDefinition(defaultIndexDefinition);
        indexedCorpus.getIndexManager().deleteIndex();
        indexedCorpus.getIndexManager().createIndex();
    }

    public void testIndex_02() throws IndexException {
        IndexedCorpus indexedCorpus = (IndexedCorpus)this.corpus;
        DefaultIndexDefinition defaultIndexDefinition = new DefaultIndexDefinition();
        defaultIndexDefinition.setIrEngineClassName(LuceneIREngine.class.getName());
        defaultIndexDefinition.setIndexLocation(TEMP_LOCATION);
        indexedCorpus.setIndexDefinition(defaultIndexDefinition);
        indexedCorpus.getIndexManager().optimizeIndex();
    }

    public void testIndex_10() throws IndexException, SearchException {
        IndexedCorpus indexedCorpus = (IndexedCorpus)this.corpus;
        DefaultIndexDefinition defaultIndexDefinition = new DefaultIndexDefinition();
        defaultIndexDefinition.setIrEngineClassName(LuceneIREngine.class.getName());
        defaultIndexDefinition.setIndexLocation(TEMP_LOCATION);
        indexedCorpus.setIndexDefinition(defaultIndexDefinition);
        LuceneSearch luceneSearch = new LuceneSearch();
        luceneSearch.setCorpus(indexedCorpus);
        QueryResultList queryResultList = luceneSearch.search("+content:Diller +author:John");
        Iterator iterator = queryResultList.getQueryResults();
        Assert.assertTrue((boolean)iterator.hasNext());
    }

    public void testIndex_11() {
    }

    public void testIndex_12() {
    }

    public void testIndex_101() throws IndexException {
        IndexedCorpus indexedCorpus = (IndexedCorpus)this.corpus;
        DefaultIndexDefinition defaultIndexDefinition = new DefaultIndexDefinition();
        defaultIndexDefinition.setIrEngineClassName(LuceneIREngine.class.getName());
        defaultIndexDefinition.setIndexLocation(TEMP_LOCATION);
        indexedCorpus.setIndexDefinition(defaultIndexDefinition);
        indexedCorpus.getIndexManager().deleteIndex();
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            TestIndex testIndex = new TestIndex("");
            testIndex.setUp();
            testIndex.testIndex_01();
            testIndex.tearDown();
            testIndex.setUp();
            testIndex.testIndex_02();
            testIndex.tearDown();
            testIndex.setUp();
            testIndex.testIndex_10();
            testIndex.tearDown();
            testIndex.setUp();
            testIndex.testIndex_101();
            testIndex.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

