/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.TestDocument;
import gate.creole.gazetteer.DefaultGazetteer;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestGazetteer
extends TestCase {
    public TestGazetteer(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testDefaultGazetteer() throws Exception {
        Document document = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/doc0.html"));
        DefaultGazetteer defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer");
        defaultGazetteer.setDocument(document);
        defaultGazetteer.setAnnotationSetName("GazetteerAS");
        defaultGazetteer.execute();
        AnnotationSet annotationSet = document.getAnnotations("GazetteerAS");
        TestGazetteer.assertTrue((String)("Found " + annotationSet.size() + " annotations instead of the expected 53!"), (annotationSet.size() == 53 ? 1 : 0) != 0);
        annotationSet.clear();
        defaultGazetteer.setWholeWordsOnly(false);
        defaultGazetteer.execute();
        TestGazetteer.assertTrue((String)("Found " + annotationSet.size() + " annotations instead of the expected 135!"), (annotationSet.size() == 135 ? 1 : 0) != 0);
        defaultGazetteer.setWholeWordsOnly(true);
        annotationSet.clear();
        defaultGazetteer.setLongestMatchOnly(false);
        defaultGazetteer.execute();
        TestGazetteer.assertTrue((String)("Found " + annotationSet.size() + " annotations instead of the expected 68!"), (annotationSet.size() == 68 ? 1 : 0) != 0);
        defaultGazetteer.setLongestMatchOnly(true);
        annotationSet.clear();
        Factory.deleteResource(defaultGazetteer);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("caseSensitive", false);
        defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", featureMap);
        defaultGazetteer.setDocument(document);
        defaultGazetteer.setAnnotationSetName("GazetteerAS");
        defaultGazetteer.execute();
        TestGazetteer.assertTrue((String)("Found " + annotationSet.size() + " annotations instead of the expected 99!"), (annotationSet.size() == 99 ? 1 : 0) != 0);
        defaultGazetteer.setCaseSensitive(true);
        annotationSet.clear();
        Factory.deleteResource(defaultGazetteer);
        Factory.deleteResource(document);
    }

    public static Test suite() {
        return new TestSuite(TestGazetteer.class);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            TestGazetteer testGazetteer = new TestGazetteer("");
            testGazetteer.setUp();
            testGazetteer.testDefaultGazetteer();
            testGazetteer.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

