/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.TestDocument;
import gate.creole.POSTagger;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.gazetteer.FlexibleGazetteer;
import gate.creole.morph.Morph;
import gate.creole.splitter.SentenceSplitter;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.util.GateRuntimeException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFlexibleGazetteer
extends TestCase {
    private static final boolean DEBUG = false;

    public TestFlexibleGazetteer(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        File file = new File(System.getProperty("gate.home"), "plugins");
        try {
            Gate.getCreoleRegister().registerDirectories(new File(file, "Tools").toURI().toURL());
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    public void tearDown() throws Exception {
    }

    public void testFlexibleGazetteer() throws Exception {
        Document document = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/doc0.html"));
        DefaultTokeniser defaultTokeniser = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser");
        SentenceSplitter sentenceSplitter = (SentenceSplitter)Factory.createResource("gate.creole.splitter.SentenceSplitter");
        POSTagger pOSTagger = (POSTagger)Factory.createResource("gate.creole.POSTagger");
        Morph morph = (Morph)Factory.createResource("gate.creole.morph.Morph");
        DefaultGazetteer defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer");
        FeatureMap featureMap = Factory.newFeatureMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Token.root");
        featureMap.put("inputFeatureNames", arrayList);
        featureMap.put("gazetteerInst", defaultGazetteer);
        FlexibleGazetteer flexibleGazetteer = (FlexibleGazetteer)Factory.createResource("gate.creole.gazetteer.FlexibleGazetteer", featureMap);
        defaultTokeniser.setDocument(document);
        defaultTokeniser.execute();
        sentenceSplitter.setDocument(document);
        sentenceSplitter.execute();
        pOSTagger.setDocument(document);
        pOSTagger.execute();
        morph.setDocument(document);
        morph.execute();
        flexibleGazetteer.setDocument(document);
        flexibleGazetteer.execute();
        AnnotationSet annotationSet = document.getAnnotations();
        AnnotationSet annotationSet2 = annotationSet.get("Lookup");
        TestFlexibleGazetteer.assertTrue((annotationSet2.size() == 28 ? 1 : 0) != 0);
        Factory.deleteResource(document);
        Factory.deleteResource(defaultTokeniser);
        Factory.deleteResource(morph);
        Factory.deleteResource(flexibleGazetteer);
    }

    public static Test suite() {
        return new TestSuite(TestFlexibleGazetteer.class);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            TestFlexibleGazetteer testFlexibleGazetteer = new TestFlexibleGazetteer("");
            testFlexibleGazetteer.setUp();
            testFlexibleGazetteer.testFlexibleGazetteer();
            testFlexibleGazetteer.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

