/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.InvalidFormatException;
import gate.creole.gazetteer.MappingNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingDefinition
extends AbstractLanguageResource
implements List {
    private static final long serialVersionUID = 3617291212063848503L;
    private static final String ENCODING = "UTF-8";
    private List<MappingNode> nodes = new ArrayList<MappingNode>();
    private URL url;
    private Set<String> lists = new HashSet<String>();
    private Map<String, MappingNode> nodesByList = new HashMap<String, MappingNode>();

    public List<String> getUrls() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            hashSet.add(this.nodes.get(i).getOntologyID());
        }
        return new ArrayList<String>(hashSet);
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public void load() throws ResourceInstantiationException, InvalidFormatException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not set (null).");
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.url.openStream(), ENCODING));
            while (null != (string = bufferedReader.readLine())) {
                if (0 == string.trim().length()) continue;
                MappingNode mappingNode = new MappingNode(string);
                this.add(mappingNode);
            }
            bufferedReader.close();
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new InvalidFormatException(this.url, "on load");
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
    }

    public void store() throws ResourceInstantiationException {
        if (null == this.url) {
            throw new ResourceInstantiationException("URL not set (null).");
        }
        try {
            File file = new File(this.url.getFile());
            file.delete();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.nodes.size(); ++i) {
                bufferedWriter.write(this.nodes.get(i).toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new ResourceInstantiationException(iOException);
        }
    }

    public Set<String> getLists() {
        return new HashSet<String>(this.lists);
    }

    public MappingNode getNodeByList(String string) {
        return this.nodesByList.get(string);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.nodes.contains(object);
    }

    @Override
    public Iterator iterator() {
        return new SafeIterator();
    }

    @Override
    public Object[] toArray() {
        return this.nodes.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.nodes.toArray(objectArray);
    }

    @Override
    public boolean add(Object object) {
        String string;
        boolean bl = false;
        if (object instanceof MappingNode && !this.nodesByList.containsKey(string = ((MappingNode)object).getList())) {
            bl = this.nodes.add((MappingNode)object);
            this.nodesByList.put(string, (MappingNode)object);
            this.lists.add(string);
        }
        return bl;
    }

    public void add(int n, Object object) {
        String string;
        if (object instanceof MappingNode && !this.nodesByList.containsKey(string = ((MappingNode)object).getList())) {
            this.nodes.add(n, (MappingNode)object);
            this.nodesByList.put(string, (MappingNode)object);
            this.lists.add(string);
        }
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException("this method has not been implemented");
    }

    public Object get(int n) {
        return this.nodes.get(n);
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = false;
        if (object instanceof MappingNode) {
            bl = this.nodes.remove(object);
            String string = ((MappingNode)object).getList();
            this.lists.remove(string);
            this.nodesByList.remove(string);
        }
        return bl;
    }

    public Object remove(int n) {
        MappingNode mappingNode = null;
        mappingNode = this.nodes.remove(n);
        if (null != mappingNode) {
            String string = mappingNode.getList();
            this.lists.remove(string);
            this.nodesByList.remove(string);
        }
        return mappingNode;
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.nodes.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            if (!(e instanceof MappingNode)) continue;
            bl |= this.add(e);
        }
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = this.nodes.size();
        for (Object e : collection) {
            if (!(e instanceof MappingNode)) continue;
            this.add(n++, e);
        }
        return n2 != this.nodes.size();
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            bl |= this.remove(e);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        int n = this.nodes.size();
        ArrayList<MappingNode> arrayList = new ArrayList<MappingNode>();
        for (int i = 0; i < this.nodes.size(); ++i) {
            MappingNode mappingNode = this.nodes.get(i);
            if (!collection.contains(mappingNode)) continue;
            arrayList.add(mappingNode);
        }
        this.removeAll(arrayList);
        return n != this.nodes.size();
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.lists.clear();
        this.nodesByList.clear();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MappingDefinition) {
            MappingDefinition mappingDefinition = (MappingDefinition)object;
            bl &= ((Object)this.nodes).equals(mappingDefinition.nodes);
            bl &= ((Object)this.lists).equals(mappingDefinition.lists);
            bl &= ((Object)this.nodesByList).equals(mappingDefinition.lists);
        }
        return bl;
    }

    public List subList(int n, int n2) {
        return this.nodes.subList(n, n2);
    }

    public ListIterator listIterator(int n) {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.nodes.lastIndexOf(object);
    }

    @Override
    public int indexOf(Object object) {
        return this.nodes.indexOf(object);
    }

    private class SafeIterator
    implements Iterator {
        private int index = 0;
        private boolean removeCalled = false;

        private SafeIterator() {
        }

        public boolean hasNext() {
            return this.index < MappingDefinition.this.nodes.size();
        }

        public Object next() {
            this.removeCalled = false;
            return MappingDefinition.this.nodes.get(this.index++);
        }

        public void remove() {
            if (!this.removeCalled && this.index > 0) {
                --this.index;
                MappingDefinition.this.remove(MappingDefinition.this.nodes.get(this.index));
            }
            this.removeCalled = true;
        }
    }
}

