/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.GazetteerNode;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.LuckyException;
import gate.util.protocols.gate.Handler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class GazetteerList
extends AbstractLanguageResource
implements List {
    public static final int LIST_MODE = 0;
    public static final int STRING_MODE = 1;
    private URL url;
    private String encoding = "UTF-8";
    private int mode = 0;
    private boolean isModified = false;
    private List entries = new ArrayList();
    private String content = null;
    private String separator;

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        if (n != this.mode) {
            switch (n) {
                case 0: {
                    this.mode = n;
                    this.updateContent(this.content);
                    break;
                }
                case 1: {
                    this.content = this.toString();
                    this.mode = n;
                    break;
                }
                default: {
                    throw new GateRuntimeException("Invalid Mode =" + this.mode + "\nValid modes are:\nLIST_MODE = " + 0 + "\nSTRING_MODE = " + 1);
                }
            }
        }
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void load() throws ResourceInstantiationException {
        try {
            String string;
            if (null == this.url) {
                throw new ResourceInstantiationException("URL not specified (null).");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.url.openStream(), this.encoding));
            while (null != (string = bufferedReader.readLine())) {
                this.entries.add(new GazetteerNode(string, this.separator));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception.getClass() + ":" + exception.getMessage());
        }
        this.isModified = false;
    }

    public void store() throws ResourceInstantiationException {
        try {
            if (null == this.url) {
                throw new ResourceInstantiationException("URL not specified (null)");
            }
            URL uRL = this.url;
            if (-1 != this.url.getProtocol().indexOf("gate")) {
                uRL = Handler.class.getResource(Files.getResourcePath() + this.url.getPath());
            }
            File file = new File(uRL.getFile());
            file.delete();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding);
            Iterator iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                outputStreamWriter.write(iterator.next().toString());
                outputStreamWriter.write(13);
                outputStreamWriter.write(10);
            }
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception.getClass() + ":" + exception.getMessage());
        }
        this.isModified = false;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
        this.isModified = true;
    }

    public URL getURL() {
        return this.url;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return 0 == this.entries.size();
    }

    public boolean contains(Object object) {
        return this.entries.contains(object);
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public Object[] toArray() {
        return this.entries.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.toArray(objectArray);
    }

    public boolean add(Object object) {
        boolean bl = false;
        if (object instanceof String) {
            bl = this.entries.add(object);
        }
        this.isModified |= bl;
        return bl;
    }

    public boolean remove(Object object) {
        boolean bl = this.entries.remove(object);
        this.isModified |= bl;
        return bl;
    }

    public boolean containsAll(Collection collection) {
        return this.entries.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String)) continue;
            bl |= this.entries.add(e);
        }
        this.isModified |= bl;
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = this.entries.addAll(n, collection);
        this.isModified |= bl;
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = this.entries.removeAll(collection);
        this.isModified |= bl;
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = this.entries.retainAll(collection);
        this.isModified |= bl;
        return bl;
    }

    public void clear() {
        if (0 < this.entries.size()) {
            this.isModified = true;
        }
        this.entries.clear();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof GazetteerList) {
            bl = true;
            GazetteerList gazetteerList = (GazetteerList)object;
            bl &= ((Object)this.entries).equals(gazetteerList.entries);
        }
        return bl;
    }

    public Object get(int n) {
        return this.entries.get(n);
    }

    public Object set(int n, Object object) {
        this.isModified = true;
        return this.entries.set(n, object);
    }

    public void add(int n, Object object) {
        this.isModified = true;
        this.entries.add(n, object);
    }

    public Object remove(int n) {
        int n2 = this.entries.size();
        Object e = this.entries.remove(n);
        this.isModified |= n2 != this.entries.size();
        return e;
    }

    public int indexOf(Object object) {
        return this.entries.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.entries.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.entries.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.entries.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.entries.subList(n, n2);
    }

    public String toString() {
        String string = null;
        switch (this.mode) {
            case 0: {
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = null;
                for (int i = 0; i < this.entries.size(); ++i) {
                    GazetteerNode gazetteerNode = (GazetteerNode)this.entries.get(i);
                    string2 = gazetteerNode.getEntry().trim();
                    if (string2.length() <= 0) continue;
                    stringBuffer.append(string2);
                    Map map = gazetteerNode.getFeatureMap();
                    if (map != null && map.size() > 0) {
                        stringBuffer.append(gazetteerNode.featureMapToString(map));
                    }
                    stringBuffer.append("\n");
                }
                string = stringBuffer.toString();
                break;
            }
            case 1: {
                string = this.content;
                break;
            }
            default: {
                throw new GateRuntimeException("Invalid Mode =" + this.mode + "\nValid modes are:\nLIST_MODE = " + 0 + "\nSTRING_MODE = " + 1);
            }
        }
        return string;
    }

    public void updateContent(String string) {
        switch (this.mode) {
            case 1: {
                this.content = string;
                break;
            }
            case 0: {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                ArrayList<GazetteerNode> arrayList = new ArrayList<GazetteerNode>();
                try {
                    String string2;
                    while (null != (string2 = bufferedReader.readLine())) {
                        arrayList.add(new GazetteerNode(string2, this.separator));
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new LuckyException("IOException :" + iOException.getMessage());
                }
                this.isModified = !((Object)arrayList).equals(this.entries);
                this.clear();
                this.entries = arrayList;
                break;
            }
            default: {
                throw new GateRuntimeException("Invalid Mode =" + this.mode + "\nValid modes are:\nLIST_MODE = " + 0 + "\nSTRING_MODE = " + 1);
            }
        }
    }
}

